/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@GenerateInline
@GenerateCached(value=false)
public abstract class ArrayBufferViewGetByteLengthNode
extends JavaScriptBaseNode {
    protected ArrayBufferViewGetByteLengthNode() {
    }

    public abstract int executeInt(Node var1, JSTypedArrayObject var2, JSContext var3);

    @Specialization(guards={"!hasDetachedBuffer(obj, context)", "cachedArray == getArrayType(obj)"}, limit="1")
    protected static int getByteLength(JSTypedArrayObject obj, JSContext context2, @Cached(value="getArrayType(obj)") TypedArray cachedArray) {
        return cachedArray.lengthInt(obj) * cachedArray.bytesPerElement();
    }

    @Specialization(guards={"!hasDetachedBuffer(obj, context)"}, replaces={"getByteLength"})
    protected static int getByteLengthOverLimit(JSTypedArrayObject obj, JSContext context2) {
        TypedArray typedArray = ArrayBufferViewGetByteLengthNode.getArrayType(obj);
        return typedArray.lengthInt(obj) * typedArray.bytesPerElement();
    }

    @Specialization(guards={"hasDetachedBuffer(obj, context)"})
    protected static int getByteLengthDetached(JSTypedArrayObject obj, JSContext context2) {
        return 0;
    }

    @NeverDefault
    protected static TypedArray getArrayType(JSTypedArrayObject obj) {
        return JSArrayBufferView.typedArrayGetArrayType(obj);
    }

    protected boolean hasDetachedBuffer(JSTypedArrayObject object, JSContext context2) {
        return JSArrayBufferView.hasDetachedBuffer(object, context2);
    }
}

