/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.ui.RecordView;
import com.intellij.database.run.ui.TabInfoProvider;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/run/ui/RecordViewInfoProvider;", "Lcom/intellij/database/run/ui/TabInfoProvider;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "openValueEditorTab", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lkotlin/jvm/functions/Function0;)V", "viewer", "Lcom/intellij/database/run/ui/RecordView;", "update", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "getViewer", "dispose", "intellij.grid.impl"})
public final class RecordViewInfoProvider
extends TabInfoProvider {
    @NotNull
    private final RecordView viewer;

    public RecordViewInfoProvider(@NotNull DataGrid grid, @NotNull Function0<Unit> openValueEditorTab) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(openValueEditorTab, (String)"openValueEditorTab");
        String string = DataGridBundle.message((String)"EditMaximized.Record.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        AnAction anAction = ActionManager.getInstance().getAction("Console.TableResult.EditMaximized.Record.Group");
        super(string, anAction instanceof ActionGroup ? (ActionGroup)anAction : null);
        this.viewer = new RecordView(grid, openValueEditorTab);
        this.updateTabInfo();
    }

    @Override
    public void update(@Nullable UpdateEvent event) {
        this.setUpdated(false);
        if (this.isOnTab()) {
            super.update(event);
            if (!this.viewer.validateIfNeeded()) {
                this.updateTabInfo();
            }
        }
    }

    @Override
    @NotNull
    public RecordView getViewer() {
        return this.viewer;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.viewer);
    }
}

