/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallableTypeImpl
implements PyCallableType {
    @Nullable
    private final List<PyCallableParameter> myParameters;
    @Nullable
    private final PyType myReturnType;
    @Nullable
    private final PyCallable myCallable;
    @Nullable
    private final PyAstFunction.Modifier myModifier;
    private final int myImplicitOffset;

    public PyCallableTypeImpl(@Nullable List<PyCallableParameter> parameters, @Nullable PyType returnType) {
        this(parameters, returnType, null, null, 0);
    }

    public PyCallableTypeImpl(@Nullable List<PyCallableParameter> parameters, @Nullable PyType returnType, @Nullable PyCallable callable, @Nullable PyAstFunction.Modifier modifier, int offset) {
        this.myParameters = parameters;
        this.myReturnType = returnType;
        this.myCallable = callable;
        this.myModifier = modifier;
        this.myImplicitOffset = offset;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(0);
        }
        return this.myReturnType;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(1);
        }
        if (callSite == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(2);
        }
        if (!PyTypeChecker.hasGenerics(this.myReturnType, context)) {
            return PyNarrowedType.Companion.bindIfNeeded(this.myReturnType, callSite);
        }
        PyCallExpression.PyArgumentsMapping fullMapping = PyCallExpressionHelper.mapArguments(callSite, this, context);
        Map<PyExpression, PyCallableParameter> actualParameters = fullMapping.getMappedParameters();
        List allParameters = ContainerUtil.notNullize(this.getParameters(context));
        PyExpression receiver = callSite.getReceiver(this.myCallable);
        return PyCallableTypeImpl.analyzeCallType(this.myReturnType, actualParameters, allParameters, receiver, callSite, context);
    }

    @Nullable
    private static PyType analyzeCallType(@Nullable PyType type2, @NotNull Map<PyExpression, PyCallableParameter> actualParameters, @NotNull Collection<PyCallableParameter> allParameters, @Nullable PyExpression receiver, @NotNull PyCallSiteExpression callsite, @NotNull TypeEvalContext context) {
        if (actualParameters == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(3);
        }
        if (allParameters == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(4);
        }
        if (callsite == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(6);
        }
        PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.unifyGenericCall(receiver, actualParameters, context);
        PyTypeChecker.GenericSubstitutions substitutionsWithUnresolvedReturnGenerics = PyTypeChecker.getSubstitutionsWithUnresolvedReturnGenerics(allParameters, type2, substitutions, context);
        PyType typeAfterSubstitution = PyTypeChecker.substitute(type2, substitutionsWithUnresolvedReturnGenerics, context);
        return PyNarrowedType.Companion.bindIfNeeded(typeAfterSubstitution, callsite);
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(7);
        }
        return this.myParameters;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name2 == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(8);
        }
        if (direction == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(9);
        }
        if (resolveContext == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @Nullable
    public String getName() {
        TypeEvalContext context = TypeEvalContext.codeInsightFallback(null);
        return String.format("(%s) -> %s", this.myParameters != null ? StringUtil.join(this.myParameters, param -> {
            if (param != null) {
                StringBuilder builder = new StringBuilder();
                String name2 = param.getName();
                PyType type2 = param.getType(context);
                if (name2 != null) {
                    builder.append(name2);
                    if (type2 != null) {
                        builder.append(": ");
                    }
                }
                builder.append(type2 != null ? type2.getName() : "Any");
                return builder.toString();
            }
            return "Any";
        }, (String)", ") : "...", this.myReturnType != null ? this.myReturnType.getName() : "Any");
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    @Override
    @Nullable
    public PyCallable getCallable() {
        return this.myCallable;
    }

    @Override
    @Nullable
    public PyAstFunction.Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public int getImplicitOffset() {
        return this.myImplicitOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyCallableTypeImpl type2 = (PyCallableTypeImpl)o;
        return this.myImplicitOffset == type2.myImplicitOffset && Objects.equals(this.myParameters, type2.myParameters) && Objects.equals(this.myReturnType, type2.myReturnType) && Objects.equals(this.myCallable, type2.myCallable) && this.myModifier == type2.myModifier;
    }

    public int hashCode() {
        return Objects.hash(this.myParameters, this.myReturnType, this.myCallable, this.myModifier, this.myImplicitOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callsite";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/types/PyCallableTypeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReturnType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeCallType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

