/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u001a\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\nJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/notebooks/visualization/UpdateContext;", "", "force", "", "<init>", "(Z)V", "getForce", "()Z", "foldingOperations", "", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "", "inlayOperations", "Lcom/intellij/openapi/editor/InlayModel;", "addFoldingOperation", "block", "addInlayOperation", "applyUpdates", "editor", "Lcom/intellij/openapi/editor/Editor;", "RemovalTrackingFoldingModel", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nUpdateContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateContext.kt\ncom/intellij/notebooks/visualization/UpdateContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1863#2,2:59\n1863#2,2:61\n*S KotlinDebug\n*F\n+ 1 UpdateContext.kt\ncom/intellij/notebooks/visualization/UpdateContext\n*L\n26#1:59,2\n33#1:61,2\n*E\n"})
public final class UpdateContext {
    private final boolean force;
    @NotNull
    private final List<Function1<FoldingModelEx, Unit>> foldingOperations;
    @NotNull
    private final List<Function1<InlayModel, Unit>> inlayOperations;

    public UpdateContext(boolean force) {
        this.force = force;
        this.foldingOperations = new ArrayList();
        this.inlayOperations = new ArrayList();
    }

    public /* synthetic */ UpdateContext(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getForce() {
        return this.force;
    }

    public final void addFoldingOperation(@NotNull Function1<? super FoldingModelEx, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.foldingOperations.add(block);
    }

    public final void addInlayOperation(@NotNull Function1<? super InlayModel, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.inlayOperations.add(block);
    }

    public final void applyUpdates(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.isDisposed()) {
            return;
        }
        if (!((Collection)this.foldingOperations).isEmpty()) {
            FoldingModel foldingModel = editor.getFoldingModel();
            Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
            RemovalTrackingFoldingModel foldingModel2 = new RemovalTrackingFoldingModel((FoldingModelImpl)foldingModel);
            foldingModel2.runBatchFoldingOperation(() -> UpdateContext.applyUpdates$lambda$1(this, foldingModel2), true, false);
        }
        if (!((Collection)this.inlayOperations).isEmpty()) {
            InlayModel inlayModel = editor.getInlayModel();
            Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
            InlayModel inlayModel2 = inlayModel;
            inlayModel2.execute(true, () -> UpdateContext.applyUpdates$lambda$3(this, inlayModel2));
        }
    }

    private static final void applyUpdates$lambda$1(UpdateContext this$0, RemovalTrackingFoldingModel $foldingModel) {
        Iterable $this$forEach$iv = this$0.foldingOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)$foldingModel);
        }
    }

    private static final void applyUpdates$lambda$3(UpdateContext this$0, InlayModel $inlayModel) {
        Iterable $this$forEach$iv = this$0.inlayOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)$inlayModel);
        }
    }

    public UpdateContext() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J9\u0010\u0013\u001a\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0012\b\u0001\u0010\u0018\u001a\f0\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u0015H\u0097\u0001J1\u0010\u001b\u001a\u00020\t2\u0012\b\u0001\u0010\u0016\u001a\f0\u001c\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00152\u0012\b\u0001\u0010\u0017\u001a\f0\u001d\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u0015H\u0096\u0001J\t\u0010\u001e\u001a\u00020\tH\u0096\u0001J\t\u0010\u001f\u001a\u00020\tH\u0096\u0001JW\u0010 \u001a\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0012\b\u0001\u0010\u0018\u001a\f0\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00152\u0014\b\u0001\u0010!\u001a\u000e\u0018\u00010\"\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010#\u001a\u00020\u0007H\u0097\u0001J4\u0010$\u001a(\u0012\f\u0012\n &*\u0004\u0018\u00010\u000b0\u000b &*\u0014\u0012\u000e\b\u0001\u0012\n &*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010%0%H\u0096\u0001\u00a2\u0006\u0002\u0010'JF\u0010(\u001a:\u0012\f\u0012\n &*\u0004\u0018\u00010\u000b0\u000b &*\u001c\u0012\u000e\b\u0001\u0012\n &*\u0004\u0018\u00010\u000b0\u000b0%\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00150%\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010'J\u001d\u0010)\u001a\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0097\u0001J%\u0010*\u001a\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0097\u0001J*\u0010+\u001a\n &*\u0004\u0018\u00010\u000b0\u000b2\u0012\b\u0001\u0010\u0016\u001a\f0,\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010-JT\u0010.\u001a8\u0012\f\u0012\n &*\u0004\u0018\u00010\u000b0\u000b &*\u001a\u0012\f\u0012\n &*\u0004\u0018\u00010\u000b0\u000b00\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00150/\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00152\u000e\u0010\u0016\u001a\n &*\u0004\u0018\u00010\"0\"H\u0097\u0001\u00a2\u0006\u0002\u00101J\u0011\u00102\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0096\u0001J\u0015\u00103\u001a\u000e\u0018\u000104\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001JX\u00105\u001a<\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u0015 &*\u001c\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001500\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00150/\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0097\u0001\u00a2\u0006\u0002\u00106J\u001d\u00107\u001a\u00020\u00072\u0012\b\u0001\u0010\u0016\u001a\f0\u000b\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u0015H\u0096\u0001J\u0019\u00108\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001J\t\u00109\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010:\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000fH\u0096\u0001J\t\u0010;\u001a\u00020\tH\u0096\u0001J%\u0010<\u001a\u00020\t2\u0012\b\u0001\u0010\u0016\u001a\f0=\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0017\u001a\u00020\u0007H\u0097\u0001J-\u0010<\u001a\u00020\t2\u0012\b\u0001\u0010\u0016\u001a\f0=\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010>\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/notebooks/visualization/UpdateContext$RemovalTrackingFoldingModel;", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "model", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/FoldingModelImpl;)V", "resetCache", "", "removeFoldRegion", "", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "addCustomLinesFolding", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "startLine", "", "endLine", "renderer", "Lcom/intellij/openapi/editor/CustomFoldRegionRenderer;", "addFoldRegion", "Lorg/jetbrains/annotations/Nullable;", "Lkotlin/jvm/internal/EnhancedNullability;", "p0", "p1", "p2", "", "Lorg/jetbrains/annotations/NotNull;", "addListener", "Lcom/intellij/openapi/editor/ex/FoldingListener;", "Lcom/intellij/openapi/Disposable;", "clearDocumentRangesModificationStatus", "clearFoldRegions", "createFoldRegion", "p3", "Lcom/intellij/openapi/editor/FoldingGroup;", "p4", "fetchTopLevel", "", "kotlin.jvm.PlatformType", "()[Lcom/intellij/openapi/editor/FoldRegion;", "getAllFoldRegions", "getCollapsedRegionAtOffset", "getFoldRegion", "getFoldingPlaceholderAt", "Ljava/awt/Point;", "(Ljava/awt/Point;)Lcom/intellij/openapi/editor/FoldRegion;", "getGroupedRegions", "", "", "(Lcom/intellij/openapi/editor/FoldingGroup;)Ljava/util/List;", "getLastCollapsedRegionBefore", "getPlaceholderAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getRegionsOverlappingWith", "(II)Ljava/util/List;", "hasDocumentRegionChangedFor", "intersectsRegion", "isFoldingEnabled", "isOffsetCollapsed", "rebuild", "runBatchFoldingOperation", "Ljava/lang/Runnable;", "setFoldingEnabled", "intellij.notebooks.visualization"})
    private static final class RemovalTrackingFoldingModel
    implements FoldingModelEx {
        @NotNull
        private final FoldingModelImpl model;
        private boolean resetCache;

        public RemovalTrackingFoldingModel(@NotNull FoldingModelImpl model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.model = model;
        }

        public void removeFoldRegion(@NotNull FoldRegion region) {
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            this.resetCache = true;
            this.model.removeFoldRegion(region);
        }

        @Nullable
        public CustomFoldRegion addCustomLinesFolding(int startLine, int endLine, @NotNull CustomFoldRegionRenderer renderer) {
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            if (this.resetCache) {
                this.model.updateCachedOffsets();
                this.resetCache = false;
            }
            return this.model.addCustomLinesFolding(startLine, endLine, renderer);
        }

        public void setFoldingEnabled(boolean p0) {
            this.model.setFoldingEnabled(p0);
        }

        public boolean isFoldingEnabled() {
            return this.model.isFoldingEnabled();
        }

        public FoldRegion getFoldingPlaceholderAt(@NotNull Point p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.model.getFoldingPlaceholderAt(p0);
        }

        public boolean intersectsRegion(int p0, int p1) {
            return this.model.intersectsRegion(p0, p1);
        }

        public int getLastCollapsedRegionBefore(int p0) {
            return this.model.getLastCollapsedRegionBefore(p0);
        }

        @Nullable
        public TextAttributes getPlaceholderAttributes() {
            return this.model.getPlaceholderAttributes();
        }

        public FoldRegion[] fetchTopLevel() {
            return this.model.fetchTopLevel();
        }

        @Nullable
        public FoldRegion createFoldRegion(int p0, int p1, @NotNull String p2, @Nullable FoldingGroup p3, boolean p4) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            return this.model.createFoldRegion(p0, p1, p2, p3, p4);
        }

        public void addListener(@NotNull FoldingListener p0, @NotNull Disposable p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            this.model.addListener(p0, p1);
        }

        public void clearFoldRegions() {
            this.model.clearFoldRegions();
        }

        public void rebuild() {
            this.model.rebuild();
        }

        @NotNull
        public List<FoldRegion> getGroupedRegions(FoldingGroup p0) {
            List list = this.model.getGroupedRegions(p0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGroupedRegions(...)");
            return list;
        }

        public void clearDocumentRangesModificationStatus() {
            this.model.clearDocumentRangesModificationStatus();
        }

        public boolean hasDocumentRegionChangedFor(@NotNull FoldRegion p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.model.hasDocumentRegionChangedFor(p0);
        }

        @NotNull
        public List<FoldRegion> getRegionsOverlappingWith(int p0, int p1) {
            List list = this.model.getRegionsOverlappingWith(p0, p1);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegionsOverlappingWith(...)");
            return list;
        }

        @Nullable
        public FoldRegion addFoldRegion(int p0, int p1, @NotNull String p2) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            return this.model.addFoldRegion(p0, p1, p2);
        }

        @NotNull
        public FoldRegion[] getAllFoldRegions() {
            FoldRegion[] foldRegionArray = this.model.getAllFoldRegions();
            Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
            return foldRegionArray;
        }

        public boolean isOffsetCollapsed(int p0) {
            return this.model.isOffsetCollapsed(p0);
        }

        @Nullable
        public FoldRegion getCollapsedRegionAtOffset(int p0) {
            return this.model.getCollapsedRegionAtOffset(p0);
        }

        @Nullable
        public FoldRegion getFoldRegion(int p0, int p1) {
            return this.model.getFoldRegion(p0, p1);
        }

        @Deprecated(message="Deprecated in Java")
        public void runBatchFoldingOperation(@NotNull Runnable p0, boolean p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.model.runBatchFoldingOperation(p0, p1);
        }

        public void runBatchFoldingOperation(@NotNull Runnable p0, boolean p1, boolean p2) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.model.runBatchFoldingOperation(p0, p1, p2);
        }
    }
}

