/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalsDetails;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.kit.Quote;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.EnclosureLexeme;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexemeUtilsKt;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionProposalsContext;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimByUnbalancedCloseEnclosureTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "context", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionProposalsContext;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionProposalsContext;)V", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "balanceBefore", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/EnclosureLexeme;", "getBalanceBefore", "()Ljava/util/List;", "balanceBefore$delegate", "Lkotlin/Lazy;", "balanceAfter", "getBalanceAfter", "balanceAfter$delegate", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "isMatch", "", "open", "close", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nProposalTransformers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProposalTransformers.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimByUnbalancedCloseEnclosureTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,358:1\n774#2:359\n865#2,2:360\n*S KotlinDebug\n*F\n+ 1 ProposalTransformers.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimByUnbalancedCloseEnclosureTransformer\n*L\n79#1:359\n79#1:360,2\n*E\n"})
public final class TrimByUnbalancedCloseEnclosureTransformer
extends DiagnosableProposalTransformer {
    @NotNull
    private final MLCompletionProposalsContext context;
    @NotNull
    private final MLCompletionEnclosuresDefinition enclosuresDefinition;
    @NotNull
    private final Lazy balanceBefore$delegate;
    @NotNull
    private final Lazy balanceAfter$delegate;

    public TrimByUnbalancedCloseEnclosureTransformer(@NotNull MLCompletionLanguageKit kit, @NotNull MLCompletionProposalsContext context2) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super("Trim by unbalanced bracket");
        this.context = context2;
        this.enclosuresDefinition = kit.getEnclosures().getDefinition();
        this.balanceBefore$delegate = LazyKt.lazy(() -> TrimByUnbalancedCloseEnclosureTransformer.balanceBefore_delegate$lambda$0(this));
        this.balanceAfter$delegate = LazyKt.lazy(() -> TrimByUnbalancedCloseEnclosureTransformer.balanceAfter_delegate$lambda$2(this));
    }

    private final List<EnclosureLexeme> getBalanceBefore() {
        Lazy lazy = this.balanceBefore$delegate;
        return (List)lazy.getValue();
    }

    private final List<EnclosureLexeme> getBalanceAfter() {
        Lazy lazy = this.balanceAfter$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        return (RawMLCompletionProposal)this.diagnoseMapping((MLCompletionProposal)proposal, () -> TrimByUnbalancedCloseEnclosureTransformer.transformRaw$lambda$3(proposal, this));
    }

    private final boolean isMatch(EnclosureLexeme open, EnclosureLexeme close) {
        EnclosureLexeme enclosureLexeme = open;
        EnclosureLexeme enclosureLexeme2 = close;
        return Intrinsics.areEqual((Object)(enclosureLexeme != null ? enclosureLexeme.getText() : null), (Object)this.enclosuresDefinition.getCloseToOpen().get(enclosureLexeme2 != null ? enclosureLexeme2.getText() : null));
    }

    private static final List balanceBefore_delegate$lambda$0(TrimByUnbalancedCloseEnclosureTransformer this$0) {
        return MLCompletionLexemeUtilsKt.findBalanceBreakAware(MLCompletionLexemeUtilsKt.enclosures(this$0.context.getLexemesBeforeOffset()), this$0.enclosuresDefinition);
    }

    /*
     * WARNING - void declaration
     */
    private static final List balanceAfter_delegate$lambda$2(TrimByUnbalancedCloseEnclosureTransformer this$0) {
        void $this$filterTo$iv$iv;
        Set<Integer> alreadyPairedBracketsOffsets = this$0.context.getAfterOffset().getAlreadyPairedBracketsOffsets();
        int completionOffset = this$0.context.getOffset();
        Iterable $this$filter$iv = MLCompletionLexemeUtilsKt.enclosures(this$0.context.getAfterOffset().getLexemes());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EnclosureLexeme it = (EnclosureLexeme)element$iv$iv;
            boolean bl = false;
            if (!(completionOffset + it.getOffset() < this$0.context.getLineRange().getEndOffset() || !alreadyPairedBracketsOffsets.contains(it.getOffset()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return MLCompletionLexemeUtilsKt.findInvertedBalanceBreakAware((List)destination$iv$iv, this$0.enclosuresDefinition);
    }

    private static final RawMLCompletionProposal transformRaw$lambda$3(RawMLCompletionProposal $proposal, TrimByUnbalancedCloseEnclosureTransformer this$0) {
        if (((CharSequence)$proposal.getSuggestion()).length() == 0) {
            return $proposal;
        }
        SortedSet sortedSet = $proposal.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES());
        if (sortedSet == null || (sortedSet = CollectionsKt.toSortedSet((Iterable)sortedSet)) == null) {
            sortedSet = SetsKt.sortedSetOf((Object[])new Integer[0]);
        }
        SortedSet matchedIndices = sortedSet;
        List<EnclosureLexeme> allEnclosures = MLCompletionLexemeUtilsKt.enclosures(this$0.context.lexemesOf($proposal));
        Set<Integer> alreadyPairedEnclosuresOffsets = this$0.context.getAfterOffset().getAlreadyPairedBracketsOffsets();
        List stack = new ArrayList();
        int balanceBeforeIndex = this$0.getBalanceBefore().size() - 1;
        boolean lineSurroundingQuoteUsed = false;
        for (EnclosureLexeme enclosure : allEnclosures) {
            EnclosureLexeme enclosureLexeme = enclosure;
            if (enclosureLexeme instanceof EnclosureLexeme.Open) {
                stack.add(enclosure);
                continue;
            }
            if (enclosureLexeme instanceof EnclosureLexeme.Close) {
                boolean matched = false;
                if (this$0.isMatch((EnclosureLexeme)CollectionsKt.lastOrNull((List)stack), enclosure)) {
                    EnclosureLexeme open = (EnclosureLexeme)CollectionsKt.last((List)stack);
                    if (enclosure instanceof EnclosureLexeme.StringMarker) {
                        matched = true;
                    } else if (!matchedIndices.contains(open.getOffset()) || matchedIndices.contains(enclosure.getOffset())) {
                        matched = true;
                    } else {
                        int indexAfterCaret = matchedIndices.headSet(open.getOffset()).size();
                        if (!alreadyPairedEnclosuresOffsets.contains(indexAfterCaret)) {
                            matched = true;
                        }
                    }
                    if (matched) {
                        CollectionsKt.removeLast((List)stack);
                    }
                } else if (stack.isEmpty()) {
                    if (matchedIndices.contains(enclosure.getOffset())) {
                        matched = true;
                    } else {
                        EnclosureLexeme openEnclosureBefore = (EnclosureLexeme)CollectionsKt.getOrNull(this$0.getBalanceBefore(), (int)balanceBeforeIndex);
                        EnclosureLexeme closeEnclosureAfter = (EnclosureLexeme)CollectionsKt.firstOrNull(this$0.getBalanceAfter());
                        if (this$0.isMatch(openEnclosureBefore, enclosure) && !this$0.isMatch(openEnclosureBefore, closeEnclosureAfter)) {
                            --balanceBeforeIndex;
                            matched = true;
                        }
                    }
                    if (!matched && !lineSurroundingQuoteUsed && this$0.getBalanceBefore().isEmpty() && enclosure instanceof EnclosureLexeme.StringMarker.Close) {
                        Map<String, String> map2 = this$0.enclosuresDefinition.getOpenToClose();
                        Quote quote = this$0.context.getLineSurroundingOpenQuote();
                        String expectedCloseQuote = map2.get(quote != null ? quote.getQuote() : null);
                        if (Intrinsics.areEqual((Object)expectedCloseQuote, (Object)enclosure.getText())) {
                            lineSurroundingQuoteUsed = true;
                            matched = true;
                        }
                    }
                }
                if (matched) continue;
                String string = $proposal.getSuggestion().substring(0, enclosure.getOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return $proposal.withSuggestion(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        return $proposal;
    }
}

