/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.extensions.github.alerts;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.ParserState;
import org.commonmark.text.Characters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.markdown.extensions.github.alerts.AlertBlock;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\n*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/jewel/markdown/extensions/github/alerts/AlertParser;", "Lorg/commonmark/parser/block/AbstractBlockParser;", "type", "", "<init>", "(Ljava/lang/String;)V", "block", "Lorg/jetbrains/jewel/markdown/extensions/github/alerts/AlertBlock;", "getBlock", "isContainer", "", "canContain", "childBlock", "Lorg/commonmark/node/Block;", "tryContinue", "Lorg/commonmark/parser/block/BlockContinue;", "parserState", "Lorg/commonmark/parser/block/ParserState;", "isMarker", "index", "", "intellij.platform.jewel.markdown.extensions.gfmAlerts"})
final class AlertParser
extends AbstractBlockParser {
    @NotNull
    private final AlertBlock block;

    public AlertParser(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = type.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.block = switch (string) {
            case "note" -> new AlertBlock.Note();
            case "tip" -> new AlertBlock.Tip();
            case "important" -> new AlertBlock.Important();
            case "warning" -> new AlertBlock.Warning();
            case "caution" -> new AlertBlock.Caution();
            default -> throw new IllegalStateException(("Unsupported highlighted blockquote type: '" + type + "'").toString());
        };
    }

    @NotNull
    public AlertBlock getBlock() {
        return this.block;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(@Nullable Block childBlock) {
        return !(childBlock instanceof AlertBlock);
    }

    @Nullable
    public BlockContinue tryContinue(@NotNull ParserState parserState) {
        BlockContinue blockContinue;
        Intrinsics.checkNotNullParameter((Object)parserState, (String)"parserState");
        int nextNonSpace = parserState.getNextNonSpaceIndex();
        if (this.isMarker(parserState, nextNonSpace)) {
            int newColumn = parserState.getColumn() + parserState.getIndent() + 1;
            if (Characters.isSpaceOrTab((CharSequence)parserState.getLine().getContent(), (int)(nextNonSpace + 1))) {
                ++newColumn;
            }
            blockContinue = BlockContinue.atColumn((int)newColumn);
        } else {
            blockContinue = BlockContinue.none();
        }
        return blockContinue;
    }

    private final boolean isMarker(ParserState $this$isMarker, int index) {
        CharSequence line = $this$isMarker.getLine().getContent();
        return $this$isMarker.getIndent() < Parsing.CODE_BLOCK_INDENT && index < line.length() && line.charAt(index) == '>';
    }
}

