/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.CollapsedDumpParser;
import com.intellij.profiler.api.BaseCallStackElement;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH$J\b\u0010\r\u001a\u00020\u000eH$J\b\u0010\u000f\u001a\u00020\u0010H$\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/FileReader;", "", "<init>", "()V", "readFully", "", "parser", "Lcom/intellij/profiler/CollapsedDumpParser;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createReader", "Ljava/io/BufferedReader;", "withProgressFraction", "", "progressFraction", "", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerDumpUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerDumpUtil.kt\ncom/intellij/profiler/FileReader\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n57#2:100\n1#3:101\n*S KotlinDebug\n*F\n+ 1 ProfilerDumpUtil.kt\ncom/intellij/profiler/FileReader\n*L\n22#1:100\n22#1:101\n*E\n"})
public abstract class FileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readFully(@NotNull CollapsedDumpParser<BaseCallStackElement> parser, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        BufferedReader reader = this.createReader();
        boolean withProgress = false;
        withProgress = this.withProgressFraction();
        boolean initialIsIndeterminateState = indicator.isIndeterminate();
        if (withProgress) {
            indicator.setIndeterminate(false);
        }
        Reader $this$useLines$iv = reader;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            for (String line : lines) {
                if (withProgress) {
                    try {
                        double fraction = this.progressFraction();
                        indicator.setFraction(fraction);
                    }
                    catch (Throwable e) {
                        indicator.setIndeterminate(true);
                        withProgress = false;
                    }
                }
                indicator.checkCanceled();
                parser.consumeLine(line);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        indicator.setIndeterminate(initialIsIndeterminateState);
    }

    @NotNull
    protected abstract BufferedReader createReader();

    protected abstract boolean withProgressFraction();

    protected abstract double progressFraction();
}

