/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.ES6ImportExecutorFactory;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportExecutorFactory;
import com.intellij.lang.javascript.modules.imports.JSRequireExecutorFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.ultimate.PluginVerifier;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHandlersFactory {
    public static final LanguageExtension<JSHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.handlersFactory");
    private static final JSHandlersFactory DEFAULT_INSTANCE = new JSHandlersFactory();

    public JSHandlersFactory() {
        PluginVerifier.verifyUltimatePlugin();
    }

    @NotNull
    public static JSHandlersFactory forElement(@Nullable PsiElement element) {
        Language dialect = element != null ? DialectDetector.languageOfElement(element) : null;
        return JSHandlersFactory.forLanguage(dialect);
    }

    @NotNull
    public static JSHandlersFactory forLanguage(@Nullable Language dialect) {
        JSHandlersFactory dialectSpecificFactory = dialect != null ? (JSHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSHandlersFactory jSHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSHandlersFactory == null) {
            JSHandlersFactory.$$$reportNull$$$0(0);
        }
        return jSHandlersFactory;
    }

    @Nullable
    public final JSAddImportExecutor createAddImportExecutor(@NotNull PsiElement place) {
        List<JSImportExecutorFactory> factories;
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(1);
        }
        if ((factories = this.createImportFactories(place)).isEmpty()) {
            return null;
        }
        return factories.get(0).createExecutor(place);
    }

    @NotNull
    public List<JSImportExecutorFactory> createImportFactories(@NotNull PsiElement place) {
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(2);
        }
        ArrayList<JSImportExecutorFactory> objects = new ArrayList<JSImportExecutorFactory>();
        if (JSHandlersFactory.isES6ImportAvailable(place)) {
            objects.add(ES6ImportExecutorFactory.FACTORY);
        }
        if (JSHandlersFactory.isCommonJSAvailable(place)) {
            objects.add(JSRequireExecutorFactory.FACTORY);
        }
        ArrayList<JSImportExecutorFactory> arrayList = objects;
        if (arrayList == null) {
            JSHandlersFactory.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public JSImportPlaceInfo createImportPlaceInfo(@NotNull PsiElement place, ResolveResult @NotNull [] results) {
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(4);
        }
        if (results == null) {
            JSHandlersFactory.$$$reportNull$$$0(5);
        }
        return new JSImportPlaceInfo(place, results);
    }

    @NotNull
    public final JSImportPlaceInfo createImportPlaceInfo(@NotNull PsiElement place) {
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(6);
        }
        JSImportPlaceInfo jSImportPlaceInfo = this.createImportPlaceInfo(place, ResolveResult.EMPTY_ARRAY);
        if (jSImportPlaceInfo == null) {
            JSHandlersFactory.$$$reportNull$$$0(7);
        }
        return jSImportPlaceInfo;
    }

    public static boolean isES6ImportAvailable(@NotNull PsiElement place) {
        DialectOptionHolder holder;
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(8);
        }
        if ((holder = DialectDetector.dialectOfElement(place)) == null) {
            return false;
        }
        if (!holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return false;
        }
        if (holder.isJavaScript()) {
            PsiFile file = place.getContainingFile();
            if (file != null && CommonJSUtil.isCjsFile(file)) {
                return false;
            }
            return JSHandlersFactory.checkModuleStatus(place, false);
        }
        return true;
    }

    private static boolean checkModuleStatus(@NotNull PsiElement place, boolean commonJS) {
        PsiElement module;
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(9);
        }
        if ((module = ES6PsiUtil.findExternalModule(place, false)) != null) {
            return !commonJS;
        }
        JSModuleStatusOwner owner = ES6PsiUtil.getModuleStatusOwner(place);
        if (owner != null) {
            JSModuleStatusOwner.ModuleStatus toCompare = commonJS ? JSModuleStatusOwner.ModuleStatus.ES6 : JSModuleStatusOwner.ModuleStatus.COMMONJS;
            return owner.getModuleStatus() != toCompare;
        }
        JSElement scope2 = ES6PsiUtil.getNonStrictExportScope(place);
        return scope2 != null;
    }

    private static boolean isCommonJSAvailable(@NotNull PsiElement place) {
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(10);
        }
        if (place instanceof JSXmlLiteralExpression) {
            return false;
        }
        if (DialectDetector.isJavaScript(place)) {
            PsiFile placeFile = place.getContainingFile();
            if (placeFile != null && CommonJSUtil.isMjsFile(placeFile)) {
                return false;
            }
            return JSHandlersFactory.checkModuleStatus(place, true);
        }
        return false;
    }

    @NotNull
    public JSCompletionKeywordsContributor newCompletionKeywordsContributor() {
        return new JSCompletionKeywordsContributor();
    }

    @NotNull
    public Class<? extends JSCodeStyleSettings> getCodeStyleSettingsClass() {
        return JSCodeStyleSettings.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSHandlersFactory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSHandlersFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportFactories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportPlaceInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAddImportExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createImportFactories";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createImportPlaceInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isES6ImportAvailable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkModuleStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCommonJSAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

