/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrayTypeImpl
extends JSTypeBaseImpl
implements JSArrayType {
    private static final JSType.LocalTypeKey GENERIC_ARRAY_KEY = JSType.createLocalTypeKey("js.array.generic.type");
    private static final JSType.LocalTypeKey GENERIC_READONLY_ARRAY_KEY = JSType.createLocalTypeKey("js.readonly.array.generic.type");
    @NotNull
    private final JSType myType;

    public JSArrayTypeImpl(@Nullable JSType type2, @NotNull JSTypeSource typeSource) {
        if (typeSource == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(0);
        }
        super(typeSource);
        this.myType = type2 != null ? type2 : JSAnyType.getWithLanguage(typeSource.getLanguage());
    }

    protected JSArrayTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(2);
        }
        super(typeSource);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(typeSource, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(4);
        }
        this.myType.accept(visitor);
    }

    @Override
    @NotNull
    public JSGenericTypeImpl asGenericType() {
        JSGenericTypeImpl jSGenericTypeImpl = (JSGenericTypeImpl)this.getResolveCachedType(() -> JSArrayType.GenericArrayBuilder.getGenericType((JSType)this, this.myType, this.isReadonly()), this.getTypeKey());
        if (jSGenericTypeImpl == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(5);
        }
        return jSGenericTypeImpl;
    }

    private JSType.LocalTypeKey getTypeKey() {
        return this.isReadonly() ? GENERIC_READONLY_ARRAY_KEY : GENERIC_ARRAY_KEY;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        boolean wrapInBrackets;
        if (format == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(6);
        }
        if (builder2 == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(7);
        }
        if (format == JSType.TypeTextFormat.CODE && this.isEcma()) {
            builder2.append("Array");
            return;
        }
        if (this.isReadonly()) {
            builder2.append("readonly ");
        }
        if (wrapInBrackets = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType)) {
            builder2.append("(");
        }
        this.myType.buildTypeText(format, builder2);
        if (wrapInBrackets) {
            builder2.append(")");
        }
        builder2.append("[]");
    }

    @Override
    protected int hashCodeImpl() {
        return this.myType.hashCode();
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        if (!this.isEcma()) {
            return null;
        }
        PsiElement clazz = JSResolveUtil.findType("Array", (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(9);
        }
        if (elementType instanceof JSArrayType) {
            if (JSTypeComparingContextService.isSubtyping(processingContext)) {
                if (JSArrayTypeImpl.isEmptyArrayType(this)) {
                    return false;
                }
                if (JSArrayTypeImpl.isEmptyArrayType((JSArrayType)elementType)) {
                    return true;
                }
            }
            if (!((JSArrayType)elementType).isPrimitive()) {
                return this.myType.isDirectlyAssignableType(((JSArrayType)elementType).getType(), processingContext);
            }
            return true;
        }
        if (elementType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)elementType;
            if (JSArrayType.isGenericArray(genericType)) {
                return this.myType.isDirectlyAssignableType(genericType.getArguments().get(0), processingContext);
            }
            return this.asGenericType().isDirectlyAssignableType(elementType, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static boolean isEmptyArrayType(@NotNull JSArrayType type2) {
        PsiElement element;
        if (type2 == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(10);
        }
        return (element = type2.getSourceElement()) instanceof JSExpression && JSTypeGuardUtil.isEmptyArrayExpression((JSExpression)element);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(11);
        }
        if (processingContext == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(12);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSArrayTypeImpl.$$$reportNull$$$0(13);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.asGenericType().isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(14);
        }
        return assignableResult3;
    }

    @Override
    @Nullable
    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create(this.getTypeName(), null);
    }

    @Override
    public boolean hasQualifiedName() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(15);
        }
        return this.myType.isEquivalentTo(((JSArrayTypeImpl)type2).getType(), processingContext, allowResolve);
    }

    @Override
    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType newComponentType;
        JSType oldComponentType;
        if (childTransform == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(17);
        }
        if (newSource == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(18);
        }
        if ((oldComponentType = this.getType()) == (newComponentType = JSTypeUtils.transformTypeHierarchySafe(oldComponentType, childTransform))) {
            JSArrayTypeImpl jSArrayTypeImpl = this;
            if (jSArrayTypeImpl == null) {
                JSArrayTypeImpl.$$$reportNull$$$0(19);
            }
            return jSArrayTypeImpl;
        }
        return new JSArrayTypeImpl(newComponentType, newSource);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(20);
        }
        return new JSArrayTypeImpl(this.getType(), source);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 13, 14, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asGenericType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyArrayType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 13, 14, 16, 19 -> new IllegalStateException(string);
        };
    }
}

