/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSInheritedFromObjectFilter
implements Filter {
    public static final String ID = "HIDE_INHERITED_FROM_OBJECT";

    public boolean isVisible(TreeElement treeNode) {
        String qualifiedName;
        JSStructureViewElementBase node;
        JSStructureViewElementBase jSStructureViewElementBase = node = treeNode instanceof JSStructureViewElementBase ? (JSStructureViewElementBase)treeNode : null;
        if (node == null || !node.isInherited()) {
            return true;
        }
        PsiElement o = node.getValue();
        JSQualifiedName name = o instanceof JSElementBase ? ((JSElementBase)o).getNamespace() : null;
        String string = qualifiedName = name == null ? null : name.getQualifiedName();
        if (qualifiedName == null && DialectDetector.isActionScript(o)) {
            PsiElement parentClass = JSResolveUtil.findParent(o);
            qualifiedName = parentClass instanceof JSClass ? ((JSClass)parentClass).getQualifiedName() : null;
        }
        return !"Object".equals(qualifiedName);
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(JavaScriptBundle.message("action.structureview.show.object.inherited", new Object[0]), null, AllIcons.Json.Object);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    public boolean isReverted() {
        return true;
    }
}

