/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeImpl;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeValueImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.service.DocumentOffsetsManager;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceExtension;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptInlayHintsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.compiler.ui.TypeScriptNodePackageWrapper;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TypeScriptLanguageServiceUtil {
    public static final String LIB_DIRECTORY = "lib";
    public static final Condition<VirtualFile> IS_VALID_FILE_FOR_SERVICE = virtualFile -> virtualFile != null && virtualFile.isInLocalFileSystem();
    public static final Condition<VirtualFile> ACCEPTABLE_TS_FILE = virtualFile -> {
        if (!IS_VALID_FILE_FOR_SERVICE.value(virtualFile)) {
            return false;
        }
        FileType type2 = virtualFile.getFileType();
        return TypeScriptLanguageServiceUtil.isTypeScriptFileType(type2) && virtualFile.getUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER) == null;
    };
    private static final String[] TYPESCRIPT_SERVICE_FILES = new String[]{"tsserver.js", "tsserverlibrary.js"};
    private static final Set<String> FILE_BASE_PARAMETERS = ImmutableSet.of((Object)"p", (Object)"project", (Object)"out", (Object)"outFile", (Object)"outDir");
    public static final String[] CONFIG_PARAMS = new String[]{"-p", "--p", "--project", "-project"};
    @TestOnly
    public static volatile TypeScriptUseServiceState ourUseService = TypeScriptUseServiceState.DO_NOT_USE;

    @TestOnly
    public static void setUseService(boolean useService) {
        ourUseService = useService ? TypeScriptUseServiceState.USE_FOR_EVERYTHING : TypeScriptUseServiceState.DO_NOT_USE;
    }

    @TestOnly
    public static void useService(boolean forEverything, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(0);
        }
        ourUseService = forEverything ? TypeScriptUseServiceState.USE_FOR_EVERYTHING : TypeScriptUseServiceState.USE_FOR_EVALUATION;
        Disposer.register((Disposable)parentDisposable, () -> {
            ourUseService = TypeScriptUseServiceState.DO_NOT_USE;
        });
    }

    public static boolean isTypeScriptFileType(FileType type2) {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type2);
    }

    public static boolean isJavaScriptOrTypeScriptFileType(@NotNull FileType type2) {
        if (type2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(1);
        }
        return TypeScriptLanguageServiceUtil.isTypeScriptFileType(type2) || type2 == JavaScriptFileType.INSTANCE;
    }

    public static boolean isServiceEnabled(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return TypeScriptLanguageServiceUtil.isServiceEnabled(settings);
    }

    private static boolean isServiceEnabled(@Nullable TypeScriptCompilerSettings settings) {
        if (settings == null || ApplicationManager.getApplication().isUnitTestMode() && ourUseService == TypeScriptUseServiceState.DO_NOT_USE) {
            return false;
        }
        return settings.useService();
    }

    @ApiStatus.Internal
    public static boolean isServiceCompletionEnabled() {
        return !Objects.equals(Registry.get((String)"typescript.service.completion.enabled").getSelectedOption(), "false");
    }

    @ApiStatus.Internal
    public static boolean isServiceCompletionConservative() {
        return Objects.equals(Registry.get((String)"typescript.service.completion.enabled").getSelectedOption(), "conservative");
    }

    public static boolean useServiceCompletion(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(2);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && TypeScriptCompilerSettings.getSettings(project).isUseServiceCompletion();
    }

    public static boolean useServiceParameterInfo(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(3);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && ACCEPTABLE_TS_FILE.value((Object)file) && TypeScriptCompilerSettings.getSettings(project).isUseServiceParameterInfo();
    }

    @Contract(value="null -> false")
    public static boolean checkProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && project.isOpen();
    }

    private static boolean useNewTypeScriptService(@Nullable Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourUseService != TypeScriptUseServiceState.USE_FOR_EVERYTHING || project == null) {
            return false;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.useService();
    }

    public static boolean shouldUseMainFile(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(4);
        }
        return settings.useMainFile();
    }

    public static String getActualLibDirectory(@Nullable Project project, @NotNull TypeScriptCompilerSettings settings) {
        VirtualFile dir;
        VirtualFile packageJson;
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(5);
        }
        if (project == null || project.isDefault() || project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode() && ourUseService == TypeScriptUseServiceState.DO_NOT_USE) {
            return null;
        }
        NodeJsInterpreter interpreter2 = TypeScriptLanguageServiceUtil.getNodeInterpreter(project, settings);
        TypeScriptNodePackageWrapper.TypeScriptNodePackageDescriptor descriptor = TypeScriptNodePackageWrapper.createDescriptor(project, settings);
        NodePackage nodePackage = TypeScriptNodePackageWrapper.getPackageFromSettings(project, descriptor, settings, interpreter2);
        String path2 = nodePackage.getSystemIndependentPath();
        if (nodePackage instanceof YarnPnpNodePackage && (packageJson = ((YarnPnpNodePackage)nodePackage).getPackageJson(project)) != null && (dir = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson, nodePackage.getName())) != null) {
            return nodePackage.getSystemIndependentPath();
        }
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path2);
        VirtualFile modulePackage = TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModulePackage(fileByPath);
        return modulePackage == null ? null : modulePackage.getPath();
    }

    @Nullable
    public static VirtualFile getDefaultConfig(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(6);
        }
        if (project.isDisposed() || DumbService.isDumb((Project)project)) {
            return null;
        }
        VirtualFile candidate = TypeScriptLanguageServiceUtil.getDefaultOptionsConfig(project);
        if (candidate != null) {
            return candidate;
        }
        List<VirtualFile> result2 = TypeScriptConfigUtil.getRootConfigFiles(project);
        if (result2.isEmpty()) {
            return null;
        }
        if (result2.size() == 1) {
            return result2.get(0);
        }
        return ((StreamEx)StreamEx.of(result2).map(VirtualFile::getParent).distinct()).count() == 1L ? result2.get(0) : null;
    }

    @Nullable
    public static VirtualFile getDefaultOptionsConfig(@NotNull Project project) {
        VirtualFile candidate;
        Object projectPathObject;
        Map<String, Object> parsedOptions;
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(7);
        }
        if (!(parsedOptions = TypeScriptLanguageServiceUtil.getDefaultOptions(project)).isEmpty() && (projectPathObject = parsedOptions.get("project")) instanceof String && (candidate = LocalFileSystem.getInstance().findFileByPath(projectPathObject.toString())) != null) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public static String getDefaultConfigPath(@NotNull Project project) {
        VirtualFile config;
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(8);
        }
        return (config = TypeScriptLanguageServiceUtil.getDefaultConfig(project)) != null ? JSLanguageServiceUtil.normalizeNameAndPath(config) : null;
    }

    @Nullable
    public static VirtualFile getTypeScriptLibFromNodeModulePackage(@Nullable VirtualFile nodeModulePackage) {
        if (nodeModulePackage == null) {
            return null;
        }
        if (TypeScriptLanguageServiceUtil.hasServiceFiles(nodeModulePackage)) {
            return nodeModulePackage;
        }
        VirtualFile lib = nodeModulePackage.findChild(LIB_DIRECTORY);
        if (lib == null) {
            return null;
        }
        if (TypeScriptLanguageServiceUtil.hasServiceFiles(lib)) {
            return lib;
        }
        return null;
    }

    public static boolean hasServiceFiles(@NotNull VirtualFile lib) {
        VirtualFile[] children;
        if (lib == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(9);
        }
        if ((children = lib.getChildren()) != null) {
            for (VirtualFile file : children) {
                if (!ArrayUtil.contains((String)file.getName(), (String[])TYPESCRIPT_SERVICE_FILES)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @NlsSafe
    public static String getNormalizedVersionString(@Nullable String version2) {
        if (version2 == null) {
            return null;
        }
        Version parseVersion = Version.parseVersion((String)version2);
        if (parseVersion == null) {
            return null;
        }
        return parseVersion.toString();
    }

    public static void fillFileStartLength(@NotNull Project project, @NotNull TypeScriptInlayHintsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull Document document, @NotNull TextRange textRange) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(10);
        }
        if (args == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(11);
        }
        if (virtualFile == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(12);
        }
        if (document == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(13);
        }
        if (textRange == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(14);
        }
        DocumentOffsetsManager offsetsManager = (DocumentOffsetsManager)project.getService(DocumentOffsetsManager.class);
        int startOriginal = (Integer)ReadAction.compute(() -> offsetsManager.getOriginalOffset(document, textRange.getStartOffset()));
        int endOriginal = (Integer)ReadAction.compute(() -> offsetsManager.getOriginalOffset(document, textRange.getEndOffset()));
        args.start = startOriginal + 1;
        args.length = endOriginal - startOriginal;
        args.file = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile));
    }

    @Nullable
    public static NodeJsInterpreter getNodeInterpreter(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(16);
        }
        return NodeJsInterpreterRef.create(settings.getNodeInterpreterRefName()).resolve(project);
    }

    @Nullable
    public static NodeJsInterpreter getNodeInterpreter(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(17);
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return JSLanguageServiceUtil.getInterpreterIfValid(TypeScriptLanguageServiceUtil.getNodeInterpreter(project, settings));
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @Nullable String path2) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmpty((String)path2)) {
            String string = StringUtil.notNullize((String)path2);
            if (string == null) {
                TypeScriptLanguageServiceUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = (String)ReadAction.compute(() -> {
            VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path2);
            if (fileByPath == null) {
                return path2;
            }
            if (DumbService.isDumb((Project)project) || project.isDisposed() || !project.isOpen()) {
                return path2;
            }
            VirtualFile root = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(fileByPath);
            if (root != null) {
                return "/" + VfsUtilCore.getRelativePath((VirtualFile)fileByPath, (VirtualFile)root);
            }
            return path2;
        });
        if (string == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    public static JSLanguageServiceUtil.PsiElementInfo getPsiElementInfo(@Nullable PsiFile file, @NotNull Document document, @Nullable TypeScriptResponseCommon.Location start, @Nullable TypeScriptResponseCommon.Location end) {
        if (document == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(21);
        }
        if (start == null || end == null) {
            return null;
        }
        int line = start.line - 1;
        int startOffset = start.offset - 1;
        int endLine = end.line - 1;
        int endOffset = end.offset - 1;
        return JSLanguageServiceUtil.getElementInfo(file, document, line, startOffset, endLine, endOffset);
    }

    public static TypeScriptService.CompletionMergeStrategy getCompletionMergeStrategy(@NotNull CompletionParameters parameters2, @NotNull PsiFile file, @NotNull PsiElement context2) {
        boolean isJavaScript;
        if (parameters2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(22);
        }
        if (file == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(23);
        }
        if (context2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(24);
        }
        if (!(isJavaScript = DialectDetector.isJavaScript(context2)) && !DialectDetector.isTypeScript(context2) || isJavaScript && !TypeScriptConfigUtil.allowJS(file)) {
            return TypeScriptService.CompletionMergeStrategy.NON;
        }
        return TypeScriptLanguageServiceUtil.getMergeStrategyForPosition(context2, isJavaScript);
    }

    public static TypeScriptService.CompletionMergeStrategy getMergeStrategyForPosition(@NotNull PsiElement position, boolean isJavaScript) {
        ES6FromClause clause;
        ES6ImportDeclaration declaration;
        ASTNode node;
        TypeScriptService.CompletionMergeStrategy defaultStrategy;
        PsiElement parent;
        if (position == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(25);
        }
        if ((parent = position.getParent()) == null) {
            return TypeScriptService.CompletionMergeStrategy.NON;
        }
        if (parent instanceof JSLiteralExpression && ((JSLiteralExpression)parent).isQuotedLiteral()) {
            return TypeScriptService.CompletionMergeStrategy.MERGE;
        }
        TypeScriptService.CompletionMergeStrategy completionMergeStrategy = defaultStrategy = isJavaScript ? TypeScriptService.CompletionMergeStrategy.MERGE : TypeScriptService.CompletionMergeStrategy.REPLACE;
        if (parent instanceof JSXXmlLiteralExpressionImpl && (node = position.getNode()).getElementType() == JSTokenTypes.XML_TAG_NAME && position.textContains('.') && node.getText().endsWith("IntellijIdeaRulezzz")) {
            return defaultStrategy;
        }
        if (parent instanceof ES6ImportSpecifier && (declaration = ((ES6ImportSpecifier)parent).getDeclaration()) != null && (clause = declaration.getFromClause()) != null) {
            return clause.resolveReferencedElements().isEmpty() ? defaultStrategy : TypeScriptService.CompletionMergeStrategy.NON;
        }
        if (parent instanceof JSXmlAttributeImpl || parent instanceof JSXmlAttributeValueImpl) {
            return defaultStrategy;
        }
        if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() != null) {
            return ((JSReferenceExpression)parent).getQualifier() instanceof JSThisExpression ? TypeScriptService.CompletionMergeStrategy.MERGE : defaultStrategy;
        }
        if (parent instanceof JSReferenceExpression && TypeScriptLanguageServiceUtil.isShorthandedProperty(parent)) {
            return defaultStrategy;
        }
        if (parent instanceof JSVariable && parent.getParent() instanceof JSDestructuringProperty) {
            return defaultStrategy;
        }
        if (TypeScriptLanguageServiceUtil.isServiceCompletionConservative()) {
            return TypeScriptService.CompletionMergeStrategy.NON;
        }
        return isJavaScript ? TypeScriptService.CompletionMergeStrategy.NON : TypeScriptService.CompletionMergeStrategy.MERGE;
    }

    @NotNull
    public static Map<String, Object> getDefaultOptions(@NotNull Project project) {
        String expanded;
        String value;
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(26);
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        String parameters2 = settings.getDefaultServiceOptions();
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        VirtualFile projectDir = project.getBaseDir();
        if (settings.useDeprecatedSettings() && settings.isHasOutDirectory() && (value = TypeScriptLanguageServiceUtil.parseMacroOrSelf(project, settings.getOutDirectory())) != null) {
            if (!FileUtil.isAbsolute((String)value) && projectDir != null) {
                value = FileUtil.toSystemDependentName((String)(projectDir.getPath() + "/" + value));
            }
            result2.put(TypeScriptUtil.isJavaScriptFile(value) ? "outFile" : "outDir", value);
        }
        boolean isGenerateSourceMap = settings.isGenerateSourceMap();
        if (settings.useDeprecatedSettings()) {
            result2.put("sourceMap", isGenerateSourceMap);
        }
        if (!StringUtil.isEmpty((String)(expanded = TypeScriptLanguageServiceUtil.parseMacroOrSelf(project, parameters2)))) {
            List strings = ParametersListUtil.parse((String)expanded);
            for (int i = 0; i < strings.size(); ++i) {
                String valueAsString;
                String string = (String)strings.get(i);
                if (!string.startsWith("-")) continue;
                String compilerOption = TypeScriptLanguageServiceUtil.getCompilerOptionName(string);
                int nextIndex = i + 1;
                if (nextIndex < strings.size() && !(valueAsString = (String)strings.get(nextIndex)).startsWith("-")) {
                    Object value2 = TypeScriptLanguageServiceUtil.parseValue(valueAsString);
                    if (TypeScriptLanguageServiceUtil.isFilePathCommand(compilerOption) && !FileUtil.isAbsolute((String)valueAsString) && projectDir != null) {
                        value2 = FileUtil.toSystemDependentName((String)(projectDir.getPath() + "/" + String.valueOf(value2)));
                    }
                    result2.put(compilerOption, value2);
                    ++i;
                    continue;
                }
                result2.put(compilerOption, true);
            }
        }
        HashMap<String, Object> hashMap = result2;
        if (hashMap == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    @NotNull
    private static String getCompilerOptionName(String string) {
        String trimmed = StringUtil.trimStart((String)StringUtil.trimStart((String)string, (String)"-"), (String)"-");
        if (trimmed.equals("t")) {
            return "target";
        }
        if (trimmed.equals("p")) {
            return "project";
        }
        if (trimmed.equals("m")) {
            return "module";
        }
        if (trimmed.equals("d")) {
            return "declaration";
        }
        String string2 = trimmed;
        if (string2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(28);
        }
        return string2;
    }

    private static boolean isFilePathCommand(@NotNull String shortName) {
        if (shortName == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(29);
        }
        return FILE_BASE_PARAMETERS.contains(shortName);
    }

    @Nullable
    private static String parseMacroOrSelf(@NotNull Project project, @Nullable String parameters2) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(30);
        }
        if (parameters2 == null) {
            return parameters2;
        }
        DataContext context2 = SimpleDataContext.getProjectContext((Project)project);
        String expanded = parameters2;
        try {
            expanded = MacroManager.getInstance().expandMacrosInString(parameters2, true, context2);
        }
        catch (Macro.ExecutionCancelledException executionCancelledException) {
            // empty catch block
        }
        return expanded;
    }

    @Nullable
    private static Object parseValue(@NotNull String value) {
        if (value == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(31);
        }
        if (Boolean.TRUE.toString().equals(value)) {
            return true;
        }
        if (Boolean.FALSE.toString().equals(value)) {
            return false;
        }
        if ("null".equals(value)) {
            return null;
        }
        return value;
    }

    private static boolean isShorthandedProperty(@NotNull PsiElement parent) {
        PsiElement candidate;
        if (parent == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(32);
        }
        return (candidate = parent.getParent()) instanceof JSProperty && ((JSProperty)candidate).isShorthanded();
    }

    public static boolean saveChangedConfigs(@NotNull PsiFile file) {
        Collection<VirtualFile> configs;
        if (file == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(33);
        }
        if (!(configs = TypeScriptLanguageServiceUtil.getChangedConfigs((PsiElement)file)).isEmpty()) {
            TypeScriptLanguageServiceUtil.saveChangedFilesAndRestartHighlighting(file, configs);
            return true;
        }
        return false;
    }

    private static void saveChangedFilesAndRestartHighlighting(@NotNull PsiFile file, @NotNull Collection<VirtualFile> changedFiles) {
        if (file == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(34);
        }
        if (changedFiles == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(35);
        }
        Project project = file.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            for (VirtualFile config : changedFiles) {
                Document document = FileDocumentManager.getInstance().getDocument(config);
                if (document == null) continue;
                FileDocumentManager.getInstance().saveDocument(document);
            }
            DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
        }, project.getDisposed());
    }

    @NotNull
    public static Collection<VirtualFile> getChangedConfigs(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager manager = FileDocumentManager.getInstance();
        SmartList changedConfigs = null;
        for (Document document : manager.getUnsavedDocuments()) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            PsiFile candidate = documentManager.getCachedPsiFile(document);
            if (candidate == null) continue;
            for (TypeScriptServiceExtension extension : TypeScriptServiceExtension.EP_NAME.getExtensionList()) {
                VirtualFile vFile;
                if (!extension.isConfigFile(candidate, context2)) continue;
                if (changedConfigs == null) {
                    changedConfigs = new SmartList();
                }
                if ((vFile = candidate.getVirtualFile()) == null) continue;
                changedConfigs.add(vFile);
            }
        }
        List<Object> list = changedConfigs == null ? Collections.emptyList() : changedConfigs;
        if (list == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 27, 28, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 23: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = LIB_DIRECTORY;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOptions";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOptionName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "useService";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScriptOrTypeScriptFileType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "useServiceCompletion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "useServiceParameterInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseMainFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActualLibDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfig";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOptionsConfig";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasServiceFiles";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillFileStartLength";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNodeInterpreter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 37: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementInfo";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionMergeStrategy";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMergeStrategyForPosition";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOptions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isFilePathCommand";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "parseMacroOrSelf";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandedProperty";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "saveChangedConfigs";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "saveChangedFilesAndRestartHighlighting";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getChangedConfigs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 27, 28, 37 -> new IllegalStateException(string);
        };
    }

    @TestOnly
    public static enum TypeScriptUseServiceState {
        DO_NOT_USE,
        USE_FOR_EVALUATION,
        USE_FOR_EVERYTHING;

    }
}

