/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Property;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.EnvironmentVariablesDataOptions;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.ValueWithDefault;
import org.jetbrains.plugins.terminal.settings.TerminalLocalOptions;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="TerminalProjectNonSharedOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002*+B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130%H\u0002J\u0006\u0010&\u001a\u00020\u0013J\u0018\u0010'\u001a\u00020\u00132\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130%H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u00132\b\u0010)\u001a\u0004\u0018\u00010\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R$\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "getState", "loadState", "", "newState", "getEnvData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "envData", "<set-?>", "", "startingDirectory", "getStartingDirectory", "()Ljava/lang/String;", "setStartingDirectory", "(Ljava/lang/String;)V", "startingDirectory$delegate", "Lorg/jetbrains/plugins/terminal/ValueWithDefault;", "defaultStartingDirectory", "getDefaultStartingDirectory", "getDefaultWorkingDirectory", "value", "shellPath", "getShellPath", "setShellPath", "isProjectLevelShellPath", "", "workingDirectory", "Lkotlin/Function0;", "defaultShellPath", "findDefaultShellPath", "findWslDistributionName", "directory", "State", "Companion", "intellij.terminal"})
public final class TerminalProjectOptionsProvider
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final State state;
    @NotNull
    private final ValueWithDefault startingDirectory$delegate;
    @NotNull
    private static final Logger LOG;

    public TerminalProjectOptionsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = new State();
        this.startingDirectory$delegate = new ValueWithDefault((KMutableProperty0)new MutablePropertyReference0Impl(this.state){

            public Object get() {
                return ((State)this.receiver).getStartingDirectory();
            }

            public void set(Object value) {
                ((State)this.receiver).setStartingDirectory((String)value);
            }
        }, () -> TerminalProjectOptionsProvider.startingDirectory_delegate$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state.setStartingDirectory(newState.getStartingDirectory());
        this.state.setShellPath(newState.getShellPath());
        this.state.setEnvDataOptions(newState.getEnvDataOptions());
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.state.getEnvDataOptions().get();
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData envData) {
        Intrinsics.checkNotNullParameter((Object)envData, (String)"envData");
        this.state.getEnvDataOptions().set(envData);
    }

    @Nullable
    public final String getStartingDirectory() {
        return this.startingDirectory$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setStartingDirectory(@Nullable String string) {
        this.startingDirectory$delegate.setValue(this, $$delegatedProperties[0], string);
    }

    @Nullable
    public final String getDefaultStartingDirectory() {
        String directory = null;
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                directory = customizer.getDefaultFolder(this.project);
                if (directory == null) continue;
                break;
            }
            catch (Exception e) {
                LOG.error("Exception during getting default folder", (Throwable)e);
            }
        }
        if (directory == null) {
            directory = this.getDefaultWorkingDirectory();
        }
        String string = directory;
        return string != null ? FileUtil.toSystemDependentName((String)string) : null;
    }

    private final String getDefaultWorkingDirectory() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        return virtualFile != null ? virtualFile.getCanonicalPath() : null;
    }

    @NotNull
    public final String getShellPath() {
        Lazy workingDirectoryLazy = LazyKt.lazy(() -> TerminalProjectOptionsProvider._get_shellPath_$lambda$1(this));
        String shellPath2 = this.isProjectLevelShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy){

            public Object get() {
                return ((Lazy)this.receiver).getValue();
            }
        })) && TrustedProjects.isTrusted((Project)this.project) ? this.state.getShellPath() : TerminalLocalOptions.Companion.getInstance().getShellPath();
        CharSequence charSequence = shellPath2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return this.findDefaultShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy){

                public Object get() {
                    return ((Lazy)this.receiver).getValue();
                }
            }));
        }
        return shellPath2;
    }

    public final void setShellPath(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Lazy workingDirectoryLazy = LazyKt.lazy(() -> TerminalProjectOptionsProvider._set_shellPath_$lambda$2(this));
        String valueToStore2 = Strings.nullize((String)value, (String)this.findDefaultShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy){

            public Object get() {
                return ((Lazy)this.receiver).getValue();
            }
        })));
        if (this.isProjectLevelShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy){

            public Object get() {
                return ((Lazy)this.receiver).getValue();
            }
        }))) {
            this.state.setShellPath(valueToStore2);
        } else {
            TerminalLocalOptions.Companion.getInstance().setShellPath(valueToStore2);
        }
    }

    private final boolean isProjectLevelShellPath(Function0<String> workingDirectory) {
        return SystemInfo.isWindows && this.findWslDistributionName((String)workingDirectory.invoke()) != null;
    }

    @NotNull
    public final String defaultShellPath() {
        return this.findDefaultShellPath((Function0<String>)((Function0)() -> TerminalProjectOptionsProvider.defaultShellPath$lambda$3(this)));
    }

    private final String findDefaultShellPath(Function0<String> workingDirectory) {
        String wslDistributionName;
        if (SystemInfo.isWindows && (wslDistributionName = this.findWslDistributionName((String)workingDirectory.invoke())) != null) {
            return "wsl.exe --distribution " + wslDistributionName;
        }
        String shell = System.getenv("SHELL");
        if (shell != null && new File(shell).canExecute()) {
            return shell;
        }
        if (SystemInfo.isUnix) {
            String bashPath = "/bin/bash";
            if (new File(bashPath).exists()) {
                return bashPath;
            }
            return "/bin/sh";
        }
        return "powershell.exe";
    }

    private final String findWslDistributionName(String directory) {
        String string;
        String string2 = directory;
        if (string2 == null) {
            string = null;
        } else {
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(string2);
            string = wslPath != null ? wslPath.getDistributionId() : null;
        }
        return string;
    }

    private static final String startingDirectory_delegate$lambda$0(TerminalProjectOptionsProvider this$0) {
        return this$0.getDefaultStartingDirectory();
    }

    private static final String _get_shellPath_$lambda$1(TerminalProjectOptionsProvider this$0) {
        return this$0.getStartingDirectory();
    }

    private static final String _set_shellPath_$lambda$2(TerminalProjectOptionsProvider this$0) {
        return this$0.getStartingDirectory();
    }

    private static final String defaultShellPath$lambda$3(TerminalProjectOptionsProvider this$0) {
        return this$0.getStartingDirectory();
    }

    @JvmStatic
    @NotNull
    public static final TerminalProjectOptionsProvider getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TerminalProjectOptionsProvider.class, "startingDirectory", "getStartingDirectory()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(TerminalProjectOptionsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalProjectOptionsProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TerminalProjectOptionsProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TerminalProjectOptionsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u00020\u000e8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "", "<init>", "()V", "startingDirectory", "", "getStartingDirectory", "()Ljava/lang/String;", "setStartingDirectory", "(Ljava/lang/String;)V", "shellPath", "getShellPath", "setShellPath", "envDataOptions", "Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;", "getEnvDataOptions", "()Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;", "setEnvDataOptions", "(Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;)V", "intellij.terminal"})
    public static final class State {
        @Nullable
        private String startingDirectory;
        @Nullable
        private String shellPath;
        @NotNull
        private EnvironmentVariablesDataOptions envDataOptions = new EnvironmentVariablesDataOptions();

        @Nullable
        public final String getStartingDirectory() {
            return this.startingDirectory;
        }

        public final void setStartingDirectory(@Nullable String string) {
            this.startingDirectory = string;
        }

        @Nullable
        public final String getShellPath() {
            return this.shellPath;
        }

        public final void setShellPath(@Nullable String string) {
            this.shellPath = string;
        }

        @Property(surroundWithTag=false, flat=true)
        @NotNull
        public final EnvironmentVariablesDataOptions getEnvDataOptions() {
            return this.envDataOptions;
        }

        public final void setEnvDataOptions(@NotNull EnvironmentVariablesDataOptions environmentVariablesDataOptions) {
            Intrinsics.checkNotNullParameter((Object)((Object)environmentVariablesDataOptions), (String)"<set-?>");
            this.envDataOptions = environmentVariablesDataOptions;
        }
    }
}

