/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hive;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.hive.HiveDdlParsing;
import com.intellij.sql.dialects.hive.HiveDmlParsing;
import com.intellij.sql.dialects.hive.HiveExpressionParsing;
import com.intellij.sql.dialects.hive.HiveGeneratedParser;
import com.intellij.sql.dialects.hive.HiveTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public abstract class HiveParserBase
extends SqlParser {
    protected HiveParserBase(SqlLanguageDialectEx language) {
        super(language);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first2) {
        if (SqlGeneratedParserUtil.isExternalParameterFirst(builder.getTokenType())) {
            return true;
        }
        return SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN);
    }

    @Override
    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return refType == SQL_FUNCTION_REFERENCE;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return HiveGeneratedParser.statement(builder, level);
    }

    @Override
    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return HiveGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return HiveDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return HiveDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, HiveExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = HiveExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        return result2;
    }

    @Override
    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean distinct = SqlParserUtil.consumeToken(builder, true, HiveTypes.HIVE_DISTINCT);
        boolean all2 = false;
        if (!distinct) {
            all2 = SqlParserUtil.consumeToken(builder, true, HiveTypes.HIVE_ALL);
        }
        return super.parseFunctionArgument(builder, level, optional && !distinct && !all2, allowBoolean);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        HiveGeneratedParser.analytic_clause(builder, level);
        return true;
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, HiveDmlParsing::parenthesized_aliased_join_expression, HiveDmlParsing::top_query_expression, HiveParserBase::parseTopQueryExpressionTail, (b, l) -> HiveDmlParsing.join_expression(b, l, -1), (b, l) -> HiveDmlParsing.join_expression_0(b, l, -1));
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return HiveGeneratedParser.table_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        HiveDmlParsing.query_expression_0(builder, level, -1);
        return HiveDmlParsing.left_inner_table_op_tail(builder, level);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return HiveGeneratedParser.parse_root_(root, builder, level);
    }
}

