// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package readerrevenuesubscriptionlinking provides access to the Reader Revenue Subscription Linking API.
//
// For product documentation, see: https://developers.google.com/news/subscribe/subscription-linking/overview
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/readerrevenuesubscriptionlinking/v1"
//	...
//	ctx := context.Background()
//	readerrevenuesubscriptionlinkingService, err := readerrevenuesubscriptionlinking.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	readerrevenuesubscriptionlinkingService, err := readerrevenuesubscriptionlinking.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	readerrevenuesubscriptionlinkingService, err := readerrevenuesubscriptionlinking.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package readerrevenuesubscriptionlinking // import "google.golang.org/api/readerrevenuesubscriptionlinking/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "readerrevenuesubscriptionlinking:v1"
const apiName = "readerrevenuesubscriptionlinking"
const apiVersion = "v1"
const basePath = "https://readerrevenuesubscriptionlinking.googleapis.com/"
const basePathTemplate = "https://readerrevenuesubscriptionlinking.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://readerrevenuesubscriptionlinking.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Publications = NewPublicationsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Publications *PublicationsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewPublicationsService(s *Service) *PublicationsService {
	rs := &PublicationsService{s: s}
	rs.Readers = NewPublicationsReadersService(s)
	return rs
}

type PublicationsService struct {
	s *Service

	Readers *PublicationsReadersService
}

func NewPublicationsReadersService(s *Service) *PublicationsReadersService {
	rs := &PublicationsReadersService{s: s}
	return rs
}

type PublicationsReadersService struct {
	s *Service
}

// DeleteReaderResponse: Response to deleting a reader of a publication.
type DeleteReaderResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Entitlement: A single entitlement for a publication reader
type Entitlement struct {
	// Detail: The detail field can carry a description of the SKU that corresponds
	// to what the user has been granted access to. This description, which is
	// opaque to Google, can be displayed in the Google user subscription console
	// for users who linked the subscription to a Google Account. Max 80 character
	// limit.
	Detail string `json:"detail,omitempty"`
	// ExpireTime: Required. Expiration time of the entitlement. Entitlements that
	// have expired over 30 days will be purged. The max expire_time is 398 days
	// from now().
	ExpireTime string `json:"expireTime,omitempty"`
	// ProductId: Required. The publication's product ID that the user has access
	// to. This is the same product ID as can be found in Schema.org markup
	// (http://schema.org/productID). E.g. "dailybugle.com:basic"
	ProductId string `json:"productId,omitempty"`
	// SubscriptionToken: A source-specific subscription token. This is an opaque
	// string that the publisher provides to Google. This token is opaque and has
	// no meaning to Google.
	SubscriptionToken string `json:"subscriptionToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Entitlement) MarshalJSON() ([]byte, error) {
	type NoMethod Entitlement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Reader: A reader of a publication.
type Reader struct {
	// CreateTime: Output only. Time the publication reader was created and
	// associated with a Google user.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. The resource name of the reader. The last part of ppid in
	// the resource name is the publisher provided id.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Reader) MarshalJSON() ([]byte, error) {
	type NoMethod Reader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReaderEntitlements: A singleton containing all of a reader's entitlements
// for a publication.
type ReaderEntitlements struct {
	// Entitlements: All of the entitlements for a publication reader.
	Entitlements []*Entitlement `json:"entitlements,omitempty"`
	// Name: Output only. The resource name of the singleton.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entitlements") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entitlements") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReaderEntitlements) MarshalJSON() ([]byte, error) {
	type NoMethod ReaderEntitlements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PublicationsReadersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a publication reader, effectively severing the association
// with a Google user. If `force` is set to true, any entitlements for this
// reader will also be deleted. (Otherwise, the request will only work if the
// reader has no entitlements.) - If the reader does not exist, return
// NOT_FOUND. - Return FAILED_PRECONDITION if the force field is false (or
// unset) and entitlements are present.
//
//   - name: The resource name of the reader. Format:
//     publications/{publication_id}/readers/{ppid}.
func (r *PublicationsReadersService) Delete(name string) *PublicationsReadersDeleteCall {
	c := &PublicationsReadersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, any entitlements
// under the reader will also be purged.
func (c *PublicationsReadersDeleteCall) Force(force bool) *PublicationsReadersDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PublicationsReadersDeleteCall) Fields(s ...googleapi.Field) *PublicationsReadersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PublicationsReadersDeleteCall) Context(ctx context.Context) *PublicationsReadersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PublicationsReadersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PublicationsReadersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "readerrevenuesubscriptionlinking.publications.readers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *DeleteReaderResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PublicationsReadersDeleteCall) Do(opts ...googleapi.CallOption) (*DeleteReaderResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DeleteReaderResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PublicationsReadersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a reader of a publication. Returns NOT_FOUND if the reader does
// not exist.
//
//   - name: The resource name of the reader. Format:
//     publications/{publication_id}/readers/{ppid}.
func (r *PublicationsReadersService) Get(name string) *PublicationsReadersGetCall {
	c := &PublicationsReadersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PublicationsReadersGetCall) Fields(s ...googleapi.Field) *PublicationsReadersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PublicationsReadersGetCall) IfNoneMatch(entityTag string) *PublicationsReadersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PublicationsReadersGetCall) Context(ctx context.Context) *PublicationsReadersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PublicationsReadersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PublicationsReadersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "readerrevenuesubscriptionlinking.publications.readers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reader.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PublicationsReadersGetCall) Do(opts ...googleapi.CallOption) (*Reader, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reader{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PublicationsReadersGetEntitlementsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEntitlements: Gets the reader entitlements for a publication reader. -
// Returns PERMISSION_DENIED if the caller does not have access. - Returns
// NOT_FOUND if the reader does not exist.
//
//   - name: The name of the reader entitlements to retrieve. Format:
//     publications/{publication_id}/readers/{reader_id}/entitlements.
func (r *PublicationsReadersService) GetEntitlements(name string) *PublicationsReadersGetEntitlementsCall {
	c := &PublicationsReadersGetEntitlementsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PublicationsReadersGetEntitlementsCall) Fields(s ...googleapi.Field) *PublicationsReadersGetEntitlementsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PublicationsReadersGetEntitlementsCall) IfNoneMatch(entityTag string) *PublicationsReadersGetEntitlementsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PublicationsReadersGetEntitlementsCall) Context(ctx context.Context) *PublicationsReadersGetEntitlementsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PublicationsReadersGetEntitlementsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PublicationsReadersGetEntitlementsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.getEntitlements", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "readerrevenuesubscriptionlinking.publications.readers.getEntitlements" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReaderEntitlements.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PublicationsReadersGetEntitlementsCall) Do(opts ...googleapi.CallOption) (*ReaderEntitlements, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReaderEntitlements{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.getEntitlements", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PublicationsReadersUpdateEntitlementsCall struct {
	s                  *Service
	name               string
	readerentitlements *ReaderEntitlements
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// UpdateEntitlements: Updates the reader entitlements for a publication
// reader. The entire reader entitlements will be overwritten by the new reader
// entitlements in the payload, like a PUT. - Returns PERMISSION_DENIED if the
// caller does not have access. - Returns NOT_FOUND if the reader does not
// exist.
//
// - name: Output only. The resource name of the singleton.
func (r *PublicationsReadersService) UpdateEntitlements(name string, readerentitlements *ReaderEntitlements) *PublicationsReadersUpdateEntitlementsCall {
	c := &PublicationsReadersUpdateEntitlementsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.readerentitlements = readerentitlements
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Defaults to all fields.
func (c *PublicationsReadersUpdateEntitlementsCall) UpdateMask(updateMask string) *PublicationsReadersUpdateEntitlementsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PublicationsReadersUpdateEntitlementsCall) Fields(s ...googleapi.Field) *PublicationsReadersUpdateEntitlementsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PublicationsReadersUpdateEntitlementsCall) Context(ctx context.Context) *PublicationsReadersUpdateEntitlementsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PublicationsReadersUpdateEntitlementsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PublicationsReadersUpdateEntitlementsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.readerentitlements)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.updateEntitlements", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "readerrevenuesubscriptionlinking.publications.readers.updateEntitlements" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReaderEntitlements.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PublicationsReadersUpdateEntitlementsCall) Do(opts ...googleapi.CallOption) (*ReaderEntitlements, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReaderEntitlements{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "readerrevenuesubscriptionlinking.publications.readers.updateEntitlements", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
