/*
 * Decompiled with CFR 0.152.
 */
package bsearch.algorithms;

import bsearch.algorithms.AbstractSearchMethod;
import bsearch.algorithms.SearchParameterException;
import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.SearchManager;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.space.SearchSpace;
import java.util.HashMap;
import org.nlogo.api.MersenneTwisterFast;

public strictfp class SimulatedAnnealing
extends AbstractSearchMethod {
    double mutationRate = 0.05;
    int restartAfterStallCount = 0;
    double initialTemperature = 1.0;
    double temperatureChangeFactor = 0.99;

    @Override
    public String getName() {
        return "SimulatedAnnealing";
    }

    @Override
    public String getDescription() {
        return "Simulated Annealing is similar to a hill climbing approach, except that a downhill (inferior) move may also occur, but only with a certain probability based on the 'temperature' of the system, which decreases over time.Simulated annealing is inspired by the physical annealing process in metallurgy: heating followed by the controlled cooling of a material in order to increase crystal size.";
    }

    @Override
    public void setSearchParams(HashMap<String, String> searchMethodParams) throws SearchParameterException {
        this.mutationRate = this.validDoubleParam(searchMethodParams, "mutation-rate", 0.0, 1.0);
        this.restartAfterStallCount = this.validIntParam(searchMethodParams, "restart-after-stall-count", 0, 1000);
        this.initialTemperature = this.validDoubleParam(searchMethodParams, "initial-temperature", 0.0, Double.MAX_VALUE);
        this.temperatureChangeFactor = this.validDoubleParam(searchMethodParams, "temperature-change-factor", 0.0, 1.0);
    }

    @Override
    public HashMap<String, String> getSearchParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mutation-rate", Double.toString(this.mutationRate));
        params.put("restart-after-stall-count", Integer.toString(this.restartAfterStallCount));
        params.put("initial-temperature", Double.toString(this.initialTemperature));
        params.put("temperature-change-factor", Double.toString(this.temperatureChangeFactor));
        return params;
    }

    @Override
    public HashMap<String, String> getSearchParamsHelp() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mutation-rate", "controls how much mutation occurs when choosing a new location to try to climb uphill");
        params.put("restart-after-stall-count", "if it doesn't move to a new location after X attempts, reset the temperature, jump to a random location in the search space and try again.");
        params.put("initial-temperature", "the system's initial 'temperature': a reasonable choice would be the average expected difference in the fitness function's value for two random points in the search space.");
        params.put("temperature-change-factor", "the system's current 'temperature' is multiplied by this factor (which needs to be less than 1!) after each move. (Using this exponential temperature decay means that temperature will approach 0 over time.)");
        return params;
    }

    boolean acceptChange(double currentFitness, double candidateFitness, double temperature, SearchManager manager, MersenneTwisterFast rng) {
        if (manager.fitnessStrictlyBetter(candidateFitness, currentFitness)) {
            return true;
        }
        if (temperature <= 0.0) {
            return false;
        }
        double fitnessDiff = StrictMath.abs(candidateFitness - currentFitness);
        return rng.nextDouble() < StrictMath.exp(-fitnessDiff / temperature);
    }

    @Override
    public void search(SearchSpace space, ChromosomeFactory cFactory, SearchProtocol protocol, SearchManager manager, MersenneTwisterFast rng) throws BehaviorSearchException, NetLogoLinkException, InterruptedException {
        double temperature = this.initialTemperature;
        block0: while (!manager.searchFinished()) {
            Chromosome current = cFactory.createChromosome(space, rng);
            double currentFitness = manager.computeFitnessSingle(current, protocol.fitnessSamplingReplications, rng);
            int stallCount = 0;
            while (!manager.searchFinished()) {
                Chromosome candidate = current.mutate(this.mutationRate, rng);
                int failedMutationCounter = 0;
                int MAX_MUTATION_ATTEMPTS = 1000000;
                while (candidate.equals(current) && failedMutationCounter < 1000000) {
                    candidate = current.mutate(this.mutationRate, rng);
                }
                if (failedMutationCounter == 1000000) {
                    throw new BehaviorSearchException("An extremely large number of mutation attempts all resulted in no mutation - perhaps your mutation-rate is too low?");
                }
                double candidateFitness = manager.computeFitnessSingle(candidate, protocol.fitnessSamplingReplications, rng);
                if (this.acceptChange(currentFitness, candidateFitness, temperature, manager, rng)) {
                    current = candidate;
                    currentFitness = candidateFitness;
                    temperature *= this.temperatureChangeFactor;
                    continue;
                }
                if (this.restartAfterStallCount <= 0 || ++stallCount < this.restartAfterStallCount) continue;
                temperature = this.initialTemperature;
                continue block0;
            }
        }
    }
}

