/*
 * Decompiled with CFR 0.152.
 */
package bsearch.app;

import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.ResultListener;
import bsearch.evaluation.SearchManager;
import bsearch.nlogolink.CSVHelper;
import bsearch.nlogolink.ModelRunResult;
import bsearch.representations.Chromosome;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import bsearch.util.Stats;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CSVLoggerListener
implements ResultListener {
    private SearchProtocol protocol;
    private PrintWriter modelHistoryOut = null;
    private PrintWriter fitnessOut = null;
    private int shortenOutputFactor = 1;
    private PrintWriter bestOut = null;
    private PrintWriter finalBestOut = null;
    private PrintWriter finalCheckedBestOut = null;
    private List<Object> lastBestRowData;
    private List<Object> checkedBestRowData;
    private double bestCheckedFitness;

    public CSVLoggerListener(SearchProtocol protocol, String fileNameStem, boolean logAllModelRuns, boolean logAllFitnessEvals, boolean logBests, boolean logFinalBests, int shortenOutputFactor) throws IOException, BehaviorSearchException {
        this.protocol = protocol;
        this.shortenOutputFactor = shortenOutputFactor;
        if (logAllModelRuns) {
            this.modelHistoryOut = new PrintWriter(new BufferedWriter(new FileWriter(fileNameStem + ".modelRunHistory.csv")));
        }
        if (logAllFitnessEvals) {
            this.fitnessOut = new PrintWriter(new BufferedWriter(new FileWriter(fileNameStem + ".objectiveFunctionHistory.csv")));
        }
        if (logBests) {
            this.bestOut = new PrintWriter(new BufferedWriter(new FileWriter(fileNameStem + ".bestHistory.csv")));
        }
        if (logFinalBests) {
            this.finalBestOut = new PrintWriter(new BufferedWriter(new FileWriter(fileNameStem + ".finalBests.csv")));
            if (protocol.useBestChecking()) {
                this.finalCheckedBestOut = new PrintWriter(new BufferedWriter(new FileWriter(fileNameStem + ".finalCheckedBests.csv")));
            }
        }
        try {
            FileWriter fw = new FileWriter(fileNameStem + ".searchConfig.xml");
            protocol.save(fw);
            fw.close();
        }
        catch (IOException ex) {
            throw new BehaviorSearchException("File I/O error attempting to create or write to file: '" + fileNameStem + ".searchConfig.xml'", ex);
        }
    }

    @Override
    public void initListener(SearchSpace space) {
        LinkedList<String> headerList;
        if (this.modelHistoryOut != null) {
            headerList = new LinkedList<String>();
            headerList.add("search-number");
            headerList.add("evaluation");
            headerList.add("evals-requested-so-far");
            for (ParameterSpec p : space.getParamSpecs()) {
                headerList.add(p.getParameterName() + "*");
            }
            headerList.add("random-seed");
            headerList.add("min-result");
            headerList.add("max-result");
            headerList.add("mean-result");
            headerList.add("stdev-result");
            headerList.add("final-step-result");
            this.modelHistoryOut.println(CSVHelper.headerRow(headerList));
        }
        if (this.fitnessOut != null) {
            headerList = new LinkedList();
            headerList.add("search-number");
            headerList.add("evaluation");
            for (ParameterSpec p : space.getParamSpecs()) {
                headerList.add(p.getParameterName() + "*");
            }
            headerList.add("fitness");
            headerList.add("num-replicates");
            headerList.add("best-fitness-so-far");
            if (this.protocol.useBestChecking()) {
                headerList.add("best-fitness-rechecked");
            }
            this.fitnessOut.println(CSVHelper.headerRow(headerList));
        }
        headerList = new LinkedList();
        headerList.add("search-number");
        headerList.add("evaluation");
        for (ParameterSpec p : space.getParamSpecs()) {
            headerList.add(p.getParameterName() + "*");
        }
        headerList.add("num-replicates");
        headerList.add("best-fitness-so-far");
        if (this.protocol.useBestChecking()) {
            headerList.add("recheck-replications");
            headerList.add("best-fitness-rechecked");
        }
        if (this.bestOut != null) {
            this.bestOut.println(CSVHelper.headerRow(headerList));
        }
        if (this.finalBestOut != null) {
            this.finalBestOut.println(CSVHelper.headerRow(headerList));
        }
        if (this.finalCheckedBestOut != null) {
            this.finalCheckedBestOut.println(CSVHelper.headerRow(headerList));
        }
    }

    @Override
    public void modelRunOccurred(SearchManager manager, Chromosome point, ModelRunResult result) {
        if (this.modelHistoryOut == null) {
            return;
        }
        LinkedList<Object> dataList = new LinkedList<Object>();
        dataList.add(manager.getSearchIDNumber());
        dataList.add(manager.getEvaluationCount());
        dataList.add(manager.getEvaluationsRequestedCount());
        for (ParameterSpec p : point.getSearchSpace().getParamSpecs()) {
            dataList.add(point.getParamSettings().get(p.getParameterName()));
        }
        dataList.add(Long.toString(result.getRandomSeed()));
        LinkedList<Double> resultTimeSeries = result.getPrimaryTimeSeries();
        dataList.add(Collections.min(resultTimeSeries));
        dataList.add(Collections.max(resultTimeSeries));
        dataList.add(Stats.mean(resultTimeSeries));
        dataList.add(Stats.stdev(resultTimeSeries));
        dataList.add(resultTimeSeries.getLast());
        this.modelHistoryOut.println(CSVHelper.dataRow(dataList));
    }

    @Override
    public void fitnessComputed(SearchManager manager, Chromosome point, double fitness) {
        if (this.fitnessOut == null) {
            return;
        }
        if (manager.getEvaluationCount() % this.shortenOutputFactor != 0) {
            return;
        }
        LinkedList<Object> dataList = new LinkedList<Object>();
        dataList.add(manager.getSearchIDNumber());
        dataList.add(manager.getEvaluationCount());
        for (ParameterSpec p : point.getSearchSpace().getParamSpecs()) {
            dataList.add(point.getParamSettings().get(p.getParameterName()));
        }
        dataList.add(fitness);
        List<ModelRunResult> allTrials = manager.getCachedResults(point);
        dataList.add(allTrials.size());
        dataList.add(manager.getCurrentBestFitness());
        if (this.protocol.useBestChecking()) {
            dataList.add(manager.getCurrentBestFitnessCheckedEstimate());
        }
        this.fitnessOut.println(CSVHelper.dataRow(dataList));
    }

    private List<Object> getRowDataForNewBest(SearchManager manager) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        dataList.add(manager.getSearchIDNumber());
        dataList.add(manager.getEvaluationCount());
        Chromosome newBest = manager.getCurrentBest();
        for (ParameterSpec p : newBest.getSearchSpace().getParamSpecs()) {
            dataList.add(newBest.getParamSettings().get(p.getParameterName()));
        }
        List<ModelRunResult> allTrials = manager.getCachedResults(newBest);
        dataList.add(allTrials.size());
        dataList.add(manager.getCurrentBestFitness());
        if (this.protocol.useBestChecking()) {
            dataList.add(manager.getBestFitnessCheckingReplications());
            dataList.add(manager.getCurrentBestFitnessCheckedEstimate());
        }
        return dataList;
    }

    @Override
    public void newBestFound(SearchManager manager) {
        this.lastBestRowData = this.getRowDataForNewBest(manager);
        if (this.protocol.useBestChecking()) {
            double checkedFitness = manager.getCurrentBestFitnessCheckedEstimate();
            if (this.checkedBestRowData == null || manager.fitnessStrictlyBetter(checkedFitness, this.bestCheckedFitness)) {
                this.checkedBestRowData = new ArrayList<Object>(this.lastBestRowData);
                this.bestCheckedFitness = checkedFitness;
            }
        }
        if (this.bestOut != null) {
            this.bestOut.println(CSVHelper.dataRow(this.lastBestRowData));
        }
    }

    @Override
    public void searchStarting(SearchManager manager) {
        this.lastBestRowData = null;
        this.checkedBestRowData = null;
    }

    @Override
    public void searchFinished(SearchManager manager) {
        if (this.finalBestOut != null) {
            this.lastBestRowData.set(1, manager.getEvaluationCount());
            this.finalBestOut.println(CSVHelper.dataRow(this.lastBestRowData));
        }
        if (this.finalCheckedBestOut != null) {
            this.checkedBestRowData.set(1, manager.getEvaluationCount());
            this.finalCheckedBestOut.println(CSVHelper.dataRow(this.checkedBestRowData));
        }
    }

    @Override
    public void allSearchesFinished() {
        if (this.modelHistoryOut != null) {
            this.modelHistoryOut.flush();
            this.modelHistoryOut.close();
        }
        if (this.fitnessOut != null) {
            this.fitnessOut.flush();
            this.fitnessOut.close();
        }
        if (this.bestOut != null) {
            this.bestOut.flush();
            this.bestOut.close();
        }
        if (this.finalBestOut != null) {
            this.finalBestOut.flush();
            this.finalBestOut.close();
        }
        if (this.finalCheckedBestOut != null) {
            this.finalCheckedBestOut.flush();
            this.finalCheckedBestOut.close();
        }
    }

    @Override
    public void searchesAborted() {
        this.allSearchesFinished();
    }
}

