/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPopupMenu;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class FigureAttributes
implements Cloneable,
Serializable {
    private Map fMap = CollectionsFactory.current().createMap();
    private static final long serialVersionUID = -6886355144423666716L;
    private int figureAttributesSerializedDataVersion = 1;

    public Object get(FigureAttributeConstant figureAttributeConstant) {
        return this.fMap.get(figureAttributeConstant);
    }

    public void set(FigureAttributeConstant figureAttributeConstant, Object object) {
        if (object != null) {
            this.fMap.put(figureAttributeConstant, object);
        } else {
            this.fMap.remove(figureAttributeConstant);
        }
    }

    public boolean hasDefined(FigureAttributeConstant figureAttributeConstant) {
        return this.fMap.containsKey(figureAttributeConstant);
    }

    public Object clone() {
        try {
            FigureAttributes figureAttributes = (FigureAttributes)super.clone();
            figureAttributes.fMap = CollectionsFactory.current().createMap(this.fMap);
            return figureAttributes;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        String string = storableInput.readString();
        if (!string.toLowerCase().equals("attributes")) {
            throw new IOException("Attributes expected");
        }
        this.fMap = CollectionsFactory.current().createMap();
        int n = storableInput.readInt();
        for (int i = 0; i < n; ++i) {
            String string2 = storableInput.readString();
            String string3 = storableInput.readString();
            Object object = null;
            if (string3.equals("Color")) {
                object = new Color(storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
            } else if (string3.equals("Boolean")) {
                object = new Boolean(storableInput.readString());
            } else if (string3.equals("String")) {
                object = storableInput.readString();
            } else if (string3.equals("Int")) {
                object = new Integer(storableInput.readInt());
            } else if (string3.equals("Storable")) {
                object = storableInput.readStorable();
            } else if (string3.equals("POPUP_MENU") || string3.equals("UNKNOWN")) continue;
            FigureAttributeConstant figureAttributeConstant = FigureAttributeConstant.getConstant(string2);
            this.set(figureAttributeConstant, object);
        }
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeString("attributes");
        storableOutput.writeInt(this.fMap.size());
        Iterator iterator = this.fMap.keySet().iterator();
        while (iterator.hasNext()) {
            FigureAttributeConstant figureAttributeConstant = (FigureAttributeConstant)iterator.next();
            String string = figureAttributeConstant.getName();
            Object v = this.fMap.get(figureAttributeConstant);
            storableOutput.writeString(string);
            if (v instanceof String) {
                storableOutput.writeString("String");
                storableOutput.writeString((String)v);
                continue;
            }
            if (v instanceof Color) {
                FigureAttributes.writeColor(storableOutput, "Color", (Color)v);
                continue;
            }
            if (v instanceof Boolean) {
                storableOutput.writeString("Boolean");
                if (((Boolean)v).booleanValue()) {
                    storableOutput.writeString("TRUE");
                    continue;
                }
                storableOutput.writeString("FALSE");
                continue;
            }
            if (v instanceof Integer) {
                storableOutput.writeString("Int");
                storableOutput.writeInt((Integer)v);
                continue;
            }
            if (v instanceof Storable) {
                storableOutput.writeString("Storable");
                storableOutput.writeStorable((Storable)v);
                continue;
            }
            if (v instanceof JPopupMenu) {
                storableOutput.writeString("POPUP_MENU");
                continue;
            }
            System.err.println("Unknown attribute: " + v);
            storableOutput.writeString("UNKNOWN");
        }
    }

    public static void writeColor(StorableOutput storableOutput, String string, Color color) {
        if (color != null) {
            storableOutput.writeString(string);
            storableOutput.writeInt(color.getRed());
            storableOutput.writeInt(color.getGreen());
            storableOutput.writeInt(color.getBlue());
        }
    }

    public static Color readColor(StorableInput storableInput) throws IOException {
        return new Color(storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
    }
}

