/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractFigure;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.OrderedFigureElement;
import org.jhotdraw.standard.QuadTree;
import org.jhotdraw.standard.ReverseFigureEnumerator;
import org.jhotdraw.util.Bounds;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class CompositeFigure
extends AbstractFigure
implements FigureChangeListener {
    protected List fFigures = CollectionsFactory.current().createList();
    private static final long serialVersionUID = 7408153435700021866L;
    private int compositeFigureSerializedDataVersion = 1;
    private transient QuadTree _theQuadTree;
    protected int _nLowestZ = 0;
    protected int _nHighestZ = 0;

    protected CompositeFigure() {
    }

    public Figure add(Figure figure) {
        if (!this.containsFigure(figure)) {
            figure.setZValue(++this._nHighestZ);
            this.fFigures.add(figure);
            figure.addToContainer(this);
            this._addToQuadTree(figure);
        }
        return figure;
    }

    public void addAll(List list) {
        this.addAll(new FigureEnumerator(list));
    }

    public void addAll(FigureEnumeration figureEnumeration) {
        while (figureEnumeration.hasNextFigure()) {
            this.add(figureEnumeration.nextFigure());
        }
    }

    public Figure remove(Figure figure) {
        Figure figure2 = this.orphan(figure);
        if (figure2 != null) {
            figure2.release();
        }
        return figure2;
    }

    public void removeAll(List list) {
        this.removeAll(new FigureEnumerator(list));
    }

    public void removeAll(FigureEnumeration figureEnumeration) {
        while (figureEnumeration.hasNextFigure()) {
            this.remove(figureEnumeration.nextFigure());
        }
    }

    public void removeAll() {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.removeFromContainer(this);
        }
        this.fFigures.clear();
        this._clearQuadTree();
        this._nLowestZ = 0;
        this._nHighestZ = 0;
    }

    public synchronized Figure orphan(Figure figure) {
        figure.removeFromContainer(this);
        this.fFigures.remove(figure);
        this._removeFromQuadTree(figure);
        return figure;
    }

    public void orphanAll(List list) {
        this.orphanAll(new FigureEnumerator(list));
    }

    public void orphanAll(FigureEnumeration figureEnumeration) {
        while (figureEnumeration.hasNextFigure()) {
            this.orphan(figureEnumeration.nextFigure());
        }
    }

    public synchronized Figure replace(Figure figure, Figure figure2) {
        int n = this.fFigures.indexOf(figure);
        if (n != -1) {
            figure2.setZValue(figure.getZValue());
            figure2.addToContainer(this);
            figure.removeFromContainer(this);
            this.fFigures.set(n, figure2);
            figure.changed();
            figure2.changed();
        }
        return figure2;
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.containsFigure(figure)) {
            this.fFigures.remove(figure);
            this.fFigures.add(0, figure);
            --this._nLowestZ;
            figure.setZValue(this._nLowestZ);
            figure.changed();
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.containsFigure(figure)) {
            this.fFigures.remove(figure);
            this.fFigures.add(figure);
            ++this._nHighestZ;
            figure.setZValue(this._nHighestZ);
            figure.changed();
        }
    }

    public void sendToLayer(Figure figure, int n) {
        if (this.containsFigure(figure)) {
            if (n >= this.fFigures.size()) {
                n = this.fFigures.size() - 1;
            }
            Figure figure2 = this.getFigureFromLayer(n);
            int n2 = figure2.getZValue();
            int n3 = this.getLayer(figure);
            if (n3 < n) {
                this.assignFiguresToPredecessorZValue(n3 + 1, n);
            } else if (n3 > n) {
                this.assignFiguresToSuccessorZValue(n, n3 - 1);
            }
            this.fFigures.remove(figure);
            this.fFigures.add(n, figure);
            figure.setZValue(n2);
            figure.changed();
        }
    }

    private void assignFiguresToPredecessorZValue(int n, int n2) {
        if (n2 >= this.fFigures.size()) {
            n2 = this.fFigures.size() - 1;
        }
        for (int i = n2; i >= n; --i) {
            Figure figure = (Figure)this.fFigures.get(i);
            Figure figure2 = (Figure)this.fFigures.get(i - 1);
            figure.setZValue(figure2.getZValue());
        }
    }

    private void assignFiguresToSuccessorZValue(int n, int n2) {
        if (n2 >= this.fFigures.size()) {
            n2 = this.fFigures.size() - 1;
        }
        for (int i = n2; i >= n; --i) {
            Figure figure = (Figure)this.fFigures.get(i);
            Figure figure2 = (Figure)this.fFigures.get(i + 1);
            figure.setZValue(figure2.getZValue());
        }
    }

    public int getLayer(Figure figure) {
        if (!this.containsFigure(figure)) {
            return -1;
        }
        return this.fFigures.indexOf(figure);
    }

    public Figure getFigureFromLayer(int n) {
        if (n >= 0 && n < this.fFigures.size()) {
            return (Figure)this.fFigures.get(n);
        }
        return null;
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, this.figures());
    }

    public void draw(Graphics graphics, FigureEnumeration figureEnumeration) {
        while (figureEnumeration.hasNextFigure()) {
            figureEnumeration.nextFigure().draw(graphics);
        }
    }

    public Figure figureAt(int n) {
        return (Figure)this.fFigures.get(n);
    }

    public FigureEnumeration figures() {
        return new FigureEnumerator(CollectionsFactory.current().createList(this.fFigures));
    }

    public FigureEnumeration figures(Rectangle rectangle) {
        if (this._theQuadTree != null) {
            Object object;
            FigureEnumeration figureEnumeration = this._theQuadTree.getAllWithin(new Bounds(rectangle).asRectangle2D());
            List list = CollectionsFactory.current().createList();
            while (figureEnumeration.hasNextFigure()) {
                object = figureEnumeration.nextFigure();
                list.add(new OrderedFigureElement((Figure)object, object.getZValue()));
            }
            Collections.sort(list);
            object = CollectionsFactory.current().createList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                OrderedFigureElement orderedFigureElement = (OrderedFigureElement)iterator.next();
                object.add(orderedFigureElement.getFigure());
            }
            return new FigureEnumerator((Collection)object);
        }
        return this.figures();
    }

    public int figureCount() {
        return this.fFigures.size();
    }

    public boolean containsFigure(Figure figure) {
        return this.fFigures.contains(figure);
    }

    public final FigureEnumeration figuresReverse() {
        return new ReverseFigureEnumerator(CollectionsFactory.current().createList(this.fFigures));
    }

    public Figure findFigure(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle rectangle) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle2 = figure.displayBox();
            if (!rectangle.intersects(rectangle2)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int n, int n2, Figure figure) {
        if (figure == null) {
            return this.findFigure(n, n2);
        }
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure2 = figureEnumeration.nextFigure();
            if (!figure2.containsPoint(n, n2) || figure2.includes(figure)) continue;
            return figure2;
        }
        return null;
    }

    public Figure findFigure(Rectangle rectangle, Figure figure) {
        if (figure == null) {
            return this.findFigure(rectangle);
        }
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure2 = figureEnumeration.nextFigure();
            Rectangle rectangle2 = figure2.displayBox();
            if (!rectangle.intersects(rectangle2) || figure2.includes(figure)) continue;
            return figure2;
        }
        return null;
    }

    public Figure findFigureInside(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure().findFigureInside(n, n2);
            if (figure == null) continue;
            return figure;
        }
        if (this.containsPoint(n, n2)) {
            return this;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int n, int n2, Figure figure) {
        if (figure == null) {
            return this.findFigureInside(n, n2);
        }
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure2;
            Figure figure3 = figureEnumeration.nextFigure();
            if (figure3 == figure || (figure2 = figure3.findFigureInside(n, n2)) == null || figure3.includes(figure)) continue;
            return figure2;
        }
        if (this.containsPoint(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure2 = figureEnumeration.nextFigure();
            if (!figure2.includes(figure)) continue;
            return true;
        }
        return false;
    }

    protected void basicMoveBy(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            figureEnumeration.nextFigure().moveBy(n, n2);
        }
    }

    public void release() {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.release();
        }
        super.release();
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(figureChangeEvent);
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(figureChangeEvent);
        }
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this._removeFromQuadTree(figureChangeEvent.getFigure());
        this._addToQuadTree(figureChangeEvent.getFigure());
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRemoved(figureChangeEvent);
        }
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.figureCount());
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            storableOutput.writeStorable(figureEnumeration.nextFigure());
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        this.fFigures = CollectionsFactory.current().createList(n);
        for (int i = 0; i < n; ++i) {
            this.add((Figure)storableInput.readStorable());
        }
        this.init(this.displayBox());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.addToContainer(this);
        }
        this.init(new Rectangle(0, 0));
    }

    public void init(Rectangle rectangle) {
        this._theQuadTree = new QuadTree(new Bounds(rectangle).asRectangle2D());
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            this._addToQuadTree(figureEnumeration.nextFigure());
        }
    }

    private void _addToQuadTree(Figure figure) {
        if (this._theQuadTree != null) {
            Rectangle rectangle = figure.displayBox();
            if (rectangle.height == 0) {
                rectangle.grow(0, 1);
            }
            if (rectangle.width == 0) {
                rectangle.grow(1, 0);
            }
            this._theQuadTree.add(figure, new Bounds(rectangle).asRectangle2D());
        }
    }

    private void _removeFromQuadTree(Figure figure) {
        if (this._theQuadTree != null) {
            this._theQuadTree.remove(figure);
        }
    }

    private void _clearQuadTree() {
        if (this._theQuadTree != null) {
            this._theQuadTree.clear();
        }
    }
}

