/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.format;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.ngs.ngunits.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitMetadata {
    private Locale _locale;
    private Map<Unit, Map<String, String>> _metadata;

    public UnitMetadata(ResourceBundle resourceBundle) {
        this._locale = resourceBundle.getLocale();
        this._metadata = new HashMap<Unit, Map<String, String>>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1, string.length());
            int n2 = string.lastIndexOf(46, n - 1);
            String string3 = string.substring(n2 + 1, n);
            String string4 = string.substring(0, n2);
            try {
                Class<?> clazz = Class.forName(string4);
                Field field = clazz.getField(string3);
                Object object = field.get(null);
                if (!(object instanceof Unit)) continue;
                Map<String, String> map = this._metadata.get(object);
                if (map == null) {
                    map = new HashMap<String, String>();
                    this._metadata.put((Unit)object, map);
                }
                map.put(string2.toUpperCase(), resourceBundle.getString(string));
            }
            catch (Exception exception) {
                System.err.println("ERROR reading Unit names: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getProperty(Unit unit, String string) {
        Map<String, String> map = this._metadata.get(unit);
        if (map != null) {
            return map.get(string.toUpperCase());
        }
        return null;
    }

    public void putProperty(Unit unit, String string, String string2) {
        Map<String, String> map = this._metadata.get(unit);
        if (map == null) {
            map = new HashMap<String, String>();
            this._metadata.put(unit, map);
        }
        map.put(string.toUpperCase(), string2);
    }

    public Map<String, String> getProperties(Unit unit) {
        Map<String, String> map = this._metadata.get(unit);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return null;
    }
}

