/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.awt.Color;
import java.nio.FloatBuffer;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Observer;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Perspective;
import org.nlogo.api.World;
import org.nlogo.gl.render.AgentRenderer$;
import org.nlogo.gl.render.GLLinkShape;
import org.nlogo.gl.render.GLShape;
import org.nlogo.gl.render.ShapeManager;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.UninitializedFieldError;
import scala.collection.SeqLike;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\n\u0015\u0001Qa\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u000b-\u0002A\u0011\u0001\u0017\t\u000fA\u0002\u0001\u0019!C\u0001c!9Q\u0007\u0001a\u0001\n\u00031\u0004B\u0002\u001f\u0001A\u0003&!\u0007C\u0005>\u0001\u0001\u0007\t\u0019!C\u0001}!I!\t\u0001a\u0001\u0002\u0004%\ta\u0011\u0005\n\u000b\u0002\u0001\r\u0011!Q!\n}BQA\u0012\u0001\u0005\u0002\u001dCq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!(\u0001\t\u0003\ty\nC\u0004\u00024\u0002!\t!!.\u0003\u001bMC\u0017\r]3SK:$WM]3s\u0015\t)b#\u0001\u0004sK:$WM\u001d\u0006\u0003/a\t!a\u001a7\u000b\u0005eQ\u0012!\u00028m_\u001e|'\"A\u000e\u0002\u0007=\u0014xm\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\fQa^8sY\u0012\u001c\u0001\u0001\u0005\u0002'S5\tqE\u0003\u0002)1\u0005\u0019\u0011\r]5\n\u0005):#!B,pe2$\u0017A\u0002\u001fj]&$h\b\u0006\u0002._A\u0011a\u0006A\u0007\u0002)!)1E\u0001a\u0001K\u0005q1\u000f^3oG&d7+\u001e9q_J$X#\u0001\u001a\u0011\u0005y\u0019\u0014B\u0001\u001b \u0005\u001d\u0011un\u001c7fC:\f!c\u001d;f]\u000eLGnU;qa>\u0014Ho\u0018\u0013fcR\u0011qG\u000f\t\u0003=aJ!!O\u0010\u0003\tUs\u0017\u000e\u001e\u0005\bw\u0011\t\t\u00111\u00013\u0003\rAH%M\u0001\u0010gR,gnY5m'V\u0004\bo\u001c:uA\u0005a1\u000f[1qK6\u000bg.Y4feV\tq\b\u0005\u0002/\u0001&\u0011\u0011\t\u0006\u0002\r'\"\f\u0007/Z'b]\u0006<WM]\u0001\u0011g\"\f\u0007/Z'b]\u0006<WM]0%KF$\"a\u000e#\t\u000fm:\u0011\u0011!a\u0001\u007f\u0005i1\u000f[1qK6\u000bg.Y4fe\u0002\n!C]3oI\u0016\u0014xK]1qa\u0016$\u0017iZ3oiR)r\u0007S*Y;\u001e$h\u000f\u001f>}\u0003\u0007\t9!!\u0005\u0002\u0016\u0005e\u0001\"B\f\n\u0001\u0004I\u0005C\u0001&R\u001b\u0005Y%B\u0001'N\u0003\u0019y\u0007/\u001a8hY*\u0011ajT\u0001\u0007U><\u0017-\u001c9\u000b\u0003A\u000b1aY8n\u0013\t\u00116JA\u0002H\u0019JBQ\u0001V\u0005A\u0002U\u000bqa\u001d5ba\u0016\u001cD\t\u0005\u0002/-&\u0011q\u000b\u0006\u0002\b\u000f2\u001b\u0006.\u00199f\u0011\u0015I\u0016\u00021\u0001[\u0003\u0011\u0019\u0018N_3\u0011\u0005yY\u0016B\u0001/ \u0005\u0019!u.\u001e2mK\")a,\u0003a\u0001?\u0006)1m\u001c7peB\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\u0004C^$(\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014QaQ8m_JDQ\u0001[\u0005A\u0002%\fQ\u0001\\1cK2\u0004\"A[9\u000f\u0005-|\u0007C\u00017 \u001b\u0005i'B\u00018%\u0003\u0019a$o\\8u}%\u0011\u0001oH\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002q?!)Q/\u0003a\u0001;\u0005QA.\u00192fY\u000e{Gn\u001c:\t\u000b]L\u0001\u0019\u0001.\u0002\u0003aDQ!_\u0005A\u0002i\u000b\u0011!\u001f\u0005\u0006w&\u0001\rAW\u0001\u0002u\")Q0\u0003a\u0001}\u00061\u0001.Z5hQR\u0004\"AH@\n\u0007\u0005\u0005qDA\u0003GY>\fG\u000f\u0003\u0004\u0002\u0006%\u0001\rAW\u0001\na\u0006$8\r[*ju\u0016Dq!!\u0003\n\u0001\u0004\tY!\u0001\u0005g_:$8+\u001b>f!\rq\u0012QB\u0005\u0004\u0003\u001fy\"aA%oi\"1\u00111C\u0005A\u0002I\nqa\\;uY&tW\r\u0003\u0004\u0002\u0018%\u0001\rAW\u0001\u000eY&tW\r\u00165jG.tWm]:\t\u000f\u0005m\u0011\u00021\u0001\u0002\u001e\u0005YqN]5f]R\fG/[8o!\u0011q\u0012q\u0004.\n\u0007\u0005\u0005rDA\u0003BeJ\f\u00170A\u0006sK:$WM]!hK:$H#F\u001c\u0002(\u0005%\u00121FA\u0017\u0003_\t\u0019$a\u000e\u0002<\u0005}\u0012\u0011\t\u0005\u0006/)\u0001\r!\u0013\u0005\u0006)*\u0001\r!\u0016\u0005\u0006=*\u0001\ra\u0018\u0005\u00063*\u0001\rA\u0017\u0005\u0007\u0003cQ\u0001\u0019\u0001.\u0002\ta\u001cwN\u001d\u0005\u0007\u0003kQ\u0001\u0019\u0001.\u0002\te\u001cwN\u001d\u0005\u0007\u0003sQ\u0001\u0019\u0001.\u0002\ti\u001cwN\u001d\u0005\u0007\u0003{Q\u0001\u0019\u0001@\u0002\rM$(o\\6f\u0011\u0019\t\u0019B\u0003a\u0001e!9\u00111\u0004\u0006A\u0002\u0005u\u0011AC1mS\u001et\u0017iZ3oiR\tr'a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019&a\u0016\t\u000b]Y\u0001\u0019A%\t\u000be[\u0001\u0019\u0001.\t\r\u0005E2\u00021\u0001[\u0011\u0019\t)d\u0003a\u00015\"1\u0011\u0011H\u0006A\u0002iCQ\u0001V\u0006A\u0002UCa!!\u0016\f\u0001\u0004\u0011\u0014!\u00035jO\"d\u0017n\u001a5u\u0011\u001d\tYb\u0003a\u0001\u0003;\t\u0011\u0002Z8PkRd\u0017N\\3\u0015\u000f]\ni&a\u0018\u0002b!)q\u0003\u0004a\u0001\u0013\")A\u000b\u0004a\u0001+\"9\u00111\r\u0007A\u0002\u0005\u0015\u0014a\u0001:hEB!a$a\b\u007f\u0003!9W\r^*iCB,GcA+\u0002l!1\u0011QN\u0007A\u0002%\fAA\\1nK\u0006aq-\u001a;MS:\\7\u000b[1qKR!\u00111OA=!\rq\u0013QO\u0005\u0004\u0003o\"\"aC$M\u0019&t7n\u00155ba\u0016Da!!\u001c\u000f\u0001\u0004I\u0017AD4fiNC\u0017\r]3IK&<\u0007\u000e\u001e\u000b\b}\u0006}\u0014\u0011QAC\u0011\u0019\tig\u0004a\u0001S\"1\u00111Q\bA\u0002U\u000bQa\u001d5ba\u0016DQ!W\bA\u0002i\u000bqB]3oI\u0016\u0014\b*[4iY&<\u0007\u000e\u001e\u000b\no\u0005-\u0015QRAL\u00037CQa\u0006\tA\u0002%Cq!a$\u0011\u0001\u0004\t\t*A\u0003bO\u0016tG\u000fE\u0002'\u0003'K1!!&(\u0005\u0015\tu-\u001a8u\u0011\u001d\tI\n\u0005a\u0001\u0003;\taaY8pe\u0012\u001c\bbBA\u000e!\u0001\u0007\u0011QD\u0001\fe\u0016tG-\u001a:MC\n,G\u000eF\n8\u0003C\u000b\u0019+!*\u0002(\u0006%\u00161VAW\u0003_\u000b\t\fC\u0003\u0018#\u0001\u0007\u0011\nC\u0003i#\u0001\u0007\u0011\u000eC\u0003v#\u0001\u0007Q\u0004\u0003\u0004\u00022E\u0001\rA \u0005\u0007\u0003k\t\u0002\u0019\u0001@\t\r\u0005e\u0012\u00031\u0001\u007f\u0011\u0015i\u0018\u00031\u0001\u007f\u0011\u001d\tI!\u0005a\u0001\u0003\u0017Aa!!\u0002\u0012\u0001\u0004Q\u0016A\u0003:f]\u0012,'\u000fS1m_R9q'a.\u0002:\u0006u\u0006\"B\f\u0013\u0001\u0004I\u0005BBA^%\u0001\u0007!'\u0001\u0005jgR+(\u000f\u001e7f\u0011\u0019\tyL\u0005a\u00015\u0006AA-[1nKR,'\u000f")
public class ShapeRenderer {
    private final World world;
    private boolean stencilSupport;
    private ShapeManager shapeManager;
    private volatile boolean bitmap$init$0;

    public boolean stencilSupport() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/gl/render/ShapeRenderer.scala: 14");
        }
        return this.stencilSupport;
    }

    public void stencilSupport_$eq(boolean x$1) {
        this.stencilSupport = x$1;
        this.bitmap$init$0 = true;
    }

    public ShapeManager shapeManager() {
        return this.shapeManager;
    }

    public void shapeManager_$eq(ShapeManager x$1) {
        this.shapeManager = x$1;
    }

    public void renderWrappedAgent(GL2 gl, GLShape shape3D, double size, Color color, String label, Object labelColor, double x, double y, double z, float height, double patchSize, int fontSize, boolean outline, double lineThickness, double[] orientation) {
        double maxx = (double)this.world.maxPxcor() + 0.5;
        double minx = (double)this.world.minPxcor() - 0.5;
        double maxy = (double)this.world.maxPycor() + 0.5;
        double miny = (double)this.world.minPycor() - 0.5;
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        float stroke = (float)package$.MODULE$.max(1.0, patchSize * lineThickness);
        this.renderAgent(gl, shape3D, color, size, x, y, z, stroke, outline, orientation);
        if (this.world.wrappingAllowedInX()) {
            if (x + size / (double)2 > maxx) {
                this.renderAgent(gl, shape3D, color, size, x - (double)worldWidth, y, z, stroke, outline, orientation);
                wrapXRight = true;
            }
            if (x - size / (double)2 < minx) {
                this.renderAgent(gl, shape3D, color, size, x + (double)worldWidth, y, z, stroke, outline, orientation);
                wrapXLeft = true;
            }
        }
        if (this.world.wrappingAllowedInY()) {
            if (y + size / (double)2 > maxy) {
                this.renderAgent(gl, shape3D, color, size, x, y - (double)worldHeight, z, stroke, outline, orientation);
                if (wrapXRight) {
                    this.renderAgent(gl, shape3D, color, size, x - (double)worldWidth, y - (double)worldHeight, z, stroke, outline, orientation);
                }
                if (wrapXLeft) {
                    this.renderAgent(gl, shape3D, color, size, x + (double)worldWidth, y - (double)worldHeight, z, stroke, outline, orientation);
                }
            }
            if (y - size / (double)2 < miny) {
                this.renderAgent(gl, shape3D, color, size, x, y + (double)worldHeight, z, stroke, outline, orientation);
                if (wrapXRight) {
                    this.renderAgent(gl, shape3D, color, size, x - (double)worldWidth, y + (double)worldHeight, z, stroke, outline, orientation);
                }
                if (wrapXLeft) {
                    this.renderAgent(gl, shape3D, color, size, x + (double)worldWidth, y + (double)worldHeight, z, stroke, outline, orientation);
                }
            }
        }
        if (label.length() != 0) {
            this.renderLabel(gl, label, labelColor, (float)(x * (double)0.3f), (float)(y * (double)0.3f), (float)(z * (double)0.3f), height, fontSize, patchSize);
        }
    }

    public void renderAgent(GL2 gl, GLShape shape3D, Color color, double size, double xcor, double ycor, double zcor, float stroke, boolean outline, double[] orientation) {
        gl.glPushMatrix();
        this.alignAgent(gl, size, xcor * (double)0.3f, ycor * (double)0.3f, zcor * (double)0.3f, shape3D, false, orientation);
        gl.glColor4fv(FloatBuffer.wrap(color.getRGBComponents(null)));
        if (outline) {
            this.doOutline(gl, shape3D, color.getComponents(null));
        } else {
            gl.glLineWidth(stroke);
            gl.glCallList(shape3D.displayListIndex());
            gl.glLineWidth(1.0f);
        }
        gl.glPopMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public void alignAgent(GL2 gl, double size, double xcor, double ycor, double zcor, GLShape shape3D, boolean highlight, double[] orientation) {
        Option option = Array$.MODULE$.unapplySeq(orientation);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) {
            throw new MatchError(orientation);
        }
        double heading = BoxesRunTime.unboxToDouble(((SeqLike)option.get()).apply(0));
        double pitch = BoxesRunTime.unboxToDouble(((SeqLike)option.get()).apply(1));
        double roll = BoxesRunTime.unboxToDouble(((SeqLike)option.get()).apply(2));
        ObserverOrientation observerOrientation = this.world.observer().orientation().get();
        gl.glTranslated(xcor, ycor, zcor);
        if (highlight && this.world.observer().perspective() instanceof Perspective.Follow) {
            gl.glRotated(-observerOrientation.heading(), 0.0, 0.0, 1.0);
            gl.glRotated(90.0, 1.0, 0.0, 0.0);
            gl.glRotated(-observerOrientation.pitch(), -1.0, 0.0, 0.0);
        } else if (shape3D.rotatable() && !highlight) {
            void var18_12;
            void var16_11;
            void var14_10;
            gl.glRotated(0.0 - var14_10, 0.0, 0.0, 1.0);
            gl.glRotated((double)var16_11, 1.0, 0.0, 0.0);
            gl.glRotated((double)var18_12, 0.0, 1.0, 0.0);
        } else {
            gl.glRotated(-observerOrientation.heading(), 0.0, 0.0, 1.0);
            gl.glRotated(90.0, 1.0, 0.0, 0.0);
            if (this.world.observer().perspective() instanceof AgentFollowingPerspective) {
                gl.glRotated(-observerOrientation.pitch(), -1.0, 0.0, 0.0);
                gl.glRotated(-observerOrientation.roll(), 0.0, 0.0, 1.0);
            } else {
                gl.glRotated(observerOrientation.pitch(), -1.0, 0.0, 0.0);
                gl.glRotated(observerOrientation.roll(), 0.0, 0.0, 1.0);
            }
        }
        gl.glScaled(size, size, size);
    }

    public void doOutline(GL2 gl, GLShape shape3D, float[] rgb) {
        if (this.stencilSupport()) {
            gl.glClearStencil(0);
            gl.glClear(1024);
            gl.glEnable(2960);
            gl.glStencilFunc(519, 1, 65535);
            gl.glStencilOp(7680, 7680, 7681);
            gl.glPushMatrix();
            gl.glCallList(shape3D.displayListIndex());
            gl.glPopMatrix();
            gl.glStencilFunc(517, 1, 65535);
            gl.glStencilOp(7680, 7680, 7681);
            gl.glLineWidth(2.0f);
            gl.glPolygonMode(1028, 6913);
            gl.glColor4f((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f, 0.5f);
            gl.glCallList(shape3D.displayListIndex());
            gl.glLineWidth(4.0f);
            gl.glPolygonMode(1028, 6913);
            gl.glColor4f(rgb[0], rgb[1], rgb[2], 0.5f);
            gl.glCallList(shape3D.displayListIndex());
            gl.glLineWidth(1.0f);
            gl.glPolygonMode(1032, 6914);
            gl.glDisable(2960);
            return;
        }
        gl.glPushMatrix();
        gl.glPolygonMode(1032, 6913);
        gl.glColor4f(rgb[0], rgb[1], rgb[2], 0.5f);
        gl.glLineWidth(4.0f);
        gl.glCallList(shape3D.displayListIndex());
        gl.glColor4f((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f, 0.5f);
        gl.glLineWidth(2.0f);
        gl.glCallList(shape3D.displayListIndex());
        gl.glLineWidth(1.0f);
        gl.glPopMatrix();
        gl.glEnable(32823);
        gl.glPolygonOffset(-3.0f, -3.0f);
        gl.glPolygonMode(1032, 6914);
        gl.glColor4f(rgb[0], rgb[1], rgb[2], 0.5f);
        gl.glCallList(shape3D.displayListIndex());
        gl.glDisable(32823);
    }

    public GLShape getShape(String name) {
        return this.shapeManager().getShape(name);
    }

    public GLLinkShape getLinkShape(String name) {
        return this.shapeManager().getLinkShape(name);
    }

    public float getShapeHeight(String name, GLShape shape, double size) {
        if (this.shapeManager().modelLibraryShape(name) && shape.rotatable()) {
            return 1.0f;
        }
        return (float)size;
    }

    public void renderHighlight(GL2 gl, Agent agent, double[] coords, double[] orientation) {
        gl.glPushMatrix();
        GLShape shape = this.shapeManager().getShape(agent.shape());
        this.alignAgent(gl, agent.size(), coords[0] * (double)0.3f, coords[1] * (double)0.3f, coords[2] * (double)0.3f, shape, true, orientation);
        this.renderHalo(gl, true, agent.size() * 3.3333 * 0.285 * 2.0);
        gl.glPopMatrix();
    }

    public void renderLabel(GL2 gl, String label, Object labelColor, float xcor, float ycor, float zcor, float height, int fontSize, double patchSize) {
        Observer observer = this.world.observer();
        ObserverOrientation orientation = observer.orientation().get();
        gl.glPushMatrix();
        gl.glTranslated((double)xcor, (double)ycor, (double)(zcor + 0.15f * height));
        gl.glRotated(-orientation.heading(), 0.0, 0.0, 1.0);
        gl.glRotated(90.0, 1.0, 0.0, 0.0);
        if (observer.perspective() instanceof AgentFollowingPerspective) {
            gl.glRotated(-orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(-orientation.roll(), 0.0, 0.0, 1.0);
        } else {
            gl.glRotated(orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(orientation.roll(), 0.0, 0.0, 1.0);
        }
        AgentRenderer$.MODULE$.renderString(gl, this.world, label, labelColor, fontSize, patchSize);
        gl.glPopMatrix();
    }

    public void renderHalo(GL2 gl, boolean isTurtle, double diameter) {
        int height;
        GLShape haloShape = this.shapeManager().getShape("@@@HALO@@@");
        int width = this.world.worldWidth();
        double stretch = diameter < package$.MODULE$.max((double)width / 10.0, (double)(height = this.world.worldHeight()) / 10.0) ? package$.MODULE$.max((double)width / 10.0, (double)height / 10.0) / diameter : 1.0;
        gl.glDepthFunc(519);
        if (this.stencilSupport()) {
            gl.glClearStencil(0);
            gl.glClear(1024);
            gl.glEnable(2960);
            gl.glStencilFunc(519, 1, 65535);
            gl.glStencilOp(7680, 7681, 7681);
        }
        gl.glPushMatrix();
        gl.glScaled(stretch, stretch, 0.0);
        gl.glCallList(haloShape.displayListIndex());
        gl.glPopMatrix();
        if (this.world.observer().perspective() instanceof Perspective.Watch && this.stencilSupport()) {
            ObserverOrientation orientation = this.world.observer().orientation().get();
            if (!isTurtle) {
                gl.glRotated(-orientation.heading(), 0.0, 0.0, 1.0);
                gl.glRotated(90.0, 1.0, 0.0, 0.0);
                gl.glRotated(orientation.pitch(), -1.0, 0.0, 0.0);
            }
            gl.glStencilFunc(517, 1, 65535);
            gl.glStencilOp(7680, 7680, 7680);
            gl.glEnable(3042);
            gl.glBlendFunc(770, 1);
            float[] darkOverlay = new float[]{0.0f, 0.0f, 0.196f, 0.392f};
            gl.glColor4fv(FloatBuffer.wrap(darkOverlay));
            gl.glBegin(7);
            gl.glNormal3f(0.0f, 0.0f, 1.0f);
            gl.glVertex3f(-100.0f, 100.0f, 0.0f);
            gl.glVertex3f(-100.0f, -100.0f, 0.0f);
            gl.glVertex3f(100.0f, -100.0f, 0.0f);
            gl.glVertex3f(100.0f, 100.0f, 0.0f);
            gl.glEnd();
            gl.glDisable(3042);
            gl.glDisable(2960);
        }
        gl.glDepthFunc(515);
    }

    public ShapeRenderer(World world) {
        this.world = world;
        this.stencilSupport = false;
        this.bitmap$init$0 = true;
    }
}

