/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.CommandRunnable;
import org.nlogo.api.ControlSet;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Exceptions;
import org.nlogo.api.FileIO$;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelSections;
import org.nlogo.api.ModelTypeJ;
import org.nlogo.api.PreviewCommands$;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.CompilerException;
import org.nlogo.core.File;
import org.nlogo.core.I18N;
import org.nlogo.core.Model;
import org.nlogo.core.Shape;
import org.nlogo.core.UpdateMode;
import org.nlogo.core.UpdateModeJ;
import org.nlogo.core.WorldDimensions;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Procedure;
import org.nlogo.shape.InvalidShapeDescriptionException;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.Utils;
import org.nlogo.window.AppEventType;
import org.nlogo.window.ErrorDialogManager;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileManager;
import org.nlogo.window.GLViewManagerInterface;
import org.nlogo.window.GUIWorkspaceScala;
import org.nlogo.window.HubNetControlCenterAction;
import org.nlogo.window.JOGLLoadingException;
import org.nlogo.window.JobWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.NetLogoListenerManager;
import org.nlogo.window.PeriodicUpdater;
import org.nlogo.window.ThreadUtils;
import org.nlogo.window.UpdateManagerInterface;
import org.nlogo.window.View;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.workspace.HubNetManagerFactory;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.immutable.ListMap;

public strictfp abstract class GUIWorkspace
extends GUIWorkspaceScala
implements Event.LinkChild,
Events.AboutToQuitEvent.Handler,
Events.AddJobEvent.Handler,
Events.AfterLoadEvent.Handler,
Events.BeforeLoadEvent.Handler,
Events.JobStoppingEvent.Handler,
Events.RemoveAllJobsEvent.Handler,
Events.RemoveJobEvent.Handler,
Events.AddSliderConstraintEvent.Handler,
Events.RemoveConstraintEvent.Handler,
Events.AddBooleanConstraintEvent.Handler,
Events.AddChooserConstraintEvent.Handler,
Events.AddInputBoxConstraintEvent.Handler,
Events.CompiledEvent.Handler,
TrailDrawerInterface,
DrawingInterface,
ModelSections.ModelSaveable {
    public final KioskLevel kioskLevel;
    private final Component linkParent;
    public final ViewWidget viewWidget;
    private final View view;
    private WidgetContainer widgetContainer = null;
    public GLViewManagerInterface glView = null;
    public final NetLogoListenerManager listenerManager;
    private final ErrorDialogManager errorDialogManager;
    private PeriodicUpdater periodicUpdater;
    private Timer repaintTimer;
    private Lifeguard lifeguard;
    private double _frameRate = 30.0;
    private boolean dualView;
    private final Runnable updateRunner = new Runnable(){

        @Override
        public void run() {
            new Events.PeriodicUpdateEvent().raise(GUIWorkspace.this);
        }
    };
    private boolean periodicUpdatesEnabled = false;
    private double lastTicksListenersHeard = -1.0;
    public final Action hubNetControlCenterAction = new HubNetControlCenterAction(this);
    public final Action switchTo3DViewAction = new AbstractAction(I18N.guiJ().get("menu.tools.3DView.switch")){

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIWorkspace.this.open3DView();
        }
    };

    public GUIWorkspace(final World world, KioskLevel kioskLevel, Frame frame, Component linkParent, HubNetManagerFactory hubNetManagerFactory, ExternalFileManager externalFileManager, NetLogoListenerManager listenerManager, ErrorDialogManager errorDialogManager, ControlSet controlSet) {
        super(world, hubNetManagerFactory, frame, externalFileManager, controlSet);
        this.kioskLevel = kioskLevel;
        this.linkParent = linkParent;
        this.listenerManager = listenerManager;
        this.errorDialogManager = errorDialogManager;
        this.hubNetControlCenterAction.setEnabled(false);
        this.viewWidget = new ViewWidget(this);
        this.view = this.viewWidget.view();
        this.viewManager().setPrimary(this.view);
        this.periodicUpdater = new PeriodicUpdater(this.jobManager);
        this.periodicUpdater.start();
        world.trailDrawer(this);
        AbstractAction repaintAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (world.displayOn() && GUIWorkspace.this.displaySwitchOn() && !GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                    GUIWorkspace.this.viewManager().paintImmediately(world.observer().updatePosition());
                }
            }
        };
        this.repaintTimer = new Timer(100, repaintAction);
        this.repaintTimer.start();
        this.lifeguard = new Lifeguard();
        this.lifeguard.start();
    }

    @Override
    public View view() {
        return this.view;
    }

    public void init(GLViewManagerInterface glView) {
        this.glView = glView;
    }

    public double frameRate() {
        return this._frameRate;
    }

    public void frameRate(double frameRate) {
        this._frameRate = frameRate;
        this.updateManager().recompute();
    }

    public abstract UpdateManagerInterface updateManager();

    public abstract RendererInterface newRenderer();

    @Override
    public void stamp(Agent agent, boolean erase) {
        this.view.renderer.prepareToPaint(this.view, this.view.renderer.trailDrawer().getWidth(), this.view.renderer.trailDrawer().getHeight());
        this.view.renderer.trailDrawer().stamp(agent, erase);
        if (this.hubNetManager().isDefined()) {
            this.hubNetManager().get().sendStamp(agent, erase);
        }
    }

    @Override
    public void importWorld(String filename) throws IOException {
        super.importWorld(filename);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void importWorld(Reader reader) throws IOException {
        super.importWorld(reader);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void importDrawing(InputStream is, Option<String> mimeType) throws IOException {
        this.view.renderer.trailDrawer().importDrawing(is, mimeType);
    }

    @Override
    public void importDrawing(InputStream is) throws IOException {
        this.importDrawing(is, Option.apply(null));
    }

    @Override
    public void importDrawing(File file) throws IOException {
        this.view.renderer.trailDrawer().importDrawing(file);
    }

    @Override
    public void importDrawingBase64(String base64) throws IOException {
        this.view.renderer.trailDrawer().importDrawingBase64(base64);
    }

    @Override
    public void exportDrawing(String filename, String format2) throws IOException {
        FileIO$.MODULE$.writeImageFile(this.view.renderer.trailDrawer().getAndCreateDrawing(true), filename, format2);
    }

    @Override
    public BufferedImage getAndCreateDrawing() {
        return this.getAndCreateDrawing(true);
    }

    @Override
    public BufferedImage getAndCreateDrawing(boolean dirty) {
        return this.view.renderer.trailDrawer().getAndCreateDrawing(dirty);
    }

    @Override
    public void clearDrawing() {
        this.world().clearDrawing();
        this.view.renderer.trailDrawer().clearDrawing();
        if (this.hubNetManager().isDefined()) {
            this.hubNetManager().get().sendClear();
        }
    }

    @Override
    public void resetTicks(Context context) {
        super.resetTicks(context);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void clearTicks() {
        super.clearTicks();
        new Events.TickStateChangeEvent(false).raiseLater(this);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        new Events.TickStateChangeEvent(false).raiseLater(this);
    }

    @Override
    public boolean sendPixels() {
        return this.view.renderer.trailDrawer().sendPixels();
    }

    @Override
    public void sendPixels(boolean dirty) {
        this.view.renderer.trailDrawer().sendPixels(dirty);
    }

    @Override
    public void dispose() throws InterruptedException {
        this.periodicUpdater.stop();
        this.repaintTimer.stop();
        this.lifeguard.interrupt();
        this.lifeguard.join();
        super.dispose();
    }

    public WidgetContainer getWidgetContainer() {
        return this.widgetContainer;
    }

    public void setWidgetContainer(WidgetContainer widgetContainer) {
        this.widgetContainer = widgetContainer;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    public void waitFor(Runnable runnable) {
        ThreadUtils.waitFor(this, runnable);
    }

    @Override
    public void waitFor(CommandRunnable runnable) throws LogoException {
        ThreadUtils.waitFor(this, runnable);
    }

    @Override
    public <T> T waitForResult(ReporterRunnable<T> runnable) throws LogoException {
        return ThreadUtils.waitForResult(this, runnable);
    }

    @Override
    public void waitForQueuedEvents() throws LogoException {
        ThreadUtils.waitForQueuedEvents(this);
    }

    @Override
    public Object getLinkParent() {
        return this.linkParent;
    }

    @Override
    public boolean warningMessage(String message) {
        Object[] options = new String[]{I18N.guiJ().get("common.buttons.continue"), I18N.guiJ().get("common.buttons.cancel")};
        return 0 == OptionDialog.showMessage(this.getFrame(), I18N.guiJ().get("common.messages.warning"), I18N.guiJ().get("common.messages.warning") + ":" + message, options);
    }

    @Override
    public void resizeView() {
        org.nlogo.awt.EventQueue.mustBeEventDispatchThread();
        this.viewWidget.settings().resizeWithProgress(true);
    }

    @Override
    public void patchSize(double patchSize) {
        this.viewWidget.settings().patchSize(patchSize);
    }

    @Override
    public double patchSize() {
        return this.world().patchSize();
    }

    @Override
    public void setDimensions(final WorldDimensions d) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(d);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            try {
                org.nlogo.awt.EventQueue.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    @Override
    public void setDimensions(final WorldDimensions d, final double patchSize) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(d, patchSize);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            try {
                org.nlogo.awt.EventQueue.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    public void patchesCreatedNotify() {
        new Events.PatchesCreatedEvent().raise(this);
    }

    @Override
    public boolean compilerTestingMode() {
        return false;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return this.viewWidget.settings();
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.world().changeTopology(wrapX, wrapY);
        this.viewWidget.view().renderer.changeTopology(wrapX, wrapY);
    }

    @Override
    public void open(final String path, final boolean shouldAutoInstallLibs) {
        try {
            org.nlogo.awt.EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    new Events.OpenModelEvent(path, shouldAutoInstallLibs).raise(GUIWorkspace.this);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void openString(String modelContents) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void openModel(Model model, boolean shouldAutoInstallLibs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RendererInterface renderer() {
        return this.view.renderer;
    }

    public void reload() {
        new Events.AppEvent(AppEventType.RELOAD, new Object[0]).raiseLater(this);
    }

    @Override
    public void magicOpen(String name) {
        new Events.AppEvent(AppEventType.MAGIC_OPEN, new Object[]{name}).raiseLater(this);
    }

    @Override
    public void startLogging(String properties) {
        try {
            new Events.AppEvent(AppEventType.START_LOGGING, new Object[]{this.fileManager().attachPrefix(properties)}).raiseLater(this);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void zipLogFiles(String filename) {
        try {
            new Events.AppEvent(AppEventType.ZIP_LOG_FILES, new Object[]{this.fileManager().attachPrefix(filename)}).raiseLater(this);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void deleteLogFiles() {
        new Events.AppEvent(AppEventType.DELETE_LOG_FILES, new Object[0]).raiseLater(this);
    }

    public boolean displaySwitchOn() {
        return this.viewManager().getPrimary().displaySwitch();
    }

    public void displaySwitchOn(boolean on) {
        this.viewManager().getPrimary().displaySwitch(on);
    }

    public void set2DViewEnabled(boolean enabled) {
        if (enabled) {
            this.displaySwitchOn(this.glView.displayOn());
            this.viewManager().setPrimary(this.view);
            this.viewManager().remove(this.glView);
            this.view.dirty();
            if (this.glView.displayOn()) {
                this.view.thaw();
            }
            if (!(this.world().observer().perspective() instanceof AgentFollowingPerspective)) {
                this.world().observer().home();
            }
            this.viewWidget.setVisible(true);
            try {
                this.viewWidget.displaySwitch().setOn(this.glView.displaySwitch());
            }
            catch (IllegalStateException e) {
                Exceptions.ignore(e);
            }
        } else {
            this.viewManager().setPrimary(this.glView);
            if (!this.dualView) {
                this.viewManager().remove(this.view);
                this.view.freeze();
            }
            this.glView.displaySwitch(this.viewWidget.displaySwitch().isSelected());
            this.viewWidget.setVisible(this.dualView);
        }
        this.view.renderPerspective = enabled;
        this.viewWidget.settings().refreshViewProperties(!enabled);
        new Events.Enable2DEvent(enabled).raise(this);
    }

    public boolean dualView() {
        return this.dualView;
    }

    public void dualView(boolean on) {
        if (on != this.dualView) {
            this.dualView = on;
            if (this.dualView) {
                this.view.thaw();
                this.viewManager().setSecondary(this.view);
            } else {
                this.view.freeze();
                this.viewManager().remove(this.view);
            }
            this.viewWidget.setVisible(on);
        }
    }

    @Override
    public boolean mouseDown() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager().mouseDown();
    }

    @Override
    public boolean mouseInside() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager().mouseInside();
    }

    @Override
    public double mouseXCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager().mouseXCor();
    }

    @Override
    public double mouseYCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager().mouseYCor();
    }

    @Override
    public void updateMode(UpdateMode updateMode) {
        super.updateMode(updateMode);
        this.updateManager().recompute();
    }

    public double speedSliderPosition() {
        double s = this.updateManager().speed() * 2.0;
        if (s > 0.0) {
            s += 10.0;
        } else if (s < 0.0) {
            s -= 10.0;
        }
        return s;
    }

    public void speedSliderPosition(double speed) {
        this.updateManager().speed_$eq(speed);
    }

    @Override
    public void updateDisplay(boolean haveWorldLockAlready) {
        this.view.dirty();
        if (!this.world().displayOn()) {
            return;
        }
        if (!this.updateManager().shouldUpdateNow()) {
            this.viewManager().framesSkipped();
            return;
        }
        if (!this.displaySwitchOn()) {
            return;
        }
        if (haveWorldLockAlready) {
            try {
                this.waitFor(new CommandRunnable(){

                    @Override
                    public void run() {
                        GUIWorkspace.this.viewManager().incrementalUpdateFromEventThread();
                    }
                });
                while (!this.updateManager().isDoneSmoothing()) {
                    ThreadUtils.waitForQueuedEvents(this);
                }
            }
            catch (HaltException ex) {
                Exceptions.ignore(ex);
            }
            catch (LogoException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            this.viewManager().incrementalUpdateFromJobThread();
        }
        this.updateManager().pause();
    }

    public void setPeriodicUpdatesEnabled(boolean periodicUpdatesEnabled) {
        this.periodicUpdatesEnabled = periodicUpdatesEnabled;
    }

    @Override
    public void periodicUpdate() {
        if (this.periodicUpdatesEnabled) {
            ThreadUtils.waitFor(this, this.updateRunner);
        }
    }

    @Override
    public void breathe() {
        this.jobManager.maybeRunSecondaryJobs();
        if (this.updateMode().equals(UpdateModeJ.CONTINUOUS())) {
            this.updateManager().pseudoTick();
            this.updateDisplay(true);
        }
        this.world().comeUpForAir = this.updateManager().shouldComeUpForAirAgain();
        this.notifyListeners();
    }

    @Override
    public void updateUI() {
        ThreadUtils.waitFor(this, this.updateRunner);
        this.updateManager().reset();
        this.requestDisplayUpdate(true);
    }

    @Override
    public void requestDisplayUpdate(boolean force) {
        if (force) {
            this.updateManager().pseudoTick();
        }
        this.updateDisplay(true);
        this.notifyListeners();
    }

    private void notifyListeners() {
        double ticks = this.world().tickCounter().ticks();
        if (ticks != this.lastTicksListenersHeard) {
            this.lastTicksListenersHeard = ticks;
            this.listenerManager.tickCounterChanged(ticks);
        }
        this.listenerManager.possibleViewUpdate();
    }

    @Override
    public void halt() {
        this.jobManager.interrupt();
        ModalProgressTask.onUIThread(this.getFrame(), "Halting...", new Runnable(){

            @Override
            public void run() {
                GUIWorkspace.super.halt();
                GUIWorkspace.this.view.dirty();
                GUIWorkspace.this.view.repaint();
            }
        });
    }

    public void shapeChanged(Shape shape) {
        this.viewManager().shapeChanged(shape);
    }

    @Override
    public void handle(Events.AfterLoadEvent e) {
        this.setPeriodicUpdatesEnabled(true);
        this.world().observer().resetPerspective();
        this.updateManager().reset();
        this.updateManager().speed_$eq(0.0);
        if (this.glView != null) {
            this.glView.close();
        }
        if (this.world().program().dialect().is3D()) {
            this.open3DView();
        }
        try {
            this.evaluateCommands(new SimpleJobOwner("startup", this.world().mainRNG(), AgentKindJ.Observer()), "without-interruption [ startup ]", false);
        }
        catch (CompilerException error) {
            Exceptions.ignore(error);
        }
    }

    private void open3DView() {
        try {
            this.glView.open();
            this.set2DViewEnabled(false);
        }
        catch (JOGLLoadingException jlex) {
            String message = jlex.getMessage();
            Utils.alert("3D View", message, "" + jlex.getCause(), I18N.guiJ().get("common.buttons.continue"));
            this.switchTo3DViewAction.setEnabled(false);
        }
    }

    @Override
    public void addCustomShapes(String filename) throws IOException, InvalidShapeDescriptionException {
        try {
            this.glView.addCustomShapes(this.fileManager().attachPrefix(filename));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int[] colors() {
        return this.view.renderer.trailDrawer().colors();
    }

    @Override
    public boolean isDirty() {
        return this.view.renderer.trailDrawer().isDirty();
    }

    @Override
    public boolean isBlank() {
        return this.view.renderer.trailDrawer().isBlank();
    }

    @Override
    public void markClean() {
        this.view.renderer.trailDrawer().markClean();
    }

    @Override
    public void markDirty() {
        this.view.renderer.trailDrawer().markDirty();
    }

    @Override
    public int getWidth() {
        return this.view.renderer.trailDrawer().getWidth();
    }

    @Override
    public int getHeight() {
        return this.view.renderer.trailDrawer().getHeight();
    }

    @Override
    public void readImage(InputStream is) throws IOException {
        this.view.renderer.trailDrawer().readImage(is);
    }

    @Override
    public void readImage(BufferedImage image) throws IOException {
        this.view.renderer.trailDrawer().readImage(image);
    }

    @Override
    public void rescaleDrawing() {
        this.view.renderer.trailDrawer().rescaleDrawing();
    }

    @Override
    public void drawLine(double x0, double y0, double x1, double y1, Object color, double size, String mode) {
        this.view.renderer.trailDrawer().drawLine(x0, y0, x1, y1, color, size, mode);
        if (this.hubNetManager().isDefined()) {
            this.hubNetManager().get().sendLine(x0, y0, x1, y1, color, size, mode);
        }
    }

    @Override
    public void setColors(int[] colors, int width, int height) {
        this.view.renderer.trailDrawer().setColors(colors, width, height);
    }

    @Override
    public Object getDrawing() {
        return this.view.renderer.trailDrawer().getDrawing();
    }

    @Override
    public void ownerFinished(JobOwner owner) {
        new Events.JobRemovedEvent(owner).raiseLater(this);
        if (owner.ownsPrimaryJobs()) {
            this.updateManager().reset();
            this.updateDisplay(false);
        }
    }

    @Override
    public void handle(Events.AddJobEvent e) {
        JobWidget widget;
        JobOwner owner = e.owner;
        AgentSet agents = e.agents;
        if (owner instanceof JobWidget && agents == null && (widget = (JobWidget)owner).useAgentClass()) {
            agents = this.world().agentSetOfKind(widget.kind());
        }
        if (owner.ownsPrimaryJobs()) {
            if (e.procedure != null) {
                this.jobManager.addJob(owner, agents, this, e.procedure);
            } else {
                new Events.JobRemovedEvent(owner).raiseLater(this);
            }
        } else {
            this.jobManager.addSecondaryJob(owner, agents, this, e.procedure);
        }
    }

    @Override
    public void handle(Events.RemoveJobEvent e) {
        JobOwner owner = e.owner;
        if (owner.ownsPrimaryJobs()) {
            this.jobManager.finishJobs(owner);
        } else {
            this.jobManager.finishSecondaryJobs(owner);
        }
    }

    @Override
    public void handle(Events.JobStoppingEvent e) {
        this.jobManager.stoppingJobs(e.owner);
    }

    @Override
    public void handle(Events.RemoveAllJobsEvent e) {
        this.jobManager.haltSecondary();
        this.jobManager.haltPrimary();
    }

    @Override
    public void handle(Events.AddBooleanConstraintEvent e) {
        BooleanConstraint con = new BooleanConstraint(e.defaultValue);
        int index = this.world().observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world().observer().setConstraint(index, con);
        }
    }

    @Override
    public void handle(Events.AddInputBoxConstraintEvent e) {
        int index = this.world().observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world().observer().setConstraint(index, e.constraint);
        }
    }

    @Override
    public void handle(Events.AddChooserConstraintEvent e) {
        int index = this.world().observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world().observer().setConstraint(index, e.constraint);
        }
    }

    @Override
    public void handle(Events.AddSliderConstraintEvent e) {
        block3: {
            try {
                SliderConstraint con = SliderConstraint.makeSliderConstraint(this.world().observer(), e.minSpec, e.maxSpec, e.incSpec, e.value, e.slider.name(), this, this);
                e.slider.removeAllErrors();
                e.slider.setSliderConstraint(con);
                int index = this.world().observerOwnsIndexOf(e.varname.toUpperCase());
                if (index == -1) break block3;
                this.world().observer().setConstraint(index, con);
            }
            catch (SliderConstraint.ConstraintExceptionHolder ex) {
                for (SliderConstraint.SliderConstraintException cce : JavaConversions.asJavaIterable(ex.getErrors())) {
                    e.slider.error(cce.spec().fieldName(), (Exception)((Object)cce));
                }
            }
        }
    }

    @Override
    public void handle(Events.RemoveConstraintEvent e) {
        int index = this.world().observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world().observer().setConstraint(index, null);
        }
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        this.codeBits.clear();
    }

    public abstract void closeAgentMonitors();

    @Override
    public abstract void inspectAgent(AgentKind var1, org.nlogo.agent.Agent var2, double var3);

    public void inspectAgent(AgentKind agentClass) {
        this.inspectAgent(agentClass, null, (this.world().worldWidth() - 1) / 2);
    }

    @Override
    public void clearOutput() {
        final Events.OutputEvent event = new Events.OutputEvent(true, null, false, false);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                @Override
                public void run() {
                    event.raise(GUIWorkspace.this);
                }
            });
        } else {
            event.raise(this);
        }
    }

    @Override
    protected void sendOutput(OutputObject oo, boolean toOutputArea) {
        final Events.OutputEvent event = new Events.OutputEvent(false, oo, false, !toOutputArea);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                @Override
                public void run() {
                    event.raise(GUIWorkspace.this);
                }
            });
        } else {
            event.raise(this);
        }
    }

    @Override
    public void runtimeError(final JobOwner owner, final Context context, final Instruction instruction, final Exception ex) {
        final Thread thread = Thread.currentThread();
        org.nlogo.awt.EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIWorkspace.this.runtimeErrorPrivate(owner, context, instruction, thread, ex);
            }
        });
    }

    private void runtimeErrorPrivate(JobOwner owner, final Context context, final Instruction instruction, final Thread thread, final Exception ex) {
        if (ex instanceof HaltException && ((HaltException)ex).haltAll()) {
            this.halt();
        } else if (!(owner instanceof MonitorWidget)) {
            this.world().displayOn(true);
        }
        if (!(ex instanceof HaltException)) {
            SourceOwner sourceOwner = context.activation.procedure.owner();
            int[] posAndLength = instruction.token() == null ? new int[]{-1, 0} : instruction.getPositionAndLength();
            new Events.RuntimeErrorEvent(owner, sourceOwner, posAndLength[0], posAndLength[1]).raiseLater(this);
        }
        if (!(owner instanceof MonitorWidget) && !(ex instanceof HaltException)) {
            org.nlogo.awt.EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUIWorkspace.this.errorDialogManager.show(context, instruction, thread, ex);
                }
            });
        }
    }

    @Override
    public void handle(Events.BeforeLoadEvent e) {
        this.setPeriodicUpdatesEnabled(false);
        if (e.modelPath.isDefined()) {
            this.setModelPath(e.modelPath.get());
        } else {
            this.setModelPath(null);
        }
        this.setModelType(e.modelType);
        if (this.hubNetManager().isDefined()) {
            this.hubNetManager().get().disconnect();
        }
        this.jobManager.haltSecondary();
        this.jobManager.haltPrimary();
        this.getExtensionManager().reset();
        this.fileManager().handleModelChange();
        this.setPreviewCommands(PreviewCommands$.MODULE$.DEFAULT());
        this.clearDrawing();
        this.viewManager().resetMouseCors();
        this.displaySwitchOn(true);
        this.setProcedures(new ListMap<String, Procedure>());
        this.lastTicksListenersHeard = -1.0;
        this.plotManager().forgetAll();
    }

    public void modelSaved(String newModelPath) {
        this.setModelPath(newModelPath);
        this.setModelType(ModelTypeJ.NORMAL());
    }

    @Override
    public void handle(Events.AboutToQuitEvent e) {
        if (this.hubNetManager().isDefined()) {
            this.hubNetManager().get().disconnect();
        }
    }

    @Override
    public void hubNetRunning_$eq(boolean running) {
        if (this.hubNetRunning() != running) {
            if (running) {
                this.viewManager().add(this.hubNetManager().get());
            } else {
                this.viewManager().remove(this.hubNetManager().get());
            }
        }
        super.hubNetRunning_$eq(running);
        this.hubNetControlCenterAction.setEnabled(this.hubNetRunning());
    }

    private strictfp class Lifeguard
    extends Thread {
        Lifeguard() {
            super("Lifeguard");
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                        GUIWorkspace.this.world().comeUpForAir = true;
                    }
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException ex) {
                Exceptions.ignore(ex);
                return;
            }
        }
    }

    public strictfp static enum KioskLevel {
        NONE,
        MODERATE;

    }
}

