/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.tools.ToJSON;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.BoxFactory;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;

public class NodeBox
extends Box {
    private static final int MAX_BOX_SIZE = 0x8000000;
    protected List<Box> boxes = new LinkedList<Box>();
    protected BoxFactory factory = BoxFactory.getDefault();

    public NodeBox(Header atom) {
        super(atom);
    }

    public NodeBox(NodeBox other) {
        super(other);
        this.boxes = other.boxes;
        this.factory = other.factory;
    }

    @Override
    public void parse(ByteBuffer input) {
        while (input.remaining() >= 8) {
            Box child = NodeBox.parseChildBox(input, this.factory);
            if (child == null) continue;
            this.boxes.add(child);
        }
    }

    public static Box parseChildBox(ByteBuffer input, BoxFactory factory) {
        ByteBuffer fork = input.duplicate();
        while (input.remaining() >= 4 && fork.getInt() == 0) {
            input.getInt();
        }
        if (input.remaining() < 4) {
            return null;
        }
        Header childAtom = Header.read(input);
        if (childAtom != null && (long)input.remaining() >= childAtom.getBodySize()) {
            return NodeBox.parseBox(NIOUtils.read(input, (int)childAtom.getBodySize()), childAtom, factory);
        }
        return null;
    }

    public static Box newBox(Header header, BoxFactory factory) {
        Class<? extends Box> claz = factory.toClass(header.getFourcc());
        if (claz == null) {
            return new LeafBox(header);
        }
        try {
            try {
                return claz.getConstructor(Header.class).newInstance(header);
            }
            catch (NoSuchMethodException e) {
                return claz.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Box parseBox(ByteBuffer input, Header childAtom, BoxFactory factory) {
        Box box = NodeBox.newBox(childAtom, factory);
        if (childAtom.getBodySize() < 0x8000000L) {
            box.parse(input);
            return box;
        }
        return new LeafBox(new Header("free", 8L));
    }

    public List<Box> getBoxes() {
        return this.boxes;
    }

    public void add(Box box) {
        this.boxes.add(box);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        for (Box box : this.boxes) {
            box.write(out);
        }
    }

    public void addFirst(MovieHeaderBox box) {
        this.boxes.add(0, box);
    }

    public void replace(String fourcc, Box box) {
        this.removeChildren(fourcc);
        this.add(box);
    }

    public void replace(Box box) {
        this.removeChildren(box.getFourcc());
        this.add(box);
    }

    @Override
    protected void dump(StringBuilder sb) {
        sb.append("{\"tag\":\"" + this.header.getFourcc() + "\",");
        ArrayList<String> fields = new ArrayList<String>(0);
        this.collectModel(this.getClass(), fields);
        ToJSON.fieldsToJSON(this, sb, fields.toArray(new String[0]));
        sb.append("\"boxes\": [");
        this.dumpBoxes(sb);
        sb.append("]");
        sb.append("}");
    }

    protected void getModelFields(List<String> model) {
    }

    protected void dumpBoxes(StringBuilder sb) {
        for (int i = 0; i < this.boxes.size(); ++i) {
            this.boxes.get(i).dump(sb);
            if (i >= this.boxes.size() - 1) continue;
            sb.append(",");
        }
    }

    public void removeChildren(String ... fourcc) {
        Iterator<Box> it = this.boxes.iterator();
        block0: while (it.hasNext()) {
            Box box = it.next();
            String fcc = box.getFourcc();
            for (String cand : fourcc) {
                if (!cand.equals(fcc)) continue;
                it.remove();
                continue block0;
            }
        }
    }
}

