/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.sampling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openimaj.image.pixel.sampling.RectangleSampler;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.iterator.IterableIterator;

public class QuadtreeSampler
implements Iterable<Rectangle> {
    Rectangle base;
    int nLevels;

    public QuadtreeSampler(Rectangle r, int nLevels) {
        this.base = r;
        this.nLevels = nLevels;
    }

    public List<List<Rectangle>> levelRectangles() {
        ArrayList<List<Rectangle>> rects = new ArrayList<List<Rectangle>>();
        for (RectangleSampler rs : IterableIterator.in(this.levelIterator())) {
            rects.add(rs.allRectangles());
        }
        return rects;
    }

    public List<Rectangle> allRectangles() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        for (Rectangle r : this) {
            list.add(r);
        }
        return list;
    }

    @Override
    public Iterator<Rectangle> iterator() {
        return new Iterator<Rectangle>(){
            Iterator<RectangleSampler> levelIter;
            Iterator<Rectangle> rectIter;
            {
                this.levelIter = QuadtreeSampler.this.levelIterator();
                this.rectIter = this.levelIter.hasNext() ? this.levelIter.next().iterator() : null;
            }

            @Override
            public boolean hasNext() {
                if (this.rectIter != null && this.rectIter.hasNext()) {
                    return true;
                }
                return this.levelIter.hasNext();
            }

            @Override
            public Rectangle next() {
                if (!this.rectIter.hasNext()) {
                    this.rectIter = this.levelIter.next().iterator();
                }
                return this.rectIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal is not supported!");
            }
        };
    }

    public Iterator<RectangleSampler> levelIterator() {
        return new Iterator<RectangleSampler>(){
            int level = 0;

            @Override
            public boolean hasNext() {
                return this.level < QuadtreeSampler.this.nLevels;
            }

            @Override
            public RectangleSampler next() {
                if (this.level >= QuadtreeSampler.this.nLevels) {
                    throw new NoSuchElementException();
                }
                float sz = (float)Math.pow(2.0, this.level);
                float dx = QuadtreeSampler.this.base.width / sz;
                float dy = QuadtreeSampler.this.base.height / sz;
                RectangleSampler r = new RectangleSampler(QuadtreeSampler.this.base, dx, dy, dx, dy);
                ++this.level;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal is not supported!");
            }
        };
    }
}

