/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.path;

import java.util.Iterator;
import java.util.List;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.path.Path2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.PointList;

public class Polyline
extends PointList
implements Path2d {
    public Polyline(Point2d ... points) {
        super(points);
    }

    public Polyline(List<? extends Point2d> points) {
        this(points, false);
    }

    public Polyline(List<? extends Point2d> points, boolean copy) {
        super(points, copy);
    }

    public Polyline(Iterator<Line2d> lineIterator) {
        super(new Point2d[0]);
        Point2d end = null;
        while (lineIterator.hasNext()) {
            Line2d line = lineIterator.next();
            this.points.add(line.begin);
            end = line.end;
        }
        if (end != null) {
            this.points.add(end);
        }
    }

    @Override
    public Point2d begin() {
        return (Point2d)this.points.get(0);
    }

    @Override
    public Point2d end() {
        return (Point2d)this.points.get(this.points.size() - 1);
    }

    @Override
    public Polyline asPolyline() {
        return this;
    }

    @Override
    public Iterator<Line2d> lineIterator() {
        return new Iterator<Line2d>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Polyline.this.points.size() - 1;
            }

            @Override
            public Line2d next() {
                Line2d line = new Line2d((Point2d)Polyline.this.points.get(this.i), (Point2d)Polyline.this.points.get(this.i + 1));
                ++this.i;
                return line;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public double calculateLength() {
        double length = 0.0;
        for (int i = 0; i < this.points.size() - 1; ++i) {
            length += Line2d.distance((Point2d)this.points.get(i), (Point2d)this.points.get(i + 1));
        }
        return length;
    }
}

