/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadPoolExecutor;
import org.openimaj.util.function.Function;
import org.openimaj.util.function.MultiFunction;
import org.openimaj.util.function.Operation;
import org.openimaj.util.function.Predicate;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.stream.Stream;

public abstract class AbstractStream<T>
implements Stream<T> {
    @Override
    public void forEach(Operation<T> op) {
        while (this.hasNext()) {
            op.perform(this.next());
        }
    }

    @Override
    public void forEach(Operation<T> operation, Predicate<T> stopPredicate) {
        while (this.hasNext()) {
            Object next = this.next();
            operation.perform(next);
            if (!stopPredicate.test(next)) continue;
            break;
        }
    }

    @Override
    public int forEach(Operation<T> operation, int limit) {
        int seen = 0;
        while (this.hasNext()) {
            Object next = this.next();
            operation.perform(next);
            if (++seen < limit) continue;
            break;
        }
        return seen;
    }

    @Override
    public void parallelForEach(Operation<T> op) {
        Parallel.forEachUnpartitioned(this, op);
    }

    @Override
    public void parallelForEach(Operation<T> op, ThreadPoolExecutor pool) {
        Parallel.forEachUnpartitioned(this, op, pool);
    }

    @Override
    public Stream<T> filter(Predicate<T> filter) {
        return new FilterStream(filter);
    }

    @Override
    public <R> Stream<R> transform(Function<Stream<T>, Stream<R>> transform) {
        return transform.apply(this);
    }

    @Override
    public <R> Stream<R> map(final Function<T, R> mapper) {
        return new AbstractStream<R>(){

            @Override
            public boolean hasNext() {
                return AbstractStream.this.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(AbstractStream.this.next());
            }
        };
    }

    @Override
    public <R> Stream<R> map(final MultiFunction<T, R> mapper) {
        return new AbstractStream<R>(){
            List<R> current;
            int currentIndex;

            @Override
            public boolean hasNext() {
                if (this.current != null && this.currentIndex >= this.current.size()) {
                    this.current = null;
                    this.currentIndex = 0;
                }
                if (this.current == null) {
                    if (AbstractStream.this.hasNext()) {
                        for (Object obj : AbstractStream.this) {
                            List list = mapper.apply(obj);
                            if (list == null || list.size() <= 0) continue;
                            this.current = list;
                            this.currentIndex = 0;
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            }

            @Override
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object ret = this.current.get(this.currentIndex);
                ++this.currentIndex;
                return ret;
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    class FilterStream
    extends AbstractStream<T> {
        Predicate<T> filter;
        T obj = null;

        FilterStream(Predicate<T> predicate) {
            this.filter = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.obj != null) {
                return true;
            }
            while (AbstractStream.this.hasNext() && !this.filter.test(this.obj = AbstractStream.this.next())) {
                this.obj = null;
            }
            return this.obj != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("iteration has no more elements");
            }
            Object toRet = this.obj;
            this.obj = null;
            return toRet;
        }
    }
}

