package streamanalytics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthenticationMode enumerates the values for authentication mode.
type AuthenticationMode string

const (
	// AuthenticationModeConnectionString ...
	AuthenticationModeConnectionString AuthenticationMode = "ConnectionString"
	// AuthenticationModeMsi ...
	AuthenticationModeMsi AuthenticationMode = "Msi"
	// AuthenticationModeUserToken ...
	AuthenticationModeUserToken AuthenticationMode = "UserToken"
)

// PossibleAuthenticationModeValues returns an array of possible values for the AuthenticationMode const type.
func PossibleAuthenticationModeValues() []AuthenticationMode {
	return []AuthenticationMode{AuthenticationModeConnectionString, AuthenticationModeMsi, AuthenticationModeUserToken}
}

// BindingType enumerates the values for binding type.
type BindingType string

const (
	// BindingTypeFunctionRetrieveDefaultDefinitionParameters ...
	BindingTypeFunctionRetrieveDefaultDefinitionParameters BindingType = "FunctionRetrieveDefaultDefinitionParameters"
	// BindingTypeMicrosoftMachineLearningWebService ...
	BindingTypeMicrosoftMachineLearningWebService BindingType = "Microsoft.MachineLearning/WebService"
	// BindingTypeMicrosoftStreamAnalyticsJavascriptUdf ...
	BindingTypeMicrosoftStreamAnalyticsJavascriptUdf BindingType = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// PossibleBindingTypeValues returns an array of possible values for the BindingType const type.
func PossibleBindingTypeValues() []BindingType {
	return []BindingType{BindingTypeFunctionRetrieveDefaultDefinitionParameters, BindingTypeMicrosoftMachineLearningWebService, BindingTypeMicrosoftStreamAnalyticsJavascriptUdf}
}

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// ClusterProvisioningStateCanceled The cluster provisioning was canceled.
	ClusterProvisioningStateCanceled ClusterProvisioningState = "Canceled"
	// ClusterProvisioningStateFailed The cluster provisioning failed.
	ClusterProvisioningStateFailed ClusterProvisioningState = "Failed"
	// ClusterProvisioningStateInProgress The cluster provisioning was inprogress.
	ClusterProvisioningStateInProgress ClusterProvisioningState = "InProgress"
	// ClusterProvisioningStateSucceeded The cluster provisioning succeeded.
	ClusterProvisioningStateSucceeded ClusterProvisioningState = "Succeeded"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{ClusterProvisioningStateCanceled, ClusterProvisioningStateFailed, ClusterProvisioningStateInProgress, ClusterProvisioningStateSucceeded}
}

// ClusterSkuName enumerates the values for cluster sku name.
type ClusterSkuName string

const (
	// ClusterSkuNameDefault The default SKU.
	ClusterSkuNameDefault ClusterSkuName = "Default"
)

// PossibleClusterSkuNameValues returns an array of possible values for the ClusterSkuName const type.
func PossibleClusterSkuNameValues() []ClusterSkuName {
	return []ClusterSkuName{ClusterSkuNameDefault}
}

// CompatibilityLevel enumerates the values for compatibility level.
type CompatibilityLevel string

const (
	// CompatibilityLevelOneFullStopTwo ...
	CompatibilityLevelOneFullStopTwo CompatibilityLevel = "1.2"
	// CompatibilityLevelOneFullStopZero ...
	CompatibilityLevelOneFullStopZero CompatibilityLevel = "1.0"
)

// PossibleCompatibilityLevelValues returns an array of possible values for the CompatibilityLevel const type.
func PossibleCompatibilityLevelValues() []CompatibilityLevel {
	return []CompatibilityLevel{CompatibilityLevelOneFullStopTwo, CompatibilityLevelOneFullStopZero}
}

// CompressionType enumerates the values for compression type.
type CompressionType string

const (
	// CompressionTypeDeflate ...
	CompressionTypeDeflate CompressionType = "Deflate"
	// CompressionTypeGZip ...
	CompressionTypeGZip CompressionType = "GZip"
	// CompressionTypeNone ...
	CompressionTypeNone CompressionType = "None"
)

// PossibleCompressionTypeValues returns an array of possible values for the CompressionType const type.
func PossibleCompressionTypeValues() []CompressionType {
	return []CompressionType{CompressionTypeDeflate, CompressionTypeGZip, CompressionTypeNone}
}

// ContentStoragePolicy enumerates the values for content storage policy.
type ContentStoragePolicy string

const (
	// ContentStoragePolicyJobStorageAccount ...
	ContentStoragePolicyJobStorageAccount ContentStoragePolicy = "JobStorageAccount"
	// ContentStoragePolicySystemAccount ...
	ContentStoragePolicySystemAccount ContentStoragePolicy = "SystemAccount"
)

// PossibleContentStoragePolicyValues returns an array of possible values for the ContentStoragePolicy const type.
func PossibleContentStoragePolicyValues() []ContentStoragePolicy {
	return []ContentStoragePolicy{ContentStoragePolicyJobStorageAccount, ContentStoragePolicySystemAccount}
}

// Encoding enumerates the values for encoding.
type Encoding string

const (
	// EncodingUTF8 ...
	EncodingUTF8 Encoding = "UTF8"
)

// PossibleEncodingValues returns an array of possible values for the Encoding const type.
func PossibleEncodingValues() []Encoding {
	return []Encoding{EncodingUTF8}
}

// EventSerializationType enumerates the values for event serialization type.
type EventSerializationType string

const (
	// EventSerializationTypeAvro ...
	EventSerializationTypeAvro EventSerializationType = "Avro"
	// EventSerializationTypeCsv ...
	EventSerializationTypeCsv EventSerializationType = "Csv"
	// EventSerializationTypeJSON ...
	EventSerializationTypeJSON EventSerializationType = "Json"
	// EventSerializationTypeParquet ...
	EventSerializationTypeParquet EventSerializationType = "Parquet"
)

// PossibleEventSerializationTypeValues returns an array of possible values for the EventSerializationType const type.
func PossibleEventSerializationTypeValues() []EventSerializationType {
	return []EventSerializationType{EventSerializationTypeAvro, EventSerializationTypeCsv, EventSerializationTypeJSON, EventSerializationTypeParquet}
}

// EventsOutOfOrderPolicy enumerates the values for events out of order policy.
type EventsOutOfOrderPolicy string

const (
	// EventsOutOfOrderPolicyAdjust ...
	EventsOutOfOrderPolicyAdjust EventsOutOfOrderPolicy = "Adjust"
	// EventsOutOfOrderPolicyDrop ...
	EventsOutOfOrderPolicyDrop EventsOutOfOrderPolicy = "Drop"
)

// PossibleEventsOutOfOrderPolicyValues returns an array of possible values for the EventsOutOfOrderPolicy const type.
func PossibleEventsOutOfOrderPolicyValues() []EventsOutOfOrderPolicy {
	return []EventsOutOfOrderPolicy{EventsOutOfOrderPolicyAdjust, EventsOutOfOrderPolicyDrop}
}

// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateCreated The job is currently in the Created state.
	JobStateCreated JobState = "Created"
	// JobStateDegraded The job is currently in the Degraded state.
	JobStateDegraded JobState = "Degraded"
	// JobStateDeleting The job is currently in the Deleting state.
	JobStateDeleting JobState = "Deleting"
	// JobStateFailed The job is currently in the Failed state.
	JobStateFailed JobState = "Failed"
	// JobStateRestarting The job is currently in the Restarting state.
	JobStateRestarting JobState = "Restarting"
	// JobStateRunning The job is currently in the Running state.
	JobStateRunning JobState = "Running"
	// JobStateScaling The job is currently in the Scaling state.
	JobStateScaling JobState = "Scaling"
	// JobStateStarting The job is currently in the Starting state.
	JobStateStarting JobState = "Starting"
	// JobStateStopped The job is currently in the Stopped state.
	JobStateStopped JobState = "Stopped"
	// JobStateStopping The job is currently in the Stopping state.
	JobStateStopping JobState = "Stopping"
)

// PossibleJobStateValues returns an array of possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{JobStateCreated, JobStateDegraded, JobStateDeleting, JobStateFailed, JobStateRestarting, JobStateRunning, JobStateScaling, JobStateStarting, JobStateStopped, JobStateStopping}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeCloud ...
	JobTypeCloud JobType = "Cloud"
	// JobTypeEdge ...
	JobTypeEdge JobType = "Edge"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeCloud, JobTypeEdge}
}

// JSONOutputSerializationFormat enumerates the values for json output serialization format.
type JSONOutputSerializationFormat string

const (
	// JSONOutputSerializationFormatArray ...
	JSONOutputSerializationFormatArray JSONOutputSerializationFormat = "Array"
	// JSONOutputSerializationFormatLineSeparated ...
	JSONOutputSerializationFormatLineSeparated JSONOutputSerializationFormat = "LineSeparated"
)

// PossibleJSONOutputSerializationFormatValues returns an array of possible values for the JSONOutputSerializationFormat const type.
func PossibleJSONOutputSerializationFormatValues() []JSONOutputSerializationFormat {
	return []JSONOutputSerializationFormat{JSONOutputSerializationFormatArray, JSONOutputSerializationFormatLineSeparated}
}

// OutputErrorPolicy enumerates the values for output error policy.
type OutputErrorPolicy string

const (
	// OutputErrorPolicyDrop ...
	OutputErrorPolicyDrop OutputErrorPolicy = "Drop"
	// OutputErrorPolicyStop ...
	OutputErrorPolicyStop OutputErrorPolicy = "Stop"
)

// PossibleOutputErrorPolicyValues returns an array of possible values for the OutputErrorPolicy const type.
func PossibleOutputErrorPolicyValues() []OutputErrorPolicy {
	return []OutputErrorPolicy{OutputErrorPolicyDrop, OutputErrorPolicyStop}
}

// OutputStartMode enumerates the values for output start mode.
type OutputStartMode string

const (
	// OutputStartModeCustomTime ...
	OutputStartModeCustomTime OutputStartMode = "CustomTime"
	// OutputStartModeJobStartTime ...
	OutputStartModeJobStartTime OutputStartMode = "JobStartTime"
	// OutputStartModeLastOutputEventTime ...
	OutputStartModeLastOutputEventTime OutputStartMode = "LastOutputEventTime"
)

// PossibleOutputStartModeValues returns an array of possible values for the OutputStartMode const type.
func PossibleOutputStartModeValues() []OutputStartMode {
	return []OutputStartMode{OutputStartModeCustomTime, OutputStartModeJobStartTime, OutputStartModeLastOutputEventTime}
}

// RefreshType enumerates the values for refresh type.
type RefreshType string

const (
	// RefreshTypeRefreshPeriodicallyWithDelta ...
	RefreshTypeRefreshPeriodicallyWithDelta RefreshType = "RefreshPeriodicallyWithDelta"
	// RefreshTypeRefreshPeriodicallyWithFull ...
	RefreshTypeRefreshPeriodicallyWithFull RefreshType = "RefreshPeriodicallyWithFull"
	// RefreshTypeStatic ...
	RefreshTypeStatic RefreshType = "Static"
)

// PossibleRefreshTypeValues returns an array of possible values for the RefreshType const type.
func PossibleRefreshTypeValues() []RefreshType {
	return []RefreshType{RefreshTypeRefreshPeriodicallyWithDelta, RefreshTypeRefreshPeriodicallyWithFull, RefreshTypeStatic}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameStandard}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAvro ...
	TypeAvro Type = "Avro"
	// TypeCsv ...
	TypeCsv Type = "Csv"
	// TypeJSON ...
	TypeJSON Type = "Json"
	// TypeParquet ...
	TypeParquet Type = "Parquet"
	// TypeSerialization ...
	TypeSerialization Type = "Serialization"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAvro, TypeCsv, TypeJSON, TypeParquet, TypeSerialization}
}

// TypeBasicFunctionBinding enumerates the values for type basic function binding.
type TypeBasicFunctionBinding string

const (
	// TypeBasicFunctionBindingTypeFunctionBinding ...
	TypeBasicFunctionBindingTypeFunctionBinding TypeBasicFunctionBinding = "FunctionBinding"
	// TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService ...
	TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService TypeBasicFunctionBinding = "Microsoft.MachineLearning/WebService"
	// TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf ...
	TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf TypeBasicFunctionBinding = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// PossibleTypeBasicFunctionBindingValues returns an array of possible values for the TypeBasicFunctionBinding const type.
func PossibleTypeBasicFunctionBindingValues() []TypeBasicFunctionBinding {
	return []TypeBasicFunctionBinding{TypeBasicFunctionBindingTypeFunctionBinding, TypeBasicFunctionBindingTypeMicrosoftMachineLearningWebService, TypeBasicFunctionBindingTypeMicrosoftStreamAnalyticsJavascriptUdf}
}

// TypeBasicFunctionProperties enumerates the values for type basic function properties.
type TypeBasicFunctionProperties string

const (
	// TypeBasicFunctionPropertiesTypeAggregate ...
	TypeBasicFunctionPropertiesTypeAggregate TypeBasicFunctionProperties = "Aggregate"
	// TypeBasicFunctionPropertiesTypeFunctionProperties ...
	TypeBasicFunctionPropertiesTypeFunctionProperties TypeBasicFunctionProperties = "FunctionProperties"
	// TypeBasicFunctionPropertiesTypeScalar ...
	TypeBasicFunctionPropertiesTypeScalar TypeBasicFunctionProperties = "Scalar"
)

// PossibleTypeBasicFunctionPropertiesValues returns an array of possible values for the TypeBasicFunctionProperties const type.
func PossibleTypeBasicFunctionPropertiesValues() []TypeBasicFunctionProperties {
	return []TypeBasicFunctionProperties{TypeBasicFunctionPropertiesTypeAggregate, TypeBasicFunctionPropertiesTypeFunctionProperties, TypeBasicFunctionPropertiesTypeScalar}
}

// TypeBasicInputProperties enumerates the values for type basic input properties.
type TypeBasicInputProperties string

const (
	// TypeBasicInputPropertiesTypeInputProperties ...
	TypeBasicInputPropertiesTypeInputProperties TypeBasicInputProperties = "InputProperties"
	// TypeBasicInputPropertiesTypeReference ...
	TypeBasicInputPropertiesTypeReference TypeBasicInputProperties = "Reference"
	// TypeBasicInputPropertiesTypeStream ...
	TypeBasicInputPropertiesTypeStream TypeBasicInputProperties = "Stream"
)

// PossibleTypeBasicInputPropertiesValues returns an array of possible values for the TypeBasicInputProperties const type.
func PossibleTypeBasicInputPropertiesValues() []TypeBasicInputProperties {
	return []TypeBasicInputProperties{TypeBasicInputPropertiesTypeInputProperties, TypeBasicInputPropertiesTypeReference, TypeBasicInputPropertiesTypeStream}
}

// TypeBasicOutputDataSource enumerates the values for type basic output data source.
type TypeBasicOutputDataSource string

const (
	// TypeBasicOutputDataSourceTypeMicrosoftAzureFunction ...
	TypeBasicOutputDataSourceTypeMicrosoftAzureFunction TypeBasicOutputDataSource = "Microsoft.AzureFunction"
	// TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts ...
	TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts TypeBasicOutputDataSource = "Microsoft.DataLake/Accounts"
	// TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub ...
	TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub TypeBasicOutputDataSource = "Microsoft.EventHub/EventHub"
	// TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub ...
	TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub TypeBasicOutputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue ...
	TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue TypeBasicOutputDataSource = "Microsoft.ServiceBus/Queue"
	// TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic ...
	TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic TypeBasicOutputDataSource = "Microsoft.ServiceBus/Topic"
	// TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase ...
	TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase TypeBasicOutputDataSource = "Microsoft.Sql/Server/Database"
	// TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse ...
	TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse TypeBasicOutputDataSource = "Microsoft.Sql/Server/DataWarehouse"
	// TypeBasicOutputDataSourceTypeMicrosoftStorageBlob ...
	TypeBasicOutputDataSourceTypeMicrosoftStorageBlob TypeBasicOutputDataSource = "Microsoft.Storage/Blob"
	// TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB ...
	TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB TypeBasicOutputDataSource = "Microsoft.Storage/DocumentDB"
	// TypeBasicOutputDataSourceTypeMicrosoftStorageTable ...
	TypeBasicOutputDataSourceTypeMicrosoftStorageTable TypeBasicOutputDataSource = "Microsoft.Storage/Table"
	// TypeBasicOutputDataSourceTypeOutputDataSource ...
	TypeBasicOutputDataSourceTypeOutputDataSource TypeBasicOutputDataSource = "OutputDataSource"
	// TypeBasicOutputDataSourceTypePowerBI ...
	TypeBasicOutputDataSourceTypePowerBI TypeBasicOutputDataSource = "PowerBI"
)

// PossibleTypeBasicOutputDataSourceValues returns an array of possible values for the TypeBasicOutputDataSource const type.
func PossibleTypeBasicOutputDataSourceValues() []TypeBasicOutputDataSource {
	return []TypeBasicOutputDataSource{TypeBasicOutputDataSourceTypeMicrosoftAzureFunction, TypeBasicOutputDataSourceTypeMicrosoftDataLakeAccounts, TypeBasicOutputDataSourceTypeMicrosoftEventHubEventHub, TypeBasicOutputDataSourceTypeMicrosoftServiceBusEventHub, TypeBasicOutputDataSourceTypeMicrosoftServiceBusQueue, TypeBasicOutputDataSourceTypeMicrosoftServiceBusTopic, TypeBasicOutputDataSourceTypeMicrosoftSQLServerDatabase, TypeBasicOutputDataSourceTypeMicrosoftSQLServerDataWarehouse, TypeBasicOutputDataSourceTypeMicrosoftStorageBlob, TypeBasicOutputDataSourceTypeMicrosoftStorageDocumentDB, TypeBasicOutputDataSourceTypeMicrosoftStorageTable, TypeBasicOutputDataSourceTypeOutputDataSource, TypeBasicOutputDataSourceTypePowerBI}
}

// TypeBasicReferenceInputDataSource enumerates the values for type basic reference input data source.
type TypeBasicReferenceInputDataSource string

const (
	// TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase ...
	TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase TypeBasicReferenceInputDataSource = "Microsoft.Sql/Server/Database"
	// TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob ...
	TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob TypeBasicReferenceInputDataSource = "Microsoft.Storage/Blob"
	// TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource ...
	TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource TypeBasicReferenceInputDataSource = "ReferenceInputDataSource"
)

// PossibleTypeBasicReferenceInputDataSourceValues returns an array of possible values for the TypeBasicReferenceInputDataSource const type.
func PossibleTypeBasicReferenceInputDataSourceValues() []TypeBasicReferenceInputDataSource {
	return []TypeBasicReferenceInputDataSource{TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase, TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob, TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource}
}

// TypeBasicStreamInputDataSource enumerates the values for type basic stream input data source.
type TypeBasicStreamInputDataSource string

const (
	// TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs ...
	TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs TypeBasicStreamInputDataSource = "Microsoft.Devices/IotHubs"
	// TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub ...
	TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub TypeBasicStreamInputDataSource = "Microsoft.EventHub/EventHub"
	// TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub ...
	TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub TypeBasicStreamInputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob ...
	TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob TypeBasicStreamInputDataSource = "Microsoft.Storage/Blob"
	// TypeBasicStreamInputDataSourceTypeStreamInputDataSource ...
	TypeBasicStreamInputDataSourceTypeStreamInputDataSource TypeBasicStreamInputDataSource = "StreamInputDataSource"
)

// PossibleTypeBasicStreamInputDataSourceValues returns an array of possible values for the TypeBasicStreamInputDataSource const type.
func PossibleTypeBasicStreamInputDataSourceValues() []TypeBasicStreamInputDataSource {
	return []TypeBasicStreamInputDataSource{TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs, TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub, TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub, TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob, TypeBasicStreamInputDataSourceTypeStreamInputDataSource}
}

// UdfType enumerates the values for udf type.
type UdfType string

const (
	// UdfTypeScalar ...
	UdfTypeScalar UdfType = "Scalar"
)

// PossibleUdfTypeValues returns an array of possible values for the UdfType const type.
func PossibleUdfTypeValues() []UdfType {
	return []UdfType{UdfTypeScalar}
}
