/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fa extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "وقت گرینویچ",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "وقت عادی آپیا",
               "",
               "وقت تابستانی آپیا",
               "",
               "وقت آپیا",
               "",
            };
        final String[] Cook = new String[] {
               "وقت عادی جزایر کوک",
               "",
               "وقت تابستانی جزایر کوک",
               "",
               "وقت جزایر کوک",
               "",
            };
        final String[] Cuba = new String[] {
               "وقت عادی کوبا",
               "CST",
               "وقت تابستانی کوبا",
               "CDT",
               "وقت کوبا",
               "CT",
            };
        final String[] Fiji = new String[] {
               "وقت عادی فیجی",
               "",
               "وقت تابستانی فیجی",
               "",
               "وقت فیجی",
               "",
            };
        final String[] Gulf = new String[] {
               "وقت عادی خلیج فارس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "وقت عادی خوود",
               "",
               "وقت تابستانی خوود",
               "",
               "وقت خوود",
               "",
            };
        final String[] Iran = new String[] {
               "وقت عادی ایران",
               "",
               "وقت تابستانی ایران",
               "",
               "وقت ایران",
               "",
            };
        final String[] Niue = new String[] {
               "وقت نیوئه",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "وقت عادی اومسک",
               "",
               "وقت تابستانی اومسک",
               "",
               "وقت اومسک",
               "",
            };
        final String[] Peru = new String[] {
               "وقت عادی پرو",
               "",
               "وقت تابستانی پرو",
               "",
               "وقت پرو",
               "",
            };
        final String[] Truk = new String[] {
               "وقت چوئوک",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "وقت جزیرهٔ ویک",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "وقت عادی شیلی",
               "",
               "وقت تابستانی شیلی",
               "",
               "وقت شیلی",
               "",
            };
        final String[] China = new String[] {
               "وقت عادی چین",
               "CST",
               "وقت تابستانی چین",
               "CDT",
               "وقت چین",
               "CT",
            };
        final String[] Cocos = new String[] {
               "وقت جزایر کوکوس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "وقت دیویس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "وقت هند",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "وقت عادی ژاپن",
               "JST",
               "وقت تابستانی ژاپن",
               "JDT",
               "وقت ژاپن",
               "JT",
            };
        final String[] Korea = new String[] {
               "وقت عادی کره",
               "KST",
               "وقت تابستانی کره",
               "KST",
               "وقت کره",
               "KST",
            };
        final String[] Nauru = new String[] {
               "وقت نائورو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "وقت نپال",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "وقت پالائو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "وقت عادی ساموا",
               "SST",
               "وقت تابستانی ساموا",
               "SST",
               "وقت ساموا",
               "SST",
            };
        final String[] Syowa = new String[] {
               "وقت شووا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "وقت عادی تونگا",
               "",
               "وقت تابستانی تونگا",
               "",
               "وقت تونگا",
               "",
            };
        final String[] Yukon = new String[] {
               "وقت یوکان",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "وقت عادی آلاسکا",
               "AKST",
               "وقت تابستانی آلاسکا",
               "AKDT",
               "وقت آلاسکا",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "وقت عادی آمازون",
               "",
               "وقت تابستانی آمازون",
               "",
               "وقت آمازون",
               "",
            };
        final String[] Azores = new String[] {
               "وقت عادی آزور",
               "",
               "وقت تابستانی آزور",
               "",
               "وقت آزور",
               "",
            };
        final String[] Bhutan = new String[] {
               "وقت بوتان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "وقت برونئی دارالسلام",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "وقت عادی جزیرهٔ ایستر",
               "",
               "وقت تابستانی جزیرهٔ ایستر",
               "",
               "وقت جزیرهٔ ایستر",
               "",
            };
        final String[] Guyana = new String[] {
               "وقت گویان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "وقت عادی هاوایی‐الوشن",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "وقت عادی اسرائیل",
               "IST",
               "وقت تابستانی اسرائیل",
               "IDT",
               "وقت اسرائیل",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "وقت کوسرای",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "وقت ماوسون",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "وقت عادی مسکو",
               "MSK",
               "وقت تابستانی مسکو",
               "MSK",
               "وقت مسکو",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "وقت پوناپه",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "وقت عادی سامارا",
               "",
               "وقت تابستانی سامارا",
               "",
               "وقت سامارا",
               "",
            };
        final String[] Tahiti = new String[] {
               "وقت تاهیتی",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "وقت عادی تایپه",
               "CST",
               "وقت تابستانی تایپه",
               "CDT",
               "وقت تایپه",
               "CT",
            };
        final String[] Turkey = new String[] {
               "وقت عادی ترکیه",
               "",
               "وقت تابستانی ترکیه",
               "",
               "وقت ترکیه",
               "",
            };
        final String[] Tuvalu = new String[] {
               "وقت تووالو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "وقت وستوک",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "وقت والیس و فوتونا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "وقت عادی عربستان",
               "",
               "وقت تابستانی عربستان",
               "",
               "وقت عربستان",
               "",
            };
        final String[] Armenia = new String[] {
               "وقت عادی ارمنستان",
               "",
               "وقت تابستانی ارمنستان",
               "",
               "وقت ارمنستان",
               "",
            };
        final String[] Bolivia = new String[] {
               "وقت بولیوی",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "وقت عادی چت‌هام",
               "",
               "وقت تابستانی چت‌هام",
               "",
               "وقت چت‌هام",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "زمان هماهنگ جهانی",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "وقت اکوادور",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "وقت گامبیه",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "وقت عادی گرجستان",
               "",
               "وقت تابستانی گرجستان",
               "",
               "وقت گرجستان",
               "",
            };
        final String[] Irkutsk = new String[] {
               "وقت عادی ایرکوتسک",
               "",
               "وقت تابستانی ایرکوتسک",
               "",
               "وقت ایرکوتسک",
               "",
            };
        final String[] Magadan = new String[] {
               "وقت عادی ماگادان",
               "",
               "وقت تابستانی ماگادان",
               "",
               "وقت ماگادان",
               "",
            };
        final String[] Myanmar = new String[] {
               "وقت میانمار",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "وقت عادی جزیرهٔ نورفولک",
               "",
               "وقت تابستانی جزیرهٔ نورفولک",
               "",
               "وقت جزیرهٔ نورفولک",
               "",
            };
        final String[] Noronha = new String[] {
               "وقت عادی فرناندو دی نورونیا",
               "",
               "وقت تابستانی فرناندو دی نورونیا",
               "",
               "وقت فرناندو دی نورونیا",
               "",
            };
        final String[] Reunion = new String[] {
               "وقت رئونیون",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "وقت روترا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "وقت جزایر سلیمان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "وقت توکلائو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "وقت عادی اروگوئه",
               "",
               "وقت تابستانی اروگوئه",
               "",
               "وقت اروگوئه",
               "",
            };
        final String[] Vanuatu = new String[] {
               "وقت عادی واناتو",
               "",
               "وقت تابستانی واناتو",
               "",
               "وقت واناتو",
               "",
            };
        final String[] Yakutsk = new String[] {
               "وقت عادی یاکوتسک",
               "",
               "وقت تابستانی یاکوتسک",
               "",
               "وقت یاکوتسک",
               "",
            };
        final String[] Atlantic = new String[] {
               "وقت عادی آتلانتیک",
               "AST",
               "وقت تابستانی آتلانتیک",
               "AST",
               "وقت آتلانتیک",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "وقت عادی برازیلیا",
               "",
               "وقت تابستانی برازیلیا",
               "",
               "وقت برازیلیا",
               "",
            };
        final String[] Chamorro = new String[] {
               "وقت عادی چامورو",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "وقت عادی کلمبیا",
               "",
               "وقت تابستانی کلمبیا",
               "",
               "وقت کلمبیا",
               "",
            };
        final String[] Falkland = new String[] {
               "وقت عادی جزایر فالکلند",
               "",
               "وقت تابستانی جزایر فالکلند",
               "",
               "وقت جزایر فالکلند",
               "",
            };
        final String[] Malaysia = new String[] {
               "وقت مالزی",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "وقت مالدیو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "وقت عادی اولان‌باتور",
               "",
               "وقت تابستانی اولان‌باتور",
               "",
               "وقت اولان‌باتور",
               "",
            };
        final String[] Pakistan = new String[] {
               "وقت عادی پاکستان",
               "PKT",
               "وقت تابستانی پاکستان",
               "PKST",
               "وقت پاکستان",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "وقت عادی پاراگوئه",
               "",
               "وقت تابستانی پاراگوئه",
               "",
               "وقت پاراگوئه",
               "",
            };
        final String[] Pitcairn = new String[] {
               "وقت پیتکایرن",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "وقت سورینام",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "وقت عادی آرژانتین",
               "",
               "وقت تابستانی آرژانتین",
               "",
               "وقت آرژانتین",
               "",
            };
        final String[] Christmas = new String[] {
               "وقت جزیرهٔ کریسمس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "وقت گالاپاگوس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "وقت عادی هنگ‌کنگ",
               "HKT",
               "وقت تابستانی هنگ‌کنگ",
               "HKST",
               "وقت هنگ‌کنگ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "وقت هندوچین",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "وقت عادی پتروپاولوسک‐کامچاتسکی",
               "",
               "وقت تابستانی پتروپاولوسک‐کامچاتسکی",
               "",
               "وقت پتروپاولوسک‐کامچاتسکی",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "وقت قرقیزستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "وقت عادی لردهو",
               "",
               "وقت تابستانی لردهو",
               "",
               "وقت لردهو",
               "",
            };
        final String[] Marquesas = new String[] {
               "وقت مارکوئز",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "وقت عادی موریس",
               "",
               "وقت تابستانی موریس",
               "",
               "وقت موریس",
               "",
            };
        final String[] Singapore = new String[] {
               "وقت سنگاپور",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "وقت ونزوئلا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "وقت عادی جمهوری آذربایجان",
               "",
               "وقت تابستانی جمهوری آذربایجان",
               "",
               "وقت جمهوری آذربایجان",
               "",
            };
        final String[] Bangladesh = new String[] {
               "وقت عادی بنگلادش",
               "",
               "وقت تابستانی بنگلادش",
               "",
               "وقت بنگلادش",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "وقت عادی کیپ‌ورد",
               "",
               "وقت تابستانی کیپ‌ورد",
               "",
               "وقت کیپ‌ورد",
               "",
            };
        final String[] East_Timor = new String[] {
               "وقت تیمور شرقی",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "وقت قزاقستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "وقت سیشل",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "وقت تاجیکستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "وقت عادی ازبکستان",
               "",
               "وقت تابستانی ازبکستان",
               "",
               "وقت ازبکستان",
               "",
            };
        final String[] Afghanistan = new String[] {
               "وقت افغانستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "وقت عادی کراسنویارسک",
               "",
               "وقت تابستانی کراسنویارسک",
               "",
               "وقت کراسنویارسک",
               "",
            };
        final String[] New_Zealand = new String[] {
               "وقت عادی نیوزیلند",
               "NZST",
               "وقت تابستانی نیوزیلند",
               "NZDT",
               "وقت نیوزیلند",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "وقت عادی فیلیپین",
               "PST",
               "وقت تابستانی فیلیپین",
               "PDT",
               "وقت فیلیپین",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "وقت عادی ولادی‌وستوک",
               "",
               "وقت تابستانی ولادی‌وستوک",
               "",
               "وقت ولادی‌وستوک",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "وقت اقیانوس هند",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "وقت جزایر لاین",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "وقت عادی نیوفاندلند",
               "NST",
               "وقت تابستانی نیوفاندلند",
               "NDT",
               "وقت نیوفاندلند",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "وقت عادی ترکمنستان",
               "",
               "وقت تابستانی ترکمنستان",
               "",
               "وقت ترکمنستان",
               "",
            };
        final String[] French_Guiana = new String[] {
               "وقت گویان فرانسه",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "وقت عادی کالدونیای جدید",
               "",
               "وقت تابستانی کالدونیای جدید",
               "",
               "وقت کالدونیای جدید",
               "",
            };
        final String[] South_Georgia = new String[] {
               "وقت جورجیای جنوبی",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "وقت عادی یکاترینبورگ",
               "",
               "وقت تابستانی یکاترینبورگ",
               "",
               "وقت یکاترینبورگ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "وقت مرکز آفریقا",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "وقت شرق افریقا",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "وقت غرب افریقا",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "وقت دومون دورویل",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "وقت عادی مرکز اروپا",
               "CET",
               "وقت تابستانی مرکز اروپا",
               "CEST",
               "وقت مرکز اروپا",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "وقت عادی شرق اروپا",
               "EET",
               "وقت تابستانی شرق اروپا",
               "EEST",
               "وقت شرق اروپا",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "وقت عادی غرب اروپا",
               "WET",
               "وقت تابستانی غرب اروپا",
               "WEST",
               "وقت غرب اروپا",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "وقت عادی شرق مکزیک",
               "MST",
               "وقت تابستانی شرق مکزیک",
               "MDT",
               "وقت شرق مکزیک",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "وقت عادی جنوب افریقا",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "وقت عادی مرکز امریکا",
               "CST",
               "وقت تابستانی مرکز امریکا",
               "CDT",
               "وقت مرکز امریکا",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "وقت عادی شرق امریکا",
               "EST",
               "وقت تابستانی شرق امریکا",
               "EST",
               "وقت شرق امریکا",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "وقت عادی غرب امریکا",
               "PST",
               "وقت تابستانی غرب امریکا",
               "PDT",
               "وقت غرب امریکا",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "وقت سرزمین‌های جنوبی و جنوبگان فرانسه",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "وقت جزایر گیلبرت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "وقت عادی هاوایی‐الوشن",
               "HST",
               "وقت تابستانی هاوایی‐الوشن",
               "HDT",
               "وقت هاوایی‐الوشن",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "وقت جزایر فونیکس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "وقت عادی سنت‌پیر و میکلون",
               "",
               "وقت تابستانی سنت‌پیر و میکلون",
               "",
               "وقت سنت‌پیر و میکلون",
               "",
            };
        final String[] America_Mountain = new String[] {
               "وقت عادی کوهستانی امریکا",
               "MST",
               "وقت تابستانی کوهستانی امریکا",
               "MST",
               "وقت کوهستانی امریکا",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "وقت جزایر مارشال",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "وقت پاپوا گینهٔ نو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "وقت عادی مرکز استرالیا",
               "ACST",
               "وقت تابستانی مرکز استرالیا",
               "ACDT",
               "وقت مرکز استرالیا",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "وقت عادی استرالیای شرقی",
               "AEST",
               "وقت تابستانی استرالیای شرقی",
               "AEDT",
               "وقت استرالیای شرقی",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "وقت عادی استرالیای غربی",
               "AWST",
               "وقت تابستانی استرالیای غربی",
               "AWDT",
               "وقت استرالیای غربی",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "وقت مرکز اندونزی",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "وقت شرق اندونزی",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "وقت غرب اندونزی",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "وقت عادی مرکز استرالیای غربی",
               "",
               "وقت تابستانی مرکز استرالیای غربی",
               "",
               "وقت مرکز استرالیای غربی",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت تابستانی بریتانیا",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "زمان هماهنگ جهانی",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت عادی ایرلند",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "زمان هماهنگ جهانی",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "زمان هماهنگ جهانی",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت تابستانی بریتانیا",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "زمان هماهنگ جهانی",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "زمان هماهنگ جهانی",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "زمان هماهنگ جهانی",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت عادی ایرلند",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت تابستانی بریتانیا",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت تابستانی بریتانیا",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت تابستانی بریتانیا",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت تابستانی بریتانیا",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "وقت گرینویچ",
                    "GMT",
                    "وقت تابستانی بریتانیا",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "عدن" },
            { "timezone.excity.Asia/Baku", "باکو" },
            { "timezone.excity.Asia/Dili", "دیلی" },
            { "timezone.excity.Asia/Gaza", "غزه" },
            { "timezone.excity.Asia/Hovd", "خوود" },
            { "timezone.excity.Asia/Omsk", "اومسک" },
            { "timezone.excity.Asia/Oral", "اورال" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "عَمان" },
            { "timezone.excity.Asia/Aqtau", "آقتاو" },
            { "timezone.excity.Asia/Chita", "چیتا" },
            { "timezone.excity.Asia/Dhaka", "داکا" },
            { "timezone.excity.Asia/Dubai", "دبی" },
            { "timezone.excity.Asia/Kabul", "کابل" },
            { "timezone.excity.Asia/Macau", "ماکائو" },
            { "timezone.excity.Asia/Qatar", "قطر" },
            { "timezone.excity.Asia/Seoul", "سئول" },
            { "timezone.excity.Asia/Tokyo", "توکیو" },
            { "timezone.excity.Asia/Tomsk", "تومسک" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "جوبا" },
            { "timezone.excity.Africa/Lome", "لومه" },
            { "timezone.excity.Asia/Almaty", "آلماتی" },
            { "timezone.excity.Asia/Anadyr", "آنادیر" },
            { "timezone.excity.Asia/Aqtobe", "آقتوبه" },
            { "timezone.excity.Asia/Atyrau", "آتیراو" },
            { "timezone.excity.Asia/Beirut", "بیروت" },
            { "timezone.excity.Asia/Brunei", "برونئی" },
            { "timezone.excity.Asia/Hebron", "الخلیل" },
            { "timezone.excity.Asia/Kuwait", "کویت" },
            { "timezone.excity.Asia/Manila", "مانیل" },
            { "timezone.excity.Asia/Muscat", "مسقط" },
            { "timezone.excity.Asia/Riyadh", "ریاض" },
            { "timezone.excity.Asia/Saigon", "هوشی‌مین‌سیتی" },
            { "timezone.excity.Asia/Taipei", "تایپه" },
            { "timezone.excity.Asia/Tehran", "تهران" },
            { "timezone.excity.Asia/Urumqi", "ارومچی" },
            { "timezone.excity.Etc/Unknown", "شهر نامشخص" },
            { "timezone.excity.Europe/Kiev", "کیف" },
            { "timezone.excity.Europe/Oslo", "اسلو" },
            { "timezone.excity.Europe/Riga", "ریگا" },
            { "timezone.excity.Europe/Rome", "رم" },
            { "timezone.excity.Indian/Mahe", "ماهه" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "اکرا" },
            { "timezone.excity.Africa/Cairo", "قاهره" },
            { "timezone.excity.Africa/Ceuta", "سبته" },
            { "timezone.excity.Africa/Dakar", "داکار" },
            { "timezone.excity.Africa/Lagos", "لاگوس" },
            { "timezone.excity.Africa/Tunis", "تونس" },
            { "timezone.excity.America/Adak", "ایدک" },
            { "timezone.excity.America/Lima", "لیما" },
            { "timezone.excity.America/Nome", "نوم" },
            { "timezone.excity.Asia/Baghdad", "بغداد" },
            { "timezone.excity.Asia/Bahrain", "بحرین" },
            { "timezone.excity.Asia/Bangkok", "بانکوک" },
            { "timezone.excity.Asia/Barnaul", "بارنائول" },
            { "timezone.excity.Asia/Bishkek", "بیشکک" },
            { "timezone.excity.Asia/Colombo", "کلمبو" },
            { "timezone.excity.Asia/Irkutsk", "ایرکوتسک" },
            { "timezone.excity.Asia/Jakarta", "جاکارتا" },
            { "timezone.excity.Asia/Karachi", "کراچی" },
            { "timezone.excity.Asia/Kuching", "کوچینگ" },
            { "timezone.excity.Asia/Magadan", "ماگادان" },
            { "timezone.excity.Asia/Nicosia", "نیکوزیا" },
            { "timezone.excity.Asia/Rangoon", "یانگون" },
            { "timezone.excity.Asia/Tbilisi", "تفلیس" },
            { "timezone.excity.Asia/Thimphu", "تیمفو" },
            { "timezone.excity.Asia/Yakutsk", "یاکوتسک" },
            { "timezone.excity.Asia/Yerevan", "ایروان" },
            { "timezone.excity.Europe/Kirov", "کیروف" },
            { "timezone.excity.Europe/Malta", "مالت" },
            { "timezone.excity.Europe/Minsk", "مینسک" },
            { "timezone.excity.Europe/Paris", "پاریس" },
            { "timezone.excity.Europe/Sofia", "صوفیه" },
            { "timezone.excity.Europe/Vaduz", "فادوتس" },
            { "timezone.excity.Indian/Cocos", "کوکوس" },
            { "timezone.excity.Pacific/Apia", "آپیا" },
            { "timezone.excity.Pacific/Fiji", "فیجی" },
            { "timezone.excity.Pacific/Guam", "گوام" },
            { "timezone.excity.Pacific/Niue", "نیوئه" },
            { "timezone.excity.Pacific/Truk", "چوک" },
            { "timezone.excity.Pacific/Wake", "ویک" },
            { "timezone.excity.Africa/Asmera", "اسمره" },
            { "timezone.excity.Africa/Bamako", "باماکو" },
            { "timezone.excity.Africa/Bangui", "بانگی" },
            { "timezone.excity.Africa/Banjul", "بانجول" },
            { "timezone.excity.Africa/Bissau", "بیسائو" },
            { "timezone.excity.Africa/Douala", "دوآلا" },
            { "timezone.excity.Africa/Harare", "هراره" },
            { "timezone.excity.Africa/Kigali", "کیگالی" },
            { "timezone.excity.Africa/Luanda", "لواندا" },
            { "timezone.excity.Africa/Lusaka", "لوزاکا" },
            { "timezone.excity.Africa/Malabo", "مالابو" },
            { "timezone.excity.Africa/Maputo", "ماپوتو" },
            { "timezone.excity.Africa/Maseru", "ماسرو" },
            { "timezone.excity.Africa/Niamey", "نیامی" },
            { "timezone.excity.America/Aruba", "اروبا" },
            { "timezone.excity.America/Bahia", "بایا" },
            { "timezone.excity.America/Belem", "بلم" },
            { "timezone.excity.America/Boise", "بویسی" },
            { "timezone.excity.America/Jujuy", "خوخوی" },
            { "timezone.excity.America/Sitka", "سیتکا" },
            { "timezone.excity.America/Thule", "تول" },
            { "timezone.excity.Asia/Ashgabat", "عشق‌آباد" },
            { "timezone.excity.Asia/Calcutta", "کلکته" },
            { "timezone.excity.Asia/Damascus", "دمشق" },
            { "timezone.excity.Asia/Dushanbe", "دوشنبه" },
            { "timezone.excity.Asia/Jayapura", "جایاپورا" },
            { "timezone.excity.Asia/Katmandu", "کاتماندو" },
            { "timezone.excity.Asia/Khandyga", "خاندیگا" },
            { "timezone.excity.Asia/Makassar", "ماکاسار" },
            { "timezone.excity.Asia/Qostanay", "قوستانای" },
            { "timezone.excity.Asia/Sakhalin", "ساخالین" },
            { "timezone.excity.Asia/Shanghai", "شانگهای" },
            { "timezone.excity.Asia/Tashkent", "تاشکند" },
            { "timezone.excity.Asia/Ust-Nera", "اوست نرا" },
            { "timezone.excity.Europe/Athens", "آتن" },
            { "timezone.excity.Europe/Berlin", "برلین" },
            { "timezone.excity.Europe/Dublin", "دوبلین" },
            { "timezone.excity.Europe/Jersey", "جرزی" },
            { "timezone.excity.Europe/Lisbon", "لیسبون" },
            { "timezone.excity.Europe/London", "لندن" },
            { "timezone.excity.Europe/Madrid", "مادرید" },
            { "timezone.excity.Europe/Monaco", "موناکو" },
            { "timezone.excity.Europe/Moscow", "مسکو" },
            { "timezone.excity.Europe/Prague", "پراگ" },
            { "timezone.excity.Europe/Samara", "سامارا" },
            { "timezone.excity.Europe/Skopje", "اسکوپیه" },
            { "timezone.excity.Europe/Tirane", "تیرانا" },
            { "timezone.excity.Europe/Vienna", "وین" },
            { "timezone.excity.Europe/Warsaw", "ورشو" },
            { "timezone.excity.Europe/Zagreb", "زاگرب" },
            { "timezone.excity.Europe/Zurich", "زوریخ" },
            { "timezone.excity.Indian/Chagos", "شاگوس" },
            { "timezone.excity.Indian/Comoro", "کومورو" },
            { "timezone.excity.Pacific/Efate", "افاته" },
            { "timezone.excity.Pacific/Nauru", "نائورو" },
            { "timezone.excity.Pacific/Palau", "پالائو" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "آبیجان" },
            { "timezone.excity.Africa/Algiers", "الجزیره" },
            { "timezone.excity.Africa/Conakry", "کوناکری" },
            { "timezone.excity.Africa/Kampala", "کامپالا" },
            { "timezone.excity.Africa/Mbabane", "مبابانه" },
            { "timezone.excity.Africa/Nairobi", "نایروبی" },
            { "timezone.excity.Africa/Tripoli", "طرابلس" },
            { "timezone.excity.America/Belize", "بلیز" },
            { "timezone.excity.America/Bogota", "بوگوتا" },
            { "timezone.excity.America/Cancun", "کانکون" },
            { "timezone.excity.America/Cayman", "کیمن" },
            { "timezone.excity.America/Cuiaba", "کویاوا" },
            { "timezone.excity.America/Dawson", "داوسن" },
            { "timezone.excity.America/Denver", "دنور" },
            { "timezone.excity.America/Guyana", "گویان" },
            { "timezone.excity.America/Havana", "هاوانا" },
            { "timezone.excity.America/Inuvik", "اینوویک" },
            { "timezone.excity.America/Juneau", "جونو" },
            { "timezone.excity.America/La_Paz", "لاپاز" },
            { "timezone.excity.America/Maceio", "ماسیو" },
            { "timezone.excity.America/Manaus", "ماناوس" },
            { "timezone.excity.America/Merida", "مریدا" },
            { "timezone.excity.America/Nassau", "ناسائو" },
            { "timezone.excity.America/Panama", "پاناما" },
            { "timezone.excity.America/Recife", "ریسیفی" },
            { "timezone.excity.America/Regina", "رجاینا" },
            { "timezone.excity.Asia/Famagusta", "فاماگوستا" },
            { "timezone.excity.Asia/Hong_Kong", "هنگ‌کنگ" },
            { "timezone.excity.Asia/Jerusalem", "اورشلیم" },
            { "timezone.excity.Asia/Kamchatka", "کامچاتکا" },
            { "timezone.excity.Asia/Pontianak", "پونتیاناک" },
            { "timezone.excity.Asia/Pyongyang", "پیونگ‌یانگ" },
            { "timezone.excity.Asia/Qyzylorda", "قیزیل‌اوردا" },
            { "timezone.excity.Asia/Samarkand", "سمرقند" },
            { "timezone.excity.Asia/Singapore", "سنگاپور" },
            { "timezone.excity.Asia/Vientiane", "وینتیان" },
            { "timezone.excity.Europe/Andorra", "آندورا" },
            { "timezone.excity.Europe/Saratov", "ساراتوف" },
            { "timezone.excity.Europe/Tallinn", "تالین" },
            { "timezone.excity.Europe/Vatican", "واتیکان" },
            { "timezone.excity.Europe/Vilnius", "ویلنیوس" },
            { "timezone.excity.Indian/Mayotte", "مایوت" },
            { "timezone.excity.Indian/Reunion", "رئونیون" },
            { "timezone.excity.Pacific/Easter", "ایستر" },
            { "timezone.excity.Pacific/Kosrae", "کوسرای" },
            { "timezone.excity.Pacific/Majuro", "ماجورو" },
            { "timezone.excity.Pacific/Midway", "میدوی" },
            { "timezone.excity.Pacific/Noumea", "نومئا" },
            { "timezone.excity.Pacific/Ponape", "پانپی" },
            { "timezone.excity.Pacific/Saipan", "سایپان" },
            { "timezone.excity.Pacific/Tahiti", "تاهیتی" },
            { "timezone.excity.Pacific/Tarawa", "تاراوا" },
            { "timezone.excity.Pacific/Wallis", "والیس" },
            { "timezone.excity.Africa/Blantyre", "بلانتیره" },
            { "timezone.excity.Africa/Djibouti", "جیبوتی" },
            { "timezone.excity.Africa/El_Aaiun", "العیون" },
            { "timezone.excity.Africa/Freetown", "فری‌تاون" },
            { "timezone.excity.Africa/Gaborone", "گابورون" },
            { "timezone.excity.Africa/Khartoum", "خارطوم" },
            { "timezone.excity.Africa/Kinshasa", "کینشاسا" },
            { "timezone.excity.Africa/Monrovia", "مونروویا" },
            { "timezone.excity.Africa/Ndjamena", "انجامنا" },
            { "timezone.excity.Africa/Sao_Tome", "سائوتومه" },
            { "timezone.excity.Africa/Windhoek", "ویندهوک" },
            { "timezone.excity.America/Antigua", "آنتیگوا" },
            { "timezone.excity.America/Caracas", "کاراکاس" },
            { "timezone.excity.America/Cayenne", "کاین" },
            { "timezone.excity.America/Chicago", "شیکاگو" },
            { "timezone.excity.America/Cordoba", "کوردووا" },
            { "timezone.excity.America/Creston", "کرستون" },
            { "timezone.excity.America/Curacao", "کوراسائو" },
            { "timezone.excity.America/Detroit", "دیترویت" },
            { "timezone.excity.America/Godthab", "نووک" },
            { "timezone.excity.America/Grenada", "گرنادا" },
            { "timezone.excity.America/Halifax", "هلیفکس" },
            { "timezone.excity.America/Iqaluit", "ایکلوئت" },
            { "timezone.excity.America/Jamaica", "جامائیکا" },
            { "timezone.excity.America/Managua", "ماناگوا" },
            { "timezone.excity.America/Marigot", "ماریگات" },
            { "timezone.excity.America/Mendoza", "مندوسا" },
            { "timezone.excity.America/Moncton", "مانکتون" },
            { "timezone.excity.America/Noronha", "نورونیا" },
            { "timezone.excity.America/Ojinaga", "اوجیناگا" },
            { "timezone.excity.America/Phoenix", "فینکس" },
            { "timezone.excity.America/Tijuana", "تیخوانا" },
            { "timezone.excity.America/Toronto", "تورنتو" },
            { "timezone.excity.America/Tortola", "تورتولا" },
            { "timezone.excity.America/Yakutat", "یاکوتات" },
            { "timezone.excity.Asia/Phnom_Penh", "پنوم‌پن" },
            { "timezone.excity.Atlantic/Azores", "آزور" },
            { "timezone.excity.Atlantic/Canary", "قناری" },
            { "timezone.excity.Atlantic/Faeroe", "فارو" },
            { "timezone.excity.Australia/Eucla", "اوکلا" },
            { "timezone.excity.Australia/Perth", "پرت" },
            { "timezone.excity.Europe/Belgrade", "بلگراد" },
            { "timezone.excity.Europe/Brussels", "بروکسل" },
            { "timezone.excity.Europe/Budapest", "بوداپست" },
            { "timezone.excity.Europe/Busingen", "بازنگن" },
            { "timezone.excity.Europe/Chisinau", "کیشیناو" },
            { "timezone.excity.Europe/Guernsey", "گرنزی" },
            { "timezone.excity.Europe/Helsinki", "هلسینکی" },
            { "timezone.excity.Europe/Istanbul", "استانبول" },
            { "timezone.excity.Europe/Sarajevo", "سارایوو" },
            { "timezone.excity.Indian/Maldives", "مالدیو" },
            { "timezone.excity.Pacific/Chatham", "چت‌هام" },
            { "timezone.excity.Pacific/Fakaofo", "فاکائوفو" },
            { "timezone.excity.Pacific/Gambier", "گامبیر" },
            { "timezone.excity.Pacific/Norfolk", "نورفولک" },
            { "timezone.excity.Africa/Bujumbura", "بوجومبورا" },
            { "timezone.excity.Africa/Mogadishu", "موگادیشو" },
            { "timezone.excity.America/Anguilla", "آنگوئیلا" },
            { "timezone.excity.America/Asuncion", "آسونسیون" },
            { "timezone.excity.America/Barbados", "باربادوس" },
            { "timezone.excity.America/Dominica", "دومینیکا" },
            { "timezone.excity.America/Edmonton", "ادمونتون" },
            { "timezone.excity.America/Eirunepe", "ایرونپه" },
            { "timezone.excity.America/Mazatlan", "ماساتلان" },
            { "timezone.excity.America/Miquelon", "میکلون" },
            { "timezone.excity.America/New_York", "نیویورک" },
            { "timezone.excity.America/Resolute", "رزولوت" },
            { "timezone.excity.America/Santarem", "سنتارم" },
            { "timezone.excity.America/Santiago", "سانتیاگو" },
            { "timezone.excity.America/St_Johns", "سنت جان" },
            { "timezone.excity.America/St_Kitts", "سنت کیتس" },
            { "timezone.excity.America/St_Lucia", "سنت لوسیا" },
            { "timezone.excity.America/Winnipeg", "وینیپگ" },
            { "timezone.excity.Antarctica/Casey", "کیسی" },
            { "timezone.excity.Antarctica/Davis", "دیویس" },
            { "timezone.excity.Antarctica/Syowa", "شووا" },
            { "timezone.excity.Antarctica/Troll", "ترول" },
            { "timezone.excity.Asia/Krasnoyarsk", "کراسنویارسک" },
            { "timezone.excity.Asia/Novosibirsk", "نووسیبیریسک" },
            { "timezone.excity.Asia/Ulaanbaatar", "اولان‌باتور" },
            { "timezone.excity.Asia/Vladivostok", "ولادی‌وستوک" },
            { "timezone.excity.Atlantic/Bermuda", "برمودا" },
            { "timezone.excity.Atlantic/Madeira", "مادیرا" },
            { "timezone.excity.Atlantic/Stanley", "استانلی" },
            { "timezone.excity.Australia/Darwin", "داروین" },
            { "timezone.excity.Australia/Hobart", "هوبارت" },
            { "timezone.excity.Australia/Sydney", "سیدنی" },
            { "timezone.excity.Europe/Amsterdam", "آمستردام" },
            { "timezone.excity.Europe/Astrakhan", "آستراخان" },
            { "timezone.excity.Europe/Bucharest", "بخارست" },
            { "timezone.excity.Europe/Gibraltar", "جبل‌الطارق" },
            { "timezone.excity.Europe/Ljubljana", "لیوبلیانا" },
            { "timezone.excity.Europe/Mariehamn", "ماریه‌هامن" },
            { "timezone.excity.Europe/Podgorica", "پادگاریتسا" },
            { "timezone.excity.Europe/Stockholm", "استکهلم" },
            { "timezone.excity.Europe/Ulyanovsk", "اولیانوفسک" },
            { "timezone.excity.Europe/Volgograd", "ولگاگراد" },
            { "timezone.excity.Indian/Christmas", "کریسمس" },
            { "timezone.excity.Indian/Kerguelen", "کرگولن" },
            { "timezone.excity.Indian/Mauritius", "موریس" },
            { "timezone.excity.Pacific/Auckland", "اوکلند" },
            { "timezone.excity.Pacific/Funafuti", "فونافوتی" },
            { "timezone.excity.Pacific/Honolulu", "هونولولو" },
            { "timezone.excity.Pacific/Pitcairn", "پیت‌کرن" },
            { "timezone.excity.Africa/Casablanca", "کازابلانکا" },
            { "timezone.excity.Africa/Libreville", "لیبرویل" },
            { "timezone.excity.Africa/Lubumbashi", "لوبومباشی" },
            { "timezone.excity.Africa/Nouakchott", "نوآکشوت" },
            { "timezone.excity.Africa/Porto-Novo", "پورتو نووو" },
            { "timezone.excity.America/Anchorage", "انکوریج" },
            { "timezone.excity.America/Araguaina", "آراگواینا" },
            { "timezone.excity.America/Boa_Vista", "بوئاویستا" },
            { "timezone.excity.America/Catamarca", "کاتامارکا" },
            { "timezone.excity.America/Chihuahua", "چیواوا" },
            { "timezone.excity.America/Coyhaique", "کویهایکیو" },
            { "timezone.excity.America/Fortaleza", "فورتالزا" },
            { "timezone.excity.America/Glace_Bay", "گلیس‌بی" },
            { "timezone.excity.America/Goose_Bay", "گوس‌بی" },
            { "timezone.excity.America/Guatemala", "گواتمالا" },
            { "timezone.excity.America/Guayaquil", "گوایاکیل" },
            { "timezone.excity.America/Matamoros", "ماتاموروس" },
            { "timezone.excity.America/Menominee", "منامینی" },
            { "timezone.excity.America/Monterrey", "مونتری" },
            { "timezone.excity.America/Sao_Paulo", "سائوپائولو" },
            { "timezone.excity.America/St_Thomas", "سنت توماس" },
            { "timezone.excity.America/Vancouver", "ونکوور" },
            { "timezone.excity.Antarctica/Mawson", "ماوسون" },
            { "timezone.excity.Antarctica/Palmer", "پالمر" },
            { "timezone.excity.Antarctica/Vostok", "وستوک" },
            { "timezone.excity.Asia/Kuala_Lumpur", "کوالالامپور" },
            { "timezone.excity.Asia/Novokuznetsk", "نوووکوزنتسک" },
            { "timezone.excity.Europe/Bratislava", "براتیسلاوا" },
            { "timezone.excity.Europe/Copenhagen", "کپنهاگ" },
            { "timezone.excity.Europe/Luxembourg", "لوکزامبورگ" },
            { "timezone.excity.Europe/San_Marino", "سان‌مارینو" },
            { "timezone.excity.Europe/Simferopol", "سیمفروپل" },
            { "timezone.excity.Pacific/Enderbury", "کانتون" },
            { "timezone.excity.Pacific/Galapagos", "گالاپاگوس" },
            { "timezone.excity.Pacific/Kwajalein", "کواجیلین" },
            { "timezone.excity.Pacific/Marquesas", "مارکوزه" },
            { "timezone.excity.Pacific/Pago_Pago", "پاگوپاگو" },
            { "timezone.excity.Pacific/Rarotonga", "راروتونگا" },
            { "timezone.excity.Pacific/Tongatapu", "تونگاتاپو" },
            { "timezone.excity.Africa/Addis_Ababa", "آدیس آبابا" },
            { "timezone.excity.Africa/Brazzaville", "برازویل" },
            { "timezone.excity.Africa/Ouagadougou", "اوآگادوگو" },
            { "timezone.excity.America/Costa_Rica", "کاستاریکا" },
            { "timezone.excity.America/Grand_Turk", "گراند تورک" },
            { "timezone.excity.America/Guadeloupe", "گوادلوپ" },
            { "timezone.excity.America/Hermosillo", "ارموسیو" },
            { "timezone.excity.America/Kralendijk", "کرالندیک" },
            { "timezone.excity.America/Louisville", "لوئیزویل" },
            { "timezone.excity.America/Martinique", "مارتینیک" },
            { "timezone.excity.America/Metlakatla", "متالاکاتلا" },
            { "timezone.excity.America/Montevideo", "مونته‌ویدئو" },
            { "timezone.excity.America/Montserrat", "مونتسرات" },
            { "timezone.excity.America/Paramaribo", "پاراماریبو" },
            { "timezone.excity.America/Rio_Branco", "ریوبرانکو" },
            { "timezone.excity.America/St_Vincent", "سنت وینسنت" },
            { "timezone.excity.America/Whitehorse", "وایت‌هورس" },
            { "timezone.excity.Antarctica/McMurdo", "مک‌موردو" },
            { "timezone.excity.Antarctica/Rothera", "روترا" },
            { "timezone.excity.Asia/Srednekolymsk", "اسردنکولیمسک" },
            { "timezone.excity.Asia/Yekaterinburg", "یکاترینبرگ" },
            { "timezone.excity.Atlantic/Reykjavik", "ریکیاویک" },
            { "timezone.excity.Atlantic/St_Helena", "سنت هلنا" },
            { "timezone.excity.Australia/Adelaide", "آدلاید" },
            { "timezone.excity.Australia/Brisbane", "بریسبین" },
            { "timezone.excity.Australia/Lindeman", "لیندمن" },
            { "timezone.excity.Europe/Isle_of_Man", "جزیرهٔ من" },
            { "timezone.excity.Europe/Kaliningrad", "کالینینگراد" },
            { "timezone.excity.Pacific/Kiritimati", "کریتیماتی" },
            { "timezone.excity.Africa/Johannesburg", "ژوهانسبورگ" },
            { "timezone.excity.America/El_Salvador", "السالوادور" },
            { "timezone.excity.America/Fort_Nelson", "فورت نلسون" },
            { "timezone.excity.America/Los_Angeles", "لوس‌آنجلس" },
            { "timezone.excity.America/Mexico_City", "مکزیکوسیتی" },
            { "timezone.excity.America/Porto_Velho", "پورتوولیو" },
            { "timezone.excity.America/Puerto_Rico", "پورتوریکو" },
            { "timezone.excity.America/Tegucigalpa", "تگوسیگالپا" },
            { "timezone.excity.Arctic/Longyearbyen", "لانگ‌یربین" },
            { "timezone.excity.Atlantic/Cape_Verde", "کیپ‌ورد" },
            { "timezone.excity.Australia/Lord_Howe", "لردهاو" },
            { "timezone.excity.Australia/Melbourne", "ملبورن" },
            { "timezone.excity.Indian/Antananarivo", "آنتاناناریوو" },
            { "timezone.excity.Pacific/Guadalcanal", "گوادال‌کانال" },
            { "timezone.excity.Africa/Dar_es_Salaam", "دارالسلام" },
            { "timezone.excity.America/Blanc-Sablon", "بلان‐سابلون" },
            { "timezone.excity.America/Buenos_Aires", "بوئنوس‌آیرس" },
            { "timezone.excity.America/Campo_Grande", "کمپو گرانده" },
            { "timezone.excity.America/Danmarkshavn", "دانمارکس‌هاون" },
            { "timezone.excity.America/Dawson_Creek", "داوسن کریک" },
            { "timezone.excity.America/Indiana/Knox", "ناکس، ایندیانا" },
            { "timezone.excity.America/Indianapolis", "ایندیاناپولیس" },
            { "timezone.excity.America/Punta_Arenas", "پونتا آرناس" },
            { "timezone.excity.America/Rankin_Inlet", "خلیجک رنکین" },
            { "timezone.excity.America/Scoresbysund", "اسکورسبیسوند" },
            { "timezone.excity.Antarctica/Macquarie", "مکواری" },
            { "timezone.excity.Pacific/Bougainville", "بوگنویل" },
            { "timezone.excity.Pacific/Port_Moresby", "پورت‌مورزبی" },
            { "timezone.excity.America/Cambridge_Bay", "کمبریج‌بی" },
            { "timezone.excity.America/Ciudad_Juarez", "سیوداد خوارز" },
            { "timezone.excity.America/Coral_Harbour", "اتکوکان" },
            { "timezone.excity.America/Indiana/Vevay", "ویوی، ایندیانا" },
            { "timezone.excity.America/Lower_Princes", "بخش شاهزاده‌‌نشین پایین" },
            { "timezone.excity.America/Port_of_Spain", "پورت‌آواسپین" },
            { "timezone.excity.America/Santo_Domingo", "سانتو دومینگو" },
            { "timezone.excity.America/St_Barthelemy", "سنت بارتلمی" },
            { "timezone.excity.America/Swift_Current", "سویفت‌کارنت" },
            { "timezone.excity.Australia/Broken_Hill", "بروکن‌هیل" },
            { "timezone.excity.America/Bahia_Banderas", "باهیا باندراس" },
            { "timezone.excity.America/Port-au-Prince", "پورتوپرنس" },
            { "timezone.excity.Atlantic/South_Georgia", "جورجیای جنوبی" },
            { "timezone.excity.America/Argentina/Salta", "سالتا" },
            { "timezone.excity.America/Indiana/Marengo", "مارنگو، ایندیانا" },
            { "timezone.excity.America/Indiana/Winamac", "ویناماک، ایندیانا" },
            { "timezone.excity.America/Argentina/Tucuman", "توکومن" },
            { "timezone.excity.America/Argentina/Ushuaia", "اوشوایا" },
            { "timezone.excity.America/Indiana/Tell_City", "تل‌سیتی، ایندیانا" },
            { "timezone.excity.America/Indiana/Vincennes", "وینسنس، اندیانا" },
            { "timezone.excity.Antarctica/DumontDUrville", "دومون دورویل" },
            { "timezone.excity.America/Argentina/La_Rioja", "لاریوخا" },
            { "timezone.excity.America/Argentina/San_Juan", "سن‌خوان" },
            { "timezone.excity.America/Argentina/San_Luis", "سن‌لوئیس" },
            { "timezone.excity.America/Indiana/Petersburg", "پیترزبرگ، ایندیانا" },
            { "timezone.excity.America/Kentucky/Monticello", "مانتیسلو، کنتاکی" },
            { "timezone.excity.America/North_Dakota/Beulah", "بیولا، داکوتای شمالی" },
            { "timezone.excity.America/North_Dakota/Center", "سنتر، داکوتای شمالی" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ریوگالگوس" },
            { "timezone.excity.America/North_Dakota/New_Salem", "نیوسالم، داکوتای شمالی" },
        };
        return data;
    }
}
