// © 2025 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
package com.ibm.icu.dev.test.perf;

import java.util.concurrent.TimeUnit;

import com.ibm.icu.text.Transliterator;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;

@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
public class UppercaseTransliteratorPerfTest {

    static final Transliterator UPPER = Transliterator.getInstance("Upper");

    @Benchmark
    public String testShort() {
        return UPPER.transliterate("Cat");
    }

    @Benchmark
    public String testSentence() {
        return UPPER.transliterate("The Quick Brown Fox Jumped Over The Lazy Dog");
    }

}
