/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.ProblemReport;

@NonNullApi
class DelegatingProblemBuilder
implements InternalProblemBuilder {
    private final InternalProblemBuilder delegate;

    DelegatingProblemBuilder(InternalProblemBuilder delegate) {
        this.delegate = delegate;
    }

    public ProblemReport build() {
        return this.delegate.build();
    }

    public InternalProblemBuilder label(String label) {
        return this.validateDelegate(this.delegate).label(label);
    }

    public InternalProblemBuilder documentedAt(DocLink doc) {
        return this.validateDelegate(this.delegate.documentedAt(doc));
    }

    public InternalProblemBuilder documentedAt(String url) {
        return this.validateDelegate(this.delegate.documentedAt(url));
    }

    public InternalProblemBuilder fileLocation(String path) {
        return this.validateDelegate(this.delegate.fileLocation(path));
    }

    public InternalProblemBuilder lineInFileLocation(String path, int line) {
        return this.validateDelegate(this.delegate.lineInFileLocation(path, line));
    }

    public InternalProblemBuilder lineInFileLocation(String path, int line, int column) {
        return this.validateDelegate(this.delegate.offsetInFileLocation(path, line, column));
    }

    public InternalProblemBuilder lineInFileLocation(String path, int line, int column, int length) {
        return this.validateDelegate(this.delegate.lineInFileLocation(path, line, column, length));
    }

    public InternalProblemBuilder offsetInFileLocation(String path, int offset, int length) {
        return this.validateDelegate(this.delegate.offsetInFileLocation(path, offset, length));
    }

    public InternalProblemBuilder pluginLocation(String pluginId) {
        return this.validateDelegate(this.delegate.pluginLocation(pluginId));
    }

    public InternalProblemBuilder stackLocation() {
        return this.validateDelegate(this.delegate.stackLocation());
    }

    public InternalProblemBuilder category(String category, String ... details) {
        return this.validateDelegate(this.delegate.category(category, details));
    }

    public InternalProblemBuilder details(String details) {
        return this.validateDelegate(this.delegate.details(details));
    }

    public InternalProblemBuilder solution(@Nullable String solution) {
        return this.validateDelegate(this.delegate.solution(solution));
    }

    public InternalProblemBuilder taskPathLocation(String buildTreePath) {
        return this.validateDelegate(this.delegate.solution(buildTreePath));
    }

    public InternalProblemBuilder additionalData(String key, Object value) {
        return this.validateDelegate(this.delegate.additionalData(key, value));
    }

    public InternalProblemBuilder withException(RuntimeException e) {
        return this.validateDelegate(this.delegate.withException(e));
    }

    public InternalProblemBuilder severity(Severity severity) {
        return this.validateDelegate(this.delegate.severity(severity));
    }

    private <T> T validateDelegate(T newDelegate) {
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return newDelegate;
    }
}

