/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMSender
implements SaxonLocator,
SourceLocationProvider {
    private Receiver receiver;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private HashMap<String, String> nsDeclarations = new HashMap(10);
    protected Node root = null;
    protected String systemId;

    public DOMSender(Node startNode, Receiver receiver) {
        if (startNode == null) {
            throw new NullPointerException("startNode");
        }
        if (receiver == null) {
            throw new NullPointerException("receiver");
        }
        if (receiver.getPipelineConfiguration() == null) {
            throw new IllegalArgumentException("No PipelineConfiguration in supplied Receiver");
        }
        this.root = startNode;
        this.receiver = receiver;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void send() throws XPathException {
        this.receiver.setSystemId(this.systemId);
        this.receiver.getPipelineConfiguration().setLocationProvider(this);
        this.receiver.open();
        switch (this.root.getNodeType()) {
            case 9: 
            case 11: {
                this.receiver.startDocument(0);
                this.walkNode(this.root);
                this.receiver.endDocument();
                break;
            }
            case 1: {
                this.sendElement((Element)this.root);
                break;
            }
            case 3: 
            case 4: {
                this.receiver.characters(((CharacterData)this.root).getData(), 0, 0);
                break;
            }
            case 8: {
                this.receiver.comment(((Comment)this.root).getData(), 0, 0);
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstruction)this.root).getTarget(), ((ProcessingInstruction)this.root).getData(), 0, 0);
                break;
            }
            default: {
                throw new IllegalStateException("DOMSender: unsupported kind of start node (" + this.root.getNodeType() + ")");
            }
        }
        this.receiver.close();
    }

    private void sendElement(Element startNode) throws XPathException {
        Element node = startNode;
        boolean hasNamespaceDeclarations = this.gatherNamespaces(node, false);
        while (true) {
            this.gatherNamespaces(node, true);
            Node parent = node.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            node = (Element)parent;
        }
        this.outputElement(startNode, hasNamespaceDeclarations);
    }

    private void walkNode(Node node) throws XPathException {
        if (node.hasChildNodes()) {
            NodeList nit = node.getChildNodes();
            int len = nit.getLength();
            block9: for (int i = 0; i < len; ++i) {
                Node child = nit.item(i);
                switch (child.getNodeType()) {
                    case 9: 
                    case 11: {
                        continue block9;
                    }
                    case 1: {
                        Element element = (Element)child;
                        boolean hasNamespaces = this.gatherNamespaces(element, false);
                        this.outputElement(element, hasNamespaces);
                        this.nsSupport.popContext();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 7: {
                        this.receiver.processingInstruction(((ProcessingInstruction)child).getTarget(), ((ProcessingInstruction)child).getData(), 0, 0);
                        continue block9;
                    }
                    case 8: {
                        String text = ((Comment)child).getData();
                        if (text == null) continue block9;
                        this.receiver.comment(text, 0, 0);
                        continue block9;
                    }
                    case 3: 
                    case 4: {
                        String text = ((CharacterData)child).getData();
                        if (text == null) continue block9;
                        this.receiver.characters(text, 0, 0);
                        continue block9;
                    }
                    case 5: {
                        this.walkNode(child);
                        continue block9;
                    }
                }
            }
        }
    }

    private void outputElement(Element element, boolean hasNamespaceDeclarations) throws XPathException {
        Configuration config = this.receiver.getPipelineConfiguration().getConfiguration();
        String[] elparts2 = this.nsSupport.processName(element.getTagName(), this.elparts, false);
        if (elparts2 == null) {
            throw new XPathException("Undeclared namespace in " + element.getTagName());
        }
        String uri = elparts2[0];
        String local = elparts2[1];
        String prefix = NameChecker.getPrefix(elparts2[2]);
        NamePool namePool = config.getNamePool();
        int nameCode = namePool.allocate(prefix, uri, local);
        this.receiver.startElement(nameCode, 630, 0, 0);
        for (Map.Entry<String, String> decl : this.nsDeclarations.entrySet()) {
            this.receiver.namespace(namePool.allocateNamespaceCode(decl.getKey(), decl.getValue()), 0);
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            int len = atts.getLength();
            for (int a2 = 0; a2 < len; ++a2) {
                Attr att = (Attr)atts.item(a2);
                String attname = att.getName();
                if (hasNamespaceDeclarations && (attname.equals("xmlns") || attname.startsWith("xmlns:"))) continue;
                String[] parts2 = this.nsSupport.processName(attname, this.parts, true);
                if (parts2 == null) {
                    throw new XPathException("Undeclared namespace in " + attname);
                }
                String atturi = parts2[0];
                String attlocal = parts2[1];
                String attprefix = NameChecker.getPrefix(parts2[2]);
                int attCode = namePool.allocate(attprefix, atturi, attlocal);
                this.receiver.attribute(attCode, 631, att.getValue(), 0, 0);
            }
        }
        this.receiver.startContent();
        this.walkNode(element);
        this.receiver.endElement();
    }

    private boolean gatherNamespaces(Element element, boolean cumulative) {
        boolean hasNamespaceDeclarations = false;
        if (!cumulative) {
            this.nsSupport.pushContext();
            this.nsDeclarations.clear();
        }
        try {
            String prefix = element.getPrefix();
            String uri = element.getNamespaceURI();
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            if (this.nsDeclarations.get(prefix) == null) {
                this.nsSupport.declarePrefix(prefix, uri);
                this.nsDeclarations.put(prefix, uri);
            }
        }
        catch (Throwable err) {
            // empty catch block
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts == null) {
            return false;
        }
        int alen = atts.getLength();
        for (int a1 = 0; a1 < alen; ++a1) {
            String uri;
            String prefix;
            Attr att = (Attr)atts.item(a1);
            String attname = att.getName();
            boolean possibleNamespace = attname.startsWith("xmlns");
            if (possibleNamespace && attname.equals("xmlns")) {
                hasNamespaceDeclarations = true;
                String uri2 = att.getValue();
                if (this.nsDeclarations.get("") != null && (cumulative || this.nsDeclarations.get("").equals(uri2))) continue;
                this.nsSupport.declarePrefix("", uri2);
                this.nsDeclarations.put("", uri2);
                continue;
            }
            if (possibleNamespace && attname.startsWith("xmlns:")) {
                hasNamespaceDeclarations = true;
                prefix = attname.substring(6);
                if (this.nsDeclarations.get(prefix) != null) continue;
                uri = att.getValue();
                this.nsSupport.declarePrefix(prefix, uri);
                this.nsDeclarations.put(prefix, uri);
                continue;
            }
            if (attname.indexOf(58) < 0) continue;
            try {
                prefix = att.getPrefix();
                uri = att.getNamespaceURI();
                if (this.nsDeclarations.get(prefix) != null) continue;
                this.nsSupport.declarePrefix(prefix, uri);
                this.nsDeclarations.put(prefix, uri);
                continue;
            }
            catch (Throwable err) {
                // empty catch block
            }
        }
        return hasNamespaceDeclarations;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }
}

