# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

JAVA_PKG_IUSE="doc source test"
MAVEN_ID="com.github.jnr:jnr-posix:3.1.20"
JAVA_TESTING_FRAMEWORKS="junit-4"

inherit java-pkg-2 java-pkg-simple

DESCRIPTION="Common cross-project/cross-platform POSIX APIs"
HOMEPAGE="https://github.com/jnr/jnr-posix"
SRC_URI="https://github.com/jnr/${PN}/archive/${P}.tar.gz"
S="${WORKDIR}/${PN}-${P}"

LICENSE="EPL-2.0 GPL-2 LGPL-2.1"
SLOT="0"
KEYWORDS="amd64 arm64 ppc64"

CP_DEPEND="
	>=dev-java/jnr-ffi-2.2.17:0
	dev-java/jnr-constants:0
"

DEPEND="
	${CP_DEPEND}
	>=virtual/jdk-11:*
"

RDEPEND="
	${CP_DEPEND}
	>=virtual/jre-1.8:*
"

JAVA_AUTOMATIC_MODULE_NAME="org.jnrproject.posix"
JAVA_SRC_DIR="src/main/java"

JAVA_TEST_GENTOO_CLASSPATH="junit-4"
JAVA_TEST_SRC_DIR="src/test/java"

src_test() {
	sed \
		-e '/import org.junit.Test/a import org.junit.Ignore;' \
		-i src/test/java/jnr/posix/FileTest.java || die

	if use ppc64; then
		# Ignore testMessageHdrMultipleControl
		# https://bugs.gentoo.org/866199
		# https://github.com/jnr/jnr-posix/issues/178
		sed \
			-e '/testMessageHdrMultipleControl/i @Ignore' \
			-e '/import org.junit.Test/a import org.junit.Ignore;' \
			-i src/test/java/jnr/posix/LinuxPOSIXTest.java || die
	fi

	JAVA_TEST_EXCLUDES=(
		# https://github.com/jnr/jnr-posix/blob/jnr-posix-3.1.16/pom.xml#L185
		# <exclude>**/windows/*Test.java</exclude>
		"jnr.posix.windows.WindowsFileTest"
		"jnr.posix.windows.WindowsHelpersTest"
	)
	local vm_version="$(java-config -g PROVIDES_VERSION)"
	if [[ "${vm_version}" -ge "17" ]] ; then
		JAVA_TEST_EXTRA_ARGS+=( --add-opens=java.base/java.io=ALL-UNNAMED )
		JAVA_TEST_EXTRA_ARGS+=( --add-opens=java.base/java.util=ALL-UNNAMED )
		# Some tests in jnr.posix.FileTest fail with jdk-17
		sed \
			-e '/flockTest()/i @Ignore' \
			-e '/dupTest()/i @Ignore' \
			-e '/closeTest()/i @Ignore' \
			-e '/fcntlDupfdWithArgTest()/i @Ignore' \
			-i src/test/java/jnr/posix/FileTest.java || die
	fi
	java-pkg-simple_src_test
}
