#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "gtksheet.h"
#include "gtksheetentry.h"

#define DEFAULT_PRESICION 3
#define DEFAULT_SPACE 8

GtkWidget *window;
GtkWidget *main_vbox;
GtkWidget *notebook;
GtkWidget **sheets;
GtkWidget *status_box;
GtkWidget *location;
GtkWidget *entry;

void
quit ()
{
  gtk_main_quit();
}

static void
popup_activated(GtkWidget *widget, gpointer data)
{
 GtkSheet *sheet;

 if(!GTK_IS_SHEET(widget->parent->parent)) printf("HOPLA\n"); 
 sheet=GTK_SHEET(widget->parent->parent);

 if((char *)data == "Add Column")
   gtk_sheet_add_column(sheet,1);

 if((char *)data == "Add Row")
   gtk_sheet_add_row(sheet,1);

 if((char *)data == "Insert Row"){
   if(sheet->state==GTK_SHEET_ROW_SELECTED)
     gtk_sheet_insert_rows(sheet,sheet->range.row0,                       
                               sheet->range.rowi-sheet->range.row0+1);
 }

 if((char *)data == "Insert Column"){
   if(sheet->state==GTK_SHEET_COLUMN_SELECTED)
     gtk_sheet_insert_columns(sheet,sheet->range.col0,                       
                              sheet->range.coli-sheet->range.col0+1);

 } 

 if((char *)data == "Delete Row"){
   if(sheet->state==GTK_SHEET_ROW_SELECTED)
     gtk_sheet_delete_rows(sheet,sheet->range.row0,
                              sheet->range.rowi-sheet->range.row0+1);
 }

 if((char *)data == "Delete Column"){
   if(sheet->state==GTK_SHEET_COLUMN_SELECTED)
     gtk_sheet_delete_columns(sheet,sheet->range.col0,
                              sheet->range.coli-sheet->range.col0+1);   
 } 

 if((char *)data == "Clear Cells"){
   if(sheet->state!=GTK_SHEET_NORMAL)
     gtk_sheet_range_clear(sheet, &sheet->range);
 } 

}

static GtkWidget *
build_menu(GtkWidget *sheet)
{
	static char *items[]={
		"Add Column",
		"Add Row",
		"Insert Row",
		"Insert Column",
		"Delete Row",
                "Delete Column",
                "Clear Cells"
	};
	GtkWidget *menu;
	GtkWidget *item;
	int i;

	menu=gtk_menu_new();
	menu->parent=sheet;

	for (i=0; i < (sizeof(items)/sizeof(items[0])) ; i++){
	 	item=gtk_menu_item_new_with_label(items[i]);
	 	gtk_signal_connect(GTK_OBJECT(item),"activate",
				   (GtkSignalFunc) popup_activated,
				   items[i]);
                GTK_WIDGET_SET_FLAGS (item, GTK_SENSITIVE | GTK_CAN_FOCUS);
                switch(i){
                  case 2:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_ROW_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                  case 3:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_COLUMN_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                  case 4:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_ROW_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                  case 5:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_COLUMN_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                } 

		gtk_widget_show(item);
	    	gtk_menu_append(GTK_MENU(menu),item);
	}

	return menu;
}

void
do_popup(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
   static GtkWidget *popup;
   GdkModifierType mods;
   GtkWidget *sheet;

   sheet=GTK_WIDGET(widget);

   gdk_window_get_pointer (sheet->window, NULL, NULL, &mods);
   if(mods&GDK_BUTTON3_MASK){ 

    if(popup)
       g_free(popup);

    popup=build_menu(sheet);

    gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL,
		   event->button, event->time);
   }
}

void
format_text (GtkSheet *sheet, int *justification, gchar *text, char *label)
{
  double auxval;
  int digspace=0;
  int cell_width, char_width;
  double val;
  int format;
  double space;
  int intspace;
  int nonzero=FALSE;
  int ipos;
  char nchar;
  enum {EMPTY, TEXT, NUMERIC};

  cell_width=sheet->column[sheet->active_cell.col].width;
  char_width = gdk_char_width (GTK_WIDGET(sheet)->style->font,(gchar)'X');
  space= (double)cell_width/(double)char_width;

  intspace=MIN(space, DEFAULT_SPACE);

  format=EMPTY;
  if(strlen(text) != 0)
  { 
        for(ipos=0; ipos<strlen(text); ipos++){

          switch(nchar=text[ipos]){
           case '.':
           case ' ': case ',':
           case '-': case '+':
           case 'd': case 'D':
           case 'E': case 'e':
           case '1': case '2': case '3': case '4': case '5': case '6':
           case '7': case '8': case '9':
            nonzero=TRUE;
            break;
           case '0':
            break;
           default:
            format=TEXT;
          }
          if(format != EMPTY) break;
        }
        val=atof(text);
        if(format!=EMPTY || (val==0. && nonzero))
             format = TEXT;
        else
             format = NUMERIC;
  }

  switch(format){
    case TEXT:
    case EMPTY:
      strcpy(label, text);
      return;
    case NUMERIC:
      val=atof(text);
      *justification = GTK_JUSTIFY_RIGHT;
  }

  auxval= val < 0 ? -val : val;

  while(auxval<1 && auxval != 0.){
   auxval=auxval*10.;
   digspace+=1;
  }

  if(digspace+DEFAULT_PRESICION+1>intspace || digspace > DEFAULT_PRESICION){
    sprintf (label, "%*.*E", intspace, DEFAULT_PRESICION, val);
  }
  else
    {
    sprintf (label, "%*.*f", intspace, DEFAULT_PRESICION, val);
    if(strlen(label) > space)
      sprintf (label, "%*.*E", intspace, DEFAULT_PRESICION, val);
  }
}

void
parse_numbers(GtkWidget *widget, gpointer data)
{
 GtkSheet *sheet;
 char label[400];
 int justification;

 sheet=GTK_SHEET(widget);

 justification = GTK_SHENTRY(sheet->sheet_entry)->justification;
 format_text(sheet, &justification, GTK_SHENTRY(sheet->sheet_entry)->text,
             label);

 gtk_sheet_set_cell(sheet, sheet->active_cell.row,
			   sheet->active_cell.col,
                           justification, label); 

}

void
clipboard_handler(GtkWidget *widget, GdkEventKey *key)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(widget);

  if(key->state & GDK_CONTROL_MASK || key->keyval==GDK_Control_L ||
     key->keyval==GDK_Control_R){
    if((key->keyval=='c' || key->keyval == 'C') && sheet->state != GTK_STATE_NORMAL){
            if(GTK_SHEET_IN_CLIP(sheet)) gtk_sheet_unclip_range(sheet);
            gtk_sheet_clip_range(sheet, sheet->range);
    }
    if(key->keyval=='x' || key->keyval == 'X')
            gtk_sheet_unclip_range(sheet);    
  }
}

void 
resize_handler(GtkWidget *widget, GtkSheetRange *old_range, 
                                  GtkSheetRange *new_range, 
                                  gpointer data)
{
  printf("OLD SELECTION: %d %d %d %d\n",old_range->row0, old_range->col0,
                                    old_range->rowi, old_range->coli);
  printf("NEW SELECTION: %d %d %d %d\n",new_range->row0, new_range->col0,
                                    new_range->rowi, new_range->coli);


}

void 
move_handler(GtkWidget *widget, GtkSheetRange *old_range, 
                                  GtkSheetRange *new_range, 
                                  gpointer data)
{
  printf("OLD SELECTION: %d %d %d %d\n",old_range->row0, old_range->col0,
                                    old_range->rowi, old_range->coli);
  printf("NEW SELECTION: %d %d %d %d\n",new_range->row0, new_range->col0,
                                    new_range->rowi, new_range->coli);


}

void alarm(GtkWidget *widget, gint row, gint col, gpointer data)
{
 printf("ACTIVATE CELL: %d %d\n",row,col);
}

void
build_example1(GtkWidget *widget)
{
 GtkSheet *sheet;
 GtkSheetRange range;
 gchar name[10];
 gint i;

 sheet=GTK_SHEET(widget);
 gtk_sheet_set_cell(sheet, 0,0, GTK_JUSTIFY_LEFT,
                    "You can drag & drop the selection");
 gtk_sheet_set_cell(sheet, 1,0, GTK_JUSTIFY_LEFT,
                    "and resize it clicking the right-bottom corner");
 gtk_sheet_set_cell(sheet, 3,0, GTK_JUSTIFY_LEFT,
                    "Store the selection on the clipboard pressing Ctrl-C");
 gtk_sheet_set_cell(sheet, 4,0, GTK_JUSTIFY_LEFT,
                    "(The selection handler has not been implemented yet)");



 for(i=0; i<=sheet->maxcol; i++){
   name[0]='A'+i;
   name[1]='\0';
   gtk_sheet_column_button_add_label(sheet, i, name);
   gtk_sheet_set_column_title(sheet, i, name);
 }

 range.row0=2;
 range.rowi=6;
 range.col0=1;
 range.coli=2;

 gtk_sheet_clip_range(sheet, range);

 gtk_signal_connect(GTK_OBJECT(sheet),
                    "key_press_event",
                    (GtkSignalFunc) clipboard_handler, 
                    NULL);

 gtk_signal_connect(GTK_OBJECT(sheet),
                    "resize_range",
                    (GtkSignalFunc) resize_handler, 
                    NULL);

 gtk_signal_connect(GTK_OBJECT(sheet),
                    "move_range",
                    (GtkSignalFunc) move_handler, 
                    NULL);
/*
 gtk_signal_connect(GTK_OBJECT(sheet),
                    "activate_cell",
                    (GtkSignalFunc) alarm, 
                    NULL);
*/
}


void
build_example2(GtkWidget *widget)
{
 GtkSheet *sheet;
 GtkSheetRange range;
 GdkColor color;
 
 sheet=GTK_SHEET(widget);

 gtk_sheet_hide_row_titles(sheet);
 range.row0=0;
 range.rowi=2;
 range.col0=0;
 range.coli=sheet->maxcol;
 gtk_sheet_range_set_editable(sheet, range, FALSE);
 gdk_color_parse("light gray", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 gdk_color_parse("blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);
 range.row0=1;
 gdk_color_parse("red", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);
 range.row0=2;
 gdk_color_parse("black", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);

 gtk_sheet_row_set_sensitivity(sheet, 0, FALSE);
 gtk_sheet_row_set_sensitivity(sheet, 1, FALSE);
 gtk_sheet_row_set_sensitivity(sheet, 2, FALSE);
 gtk_sheet_set_cell(sheet, 0,2, GTK_JUSTIFY_CENTER,
                    "Click the right mouse button to display a popup");
 gtk_sheet_set_cell(sheet, 1,2, GTK_JUSTIFY_CENTER,
                    "You can connect a parser to the 'set cell' signal");
 gtk_sheet_set_cell(sheet, 2,2, GTK_JUSTIFY_CENTER,
                    "(Try typing numbers)");
 gtk_sheet_set_active_cell(sheet, 3, 0);

 gtk_sheet_set_update_policy(sheet, GTK_UPDATE_CONTINUOUS, GTK_UPDATE_CONTINUOUS);
 gtk_signal_connect(GTK_OBJECT(sheet),
                    "button_press_event",
                    (GtkSignalFunc) do_popup, 
                    NULL);

 gtk_signal_connect(GTK_OBJECT(sheet),
	            "set_cell",
		    (GtkSignalFunc) parse_numbers,
                    NULL);                   
}

void
build_example3(GtkWidget *widget)
{
 GtkSheet *sheet;
 GtkSheetRange range;
 GdkColor color;
 
 sheet=GTK_SHEET(widget);

 range.row0=0;
 range.rowi=10;
 range.col0=0;
 range.coli=6;
 gdk_color_parse("orange", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 gdk_color_parse("yellow", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);
 range.row0=1;
 gdk_color_parse("blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 range.coli=0;
 gdk_color_parse("dark green", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);

 range.row0=0; 
 gdk_color_parse("dark blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_border_color(sheet, range, &color);
 gtk_sheet_range_set_border(sheet, range, CELL_RIGHT_BORDER, 4, 1);
 range.coli=0;
 range.col0=0;
 range.rowi=0;
 gdk_color_parse("red", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 gtk_sheet_range_set_border(sheet, range, CELL_RIGHT_BORDER|
                                          CELL_BOTTOM_BORDER, 4, 0);
 range.rowi=0;
 range.col0=1;
 range.coli=6;
 gdk_color_parse("dark blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_border_color(sheet, range, &color);
 gtk_sheet_range_set_border(sheet, range, CELL_BOTTOM_BORDER, 4, 1);

 GTK_SHEET_SET_FLAGS(sheet, SHEET_AUTORESIZE);

}

void
set_cell(GtkWidget *widget, gchar *insert, gint text_legth, gint position, 
         gpointer data)
{
  char *text;

  if((text=GTK_SHENTRY(GTK_SHEET(widget)->sheet_entry)->text)){
                          gtk_entry_set_text(GTK_ENTRY(entry), text);
  }
  GTK_WIDGET_UNSET_FLAGS(entry, GTK_HAS_FOCUS);
  GTK_WIDGET_SET_FLAGS(GTK_SHEET(widget)->sheet_entry, GTK_HAS_FOCUS);
} 

void
show_sheet_entry(GtkWidget *widget, gpointer data)
{
 char *text;
 GtkSheet *sheet;
 GtkSHEntry *sheet_entry;

 if(!GTK_WIDGET_HAS_FOCUS(widget)) return;

 sheet=GTK_SHEET(GTK_NOTEBOOK(notebook)->cur_page->child);

 if((text=GTK_ENTRY(entry)->text)){
   sheet_entry=GTK_SHENTRY(sheet->sheet_entry);
   gtk_shentry_set_text(sheet_entry, text, sheet_entry->justification);
 }
}

void 
activate_sheet_entry(GtkWidget *widget, gpointer data)
{
  GtkSheet *sheet;
  gint row, col;

  sheet=GTK_SHEET(GTK_NOTEBOOK(notebook)->cur_page->child);
  row=sheet->active_cell.row;
  col=sheet->active_cell.col;

  gtk_sheet_set_cell(sheet, row, col, 
                     GTK_SHENTRY(sheet->sheet_entry)->justification,
                     GTK_SHENTRY(sheet->sheet_entry)->text);

}

void
show_entry(GtkWidget *widget, gpointer data)
{
 char *text;
 
 if(!GTK_WIDGET_HAS_FOCUS(widget)) return;

 if((text=GTK_SHENTRY(widget)->text))
                          gtk_entry_set_text(GTK_ENTRY(entry), text);

}

void 
activate_sheet_cell(GtkWidget *widget, gint row, gint column, gpointer data)
{
  GtkSheet *sheet;
  char cell[100];
  char *text;
  GtkSheetCellAttr attributes;

  sheet=GTK_SHEET(widget);

  if(GTK_SHEET(widget)->column[column].name)
   sprintf(cell,"  %s:%d  ",GTK_SHEET(widget)->column[column].name, row);
  else
   sprintf(cell, " ROW: %d COLUMN: %d ", row, column);

  gtk_label_set(GTK_LABEL(location), cell);

  gtk_entry_set_max_length(GTK_ENTRY(entry), 
	GTK_SHENTRY(GTK_SHEET(widget)->sheet_entry)->text_max_length); 

 if((text=GTK_SHENTRY(GTK_SHEET(widget)->sheet_entry)->text))
                          gtk_entry_set_text(GTK_ENTRY(entry), text);
 else
                          gtk_entry_set_text(GTK_ENTRY(entry), "");

 gtk_sheet_get_attributes(sheet,sheet->active_cell.row,
                                sheet->active_cell.col, &attributes); 

 gtk_entry_set_editable(GTK_ENTRY(entry), attributes.is_editable);

}

int main(int argc, char *argv[])
{
  GtkWidget *label; 
  gint i;

  char *title[]= {"Example 1",
                  "Example 2",
                  "Example 3"};
  char *folder[]= {"Folder 1",
                   "Folder 2",
                   "Folder 3"};

  gtk_init(&argc, &argv);

  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "GtkSheet Demo");
  gtk_widget_set_usize(GTK_WIDGET(window), 500, 300);
 
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (quit), NULL);

  main_vbox=gtk_vbox_new(FALSE,1);
  gtk_container_border_width(GTK_CONTAINER(main_vbox), 0);
  gtk_container_add(GTK_CONTAINER(window), main_vbox);
  gtk_widget_show(main_vbox);

  status_box=gtk_hbox_new(FALSE, 1);
  gtk_container_border_width(GTK_CONTAINER(status_box),0);
  gtk_box_pack_start(GTK_BOX(main_vbox), status_box, FALSE, TRUE, 0);
  gtk_widget_show(status_box);

  location=gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(status_box), location, FALSE, TRUE, 0);
  gtk_widget_show(location);

  entry=gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(status_box), entry, TRUE, TRUE, 0);
  gtk_widget_show(entry);

  notebook=gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
  gtk_box_pack_start(GTK_BOX(main_vbox), notebook, TRUE, TRUE, 0);
  gtk_widget_show(notebook);

  for(i=0; i<3; i++){
   sheets=(GtkWidget **)realloc(sheets, sizeof(GtkWidget *));
   sheets[i]=gtk_sheet_new(1000,26,title[i]);

   gtk_widget_show(sheets[i]);
   label=gtk_label_new(folder[i]);
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), GTK_WIDGET(sheets[i]), label);

   gtk_signal_connect(GTK_OBJECT(GTK_SHEET(sheets[i])->sheet_entry),
                      "changed",
                      (GtkSignalFunc)show_entry, NULL);

   gtk_signal_connect(GTK_OBJECT(sheets[i]),
                      "activate_cell",
                      (GtkSignalFunc)activate_sheet_cell, NULL);
  }

  gtk_signal_connect(GTK_OBJECT(entry),
                      "changed",
                      (GtkSignalFunc)show_sheet_entry, NULL);

  gtk_signal_connect(GTK_OBJECT(entry),
                      "activate",
                      (GtkSignalFunc)activate_sheet_entry, NULL);


  build_example1(sheets[0]);
  build_example2(sheets[1]);
  build_example3(sheets[2]);

  gtk_widget_show(window);

  gtk_main();

  return(0); 
}

 
