#if !defined (DEBUG)
#define DEBUG 1
#endif

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Debug.h>

#include <stdio.h>
#include <stdlib.h>
#include "gtk/gtk.h"
#include "libgimp/gimp.h"
#include "libgimp/gimpui.h"
#include "libgimp/gimpprotocol.h"

#include "IEWindow.h"
#include "GimpStub.h"
#include "FilterViews.h"

typedef struct data {
    gint angledsp;
    gint numsegs;
    gint orientation;
    gint bg_trans;
} BlindVals;

extern "C" BlindVals		bvals;

typedef struct ReturnValue {
	BMessage	*msg;
	bool		done;
};

class GIMPDlog : public IEWindow {
public:
	GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms);
	~GIMPDlog(void);

virtual	void		MessageReceived(BMessage *message);
virtual	bool		QuitRequested (void);
		void		DoPreview (void);
//public:
protected:
	FILTER_NAME			*fFilter;
	TFilterParams		*fParms;
	BSliderTextHelper	*fHelper, *fHelper1;
	ReturnValue			*fReturn;
	BlindVals			fVals;
	bool				fPreview;
};

GIMPDlog::GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms) : IEWindow("blinds") {
	ASSERT (!ret->done); fReturn = ret; fReturn->msg = NULL;
	AddTemporaryBPath (NULL); fParms = parms; fFilter = filter;

	fVals = bvals;
	fPreview = true;
	Lock ();
	char	radioName[2] = { 48, 0 };
	fHelper = new BSliderTextHelper ("Disp", "DispT", this); fHelper->SetValue (fVals.angledsp);
	fHelper1 = new BSliderTextHelper ("Segs", "SegT", this); fHelper1->SetValue (fVals.numsegs);
	BControl	*ctl;
	ctl = (BControl *)FindView (fVals.orientation ? "Vert" : "Horz");
	ctl->SetValue (1);
	gProgressView = new TDlogProgressView (FindView ("Progress"));
	Unlock ();
	Show();
	DoPreview ();
}

GIMPDlog::~GIMPDlog(void) {
	gProgressView = NULL;
	if (!fReturn->msg) {
		fParms->fDst->Copy (*fParms->fSrc);
		FilterUpdate (fParms);
	} else  {
		if (!fPreview) {
			fPreview = true;
			DoPreview ();	//	We do the action if it was not previewed.
		}
		VERIFY (B_OK == fFilter->Archive (fReturn->msg, true));
	}
	delete fHelper; delete fHelper1;
	fReturn->done = true;
}

bool GIMPDlog::QuitRequested (void) {
	gProgressView = NULL;
	return true;
}

void GIMPDlog::DoPreview (void) {
	if (fPreview) {
		fFilter->SetValue (&fVals);
	}
}

// Handling of user interface and other events
void GIMPDlog::MessageReceived (BMessage *message) {
	int32			value;

	switch(message->what){
		case '_xPr':	//	DoMiniPreview (); break;
		case 'Disp':	value = message->FindInt32 ("be:value"); if (value != fVals.angledsp) { fVals.angledsp = value; DoPreview (); } break;
		case 'Segs':	value = message->FindInt32 ("be:value"); if (value != fVals.numsegs) { fVals.numsegs = value; DoPreview (); } break;
		case 'View':	fPreview = !fPreview;
						if (fPreview) {
							DoPreview ();
						} else {
							//	Removes the preview by restoring the original image.
							fParms->fDst->Copy (*fParms->fSrc);
							FilterUpdate (fParms);
						}
						break;
		case 'Horz':
		case 'Vert':	fVals.orientation = message->what == 'Vert' ? 1 : 0; DoPreview (); break;
		case 'Abut':	fFilter->DoAbout (); break;
		case 'OK  ':	fReturn->msg = new BMessage ('Parm'); bvals = fVals;
		case 'Esc ':	gProgressView = NULL; Quit (); break;
		default:		inherited::MessageReceived(message); break;
	}

}

void FILTER_NAME::DoIt (TFilterParams *parms, const void *values) {
	GParam	inputParms[7], *outputParms;
	gint	cntOutput;

	inputParms[0].type = PARAM_INT32; inputParms[0].data.d_int32 = RUN_NONINTERACTIVE;	//	TBD, determined by the message
	inputParms[2].type = PARAM_DRAWABLE; inputParms[2].data.d_drawable = gint32(parms);
	inputParms[3].type = PARAM_INT32; inputParms[3].data.d_int32 = ((const BlindVals *)values)->angledsp;
	inputParms[4].type = PARAM_INT32; inputParms[4].data.d_int32 = ((const BlindVals *)values)->numsegs;
	inputParms[5].type = PARAM_INT32; inputParms[5].data.d_int32 = ((const BlindVals *)values)->orientation;
	inputParms[6].type = PARAM_INT32; inputParms[6].data.d_int32 = ((const BlindVals *)values)->bg_trans;
	(*PLUG_IN_INFO.run_proc) (fName, 7, inputParms, &cntOutput, &outputParms);
}

BMessage *FILTER_NAME::ApplyFilter (TFilterParams *parms) {
	BMessage	*result = NULL;

	if (fInited) {
		ASSERT (fLock == NULL);
		DoIt (parms, fData);
	} else {
		ReturnValue	returnVal;

		fLock = new Benaphore ("Synchro Dialog");
		returnVal.done = fChanged = false; fInited = true;
		AddTemporaryBPath (filterFile);
		new GIMPDlog (&returnVal, this, parms);
		do {
			if (fChanged) {
				fLock->Lock ();
				BlindVals	tmpValues;
				memcpy (&tmpValues, fData, sizeof (BlindVals));
				fChanged = false;
				fLock->Unlock ();
				DoIt (parms, &tmpValues);
				FilterUpdate (parms);
			} else {
				snooze (250000);
			}
		} while (!returnVal.done);
		result = returnVal.msg;
	}
	return result;
}

void FILTER_NAME::PrepareData (void) {
	fData = (void *) new char [sizeof(BlindVals)]; fDataSize = sizeof (BlindVals);
	ASSERT (fData);
}

void FILTER_NAME::DisposeData (void) {
	delete (BlindVals *)fData;
}

void FILTER_NAME::SetValue (void *value) {
	ASSERT (fLock);
	fLock->Lock ();

	memcpy (fData, value, sizeof(BlindVals));
	fChanged = true;
	fLock->Unlock ();
}

void gimp_get_data (gchar *id, gpointer data) {
	ASSERT (gCurFilter); gCurFilter->GetData (id, data);
}

void gimp_set_data (gchar *id, gpointer data, guint32 length) {
	ASSERT (gCurFilter); gCurFilter->SetData (id, data, length);
}

