/* Balsa E-Mail Client
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __mail_structs_h__
#define __mail_structs_h__

#include <glib.h>

/*
 * The c-client includes are not protected against duel includes.  Therefore,
 * I've put them here so that they will only be included once.
 */
#include "mail.h"
#include "osdep.h"
#include "rfc822.h"
#include "smtp.h"

typedef struct _PostOffice PostOffice;
typedef struct _Mailbox Mailbox;
typedef struct _Message Message;

struct _PostOffice
{
  char *name;
  char *dir;
  char *maildir;

  Mailbox *open;
  GList *mailbox_list;
};

struct _Mailbox
{
  PostOffice *postoffice;

  char *name;
  char *path;

  MAILSTREAM *stream;
  GList *message_list;
};

struct _Message
{
  Mailbox *mailbox;
  long mesgno;
};

#endif /* __mail_structs_h__ */
