#include <glib.h>
#include "gmain.h"

GMainLoop *loop;

gboolean 
timeout (gpointer data)
{
  g_print ((char *)data);
  return TRUE;
}

gboolean
input_handler (GIORiver *channel, GIOCondition cond, gpointer data)
{
  gchar buffer[1024];
  gint count;

  g_io_channel_read (channel, buffer, 1023, &count);
  
  if (count == 0)
    {
      g_main_quit (loop);
      return FALSE;
    }
  else
    {
      buffer[count] = '\0';
      g_print ("Received: %s\n", buffer);
      return TRUE;
    }
}

int 
main()
{
  GIORiver *input;
  
  g_timeout_add (1000, timeout, "hello!\n");
  
  input = g_io_channel_unix_new (0);
  g_io_add_watch (input, G_IO_IN, input_handler, NULL);
  
  loop = g_main_new();
  g_main_run (loop);

  return 0;
}
