(use-package "GDI")
(defun f ()
  (let* ((hdc (multiple-value-bind (retval h) (gdi::getdc nil)
                 (if retval h (error "getdc ~S" h))))
         (sy (multiple-value-bind (retval l)
                         (gdi::getdevicecaps hdc LOGPIXELSY)
                 (if retval l (error "getdevicecaps ~S" l))))
         (logfont (make-logfont
              (- sy) 0 0 0 FW_BOLD 1 0 0 ANSI_CHARSET
              OUT_TT_PRECIS CLIP_DEFAULT_PRECIS
              PROOF_QUALITY VARIABLE_PITCH
              "Times New Roman"))
         (hfont (multiple-value-bind (retval h)
                  (gdi::createfontindirecta logfont)
                  (if retval h (error "createfonta ~S" h))))
         (x (/ (gdi::getsystemmetrics SM_CXSCREEN) 2))
         (y (/ (gdi::getsystemmetrics SM_CYSCREEN) 2))
         (hold (multiple-value-bind (retval h) (gdi::selectobject hdc hfont)
                 (if retval h (error "getdc ~S" h)))))
     (gdi::settextalign hdc (logior TA_CENTER TA_BASELINE))
     (gdi::setbkmode hdc TRANSPARENT)
     (gdi::settextcolor hdc (gdi::make-rgb 0 0 #xff))
     (gdi::textouta hdc x y "HELLO WORLD" 11)
     (gdi::selectobject hdc hold)
     (gdi::deleteobject hfont)))

(trace gdi::createfontindirecta)
(trace gdi::deleteobject)
(trace gdi::getdc)
(trace gdi::getdevicecaps)
(trace gdi::getsystemmetrics)
(trace gdi::make-rgb)
(trace gdi::make-logfont)
(trace gdi::selectobject)
(trace gdi::setbkmode)
(trace gdi::settextalign)
(trace gdi::settextcolor)
(trace gdi::textouta)
(f)
