/*
 * Electric(tm) VLSI Design System
 *
 * File: network.h
 * Network tool: header file for fully instantiated networks
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* the meaning of tool:network.NET_options */
#define NETCONPWRGND          1		/* set to connect power and ground */
#define NETCONCOMMONNAME      2		/* set to connect commonly named nets */
#define NETAUTONAME           4		/* set to automatically name all nets */
#define NETUNNBUSBASE1      010		/* set to base unnamed busses at 1 (instead of 0) */
#define NETUNNBUSBASEDESC   020		/* set to number unnamed busses descending */

extern INTBIG      net_ncc_optionskey;			/* key for "NET_ncc_options" */
extern INTBIG      net_lastgoodncckey;			/* key for "NET_last_good_ncc" */
extern INTBIG      net_lastgoodnccfacetkey;		/* key for "NET_last_good_ncc_facet" */
extern INTBIG      net_ncc_comptolerancekey;	/* key for "NET_ncc_component_tolerance" */

/* the meaning of tool:network.NET_ncc_options */
#define NCCHIERARCHICAL               01		/* set to expand hierarchy during NCC */
#define NCCCHECKEXPORTNAMES           02		/* set to check export names during NCC */
#define NCCVERBOSETEXT                04		/* set to dump information during NCC */
#define NCCVERBOSEGRAPHICS           010		/* set to display information during NCC */
#define NCCIGNOREPWRGND              020		/* set to ignore power/ground during NCC */
#define NCCRECURSE                   040		/* set to do NCC recursively */
#define NCCCHECKEXPORTNAMESOVER     0100		/* set to override export names check for a facet */
#define NCCIGNOREPWRGNDOVER         0400		/* set to override P&G ignoring for a facet */
#define NCCCHECKSIZE               01000		/* set to check component size during NCC */
#define NCCCHECKSIZEOVER           02000		/* set to override check of component size check for a facet */
#define NCCNOMERGEPARALLEL         04000		/* set to not merge parallel components during NCC */
#define NCCNOMERGEPARALLELOVER    010000		/* set to override parallel component nonmerge for a facet */
#define NCCMERGESERIAL            020000		/* set to merge serial transistors during NCC */
#define NCCMERGESERIALOVER        040000		/* set to override serial transistors merge for a facet */

/*********************** PCOMP MODULES ***********************/

#define NOPCOMP ((PCOMP *)-1)

/* meaning of PNET->state */
#define NEGATEDPORT    1				/* if port is negated */
#define EXPORTEDPORT   2				/* if port is exported */

/* meaning of PCOMP->flags */
#define COMPUNIQUEHASH 1				/* if component has unique hash */
#define COMPHASWIDLEN  2				/* if component has width and length size info */
#define COMPHASAREA    4				/* if component has area size info */

typedef struct Ipcomp
{
	INTBIG           numactual;			/* number of components associated with this */
	void            *actuallist;		/* actual components */
	NODEINST        *topactual;			/* actual component at topmost level */
	NODEINST       **hierpath;			/* hierarchical path to this */
	INTSML           hierpathcount;		/* length of hierarchical path */
	INTSML           flags;				/* state bits */
	INTSML           function;			/* component function */
	INTSML           wirecount;			/* number of unconnected ports (wires) */
	INTBIG           timestamp;			/* time stamp for entry into symmetry group */
	INTHUGE          hashvalue;			/* hash value for NCC */
	char            *hashreason;		/* the explanation of the hash value */
	float            length;			/* length/size of component */
	float            width;				/* width of component (if FET) */
	INTSML          *portindices;		/* normalized indices for each wire */
	PORTPROTO      **portlist;			/* PORTPROTOs on each wire */
	struct Ipnet   **netnumbers;		/* initial netnumbers for each wire */
	INTSML          *state;				/* information about the connection */
	INTSML          *count;				/* connection count on each wire */
	struct Ipcomp ***pconnarray;		/* array of connections */
	INTSML         **portindexarray;	/* array of normalized indices on the other component */
	struct Ipcomp   *nextpcomp;			/* next in list of pseudocomponents */
} PCOMP;
extern PCOMP *net_pcompfree;

/*********************** PNET MODULES ***********************/

#define NOPNET ((PNET *)-1)

/* meaning of PNET->flags */
#define POWERNET         1			/* if net is power */
#define GROUNDNET        2			/* if net is ground */
#define EXPORTEDNET      4			/* if net is exported */
#define NETUNIQUEHASH  010			/* if net has unique hash */

typedef struct Ipnet
{
	INTSML         flags;			/* state bits */
	INTSML         realportcount;	/* number of top-level exports on this net */
	void          *realportlist;	/* top-level export(s) on this net */
	NETWORK       *network;			/* real network that this references */
	INTHUGE        hashvalue;		/* hash value for NCC */
	char          *hashreason;		/* the explanation of the hash value */
	INTBIG         timestamp;		/* time stamp for entry into symmetry group */
	INTBIG         nodecount;		/* number of pnodes on this network */
	PCOMP        **nodelist;		/* list of pnodes on this network */
	INTBIG        *nodewire;		/* list of which wire on the pnode attaches to network */
	struct Ipnet  *nextpnet;		/* next in list */
} PNET;
extern PNET *net_pnetfree;

/*********************** AREAPERIM and TRANSISTORINFO MODULES ***********************/

#define NOAREAPERIM ((AREAPERIM *)-1)

typedef struct Iareaperim
{
	float              area;
	INTBIG             perimeter;
	INTSML             layer;
	TECHNOLOGY        *tech;
	struct Iareaperim *nextareaperim;
} AREAPERIM;

typedef struct
{
	INTBIG count;			/* number of transistors found */
	INTBIG area;			/* sum of area of transistors */
	INTBIG width;			/* sum of width of transistors */
	INTBIG length;			/* sum of length of transistors */
} TRANSISTORINFO;

/* prototypes for tool interface */
void net_init(INTBIG*, char*[], TOOL*);
void net_done(void);
INTSML net_set(INTSML, char*[]);
INTBIG net_request(char*, va_list);
void net_examinenodeproto(NODEPROTO*);
void net_slice(void);
void net_startbatch(TOOL*, INTSML);
void net_endbatch(void);
void net_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void net_newobject(INTBIG, INTBIG);
void net_killobject(INTBIG, INTBIG);
void net_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void net_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, UINTBIG*);
void net_readlibrary(LIBRARY*);
void net_eraselibrary(LIBRARY*);

/* prototypes for intratool interface */
NETWORK   *net_gethighlightednet(INTSML, INTSML);
NETWORK  **net_gethighlightednets(INTSML disperror);
void       net_freeallpcomp(PCOMP*);
void       net_freeallpnet(PNET*);
void       net_freepcomp(PCOMP*);
void       net_freepnet(PNET*);
PCOMP     *net_makepseudo(NODEPROTO*, INTBIG*, INTBIG*, INTBIG*, INTBIG*, PNET**,
			INTSML, INTSML, INTSML, INTSML);
AREAPERIM *net_gathergeometry(NETWORK *net, TRANSISTORINFO **p_gate, TRANSISTORINFO **n_gate,
			TRANSISTORINFO **p_active, TRANSISTORINFO **n_active);
INTSML     net_equate(INTSML);
INTSML     net_compare(INTSML preanalyze);
INTSML     net_analyzefacet(void);
INTBIG     net_buswidth(char*);
INTBIG     net_evalbusname(INTBIG, char*, char***, ARCINST*, NODEPROTO*, INTBIG);
void       net_freediffmemory(void);
void       net_freeflatmemory(void);
INTSML     net_samenetworkname(NETWORK *net1, NETWORK *net2);
INTBIG     net_mergeparallel(PCOMP **pcomp, INTBIG *components);
INTSML     net_comparewirelist(PCOMP *p1, PCOMP *p2, INTSML useportnames);
void       net_dumpnetwork(PCOMP *pclist, PNET *pnlist);
INTSML     net_buildfullpnetdata(PCOMP **pcomplist, PNET **pnetlist, INTBIG verbose);
char      *net_describepnet(PNET *pn);
char      *net_describepcomp(PCOMP *pc);
INTHUGE    net_getcomphash(PCOMP *pc, INTBIG verbose);
INTHUGE    net_getnethash(PNET *pn, INTBIG verbose);
void       net_initdiff(void);
void       net_showcomphash(WINDOWPART *win, PCOMP *pc, INTHUGE hashvalue, INTBIG hashindex, INTBIG verbose);
void       net_shownethash(WINDOWPART *win, PNET *pn, INTHUGE hashvalue, INTBIG hashindex, INTBIG verbose);
void       net_freenetwork(NETWORK*, NODEPROTO*);
void       net_conv_to_internal(NODEPROTO *np);
void       net_removeassociations(void);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
