/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccEngine;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class NccUtils {
    private static long pow(int x, int y) {
        long prod = 1L;
        for (int i = 0; i < y; ++i) {
            prod *= (long)x;
        }
        return prod;
    }

    public static String fullName(Cell c) {
        return c.libDescribe();
    }

    private static Cell findLayout(Cell.CellGroup group) {
        Iterator it = group.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (c.getView() != View.LAYOUT) continue;
            return c.getNewestVersion();
        }
        return null;
    }

    public static Cell[] findSchematicAndLayout(Cell cell) {
        Cell.CellGroup group = cell.getCellGroup();
        Cell layout = null;
        Cell schematic = null;
        if (cell.isSchematic()) {
            schematic = cell;
            layout = NccUtils.findLayout(group);
        } else if (cell.getView() == View.LAYOUT) {
            layout = cell;
            schematic = group.getMainSchematics();
        } else {
            schematic = group.getMainSchematics();
            layout = NccUtils.findLayout(group);
        }
        if (schematic != null && layout != null) {
            return new Cell[]{schematic, layout};
        }
        return null;
    }

    public static CellContext getCurrentCellContext() {
        EditWindow wnd = EditWindow.getCurrent();
        return NccUtils.getCellContext(wnd);
    }

    public static CellContext getCellContext(EditWindow wnd) {
        if (wnd == null) {
            return null;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("window has no Cell");
            return null;
        }
        VarContext context = wnd.getVarContext();
        return new CellContext(cell, context);
    }

    public static List getCellContextsFromWindows() {
        ArrayList<CellContext> cellCtxts = new ArrayList<CellContext>();
        EditWindow wnd = EditWindow.getCurrent();
        CellContext curCellCtxt = NccUtils.getCellContext(wnd);
        if (curCellCtxt == null) {
            return cellCtxts;
        }
        cellCtxts.add(curCellCtxt);
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow wnd2;
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (wnd2 = (EditWindow)content) == wnd) continue;
            CellContext cc = NccUtils.getCellContext((EditWindow)content);
            cellCtxts.add(cc);
        }
        return cellCtxts;
    }

    public static String hourMinSec(Date start, Date stop) {
        int msecPerHour = 3600000;
        int msecPerMin = 60000;
        long elapsedMsec = stop.getTime() - start.getTime();
        long hours = elapsedMsec / 3600000L;
        long mins = (elapsedMsec %= 3600000L) / 60000L;
        double secs = (double)(elapsedMsec %= 60000L) / 1000.0;
        String time = "";
        if (hours != 0L) {
            time = time + hours + " hours ";
        }
        if (mins != 0L) {
            time = time + mins + " minutes ";
        }
        time = time + secs + " seconds";
        return time;
    }

    public static NccResult compareAndPrintStatus(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, HierarchyInfo hierInfo, NccOptions options) {
        System.out.println("Comparing: " + NccUtils.fullName(cell1) + " with: " + NccUtils.fullName(cell2));
        System.out.flush();
        Date before = new Date();
        NccResult result = NccEngine.compare(cell1, ctxt1, cell2, ctxt2, hierInfo, options);
        if (options.checkNetEquivalenceMap) {
            result.getNetEquivalence().regressionTest();
        }
        Date after = new Date();
        String timeStr = NccUtils.hourMinSec(before, after);
        System.out.println(result.summary(options.checkSizes) + " in " + timeStr + ".");
        System.out.flush();
        return result;
    }

    public static boolean buildBlackBoxes(CellContext c1, CellContext c2, HierarchyInfo hierInfo, NccOptions options) {
        System.out.println("Build black boxes for: " + NccUtils.fullName(c1.cell) + " and: " + NccUtils.fullName(c2.cell));
        System.out.flush();
        boolean ok = NccEngine.buildBlackBoxes(c1.cell, c1.context, c2.cell, c2.context, hierInfo, options);
        System.out.println(ok ? "Done" : "Failed");
        System.out.flush();
        return ok;
    }

    public static boolean sizesMatch(double w1, double w2, NccOptions opt) {
        double maxWidth = Math.max(w1, w2);
        double minWidth = Math.min(w1, w2);
        double absWidErr = maxWidth - minWidth;
        double relWidErr = absWidErr / minWidth;
        return absWidErr <= opt.absoluteSizeTolerance || relWidErr <= opt.relativeSizeTolerance;
    }

    public static void hang(String msg) {
    }

    public static double round(double x, int places) {
        long m = NccUtils.pow(10, places);
        return Math.rint(x * (double)m) / (double)m;
    }
}

