/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import com.sun.electric.tool.ncc.jemNets.NccNameProxy;
import com.sun.electric.tool.ncc.jemNets.Wire;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class Wires {
    private final ArrayList wires = new ArrayList();
    private final String pathPrefix;

    private void growIfNeeded(int ndx) {
        while (ndx > this.wires.size() - 1) {
            this.wires.add(null);
        }
    }

    public Wires(TransitiveRelation mergedNetIDs, HierarchyEnumerator.CellInfo info, String pathPrefix) {
        this.pathPrefix = pathPrefix;
        Iterator it = mergedNetIDs.getSetsOfRelatives();
        while (it.hasNext()) {
            Set relatives = (Set)it.next();
            Iterator ni = relatives.iterator();
            if (!ni.hasNext()) continue;
            int netId = (Integer)ni.next();
            Wire w = this.get(netId, info);
            while (ni.hasNext()) {
                netId = (Integer)ni.next();
                this.growIfNeeded(netId);
                this.wires.set(netId, w);
            }
        }
    }

    public Wire get(int netID, HierarchyEnumerator.CellInfo info) {
        this.growIfNeeded(netID);
        Wire wire = (Wire)this.wires.get(netID);
        if (wire == null) {
            HierarchyEnumerator.NetNameProxy np = info.getUniqueNetNameProxy(netID, "/");
            NccNameProxy.WireNameProxy wireNm = new NccNameProxy.WireNameProxy(np, this.pathPrefix);
            wire = new Wire(wireNm);
            this.wires.set(netID, wire);
        }
        return wire;
    }

    public ArrayList getWireArray() {
        HashSet wireSet = new HashSet();
        wireSet.addAll(this.wires);
        wireSet.remove(null);
        ArrayList nonNullWires = new ArrayList();
        nonNullWires.addAll(wireSet);
        return nonNullWires;
    }
}

