/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.G;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.MetalFloorplan;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.VddGndStraps;
import java.util.ArrayList;

class MetalLayer
implements VddGndStraps {
    private static final ArcProto[] METALS = new ArcProto[]{null, Tech.m1, Tech.m2, Tech.m3, Tech.m4, Tech.m5, Tech.m6};
    private static final PrimitiveNode[] PINS = new PrimitiveNode[]{null, Tech.m1pin, Tech.m2pin, Tech.m3pin, Tech.m4pin, Tech.m5pin, Tech.m6pin};
    private final MetalFloorplan plan;
    private final int layerNum;
    private final PrimitiveNode pin;
    private final ArcProto metal;
    private ArrayList vddPorts = new ArrayList();
    private ArrayList gndPorts = new ArrayList();
    private ArrayList vddCenters = new ArrayList();
    private ArrayList gndCenters = new ArrayList();

    private void buildGnd(MetalFloorplan plan, Cell cell) {
        double pinY;
        double pinX;
        if (plan.horizontal) {
            pinX = plan.cellWidth / 2.0 - plan.gndWidth / 2.0;
            pinY = plan.gndCenter;
        } else {
            pinX = plan.gndCenter;
            pinY = plan.cellHeight / 2.0 - plan.gndWidth / 2.0;
        }
        PortInst tl = LayoutLib.newNodeInst(this.pin, -pinX, pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
        PortInst tr = LayoutLib.newNodeInst(this.pin, pinX, pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
        PortInst bl = LayoutLib.newNodeInst(this.pin, -pinX, -pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
        PortInst br = LayoutLib.newNodeInst(this.pin, pinX, -pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
        if (plan.horizontal) {
            G.newArc(this.metal, plan.gndWidth, tl, tr);
            G.newArc(this.metal, plan.gndWidth, bl, br);
        } else {
            G.newArc(this.metal, plan.gndWidth, bl, tl);
            G.newArc(this.metal, plan.gndWidth, br, tr);
        }
        this.gndPorts.add(bl);
        this.gndPorts.add(tr);
        this.gndCenters.add(new Double(-plan.gndCenter));
        this.gndCenters.add(new Double(plan.gndCenter));
    }

    private void buildVdd(MetalFloorplan plan, Cell cell) {
        double pinY;
        double pinX;
        if (plan.horizontal) {
            pinX = plan.cellWidth / 2.0 - plan.vddWidth / 2.0;
            pinY = plan.vddCenter;
        } else {
            pinX = plan.vddCenter;
            pinY = plan.cellHeight / 2.0 - plan.vddWidth / 2.0;
        }
        if (plan.mergedVdd) {
            PortInst tr = LayoutLib.newNodeInst(this.pin, pinX, pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            PortInst bl = LayoutLib.newNodeInst(this.pin, -pinX, -pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            G.newArc(this.metal, plan.vddWidth, bl, tr);
            this.vddPorts.add(bl);
            this.vddCenters.add(new Double(plan.vddCenter));
        } else {
            PortInst tl = LayoutLib.newNodeInst(this.pin, -pinX, pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            PortInst tr = LayoutLib.newNodeInst(this.pin, pinX, pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            PortInst bl = LayoutLib.newNodeInst(this.pin, -pinX, -pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            PortInst br = LayoutLib.newNodeInst(this.pin, pinX, -pinY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            if (plan.horizontal) {
                G.newArc(this.metal, plan.vddWidth, tl, tr);
                G.newArc(this.metal, plan.vddWidth, bl, br);
            } else {
                G.newArc(this.metal, plan.vddWidth, bl, tl);
                G.newArc(this.metal, plan.vddWidth, br, tr);
            }
            this.vddPorts.add(bl);
            this.vddPorts.add(tr);
            this.vddCenters.add(new Double(-plan.vddCenter));
            this.vddCenters.add(new Double(plan.vddCenter));
        }
    }

    public MetalLayer(int layerNum, MetalFloorplan plan, Cell cell) {
        this.plan = plan;
        this.layerNum = layerNum;
        this.metal = METALS[layerNum];
        this.pin = PINS[layerNum];
        this.buildGnd(plan, cell);
        this.buildVdd(plan, cell);
    }

    public boolean isHorizontal() {
        return this.plan.horizontal;
    }

    public int numVdd() {
        return this.vddPorts.size();
    }

    public PortInst getVdd(int n) {
        return (PortInst)this.vddPorts.get(n);
    }

    public double getVddCenter(int n) {
        return (Double)this.vddCenters.get(n);
    }

    public double getVddWidth(int n) {
        return this.plan.vddWidth;
    }

    public int numGnd() {
        return this.gndPorts.size();
    }

    public PortInst getGnd(int n) {
        return (PortInst)this.gndPorts.get(n);
    }

    public double getGndCenter(int n) {
        return (Double)this.gndCenters.get(n);
    }

    public double getGndWidth(int n) {
        return this.plan.gndWidth;
    }

    public PrimitiveNode getPinType() {
        return this.pin;
    }

    public ArcProto getMetalType() {
        return this.metal;
    }

    public double getCellWidth() {
        return this.plan.cellWidth;
    }

    public double getCellHeight() {
        return this.plan.cellHeight;
    }

    public int getLayerNumber() {
        return this.layerNum;
    }
}

