/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class ViewChanges {
    private static final int MAXADJUST = 5;

    ViewChanges() {
    }

    public static void convertMultiPageViews() {
        ArrayList<Cell> multiPageCells = new ArrayList<Cell>();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            if (lib.isHidden()) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                if (!cell.getView().getFullName().startsWith("schematic-page-")) continue;
                multiPageCells.add(cell);
            }
        }
        if (multiPageCells.size() == 0) {
            System.out.println("No old-style multi-page schematics to convert");
            return;
        }
        Collections.sort(multiPageCells);
        FixOldMultiPageSchematics job = new FixOldMultiPageSchematics(multiPageCells);
    }

    public static void changeCellView(Cell cell, View newView) {
        if (cell.getView() == newView) {
            return;
        }
        Iterator it = cell.getLibrary().getCells();
        while (it.hasNext()) {
            Cell other = (Cell)it.next();
            if (other.getView() != newView || !other.getName().equalsIgnoreCase(cell.getName())) continue;
            int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "There is already a cell with that view.  Is it okay to make it an older version, and make this the newest version?");
            if (response == 0) break;
            return;
        }
        ChangeCellView job = new ChangeCellView(cell, newView);
    }

    public static void makeSkeletonViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        if (curCell.getView().isTextView()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot skeletonize textual views: only layout", "Skeleton creation failed", 0);
            return;
        }
        if (curCell.getView() != View.UNKNOWN && curCell.getView() != View.LAYOUT) {
            System.out.println("Warning: skeletonization only makes sense for layout cells, not " + curCell.getView().getFullName());
        }
        MakeSkeletonView job = new MakeSkeletonView(curCell);
    }

    public static boolean skeletonizeCell(Cell curCell, Cell skeletonCell) {
        HashMap<Export, Export> newPortMap = new HashMap<Export, Export>();
        Iterator it = curCell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            PortOriginal fp = new PortOriginal(pp.getOriginalPort());
            PortInst bottomPort = fp.getBottomPort();
            NodeInst bottomNi = bottomPort.getNodeInst();
            PortProto bottomPp = bottomPort.getPortProto();
            AffineTransform subRot = fp.getTransformToTop();
            Orientation newOrient = fp.getOrientToTop();
            Point2D.Double center = new Point2D.Double(bottomNi.getAnchorCenterX(), bottomNi.getAnchorCenterY());
            subRot.transform(center, center);
            NodeInst newNi = NodeInst.makeInstance(bottomNi.getProto(), center, bottomNi.getXSize(), bottomNi.getYSize(), skeletonCell, newOrient, null, 0);
            if (newNi == null) {
                System.out.println("Cannot create node in this cell");
                return true;
            }
            PortInst newPi = newNi.findPortInstFromProto(bottomPp);
            Export npp = Export.newInstance(skeletonCell, newPi, pp.getName());
            if (npp == null) {
                System.out.println("Could not create port " + pp.getName());
                return true;
            }
            npp.copyTextDescriptorFrom(pp, Export.EXPORT_NAME_TD);
            npp.copyVarsFrom(pp);
            npp.setCharacteristic(pp.getCharacteristic());
            newPortMap.put(pp, npp);
        }
        Netlist netlist = curCell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted skeletonization (network information unavailable).  Please try again");
            return true;
        }
        int numPorts = curCell.getNumPorts();
        for (int i = 0; i < numPorts; ++i) {
            Export pp = (Export)curCell.getPort(i);
            for (int j = i + 1; j < numPorts; ++j) {
                Export oPp = (Export)curCell.getPort(j);
                if (!netlist.sameNetwork(pp.getOriginalPort().getNodeInst(), pp.getOriginalPort().getPortProto(), oPp.getOriginalPort().getNodeInst(), oPp.getOriginalPort().getPortProto())) continue;
                Export newPp = (Export)newPortMap.get(pp);
                Export newOPp = (Export)newPortMap.get(oPp);
                if (newPp == null || newOPp == null) continue;
                ArcProto univ = Generic.tech.universal_arc;
                ArcInst newAI = ArcInst.makeInstance(univ, univ.getDefaultWidth(), newPp.getOriginalPort(), newOPp.getOriginalPort());
                if (newAI == null) {
                    System.out.println("Could not create connecting arc");
                    return true;
                }
                newAI.setFixedAngle(false);
            }
        }
        Iterator it2 = curCell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = (NodeInst)it2.next();
            NodeProto np = ni.getProto();
            if (np != Generic.tech.essentialBoundsNode) continue;
            NodeInst newNi = NodeInst.makeInstance(np, ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), skeletonCell, ni.getOrient(), null, 0);
            if (newNi == null) {
                System.out.println("Cannot create node in this cell");
                return true;
            }
            newNi.setHardSelect();
            if (np != Generic.tech.cellCenterNode) continue;
            newNi.setVisInside();
        }
        Rectangle2D bounds = curCell.getBounds();
        NodeInst boundNi = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), skeletonCell);
        if (boundNi == null) {
            System.out.println("Cannot create boundary node");
            return true;
        }
        boundNi.setHardSelect();
        return false;
    }

    public static void makeIconViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        MakeIconView job = new MakeIconView(curCell);
    }

    public static Cell makeIconForCell(Cell curCell) {
        double leadLength = User.getIconGenLeadLength();
        double leadSpacing = User.getIconGenLeadSpacing();
        boolean reverseIconExportOrder = User.isIconGenReverseExportOrder();
        ArrayList exportList = new ArrayList();
        Iterator it = curCell.getPorts();
        while (it.hasNext()) {
            exportList.add(it.next());
        }
        if (reverseIconExportOrder) {
            Collections.reverse(exportList);
        }
        String iconCellName = curCell.getName() + "{ic}";
        Cell iconCell = Cell.makeInstance(curCell.getLibrary(), iconCellName);
        if (iconCell == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create Icon cell " + iconCellName, "Icon creation failed", 0);
            return null;
        }
        iconCell.setWantExpanded();
        int leftSide = 0;
        int rightSide = 0;
        int bottomSide = 0;
        int topSide = 0;
        HashMap<Export, Integer> portIndex = new HashMap<Export, Integer>();
        Iterator it2 = exportList.iterator();
        while (it2.hasNext()) {
            Export pp = (Export)it2.next();
            if (pp.isBodyOnly()) continue;
            int index = ViewChanges.iconPosition(pp);
            switch (index) {
                case 0: {
                    portIndex.put(pp, new Integer(leftSide++));
                    break;
                }
                case 1: {
                    portIndex.put(pp, new Integer(rightSide++));
                    break;
                }
                case 2: {
                    portIndex.put(pp, new Integer(topSide++));
                    break;
                }
                case 3: {
                    portIndex.put(pp, new Integer(bottomSide++));
                }
            }
        }
        double ySize = (double)Math.max(Math.max(leftSide, rightSide), 5) * leadSpacing;
        double xSize = (double)Math.max(Math.max(topSide, bottomSide), 3) * leadSpacing;
        NodeInst bbNi = null;
        if (User.isIconGenDrawBody()) {
            bbNi = NodeInst.newInstance(Artwork.tech.openedThickerPolygonNode, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
            if (bbNi == null) {
                return null;
            }
            Point2D[] boxOutline = new Point2D[]{new Point2D.Double(-xSize / 2.0, -ySize / 2.0), new Point2D.Double(-xSize / 2.0, ySize / 2.0), new Point2D.Double(xSize / 2.0, ySize / 2.0), new Point2D.Double(xSize / 2.0, -ySize / 2.0), new Point2D.Double(-xSize / 2.0, -ySize / 2.0)};
            bbNi.newVar(NodeInst.TRACE, (Object)boxOutline);
            Variable var = bbNi.newDisplayVar(Schematics.SCHEM_FUNCTION, curCell.getName());
        }
        int total = 0;
        Iterator it3 = exportList.iterator();
        while (it3.hasNext()) {
            Export pp = (Export)it3.next();
            if (pp.isBodyOnly()) continue;
            Integer portPosition = (Integer)portIndex.get(pp);
            int index = ViewChanges.iconPosition(pp);
            double spacing = leadSpacing;
            double xPos = 0.0;
            double yPos = 0.0;
            double xBBPos = 0.0;
            double yBBPos = 0.0;
            switch (index) {
                case 0: {
                    xBBPos = -xSize / 2.0;
                    xPos = xBBPos - leadLength;
                    if (leftSide * 2 < rightSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(leftSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    break;
                }
                case 1: {
                    xBBPos = xSize / 2.0;
                    xPos = xBBPos + leadLength;
                    if (rightSide * 2 < leftSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(rightSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    break;
                }
                case 2: {
                    if (topSide * 2 < bottomSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(topSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    yBBPos = ySize / 2.0;
                    yPos = yBBPos + leadLength;
                    break;
                }
                case 3: {
                    if (bottomSide * 2 < topSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(bottomSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    yBBPos = -ySize / 2.0;
                    yPos = yBBPos - leadLength;
                }
            }
            if (!ViewChanges.makeIconExport(pp, index, xPos, yPos, xBBPos, yBBPos, iconCell)) continue;
            ++total;
        }
        if (!User.isIconGenDrawBody() && !User.isIconGenDrawLeads() && User.isPlaceCellCenter() && total <= 1) {
            NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
        }
        return iconCell;
    }

    public static boolean makeIconExport(Export pp, int index, double xPos, double yPos, double xBBPos, double yBBPos, Cell np) {
        NodeInst pinNi;
        PrimitiveNode pinType = Generic.tech.universalPinNode;
        double pinSizeX = 0.0;
        double pinSizeY = 0.0;
        if (User.getIconGenExportTech() != 0) {
            pinType = Schematics.tech.busPinNode;
            pinSizeX = pinType.getDefWidth();
            pinSizeY = pinType.getDefHeight();
        }
        ArcProto wireType = Schematics.tech.wire_arc;
        if (pp.getBasePort().connectsTo(Schematics.tech.bus_arc) && pp.getNameKey().isBus()) {
            wireType = Schematics.tech.bus_arc;
            pinType = Schematics.tech.busPinNode;
            pinSizeX = pinType.getDefWidth();
            pinSizeY = pinType.getDefHeight();
        }
        if (!User.isIconGenDrawLeads()) {
            xPos = xBBPos;
            yPos = yBBPos;
        }
        if ((pinNi = NodeInst.newInstance(pinType, new Point2D.Double(xPos, yPos), pinSizeX, pinSizeY, np)) == null) {
            return false;
        }
        PortInst pi = pinNi.getOnlyPortInst();
        Export port = Export.newInstance(np, pi, pp.getName());
        if (port != null) {
            MutableTextDescriptor td = port.getMutableTextDescriptor(Export.EXPORT_NAME_TD);
            block0 : switch (User.getIconGenExportStyle()) {
                case 0: {
                    td.setPos(TextDescriptor.Position.CENT);
                    break;
                }
                case 1: {
                    switch (index) {
                        case 0: {
                            td.setPos(TextDescriptor.Position.RIGHT);
                            break;
                        }
                        case 1: {
                            td.setPos(TextDescriptor.Position.LEFT);
                            break;
                        }
                        case 2: {
                            td.setPos(TextDescriptor.Position.DOWN);
                            break;
                        }
                        case 3: {
                            td.setPos(TextDescriptor.Position.UP);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (index) {
                        case 0: {
                            td.setPos(TextDescriptor.Position.LEFT);
                            break block0;
                        }
                        case 1: {
                            td.setPos(TextDescriptor.Position.RIGHT);
                            break block0;
                        }
                        case 2: {
                            td.setPos(TextDescriptor.Position.UP);
                            break block0;
                        }
                        case 3: {
                            td.setPos(TextDescriptor.Position.DOWN);
                        }
                    }
                }
            }
            port.setTextDescriptor(Export.EXPORT_NAME_TD, td);
            double xOffset = 0.0;
            double yOffset = 0.0;
            int loc = User.getIconGenExportLocation();
            if (!User.isIconGenDrawLeads()) {
                loc = 0;
            }
            switch (loc) {
                case 0: {
                    xOffset = xBBPos - xPos;
                    yOffset = yBBPos - yPos;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    xOffset = (xPos + xBBPos) / 2.0 - xPos;
                    yOffset = (yPos + yBBPos) / 2.0 - yPos;
                }
            }
            port.setOff(Export.EXPORT_NAME_TD, xOffset, yOffset);
            if (pp.isAlwaysDrawn()) {
                port.setAlwaysDrawn();
            } else {
                port.clearAlwaysDrawn();
            }
            port.setCharacteristic(pp.getCharacteristic());
            port.copyVarsFrom(pp);
        }
        if (User.isIconGenDrawLeads()) {
            double hei;
            double wid;
            NodeInst ni;
            pinType = wireType.findPinProto();
            if (pinType == Schematics.tech.busPinNode) {
                pinType = Generic.tech.invisiblePinNode;
            }
            if ((ni = NodeInst.newInstance(pinType, new Point2D.Double(xBBPos, yBBPos), wid = pinType.getDefWidth(), hei = pinType.getDefHeight(), np)) != null) {
                PortInst head = ni.getOnlyPortInst();
                PortInst tail = pinNi.getOnlyPortInst();
                ArcInst ai = ArcInst.makeInstance(wireType, wireType.getDefaultWidth(), head, tail, new Point2D.Double(xBBPos, yBBPos), new Point2D.Double(xPos, yPos), null);
                if (ai != null && wireType == Schematics.tech.bus_arc) {
                    ai.setHeadExtended(false);
                    ai.setTailExtended(false);
                }
            }
        }
        return true;
    }

    private static int iconPosition(Export pp) {
        PortCharacteristic character = pp.getCharacteristic();
        if (pp.isPower()) {
            character = PortCharacteristic.PWR;
        }
        if (pp.isGround()) {
            character = PortCharacteristic.GND;
        }
        if (character == PortCharacteristic.IN) {
            return User.getIconGenInputSide();
        }
        if (character == PortCharacteristic.OUT) {
            return User.getIconGenOutputSide();
        }
        if (character == PortCharacteristic.BIDIR) {
            return User.getIconGenBidirSide();
        }
        if (character == PortCharacteristic.PWR) {
            return User.getIconGenPowerSide();
        }
        if (character == PortCharacteristic.GND) {
            return User.getIconGenGroundSide();
        }
        if (character == PortCharacteristic.CLK || character == PortCharacteristic.C1 || character == PortCharacteristic.C2 || character == PortCharacteristic.C3 || character == PortCharacteristic.C4 || character == PortCharacteristic.C5 || character == PortCharacteristic.C6) {
            return User.getIconGenClockSide();
        }
        return User.getIconGenInputSide();
    }

    public static void makeSchematicView() {
        Cell oldCell = WindowFrame.needCurCell();
        if (oldCell == null) {
            return;
        }
        MakeSchematicView job = new MakeSchematicView(oldCell);
    }

    private static Cell convertSchematicCell(Cell oldCell) {
        Cell newCell = ViewChanges.makeNewCell(oldCell.getName(), View.SCHEMATIC, oldCell);
        if (newCell == null) {
            return null;
        }
        HashMap newNodes = new HashMap();
        ViewChanges.buildSchematicNodes(oldCell, newCell, newNodes);
        ViewChanges.buildSchematicArcs(oldCell, newCell, newNodes);
        Iterator it = newCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            EPoint headPt = ai.getHeadLocation();
            EPoint tailPt = ai.getTailLocation();
            if (((Point2D)headPt).getX() == ((Point2D)tailPt).getX() && ((Point2D)headPt).getY() == ((Point2D)tailPt).getY() || GenMath.figureAngle(headPt, tailPt) % 450 != 0) continue;
            ai.setFixedAngle(true);
        }
        System.out.println("Cell " + newCell.describe(true) + " created with a schematic representation of " + oldCell);
        return newCell;
    }

    private static Cell makeNewCell(String newCellName, View newCellView, Cell cell) {
        Cell newCell;
        String cellName = newCellName;
        if (newCellView.getAbbreviation().length() > 0) {
            cellName = newCellName + "{" + newCellView.getAbbreviation() + "}";
        }
        if ((newCell = Cell.makeInstance(cell.getLibrary(), cellName)) == null) {
            System.out.println("Could not create cell: " + cellName);
        } else {
            System.out.println("Creating new cell: " + cellName);
        }
        return newCell;
    }

    private static void buildSchematicNodes(Cell cell, Cell newCell, HashMap newNodes) {
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst mosNI = (NodeInst)it.next();
            PrimitiveNode.Function type = ViewChanges.getNodeType(mosNI);
            NodeInst schemNI = null;
            if (type == PrimitiveNode.Function.UNKNOWN) continue;
            if (type == PrimitiveNode.Function.PIN) {
                PrimitiveNode prim = Schematics.tech.wirePinNode;
                schemNI = ViewChanges.makeSchematicNode(prim, mosNI, prim.getDefWidth(), prim.getDefHeight(), 0, 0, newCell);
            } else if (type == null) {
                Cell proto = (Cell)mosNI.getProto();
                Cell equivCell = proto.otherView(View.SCHEMATIC);
                if (equivCell == null) {
                    equivCell = ViewChanges.convertSchematicCell(proto);
                }
                schemNI = ViewChanges.makeSchematicNode(equivCell, mosNI, equivCell.getDefWidth(), equivCell.getDefHeight(), mosNI.getAngle(), 0, newCell);
            } else {
                int rotate = mosNI.getAngle();
                rotate = (rotate + 2700) % 3600;
                PrimitiveNode prim = Schematics.tech.transistorNode;
                int bits = Schematics.getPrimitiveFunctionBits(mosNI.getFunction());
                schemNI = ViewChanges.makeSchematicNode(prim, mosNI, prim.getDefWidth(), prim.getDefHeight(), rotate, bits, newCell);
                TransistorSize ts = mosNI.getTransistorSize(VarContext.globalContext);
                if (ts != null) {
                    if (mosNI.isFET()) {
                        Variable widVar;
                        Variable lenVar = schemNI.newDisplayVar(Schematics.ATTR_LENGTH, new Double(ts.getDoubleLength()));
                        if (lenVar != null) {
                            lenVar.setRelSize(0.5);
                            lenVar.setOff(-0.5, -1.0);
                        }
                        if ((widVar = schemNI.newDisplayVar(Schematics.ATTR_WIDTH, new Double(ts.getDoubleWidth()))) != null) {
                            widVar.setRelSize(1.0);
                            widVar.setOff(0.5, -1.0);
                        }
                    } else {
                        schemNI.newVar(Schematics.ATTR_AREA, (Object)new Double(ts.getDoubleLength()));
                    }
                }
            }
            newNodes.put(mosNI, schemNI);
            if (schemNI == null) continue;
            Iterator eIt = mosNI.getExports();
            while (eIt.hasNext()) {
                Export schemPP;
                Export mosPP = (Export)eIt.next();
                PortInst schemPI = ViewChanges.convertPort(mosNI, mosPP.getOriginalPort().getPortProto(), schemNI);
                if (schemPI == null || (schemPP = Export.newInstance(newCell, schemPI, mosPP.getName())) == null) continue;
                schemPP.setCharacteristic(mosPP.getCharacteristic());
                schemPP.copyTextDescriptorFrom(mosPP, Export.EXPORT_NAME_TD);
                schemPP.copyVarsFrom(mosPP);
            }
        }
    }

    private static NodeInst makeSchematicNode(NodeProto prim, NodeInst orig, double wid, double hei, int angle, int techSpecific, Cell newCell) {
        Point2D.Double newLoc = new Point2D.Double(orig.getAnchorCenterX(), orig.getAnchorCenterY());
        Orientation orient = Orientation.fromAngle(angle);
        NodeInst newNI = NodeInst.makeInstance(prim, newLoc, wid, hei, newCell, orient, null, techSpecific);
        return newNI;
    }

    private static void buildSchematicArcs(Cell cell, Cell newcell, HashMap newNodes) {
        Iterator it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst schemAI;
            ArcInst mosAI = (ArcInst)it.next();
            NodeInst mosHeadNI = mosAI.getHeadPortInst().getNodeInst();
            NodeInst mosTailNI = mosAI.getTailPortInst().getNodeInst();
            NodeInst schemHeadNI = (NodeInst)newNodes.get(mosHeadNI);
            NodeInst schemTailNI = (NodeInst)newNodes.get(mosTailNI);
            if (schemHeadNI == null || schemTailNI == null) continue;
            PortInst schemHeadPI = ViewChanges.convertPort(mosHeadNI, mosAI.getHeadPortInst().getPortProto(), schemHeadNI);
            PortInst schemTailPI = ViewChanges.convertPort(mosTailNI, mosAI.getTailPortInst().getPortProto(), schemTailNI);
            if (schemHeadPI == null || schemTailPI == null || (schemAI = ArcInst.makeInstance(Schematics.tech.wire_arc, 0.0, schemHeadPI, schemTailPI, null, null, mosAI.getName())) == null) continue;
            schemAI.setFixedAngle(false);
            schemAI.setRigid(false);
        }
    }

    private static PortInst convertPort(NodeInst mosNI, PortProto mosPP, NodeInst schemNI) {
        PortProto pp;
        PrimitiveNode.Function fun = ViewChanges.getNodeType(schemNI);
        if (fun == PrimitiveNode.Function.PIN) {
            return schemNI.getOnlyPortInst();
        }
        if (fun == null) {
            PortProto schemPP = schemNI.getProto().findPortProto(mosPP.getName());
            if (schemPP == null) {
                return null;
            }
            return schemNI.findPortInstFromProto(schemPP);
        }
        int portNum = 1;
        Iterator it = mosNI.getProto().getPorts();
        while (it.hasNext() && (pp = (PortProto)it.next()) != mosPP) {
            ++portNum;
        }
        if (portNum == 4) {
            portNum = 3;
        } else if (portNum == 3) {
            portNum = 1;
        }
        it = schemNI.getProto().getPorts();
        while (it.hasNext()) {
            PortProto schemPP = (PortProto)it.next();
            if (--portNum > 0) continue;
            return schemNI.findPortInstFromProto(schemPP);
        }
        return null;
    }

    private static void makeArcsManhattan(Cell newCell) {
        double[] x = new double[5];
        double[] y = new double[5];
        Iterator it = newCell.getNodes();
        while (it.hasNext()) {
            PrimitiveNode.Function fun;
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() instanceof Cell || (fun = ni.getFunction()) != PrimitiveNode.Function.PIN) continue;
            int count = 0;
            Iterator aIt = ni.getConnections();
            while (aIt.hasNext()) {
                Connection con = (Connection)aIt.next();
                ArcInst ai = con.getArc();
                int otherEnd = 1 - con.getEndIndex();
                if (con.getPortInst().getNodeInst() == ai.getPortInst(otherEnd).getNodeInst()) continue;
                x[count] = ai.getLocation(otherEnd).getX();
                y[count] = ai.getLocation(otherEnd).getY();
                if (++count < 5) continue;
                break;
            }
            if (count == 0) continue;
            double xp = ni.getAnchorCenterX();
            double yp = ni.getAnchorCenterY();
            double bestDist = Double.MAX_VALUE;
            double bestX = 0.0;
            double bestY = 0.0;
            for (int i = 0; i < count; ++i) {
                for (int j = 0; j < count; ++j) {
                    double dist = Math.abs(xp - x[i]) + Math.abs(yp - y[j]);
                    if (dist > bestDist) continue;
                    bestDist = dist;
                    bestX = x[i];
                    bestY = y[j];
                }
            }
            if (bestDist == Double.MAX_VALUE) continue;
            ni.move(bestX - xp, bestY - yp);
        }
    }

    private static PrimitiveNode.Function getNodeType(NodeInst ni) {
        if (ni.getProto() instanceof Cell) {
            return null;
        }
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun.isTransistor()) {
            return fun;
        }
        if (fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.SUBSTRATE || fun == PrimitiveNode.Function.WELL) {
            return PrimitiveNode.Function.PIN;
        }
        return PrimitiveNode.Function.UNKNOWN;
    }

    public static void makeLayoutView() {
        Cell oldCell = WindowFrame.needCurCell();
        if (oldCell == null) {
            return;
        }
        MakeLayoutView job = new MakeLayoutView(oldCell);
    }

    private static class MakeLayoutView
    extends Job {
        private static boolean reverseIconExportOrder;
        private Cell oldCell;
        private HashMap convertedNodes;

        protected MakeLayoutView(Cell oldCell) {
            super("Make Alternate Layout", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.oldCell = oldCell;
            this.startJob();
        }

        public boolean doIt() {
            Technology oldTech = this.oldCell.getTechnology();
            int numTechs = 0;
            Iterator it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = (Technology)it.next();
                if (!tech.isScaleRelevant()) continue;
                ++numTechs;
            }
            Object[] techNames = new String[numTechs];
            int i = 0;
            Iterator it2 = Technology.getTechnologies();
            while (it2.hasNext()) {
                Technology tech = (Technology)it2.next();
                if (!tech.isScaleRelevant()) continue;
                techNames[i++] = tech.getTechName();
            }
            String selectedValue = (String)JOptionPane.showInputDialog(null, "New technology to create", "Technology conversion", 1, null, techNames, User.getSchematicTechnology());
            if (selectedValue == null) {
                return false;
            }
            Technology newTech = Technology.findTechnology(selectedValue);
            if (newTech == null) {
                return false;
            }
            if (newTech == oldTech) {
                System.out.println("Cell " + this.oldCell.describe(true) + " is already in the " + newTech.getTechName() + " technology");
                return false;
            }
            HashMap convertedCells = new HashMap();
            Cell newCell = this.makeLayoutCells(this.oldCell, this.oldCell.getName(), oldTech, newTech, this.oldCell.getView(), convertedCells);
            System.out.println("Cell " + newCell.describe(true) + " created with a " + newTech.getTechName() + " layout equivalent of " + this.oldCell);
            WindowFrame.createEditWindow(newCell);
            return true;
        }

        private Cell makeLayoutCells(Cell oldCell, String newCellName, Technology oldTech, Technology newTech, View nView, HashMap convertedCells) {
            Iterator it = oldCell.getNodes();
            while (it.hasNext()) {
                Cell subCell;
                NodeInst ni = (NodeInst)it.next();
                if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent() || convertedCells.containsKey(subCell = (Cell)ni.getProto())) continue;
                String searchCellName = subCell.getName() + "{lay}";
                Cell existing = oldCell.getLibrary().findNodeProto(searchCellName);
                if (existing != null) {
                    convertedCells.put(oldCell, existing);
                    continue;
                }
                this.makeLayoutCells(subCell, subCell.getName(), oldTech, newTech, nView, convertedCells);
            }
            Cell newCell = ViewChanges.makeNewCell(newCellName, View.LAYOUT, oldCell);
            if (newCell == null) {
                return null;
            }
            this.makeLayoutParts(oldCell, newCell, oldTech, newTech, nView, convertedCells);
            ViewChanges.makeArcsManhattan(newCell);
            convertedCells.put(oldCell, newCell);
            return newCell;
        }

        private void makeLayoutParts(Cell oldCell, Cell newCell, Technology oldTech, Technology newTech, View nView, HashMap convertedCells) {
            this.convertedNodes = new HashMap();
            Iterator it = oldCell.getNodes();
            while (it.hasNext()) {
                NodeProto newNp;
                NodeInst ni = (NodeInst)it.next();
                if (ni.getProto() instanceof Cell) {
                    Cell newCellType = (Cell)convertedCells.get(ni.getProto());
                    if (newCellType == null) {
                        System.out.println("No equivalent cell for " + ni.getProto());
                        continue;
                    }
                    this.placeLayoutNode(ni, newCellType, newCell);
                    continue;
                }
                if (ni.getProto() == Generic.tech.cellCenterNode || (newNp = this.figureNewNodeProto(ni, newTech)) == null) continue;
                this.placeLayoutNode(ni, newNp, newCell);
            }
            boolean badArcs = false;
            Iterator it2 = oldCell.getArcs();
            while (it2.hasNext()) {
                ArcInst newAi;
                ArcInst ai = (ArcInst)it2.next();
                NodeInst oldHeadNi = ai.getHeadPortInst().getNodeInst();
                NodeInst oldTailNi = ai.getTailPortInst().getNodeInst();
                NodeInst newHeadNi = (NodeInst)this.convertedNodes.get(oldHeadNi);
                NodeInst newTailNi = (NodeInst)this.convertedNodes.get(oldTailNi);
                if (newHeadNi == null || newTailNi == null) continue;
                PortProto oldHeadPp = ai.getHeadPortInst().getPortProto();
                PortProto oldTailPp = ai.getTailPortInst().getPortProto();
                PortProto newHeadPp = this.convertPortProto(oldHeadNi, newHeadNi, oldHeadPp);
                PortProto newTailPp = this.convertPortProto(oldTailNi, newTailNi, oldTailPp);
                if (newHeadPp == null || newTailPp == null) continue;
                ArcProto newAp = this.figureNewArcProto(ai.getProto(), newTech, newHeadPp, newTailPp);
                boolean fixAng = ai.isFixedAngle();
                double newWid = 0.0;
                if (newAp == Generic.tech.universal_arc) {
                    fixAng = false;
                } else {
                    double defwid = ai.getProto().getDefaultWidth() - ai.getProto().getWidthOffset();
                    double curwid = ai.getWidth() - ai.getProto().getWidthOffset();
                    newWid = (newAp.getDefaultWidth() - newAp.getWidthOffset()) * curwid / defwid + newAp.getWidthOffset();
                    if (newWid <= 0.0) {
                        newWid = newAp.getDefaultWidth();
                    }
                }
                EPoint pHead = ai.getHeadLocation();
                EPoint pTail = ai.getTailLocation();
                PortInst newHeadPi = newHeadNi.findPortInstFromProto(newHeadPp);
                PortInst newTailPi = newTailNi.findPortInstFromProto(newTailPp);
                Poly newHeadPoly = newHeadPi.getPoly();
                Poly newTailPoly = newTailPi.getPoly();
                if (!newHeadPoly.contains(pHead) || !newTailPoly.contains(pTail)) {
                    if (!newHeadPoly.contains(pHead)) {
                        ((Point2D)pHead).setLocation(newHeadPoly.getCenterX(), newHeadPoly.getCenterY());
                    }
                    if (fixAng) {
                        Rectangle2D headBounds = newHeadPoly.getBounds2D();
                        Rectangle2D tailBounds = newTailPoly.getBounds2D();
                        Point2D[] newPoints = GenMath.arcconnects(ai.getAngle(), headBounds, tailBounds);
                        if (newPoints != null) {
                            ((Point2D)pHead).setLocation(newPoints[0].getX(), newPoints[0].getY());
                            ((Point2D)pTail).setLocation(newPoints[1].getX(), newPoints[1].getY());
                        }
                    }
                }
                if ((newAi = ArcInst.makeInstance(newAp, newWid, newHeadPi, newTailPi, pHead, pTail, ai.getName())) == null) {
                    System.out.println("Cell " + newCell.describe(true) + ": can't run " + newAp + " from " + newHeadNi + " " + newHeadPp + " at (" + ((Point2D)pHead).getX() + "," + ((Point2D)pHead).getY() + ") to " + newTailNi + " " + newTailPp + " at (" + ((Point2D)pTail).getX() + "," + ((Point2D)pTail).getY() + ")");
                    continue;
                }
                newAi.copyPropertiesFrom(ai);
                if (newAp != Generic.tech.universal_arc) continue;
                ai.setFixedAngle(false);
                ai.setRigid(false);
            }
        }

        private NodeProto figureNewNodeProto(NodeInst oldni, Technology newTech) {
            NodeProto oldNp = oldni.getProto();
            if (oldNp instanceof Cell || oldNp.getTechnology() == newTech) {
                return oldNp;
            }
            PrimitiveNode.Function type = oldni.getFunction();
            if (type == PrimitiveNode.Function.NODE) {
                PrimitiveNode np = (PrimitiveNode)oldNp;
                Technology.NodeLayer[] nodeLayers = np.getLayers();
                Layer layer = nodeLayers[0].getLayer();
                Layer.Function fun = layer.getFunction();
                Iterator it = newTech.getNodes();
                while (it.hasNext()) {
                    Technology.NodeLayer[] oNodeLayers;
                    Layer oLayer;
                    Layer.Function oFun;
                    PrimitiveNode oNp = (PrimitiveNode)it.next();
                    if (oNp.getFunction() != PrimitiveNode.Function.NODE || fun != (oFun = (oLayer = (oNodeLayers = oNp.getLayers())[0].getLayer()).getFunction())) continue;
                    return oNp;
                }
            }
            int i = 0;
            PrimitiveNode rNp = null;
            Iterator it = newTech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                if (np.getFunction() != type) continue;
                rNp = np;
                ++i;
            }
            if (i == 1) {
                return rNp;
            }
            if (i > 1) {
                PrimitiveNode pOldNp = (PrimitiveNode)oldNp;
                PrimitivePort pOldPp = (PrimitivePort)pOldNp.getPort(0);
                ArcProto[] oldConnections = pOldPp.getConnections();
                Iterator it2 = newTech.getNodes();
                while (it2.hasNext()) {
                    PrimitiveNode pNewNp = (PrimitiveNode)it2.next();
                    if (pNewNp.getFunction() != type) continue;
                    PrimitivePort pNewPp = (PrimitivePort)pNewNp.getPort(0);
                    ArcProto[] newConnections = pNewPp.getConnections();
                    boolean oldMatches = true;
                    for (int j = 0; j < oldConnections.length; ++j) {
                        ArcProto oap = oldConnections[j];
                        if (oap.getTechnology() == Generic.tech) continue;
                        boolean foundNew = false;
                        for (int k = 0; k < newConnections.length; ++k) {
                            ArcProto ap = newConnections[k];
                            if (ap.getTechnology() == Generic.tech || ap.getFunction() != oap.getFunction()) continue;
                            foundNew = true;
                            break;
                        }
                        if (foundNew) continue;
                        oldMatches = false;
                        break;
                    }
                    if (!oldMatches) continue;
                    rNp = pNewNp;
                    i = 1;
                    break;
                }
            }
            return rNp;
        }

        private void placeLayoutNode(NodeInst ni, NodeProto newNp, Cell newCell) {
            double newXSize = 0.0;
            double newYSize = 0.0;
            if (newNp instanceof PrimitiveNode) {
                PrimitiveNode pNewNp = (PrimitiveNode)newNp;
                PrimitiveNode pOldNp = (PrimitiveNode)ni.getProto();
                newXSize = pNewNp.getDefWidth() + ni.getXSize() - pOldNp.getDefWidth();
                newYSize = pNewNp.getDefHeight() + ni.getYSize() - pOldNp.getDefHeight();
            } else {
                Cell np = (Cell)newNp;
                Rectangle2D bounds = np.getBounds();
                newXSize = bounds.getWidth();
                newYSize = bounds.getHeight();
            }
            NodeInst newNi = NodeInst.makeInstance(newNp, ni.getAnchorCenter(), newXSize, newYSize, newCell, ni.getOrient(), ni.getName(), ni.getTechSpecific());
            if (newNi == null) {
                System.out.println("Could not create " + newNp + " in " + newCell);
                return;
            }
            this.convertedNodes.put(ni, newNi);
            newNi.copyStateBits(ni);
            newNi.copyVarsFrom(ni);
            Iterator it = ni.getExports();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                PortProto pp = this.convertPortProto(ni, newNi, e.getOriginalPort().getPortProto());
                PortInst pi = newNi.findPortInstFromProto(pp);
                Export pp2 = Export.newInstance(newCell, pi, e.getName());
                if (pp2 == null) {
                    return;
                }
                pp2.setCharacteristic(e.getCharacteristic());
                pp2.copyTextDescriptorFrom(e, Export.EXPORT_NAME_TD);
                pp2.copyVarsFrom(e);
            }
        }

        private ArcProto figureNewArcProto(ArcProto oldAp, Technology newTech, PortProto headPp, PortProto tailPp) {
            if (oldAp != Schematics.tech.wire_arc) {
                ArcProto.Function type = oldAp.getFunction();
                Iterator it = newTech.getArcs();
                while (it.hasNext()) {
                    ArcProto newAp = (ArcProto)it.next();
                    if (newAp.getFunction() != type) continue;
                    return newAp;
                }
            }
            HashSet<ArcProto> possibleArcs = new HashSet<ArcProto>();
            ArcProto[] headArcs = headPp.getBasePort().getConnections();
            ArcProto[] tailArcs = tailPp.getBasePort().getConnections();
            block1: for (int i = 0; i < headArcs.length; ++i) {
                if (headArcs[i].getTechnology() == Generic.tech) continue;
                for (int j = 0; j < tailArcs.length; ++j) {
                    if (tailArcs[j].getTechnology() == Generic.tech || headArcs[i] != tailArcs[j]) continue;
                    possibleArcs.add(headArcs[i]);
                    continue block1;
                }
            }
            Iterator it = newTech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = (ArcProto)it.next();
                if (!possibleArcs.contains(ap)) continue;
                return ap;
            }
            System.out.println("No equivalent arc for " + oldAp);
            return Generic.tech.universal_arc;
        }

        private PortProto convertPortProto(NodeInst ni, NodeInst newNi, PortProto oldPp) {
            if (newNi.getProto() instanceof Cell) {
                PortProto pp = newNi.getProto().findPortProto(oldPp.getName());
                if (pp != null) {
                    return pp;
                }
                System.out.println("Cannot find export " + oldPp.getName() + " in " + newNi.getProto());
                return newNi.getProto().getPort(0);
            }
            int numNewPorts = newNi.getProto().getNumPorts();
            if (numNewPorts == 0) {
                return null;
            }
            if (numNewPorts == 1) {
                return newNi.getProto().getPort(0);
            }
            Iterator oldPortIt = ni.getProto().getPorts();
            Iterator newPortIt = newNi.getProto().getPorts();
            while (oldPortIt.hasNext() && newPortIt.hasNext()) {
                PortProto pp = (PortProto)oldPortIt.next();
                PortProto newPp = (PortProto)newPortIt.next();
                if (pp != oldPp) continue;
                return newPp;
            }
            PrimitiveNode.Function oldFun = ni.getFunction();
            PrimitiveNode.Function newFun = newNi.getFunction();
            if (oldFun == PrimitiveNode.Function.CAPAC && newFun == PrimitiveNode.Function.ECAPAC) {
                return newNi.getProto().getPort(0);
            }
            System.out.println("No port association between " + ni.getProto() + ", " + oldPp + " and " + newNi.getProto());
            return newNi.getProto().getPort(0);
        }
    }

    private static class MakeSchematicView
    extends Job {
        private static boolean reverseIconExportOrder;
        private Cell oldCell;

        protected MakeSchematicView(Cell cell) {
            super("Make Schematic View", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.oldCell = cell;
            this.startJob();
        }

        public boolean doIt() {
            Cell newCell = ViewChanges.convertSchematicCell(this.oldCell);
            if (newCell == null) {
                return false;
            }
            WindowFrame.createEditWindow(newCell);
            return true;
        }
    }

    private static class MakeIconView
    extends Job {
        private Cell curCell;

        protected MakeIconView(Cell cell) {
            super("Make Icon View", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.startJob();
        }

        public boolean doIt() {
            EditWindow wnd;
            int response;
            Library lib = this.curCell.getLibrary();
            if (!this.curCell.isSchematic()) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "The current cell must be a schematic in order to generate an icon", "Icon creation failed", 0);
                return false;
            }
            Cell iconCell = this.curCell.iconView();
            if (iconCell != null && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Warning: Icon " + iconCell.describe(true) + " already exists.  Create a new version?")) != 0) {
                return false;
            }
            iconCell = ViewChanges.makeIconForCell(this.curCell);
            if (iconCell == null) {
                return false;
            }
            int exampleLocation = User.getIconGenInstanceLocation();
            Point2D.Double iconPos = new Point2D.Double(0.0, 0.0);
            Rectangle2D cellBounds = this.curCell.getBounds();
            Rectangle2D iconBounds = iconCell.getBounds();
            double halfWidth = iconBounds.getWidth() / 2.0;
            double halfHeight = iconBounds.getHeight() / 2.0;
            switch (exampleLocation) {
                case 0: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMaxX() + halfWidth, cellBounds.getMaxY() + halfHeight);
                    break;
                }
                case 1: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMaxY() + halfHeight);
                    break;
                }
                case 2: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMaxX() + halfWidth, cellBounds.getMinY() - halfHeight);
                    break;
                }
                case 3: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMinY() - halfHeight);
                }
            }
            EditWindow.gridAlign(iconPos);
            double px = iconCell.getBounds().getWidth();
            double py = iconCell.getBounds().getHeight();
            NodeInst ni = NodeInst.makeInstance(iconCell, iconPos, px, py, this.curCell);
            if (ni != null && (wnd = EditWindow.getCurrent()) != null && wnd.getCell() == this.curCell) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                highlighter.addElectricObject(ni, this.curCell);
                highlighter.finished();
            }
            return true;
        }
    }

    private static class MakeSkeletonView
    extends Job {
        private Cell curCell;

        protected MakeSkeletonView(Cell curCell) {
            super("Make Skeleton View", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.startJob();
        }

        public boolean doIt() {
            String skeletonCellName = this.curCell.getName() + "{lay.sk}";
            Cell skeletonCell = Cell.makeInstance(this.curCell.getLibrary(), skeletonCellName);
            if (skeletonCell == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create Skeleton cell " + skeletonCellName, "Skeleton creation failed", 0);
                return false;
            }
            boolean error = ViewChanges.skeletonizeCell(this.curCell, skeletonCell);
            if (error) {
                return false;
            }
            System.out.println("Cell " + skeletonCell.describe(true) + " created with a skeletal representation of " + this.curCell);
            WindowFrame.createEditWindow(skeletonCell);
            return true;
        }
    }

    private static class ChangeCellView
    extends Job {
        Cell cell;
        View newView;

        protected ChangeCellView(Cell cell, View newView) {
            super("Change View of " + cell + " to " + newView.getFullName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newView = newView;
            this.startJob();
        }

        public boolean doIt() {
            this.cell.setView(this.newView);
            this.cell.setTechnology(null);
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                if (wf.getContent().getCell() != this.cell) continue;
                wf.getContent().setCell(this.cell, VarContext.globalContext);
            }
            EditWindow.repaintAll();
            return true;
        }
    }

    private static class FixOldMultiPageSchematics
    extends Job {
        private List multiPageCells;

        protected FixOldMultiPageSchematics(List multiPageCells) {
            super("Repair old-style Multi-Page Schematics", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.multiPageCells = multiPageCells;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.multiPageCells.iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                int pageNo = TextUtils.atoi(cell.getView().getFullName().substring(15));
                String destCellName = cell.getName() + "{sch}";
                Cell destCell = cell.getLibrary().findNodeProto(destCellName);
                if (pageNo == 1 || destCell == null) {
                    destCell = Cell.makeInstance(cell.getLibrary(), destCellName);
                    if (destCell == null) {
                        System.out.println("Unable to create cell " + cell.getLibrary().getName() + ":" + destCellName);
                        return false;
                    }
                    destCell.setMultiPage(true);
                    destCell.newVar(User.FRAME_SIZE, (Object)"d");
                }
                double dY = (pageNo - 1) * 1000;
                ArrayList<Geometric> pasteList = new ArrayList<Geometric>();
                Iterator nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = (NodeInst)nIt.next();
                    pasteList.add(ni);
                }
                Iterator aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = (ArcInst)aIt.next();
                    pasteList.add(ai);
                }
                Clipboard.copyListToCell(null, pasteList, cell, destCell, new Point2D.Double(0.0, dY), true, true);
                Iterator vIt = cell.getVariables();
                while (vIt.hasNext()) {
                    Variable cellVar;
                    Variable var = (Variable)vIt.next();
                    if (!var.isDisplay() || (cellVar = destCell.newVar(var.getKey(), var.getObject())) == null) continue;
                    cellVar.setTextDescriptor(var.getTextDescriptor());
                    cellVar.setOff(cellVar.getXOff(), cellVar.getYOff() + dY);
                }
                cell.kill();
            }
            return true;
        }
    }
}

