/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GetInfoMulti
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static final int CHANGEXSIZE = 1;
    private static final int CHANGEYSIZE = 2;
    private static final int CHANGEXPOS = 3;
    private static final int CHANGEYPOS = 4;
    private static final int CHANGEROTATION = 5;
    private static final int CHANGEMIRRORLR = 6;
    private static final int CHANGEMIRRORUD = 7;
    private static final int CHANGEEXPANDED = 8;
    private static final int CHANGEEASYSELECT = 9;
    private static final int CHANGEINVOUTSIDECELL = 10;
    private static final int CHANGELOCKED = 11;
    private static final int CHANGEWIDTH = 12;
    private static final int CHANGERIGID = 13;
    private static final int CHANGEFIXANGLE = 14;
    private static final int CHANGESLIDABLE = 15;
    private static final int CHANGEEXTENSION = 16;
    private static final int CHANGEDIRECTION = 17;
    private static final int CHANGENEGATION = 18;
    private static final int CHANGECHARACTERISTICS = 19;
    private static final int CHANGEBODYONLY = 20;
    private static final int CHANGEALWAYSDRAWN = 21;
    private static final int CHANGEPOINTSIZE = 22;
    private static final int CHANGEUNITSIZE = 23;
    private static final int CHANGEXOFF = 24;
    private static final int CHANGEYOFF = 25;
    private static final int CHANGETEXTROT = 26;
    private static final int CHANGEANCHOR = 27;
    private static final int CHANGEFONT = 28;
    private static final int CHANGECOLOR = 29;
    private static final int CHANGEBOLD = 30;
    private static final int CHANGEITALIC = 31;
    private static final int CHANGEUNDERLINE = 32;
    private static final int CHANGECODE = 33;
    private static final int CHANGEUNITS = 34;
    private static final int CHANGESHOW = 35;
    private static GetInfoMulti theDialog = null;
    private DefaultListModel listModel;
    private JList list;
    private JPanel changePanel;
    private int[] currentChangeTypes;
    private JComponent[] currentChangeValues;
    private List highlightList = new ArrayList();
    List nodeList;
    List arcList;
    List exportList;
    List textList;
    private EditWindow wnd;
    private static final int[] nodeChanges = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] arcChanges = new int[]{12, 13, 14, 15, 16, 17, 18, 9};
    private static final int[] exportChanges = new int[]{19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 10};
    private static final int[] textChanges = new int[]{22, 23, 24, 25, 26, 27, 28, 29, 33, 34, 35, 30, 31, 32, 10};
    private static final int[] nodeArcChanges = new int[]{9};
    private static final int[] nodeTextChanges = new int[]{10};
    private static final int[] nodeExportChanges = new int[]{10};
    private static final int[] nodeTextExportChanges = new int[]{10};
    private static final int[] textExportChanges = new int[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 10};
    private static final int[][] changeCombos = new int[][]{null, nodeChanges, arcChanges, nodeArcChanges, exportChanges, nodeExportChanges, null, null, textChanges, nodeTextChanges, null, null, textExportChanges, nodeTextExportChanges, null, null};
    private JButton apply;
    private JButton cancel;
    private JScrollPane listPane;
    private JButton ok;
    private JScrollPane possibleChanges;
    private JButton remove;
    private JButton removeOthers;
    private JLabel selectionCount;

    public static void showDialog() {
        if (theDialog == null) {
            TopLevel jf = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame() : null;
            theDialog = new GetInfoMulti((Frame)jf, false);
        }
        theDialog.loadMultiInfo();
        theDialog.pack();
        theDialog.setVisible(true);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        Dimension oldDim = this.listPane.getSize();
        this.loadMultiInfo();
        this.listPane.setPreferredSize(oldDim);
        this.pack();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadMultiInfo();
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        Iterator it = this.highlightList.iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (!e.objectChanged(h.getElectricObject())) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.loadMultiInfo();
            this.pack();
        }
    }

    private GetInfoMulti(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        Undo.addDatabaseChangeListener(this);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(2);
        this.listPane.setViewportView(this.list);
        this.changePanel = new JPanel();
        this.changePanel.setLayout(new BoxLayout(this.changePanel, 1));
        this.possibleChanges.setViewportView(this.changePanel);
        this.loadMultiInfo();
        this.pack();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void loadMultiInfo() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (this.wnd != curWnd && curWnd != null) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        this.highlightList.clear();
        if (this.wnd != null) {
            Iterator it = this.wnd.getHighlighter().getHighlights().iterator();
            while (it.hasNext()) {
                this.highlightList.add(it.next());
            }
            Collections.sort(this.highlightList, new SortMultipleHighlights());
        }
        this.nodeList = new ArrayList();
        this.arcList = new ArrayList();
        this.exportList = new ArrayList();
        this.textList = new ArrayList();
        Geometric firstGeom = null;
        Geometric secondGeom = null;
        double xPositionLow = Double.MAX_VALUE;
        double xPositionHigh = -1.7976931348623157E308;
        double yPositionLow = Double.MAX_VALUE;
        double yPositionHigh = -1.7976931348623157E308;
        double xSizeLow = Double.MAX_VALUE;
        double xSizeHigh = -1.7976931348623157E308;
        double ySizeLow = Double.MAX_VALUE;
        double ySizeHigh = -1.7976931348623157E308;
        double widthLow = Double.MAX_VALUE;
        double widthHigh = -1.7976931348623157E308;
        this.selectionCount.setText(Integer.toString(this.highlightList.size()) + " selections:");
        this.listModel.clear();
        Iterator it = this.highlightList.iterator();
        while (it.hasNext()) {
            String description;
            Highlight h = (Highlight)it.next();
            ElectricObject eobj = h.getElectricObject();
            if (h.getType() == Highlight.Type.EOBJ) {
                description = "";
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (eobj instanceof Geometric) {
                    if (firstGeom == null) {
                        firstGeom = (Geometric)eobj;
                    } else if (secondGeom == null) {
                        secondGeom = (Geometric)eobj;
                    }
                }
                if (eobj instanceof NodeInst) {
                    NodeInst ni = (NodeInst)eobj;
                    this.nodeList.add(ni);
                    xPositionLow = Math.min(xPositionLow, ni.getAnchorCenterX());
                    xPositionHigh = Math.max(xPositionHigh, ni.getAnchorCenterX());
                    yPositionLow = Math.min(yPositionLow, ni.getAnchorCenterY());
                    yPositionHigh = Math.max(yPositionHigh, ni.getAnchorCenterY());
                    SizeOffset so = ni.getSizeOffset();
                    double xVal = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                    double yVal = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                    if (ni.getAngle() == 900 || ni.getAngle() == 2700) {
                        double swap = xVal;
                        xVal = yVal;
                        yVal = swap;
                    }
                    xSizeLow = Math.min(xSizeLow, xVal);
                    xSizeHigh = Math.max(xSizeHigh, xVal);
                    ySizeLow = Math.min(ySizeLow, yVal);
                    ySizeHigh = Math.max(ySizeHigh, yVal);
                    description = "Node " + ni.describe(true);
                } else if (eobj instanceof ArcInst) {
                    ArcInst ai = (ArcInst)eobj;
                    this.arcList.add(ai);
                    double trueWidth = ai.getWidth() - ai.getProto().getWidthOffset();
                    widthLow = Math.min(widthLow, trueWidth);
                    widthHigh = Math.max(widthHigh, trueWidth);
                    description = "Arc " + ai.describe(true);
                }
                this.listModel.addElement(description);
                continue;
            }
            if (h.getType() == Highlight.Type.TEXT) {
                description = "Text: unknown";
                if (h.getVar() != null) {
                    description = "Text: " + h.getVar().getFullDescription(eobj);
                    this.textList.add(h);
                } else if (h.getName() != null) {
                    if (eobj instanceof NodeInst) {
                        description = "Node name for " + ((NodeInst)eobj).describe(true);
                    } else if (eobj instanceof ArcInst) {
                        description = "Arc name for " + ((ArcInst)eobj).describe(true);
                    }
                    this.textList.add(h);
                } else if (eobj instanceof Export) {
                    description = "Text: Export '" + ((Export)eobj).getName() + "'";
                    this.exportList.add((Export)eobj);
                } else if (eobj instanceof NodeInst) {
                    description = "Text: Cell instance name " + ((NodeInst)eobj).describe(true);
                    this.textList.add(h);
                }
                this.listModel.addElement(description);
                continue;
            }
            if (h.getType() == Highlight.Type.LINE) {
                Point2D pt1 = h.getLineStart();
                Point2D pt2 = h.getLineEnd();
                String description2 = "Line from (" + pt1.getX() + "," + pt1.getY() + ") to (" + pt2.getX() + "," + pt2.getY() + ")";
                this.listModel.addElement(description2);
                continue;
            }
            if (h.getType() != Highlight.Type.BBOX) continue;
            Rectangle2D bounds = h.getBounds();
            String description3 = "Area from " + bounds.getMinX() + "<=X<=" + bounds.getMaxX() + " and " + bounds.getMinY() + "<=Y<=" + bounds.getMaxY();
            this.listModel.addElement(description3);
        }
        if (this.nodeList.size() + this.arcList.size() == 2) {
            this.listModel.addElement("---------------------------");
            Point2D firstPt = firstGeom.getTrueCenter();
            if (firstGeom instanceof NodeInst) {
                firstPt = ((NodeInst)firstGeom).getAnchorCenter();
            }
            Point2D secondPt = secondGeom.getTrueCenter();
            if (secondGeom instanceof NodeInst) {
                secondPt = ((NodeInst)secondGeom).getAnchorCenter();
            }
            this.listModel.addElement("Distance between centers: X=" + Math.abs(firstPt.getX() - secondPt.getX()) + " Y=" + Math.abs(firstPt.getY() - secondPt.getY()));
        }
        int index = 0;
        if (this.nodeList.size() != 0) {
            ++index;
        }
        if (this.arcList.size() != 0) {
            index += 2;
        }
        if (this.exportList.size() != 0) {
            index += 4;
        }
        if (this.textList.size() != 0) {
            index += 8;
        }
        this.changePanel.removeAll();
        this.currentChangeTypes = changeCombos[index];
        if (this.currentChangeTypes == null) {
            return;
        }
        this.currentChangeValues = new JComponent[this.currentChangeTypes.length];
        if (this.currentChangeTypes != null) {
            for (int c = 0; c < this.currentChangeTypes.length; ++c) {
                int change = this.currentChangeTypes[c];
                JPanel onePanel = new JPanel();
                onePanel.setLayout(new GridBagLayout());
                String msg = null;
                switch (change) {
                    case 1: {
                        msg = xSizeLow == xSizeHigh ? "(All are " + TextUtils.formatDouble(xSizeLow) + ")" : "(" + TextUtils.formatDouble(xSizeLow) + " to " + TextUtils.formatDouble(xSizeHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("X size:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case 2: {
                        msg = ySizeLow == ySizeHigh ? "(All are " + TextUtils.formatDouble(ySizeLow) + ")" : "(" + TextUtils.formatDouble(ySizeLow) + " to " + TextUtils.formatDouble(ySizeHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Y size:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case 3: {
                        msg = xPositionLow == xPositionHigh ? "(All are " + TextUtils.formatDouble(xPositionLow) + ")" : "(" + TextUtils.formatDouble(xPositionLow) + " to " + TextUtils.formatDouble(xPositionHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("X position:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case 4: {
                        msg = yPositionLow == yPositionHigh ? "(All are " + TextUtils.formatDouble(yPositionLow) + ")" : "(" + TextUtils.formatDouble(yPositionLow) + " to " + TextUtils.formatDouble(yPositionHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Y position:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case 5: {
                        this.currentChangeValues[c] = new JTextField();
                        this.addChangePossibility("Rotation:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 6: {
                        JComboBox<String> lr = new JComboBox<String>();
                        lr.addItem("Leave alone");
                        lr.addItem("Set");
                        lr.addItem("Clear");
                        this.currentChangeValues[c] = lr;
                        this.addChangePossibility("Mirror L-R:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 7: {
                        JComboBox<String> ud = new JComboBox<String>();
                        ud.addItem("Leave alone");
                        ud.addItem("Set");
                        ud.addItem("Clear");
                        this.currentChangeValues[c] = ud;
                        this.addChangePossibility("Mirror U-D:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 8: {
                        JComboBox<String> exp = new JComboBox<String>();
                        exp.addItem("Leave alone");
                        exp.addItem("Expand");
                        exp.addItem("Unexpand");
                        this.currentChangeValues[c] = exp;
                        this.addChangePossibility("Expansion:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 9: {
                        JComboBox<String> es = new JComboBox<String>();
                        es.addItem("Leave alone");
                        es.addItem("Make Easy");
                        es.addItem("Make Hard");
                        this.currentChangeValues[c] = es;
                        this.addChangePossibility("Ease of Selection:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 10: {
                        JComboBox<String> io = new JComboBox<String>();
                        io.addItem("Leave alone");
                        io.addItem("Make Invisible");
                        io.addItem("Make Visible");
                        this.currentChangeValues[c] = io;
                        this.addChangePossibility("Invisible Outside Cell:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 11: {
                        JComboBox<String> lo = new JComboBox<String>();
                        lo.addItem("Leave alone");
                        lo.addItem("Lock");
                        lo.addItem("Unlock");
                        this.currentChangeValues[c] = lo;
                        this.addChangePossibility("Locked:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 12: {
                        msg = widthLow == widthHigh ? "(All are " + TextUtils.formatDouble(widthLow) + ")" : "(" + TextUtils.formatDouble(widthLow) + " to " + TextUtils.formatDouble(widthHigh) + ")";
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Width:", this.currentChangeValues[c], msg, onePanel);
                        break;
                    }
                    case 13: {
                        JComboBox<String> ri = new JComboBox<String>();
                        ri.addItem("Leave alone");
                        ri.addItem("Make Rigid");
                        ri.addItem("Make Unrigid");
                        this.currentChangeValues[c] = ri;
                        this.addChangePossibility("Rigid:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 14: {
                        JComboBox<String> fa = new JComboBox<String>();
                        fa.addItem("Leave alone");
                        fa.addItem("Make Fixed Angle");
                        fa.addItem("Make Not Fixed Angle");
                        this.currentChangeValues[c] = fa;
                        this.addChangePossibility("Fixed Angle:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 15: {
                        JComboBox<String> sl = new JComboBox<String>();
                        sl.addItem("Leave alone");
                        sl.addItem("Make Slidable");
                        sl.addItem("Make Not Slidable");
                        this.currentChangeValues[c] = sl;
                        this.addChangePossibility("Slidable:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 16: {
                        JComboBox<String> ex = new JComboBox<String>();
                        ex.addItem("Leave alone");
                        ex.addItem("Make Both Ends Extend");
                        ex.addItem("Make Neither End Extend");
                        ex.addItem("Make Head Extend");
                        ex.addItem("Make Tail Extend");
                        this.currentChangeValues[c] = ex;
                        this.addChangePossibility("Extension:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 17: {
                        JComboBox<String> di = new JComboBox<String>();
                        di.addItem("Leave alone");
                        di.addItem("No directional arrow");
                        di.addItem("Arrow on Head and Body");
                        di.addItem("Arrow on Tail and Body");
                        di.addItem("Arrow on Body Only");
                        di.addItem("Arrow on Head, Tail, and Body");
                        this.currentChangeValues[c] = di;
                        this.addChangePossibility("Directionality:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 18: {
                        JComboBox<String> ne = new JComboBox<String>();
                        ne.addItem("Leave alone");
                        ne.addItem("No Negation");
                        ne.addItem("Negate Head");
                        ne.addItem("Negate Tail");
                        ne.addItem("Negate Head and Tail");
                        this.currentChangeValues[c] = ne;
                        this.addChangePossibility("Negation:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 19: {
                        JComboBox<String> ch = new JComboBox<String>();
                        ch.addItem("Leave alone");
                        List chList = PortCharacteristic.getOrderedCharacteristics();
                        Iterator it2 = chList.iterator();
                        while (it2.hasNext()) {
                            PortCharacteristic chara = (PortCharacteristic)it2.next();
                            ch.addItem(chara.getName());
                        }
                        this.currentChangeValues[c] = ch;
                        this.addChangePossibility("Characteristics:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 20: {
                        JComboBox<String> bo = new JComboBox<String>();
                        bo.addItem("Leave alone");
                        bo.addItem("Make Body Only");
                        bo.addItem("Make Not Body Only");
                        this.currentChangeValues[c] = bo;
                        this.addChangePossibility("Body Only:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 21: {
                        JComboBox<String> ad = new JComboBox<String>();
                        ad.addItem("Leave alone");
                        ad.addItem("Make Always Drawn");
                        ad.addItem("Make Not Always Drawn");
                        this.currentChangeValues[c] = ad;
                        this.addChangePossibility("Always Drawn:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 22: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Point Size:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 23: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Unit Size:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 24: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("X Offset:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 25: {
                        this.currentChangeValues[c] = new JTextField("");
                        this.addChangePossibility("Y Offset:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 26: {
                        JComboBox<String> tr = new JComboBox<String>();
                        tr.addItem("Leave alone");
                        tr.addItem("No Rotation");
                        tr.addItem("Rotate 90 Degrees");
                        tr.addItem("Rotate 180 Degrees");
                        tr.addItem("Rotate 270 Degrees");
                        this.currentChangeValues[c] = tr;
                        this.addChangePossibility("Text Rotation:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 27: {
                        JComboBox<Object> an = new JComboBox<Object>();
                        an.addItem("Leave alone");
                        Iterator it3 = TextDescriptor.Position.getPositions();
                        while (it3.hasNext()) {
                            TextDescriptor.Position pos = (TextDescriptor.Position)it3.next();
                            an.addItem(pos);
                        }
                        this.currentChangeValues[c] = an;
                        this.addChangePossibility("Text Anchor:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 28: {
                        JComboBox<String> fo = new JComboBox<String>();
                        fo.addItem("Leave alone");
                        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                        for (int i = 0; i < fonts.length; ++i) {
                            fo.addItem(fonts[i].getFontName());
                        }
                        this.currentChangeValues[c] = fo;
                        this.addChangePossibility("Text Font:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 29: {
                        JComboBox<String> co = new JComboBox<String>();
                        co.addItem("Leave alone");
                        int[] colorIndices = EGraphics.getColorIndices();
                        for (int i = 0; i < colorIndices.length; ++i) {
                            co.addItem(EGraphics.getColorIndexName(colorIndices[i]));
                        }
                        this.currentChangeValues[c] = co;
                        this.addChangePossibility("Text Color:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 30: {
                        JComboBox<String> bd = new JComboBox<String>();
                        bd.addItem("Leave alone");
                        bd.addItem("Make Bold");
                        bd.addItem("Make Not Bold");
                        this.currentChangeValues[c] = bd;
                        this.addChangePossibility("Bold:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 31: {
                        JComboBox<String> it4 = new JComboBox<String>();
                        it4.addItem("Leave alone");
                        it4.addItem("Make Italic");
                        it4.addItem("Make Not Italic");
                        this.currentChangeValues[c] = it4;
                        this.addChangePossibility("Italic:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 32: {
                        JComboBox<String> ul = new JComboBox<String>();
                        ul.addItem("Leave alone");
                        ul.addItem("Make Underlined");
                        ul.addItem("Make Not Underlined");
                        this.currentChangeValues[c] = ul;
                        this.addChangePossibility("Underlined:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 33: {
                        JComboBox<String> cd = new JComboBox<String>();
                        cd.addItem("Leave alone");
                        Iterator cIt = TextDescriptor.Code.getCodes();
                        while (cIt.hasNext()) {
                            cd.addItem((String)cIt.next());
                        }
                        this.currentChangeValues[c] = cd;
                        this.addChangePossibility("Code:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 34: {
                        JComboBox<String> un = new JComboBox<String>();
                        un.addItem("Leave alone");
                        Iterator uIt = TextDescriptor.Unit.getUnits();
                        while (uIt.hasNext()) {
                            un.addItem((String)uIt.next());
                        }
                        this.currentChangeValues[c] = un;
                        this.addChangePossibility("Units:", this.currentChangeValues[c], null, onePanel);
                        break;
                    }
                    case 35: {
                        JComboBox<String> sh = new JComboBox<String>();
                        sh.addItem("Leave alone");
                        Iterator sIt = TextDescriptor.DispPos.getShowStyles();
                        while (sIt.hasNext()) {
                            sh.addItem((String)sIt.next());
                        }
                        this.currentChangeValues[c] = sh;
                        this.addChangePossibility("Show:", this.currentChangeValues[c], null, onePanel);
                    }
                }
                this.changePanel.add(onePanel);
            }
        }
    }

    private void addChangePossibility(String label, JComponent comp, String msg, JPanel onePanel) {
        int bottom = 4;
        if (msg != null) {
            bottom = 0;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(4, 4, bottom, 4);
        onePanel.add((Component)new JLabel(label), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, bottom, 4);
        onePanel.add((Component)comp, gbc);
        if (msg != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(0, 4, 4, 4);
            onePanel.add((Component)new JLabel(msg), gbc);
        }
    }

    private JComponent findComponentRawValue(int type) {
        for (int c = 0; c < this.currentChangeTypes.length; ++c) {
            int change = this.currentChangeTypes[c];
            if (change != type) continue;
            return this.currentChangeValues[c];
        }
        return null;
    }

    private String findComponentStringValue(int type) {
        for (int c = 0; c < this.currentChangeTypes.length; ++c) {
            int change = this.currentChangeTypes[c];
            if (change != type) continue;
            return ((JTextField)this.currentChangeValues[c]).getText().trim();
        }
        return "";
    }

    private int findComponentIntValue(int type) {
        for (int c = 0; c < this.currentChangeTypes.length; ++c) {
            int change = this.currentChangeTypes[c];
            if (change != type) continue;
            return ((JComboBox)this.currentChangeValues[c]).getSelectedIndex();
        }
        return 0;
    }

    private void initComponents() {
        this.removeOthers = new JButton();
        this.apply = new JButton();
        this.selectionCount = new JLabel();
        this.listPane = new JScrollPane();
        this.ok = new JButton();
        this.remove = new JButton();
        this.cancel = new JButton();
        this.possibleChanges = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Multi-Object Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoMulti.this.closeDialog(evt);
            }
        });
        this.removeOthers.setText("Remove Others");
        this.removeOthers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.removeOthersActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.removeOthers, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.selectionCount.setText("0 selections:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.selectionCount, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(300, 200));
        this.listPane.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.remove.setText("Remove");
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.removeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.remove, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.possibleChanges, gridBagConstraints);
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void removeActionPerformed(ActionEvent evt) {
        int[] items = this.list.getSelectedIndices();
        ArrayList newList = new ArrayList();
        for (int i = 0; i < this.highlightList.size(); ++i) {
            int j;
            for (j = 0; j < items.length && i != items[j]; ++j) {
            }
            if (j < items.length) continue;
            newList.add(this.highlightList.get(i));
        }
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.setHighlightList(newList);
            highlighter.finished();
        }
    }

    private void applyActionPerformed(ActionEvent evt) {
        MultiChange job = new MultiChange(this);
    }

    private void removeOthersActionPerformed(ActionEvent evt) {
        int[] items = this.list.getSelectedIndices();
        ArrayList newList = new ArrayList();
        for (int i = 0; i < this.highlightList.size(); ++i) {
            int j;
            for (j = 0; j < items.length && i != items[j]; ++j) {
            }
            if (j >= items.length) continue;
            newList.add(this.highlightList.get(i));
        }
        this.highlightList = newList;
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.setHighlightList(newList);
            highlighter.finished();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private static class MultiChange
    extends Job {
        GetInfoMulti dialog;

        protected MultiChange(GetInfoMulti dialog) {
            super("Modify Objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            int numNodes = this.dialog.nodeList.size();
            if (numNodes > 0) {
                NodeInst ni;
                String xPos = this.dialog.findComponentStringValue(3);
                String yPos = this.dialog.findComponentStringValue(4);
                String xSize = this.dialog.findComponentStringValue(1);
                String ySize = this.dialog.findComponentStringValue(2);
                String rot = this.dialog.findComponentStringValue(5);
                int lr = this.dialog.findComponentIntValue(6);
                int ud = this.dialog.findComponentIntValue(7);
                int expanded = this.dialog.findComponentIntValue(8);
                int easySelect = this.dialog.findComponentIntValue(9);
                int invisOutside = this.dialog.findComponentIntValue(10);
                int locked = this.dialog.findComponentIntValue(11);
                boolean changes = false;
                Iterator it = this.dialog.nodeList.iterator();
                while (it.hasNext()) {
                    ni = (NodeInst)it.next();
                    if (ni.getProto() instanceof Cell) {
                        if (expanded == 1) {
                            ni.setExpanded();
                            changes = true;
                        } else if (expanded == 2) {
                            ni.clearExpanded();
                            changes = true;
                        }
                    }
                    if (easySelect == 1) {
                        ni.clearHardSelect();
                    } else if (easySelect == 2) {
                        ni.setHardSelect();
                    }
                    if (invisOutside == 1) {
                        ni.setVisInside();
                    } else if (invisOutside == 2) {
                        ni.clearVisInside();
                    }
                    if (locked == 1) {
                        ni.setLocked();
                        continue;
                    }
                    if (locked != 2) continue;
                    ni.clearLocked();
                }
                if (xPos.length() > 0 || yPos.length() > 0 || xSize.length() > 0 || ySize.length() > 0 || rot.length() > 0 || lr != 0 || ud != 0 || changes) {
                    if (rot.length() == 0 && lr == 0 && ud == 0) {
                        NodeInst[] nis = new NodeInst[numNodes];
                        double[] dXP = new double[numNodes];
                        double[] dYP = new double[numNodes];
                        double[] dXS = new double[numNodes];
                        double[] dYS = new double[numNodes];
                        double newXPosition = TextUtils.atof(xPos);
                        double newYPosition = TextUtils.atof(yPos);
                        int i = 0;
                        Iterator it2 = this.dialog.nodeList.iterator();
                        while (it2.hasNext()) {
                            NodeInst ni2 = (NodeInst)it2.next();
                            SizeOffset so = ni2.getSizeOffset();
                            nis[i] = ni2;
                            dXP[i] = xPos.length() == 0 ? 0.0 : newXPosition - ni2.getAnchorCenterX();
                            dYP[i] = yPos.equals("") ? 0.0 : newYPosition - ni2.getAnchorCenterY();
                            String newXSize = xSize;
                            String newYSize = ySize;
                            if (ni2.getAngle() == 900 || ni2.getAngle() == 2700) {
                                String swap = newXSize;
                                newXSize = newYSize;
                                newYSize = swap;
                            }
                            if (newXSize.equals("")) {
                                dXS[i] = 0.0;
                            } else {
                                double trueXSize = TextUtils.atof(newXSize) + so.getHighXOffset() + so.getLowXOffset();
                                dXS[i] = trueXSize - ni2.getXSize();
                            }
                            if (newYSize.equals("")) {
                                dYS[i] = 0.0;
                            } else {
                                double trueYSize = TextUtils.atof(newYSize) + so.getHighYOffset() + so.getLowYOffset();
                                dYS[i] = trueYSize - ni2.getYSize();
                            }
                            ++i;
                        }
                        NodeInst.modifyInstances(nis, dXP, dYP, dXS, dYS);
                    } else {
                        it = this.dialog.nodeList.iterator();
                        while (it.hasNext()) {
                            ni = (NodeInst)it.next();
                            SizeOffset so = ni.getSizeOffset();
                            double dX = 0.0;
                            double dY = 0.0;
                            double dXS = 0.0;
                            double dYS = 0.0;
                            if (xPos.length() > 0) {
                                dX = TextUtils.atof(xPos) - ni.getAnchorCenterX();
                            }
                            if (yPos.length() > 0) {
                                dY = TextUtils.atof(yPos) - ni.getAnchorCenterY();
                            }
                            String newXSize = xSize;
                            String newYSize = ySize;
                            if (ni.getAngle() == 900 || ni.getAngle() == 2700) {
                                String swap = newXSize;
                                newXSize = newYSize;
                                newYSize = swap;
                            }
                            if (newXSize.length() > 0) {
                                double trueXSize = TextUtils.atof(newXSize) + so.getHighXOffset() + so.getLowXOffset();
                                dXS = trueXSize - ni.getXSize();
                            }
                            if (newYSize.length() > 0) {
                                double trueYSize = TextUtils.atof(newYSize) + so.getHighYOffset() + so.getLowYOffset();
                                dYS = trueYSize - ni.getYSize();
                            }
                            int dRot = 0;
                            if (rot.length() > 0) {
                                dRot = (TextUtils.atoi(rot) - ni.getAngle() + 3600) % 3600;
                            }
                            boolean dMirrorLR = false;
                            if (lr == 1 && !ni.isXMirrored()) {
                                dMirrorLR = true;
                            } else if (lr == 2 && ni.isXMirrored()) {
                                dMirrorLR = true;
                            }
                            boolean dMirrorUD = false;
                            if (ud == 1 && !ni.isYMirrored()) {
                                dMirrorUD = true;
                            } else if (ud == 2 && ni.isYMirrored()) {
                                dMirrorUD = true;
                            }
                            Orientation orient = Orientation.fromJava(dRot, dMirrorLR, dMirrorUD);
                            ni.modifyInstance(dX, dY, dXS, dYS, orient);
                        }
                    }
                }
            }
            if (this.dialog.arcList.size() > 0) {
                String width = this.dialog.findComponentStringValue(12);
                int rigid = this.dialog.findComponentIntValue(13);
                int fixedangle = this.dialog.findComponentIntValue(14);
                int slidable = this.dialog.findComponentIntValue(15);
                int extension = this.dialog.findComponentIntValue(16);
                int directional = this.dialog.findComponentIntValue(17);
                int negated = this.dialog.findComponentIntValue(18);
                int easySelect = this.dialog.findComponentIntValue(9);
                Iterator it = this.dialog.arcList.iterator();
                while (it.hasNext()) {
                    double newWidth;
                    ArcInst ai = (ArcInst)it.next();
                    if (width.length() > 0 && (newWidth = TextUtils.atof(width) + ai.getProto().getWidthOffset()) != ai.getWidth()) {
                        ai.modify(newWidth - ai.getWidth(), 0.0, 0.0, 0.0, 0.0);
                    }
                    if (rigid == 1) {
                        ai.setRigid(true);
                    } else if (rigid == 2) {
                        ai.setRigid(false);
                    }
                    if (fixedangle == 1) {
                        ai.setFixedAngle(true);
                    } else if (fixedangle == 2) {
                        ai.setFixedAngle(false);
                    }
                    if (slidable == 1) {
                        ai.setSlidable(true);
                    } else if (slidable == 2) {
                        ai.setSlidable(false);
                    }
                    switch (extension) {
                        case 1: {
                            ai.setExtended(1, true);
                            ai.setExtended(0, true);
                            break;
                        }
                        case 2: {
                            ai.setExtended(1, false);
                            ai.setExtended(0, false);
                            break;
                        }
                        case 3: {
                            ai.setExtended(1, true);
                            ai.setExtended(0, false);
                            break;
                        }
                        case 4: {
                            ai.setExtended(1, false);
                            ai.setExtended(0, true);
                        }
                    }
                    switch (directional) {
                        case 1: {
                            ai.setArrowed(1, false);
                            ai.setArrowed(0, false);
                            ai.setBodyArrowed(false);
                            break;
                        }
                        case 2: {
                            ai.setArrowed(1, true);
                            ai.setArrowed(0, false);
                            ai.setBodyArrowed(true);
                            break;
                        }
                        case 3: {
                            ai.setArrowed(1, false);
                            ai.setArrowed(0, true);
                            ai.setBodyArrowed(true);
                            break;
                        }
                        case 4: {
                            ai.setArrowed(1, false);
                            ai.setArrowed(0, false);
                            ai.setBodyArrowed(true);
                            break;
                        }
                        case 5: {
                            ai.setArrowed(1, true);
                            ai.setArrowed(0, true);
                            ai.setBodyArrowed(true);
                        }
                    }
                    switch (negated) {
                        case 1: {
                            ai.setNegated(1, false);
                            ai.setNegated(0, false);
                            break;
                        }
                        case 2: {
                            ai.setNegated(1, true);
                            ai.setNegated(0, false);
                            break;
                        }
                        case 3: {
                            ai.setNegated(1, false);
                            ai.setNegated(0, true);
                            break;
                        }
                        case 4: {
                            ai.setNegated(1, true);
                            ai.setNegated(0, true);
                        }
                    }
                    if (easySelect == 1) {
                        ai.setHardSelect(false);
                        continue;
                    }
                    if (easySelect != 2) continue;
                    ai.setHardSelect(true);
                }
            }
            if (this.dialog.exportList.size() > 0) {
                int characteristics = this.dialog.findComponentIntValue(19);
                int bodyOnly = this.dialog.findComponentIntValue(20);
                int alwaysDrawn = this.dialog.findComponentIntValue(21);
                String pointSize = this.dialog.findComponentStringValue(22);
                String unitSize = this.dialog.findComponentStringValue(23);
                String xOff = this.dialog.findComponentStringValue(24);
                String yOff = this.dialog.findComponentStringValue(25);
                int textRotation = this.dialog.findComponentIntValue(26);
                int anchor = this.dialog.findComponentIntValue(27);
                int font = this.dialog.findComponentIntValue(28);
                int color = this.dialog.findComponentIntValue(29);
                int bold = this.dialog.findComponentIntValue(30);
                int italic = this.dialog.findComponentIntValue(31);
                int underline = this.dialog.findComponentIntValue(32);
                int invisOutside = this.dialog.findComponentIntValue(10);
                Iterator it = this.dialog.exportList.iterator();
                while (it.hasNext()) {
                    Export e = (Export)it.next();
                    if (characteristics != 0) {
                        JComboBox chBox = (JComboBox)this.dialog.findComponentRawValue(19);
                        String charName = (String)chBox.getSelectedItem();
                        PortCharacteristic ch = PortCharacteristic.findCharacteristic(charName);
                        e.setCharacteristic(ch);
                    }
                    if (bodyOnly == 1) {
                        e.setBodyOnly();
                    } else if (bodyOnly == 2) {
                        e.clearBodyOnly();
                    }
                    if (alwaysDrawn == 1) {
                        e.setAlwaysDrawn();
                    } else if (alwaysDrawn == 2) {
                        e.clearAlwaysDrawn();
                    }
                    MutableTextDescriptor td = e.getMutableTextDescriptor(Export.EXPORT_NAME_TD);
                    boolean tdChanged = false;
                    if (pointSize.length() > 0) {
                        td.setAbsSize(TextUtils.atoi(pointSize));
                        tdChanged = true;
                    }
                    if (unitSize.length() > 0) {
                        td.setRelSize(TextUtils.atof(unitSize));
                        tdChanged = true;
                    }
                    if (xOff.length() > 0) {
                        td.setOff(TextUtils.atof(xOff), td.getYOff());
                        tdChanged = true;
                    }
                    if (yOff.length() > 0) {
                        td.setOff(td.getXOff(), TextUtils.atof(yOff));
                        tdChanged = true;
                    }
                    if (textRotation > 0) {
                        switch (textRotation) {
                            case 1: {
                                td.setRotation(TextDescriptor.Rotation.ROT0);
                                break;
                            }
                            case 2: {
                                td.setRotation(TextDescriptor.Rotation.ROT90);
                                break;
                            }
                            case 3: {
                                td.setRotation(TextDescriptor.Rotation.ROT180);
                                break;
                            }
                            case 4: {
                                td.setRotation(TextDescriptor.Rotation.ROT270);
                            }
                        }
                        tdChanged = true;
                    }
                    if (anchor > 0) {
                        JComboBox anBox = (JComboBox)this.dialog.findComponentRawValue(27);
                        TextDescriptor.Position newPosition = (TextDescriptor.Position)anBox.getSelectedItem();
                        td.setPos(newPosition);
                        tdChanged = true;
                    }
                    if (font > 0) {
                        JComboBox foBox = (JComboBox)this.dialog.findComponentRawValue(28);
                        String fontName = (String)foBox.getSelectedItem();
                        TextDescriptor.ActiveFont newFont = TextDescriptor.ActiveFont.findActiveFont(fontName);
                        int newFontIndex = newFont != null ? newFont.getIndex() : 0;
                        td.setFace(newFontIndex);
                        tdChanged = true;
                    }
                    if (color > 0) {
                        JComboBox coBox = (JComboBox)this.dialog.findComponentRawValue(29);
                        int[] colorIndices = EGraphics.getColorIndices();
                        int newColorComboIndex = coBox.getSelectedIndex();
                        int newColorIndex = colorIndices[newColorComboIndex - 1];
                        td.setColorIndex(newColorIndex);
                        tdChanged = true;
                    }
                    if (bold == 1) {
                        td.setBold(true);
                        tdChanged = true;
                    } else if (bold == 2) {
                        td.setBold(false);
                        tdChanged = true;
                    }
                    if (italic == 1) {
                        td.setItalic(true);
                        tdChanged = true;
                    } else if (italic == 2) {
                        td.setItalic(false);
                        tdChanged = true;
                    }
                    if (underline == 1) {
                        td.setUnderline(true);
                        tdChanged = true;
                    } else if (underline == 2) {
                        td.setUnderline(false);
                        tdChanged = true;
                    }
                    if (invisOutside == 1) {
                        td.setInterior(true);
                        tdChanged = true;
                    } else if (invisOutside == 2) {
                        td.setInterior(false);
                        tdChanged = true;
                    }
                    if (!tdChanged) continue;
                    e.setTextDescriptor(Export.EXPORT_NAME_TD, td);
                }
            }
            if (this.dialog.textList.size() > 0) {
                Iterator it = this.dialog.textList.iterator();
                while (it.hasNext()) {
                    Highlight h = (Highlight)it.next();
                    ElectricObject eobj = h.getElectricObject();
                    if (h.getType() != Highlight.Type.TEXT) continue;
                    String descName = null;
                    if (h.getVar() != null) {
                        descName = h.getVar().getKey().getName();
                    } else if (h.getName() != null) {
                        if (eobj instanceof NodeInst) {
                            descName = NodeInst.NODE_NAME_TD;
                        } else if (eobj instanceof ArcInst) {
                            descName = ArcInst.ARC_NAME_TD;
                        }
                    } else if (eobj instanceof NodeInst) {
                        descName = NodeInst.NODE_PROTO_TD;
                    }
                    if (descName == null) continue;
                    MutableTextDescriptor td = eobj.getMutableTextDescriptor(descName);
                    String pointSize = this.dialog.findComponentStringValue(22);
                    String unitSize = this.dialog.findComponentStringValue(23);
                    String xOff = this.dialog.findComponentStringValue(24);
                    String yOff = this.dialog.findComponentStringValue(25);
                    int textRotation = this.dialog.findComponentIntValue(26);
                    int anchor = this.dialog.findComponentIntValue(27);
                    int font = this.dialog.findComponentIntValue(28);
                    int color = this.dialog.findComponentIntValue(29);
                    int code = this.dialog.findComponentIntValue(33);
                    int units = this.dialog.findComponentIntValue(34);
                    int show = this.dialog.findComponentIntValue(35);
                    int bold = this.dialog.findComponentIntValue(30);
                    int italic = this.dialog.findComponentIntValue(31);
                    int underline = this.dialog.findComponentIntValue(32);
                    int invisOutside = this.dialog.findComponentIntValue(10);
                    boolean tdChanged = false;
                    if (pointSize.length() > 0) {
                        td.setAbsSize(TextUtils.atoi(pointSize));
                        tdChanged = true;
                    }
                    if (unitSize.length() > 0) {
                        td.setRelSize(TextUtils.atof(unitSize));
                        tdChanged = true;
                    }
                    if (xOff.length() > 0) {
                        td.setOff(TextUtils.atof(xOff), td.getYOff());
                        tdChanged = true;
                    }
                    if (yOff.length() > 0) {
                        td.setOff(td.getXOff(), TextUtils.atof(yOff));
                        tdChanged = true;
                    }
                    if (textRotation > 0) {
                        switch (textRotation) {
                            case 1: {
                                td.setRotation(TextDescriptor.Rotation.ROT0);
                                break;
                            }
                            case 2: {
                                td.setRotation(TextDescriptor.Rotation.ROT90);
                                break;
                            }
                            case 3: {
                                td.setRotation(TextDescriptor.Rotation.ROT180);
                                break;
                            }
                            case 4: {
                                td.setRotation(TextDescriptor.Rotation.ROT270);
                            }
                        }
                        tdChanged = true;
                    }
                    if (anchor > 0) {
                        JComboBox anBox = (JComboBox)this.dialog.findComponentRawValue(27);
                        TextDescriptor.Position newPosition = (TextDescriptor.Position)anBox.getSelectedItem();
                        td.setPos(newPosition);
                        tdChanged = true;
                    }
                    if (font > 0) {
                        JComboBox foBox = (JComboBox)this.dialog.findComponentRawValue(28);
                        String fontName = (String)foBox.getSelectedItem();
                        TextDescriptor.ActiveFont newFont = TextDescriptor.ActiveFont.findActiveFont(fontName);
                        int newFontIndex = newFont != null ? newFont.getIndex() : 0;
                        td.setFace(newFontIndex);
                        tdChanged = true;
                    }
                    if (color > 0) {
                        JComboBox coBox = (JComboBox)this.dialog.findComponentRawValue(29);
                        int[] colorIndices = EGraphics.getColorIndices();
                        int newColorComboIndex = coBox.getSelectedIndex();
                        int newColorIndex = colorIndices[newColorComboIndex - 1];
                        td.setColorIndex(newColorIndex);
                        tdChanged = true;
                    }
                    if (code > 0) {
                        JComboBox cdBox = (JComboBox)this.dialog.findComponentRawValue(33);
                        TextDescriptor.Code cd = (TextDescriptor.Code)cdBox.getSelectedItem();
                        td.setCode(cd);
                        tdChanged = true;
                    }
                    if (units > 0) {
                        JComboBox unBox = (JComboBox)this.dialog.findComponentRawValue(34);
                        TextDescriptor.Unit un = (TextDescriptor.Unit)unBox.getSelectedItem();
                        td.setUnit(un);
                        tdChanged = true;
                    }
                    if (show > 0) {
                        JComboBox shBox = (JComboBox)this.dialog.findComponentRawValue(35);
                        TextDescriptor.DispPos sh = (TextDescriptor.DispPos)shBox.getSelectedItem();
                        td.setDispPart(sh);
                        tdChanged = true;
                    }
                    if (bold == 1) {
                        td.setBold(true);
                        tdChanged = true;
                    } else if (bold == 2) {
                        td.setBold(false);
                        tdChanged = true;
                    }
                    if (italic == 1) {
                        td.setItalic(true);
                        tdChanged = true;
                    } else if (italic == 2) {
                        td.setItalic(false);
                        tdChanged = true;
                    }
                    if (underline == 1) {
                        td.setUnderline(true);
                        tdChanged = true;
                    } else if (underline == 2) {
                        td.setUnderline(false);
                        tdChanged = true;
                    }
                    if (invisOutside == 1) {
                        td.setInterior(true);
                        tdChanged = true;
                    } else if (invisOutside == 2) {
                        td.setInterior(false);
                        tdChanged = true;
                    }
                    if (!tdChanged) continue;
                    eobj.setTextDescriptor(descName, td);
                }
            }
            return true;
        }
    }

    private static class SortMultipleHighlights
    implements Comparator {
        private SortMultipleHighlights() {
        }

        public int compare(Object o1, Object o2) {
            Highlight h1 = (Highlight)o1;
            Highlight h2 = (Highlight)o2;
            if (h1.getType() != h2.getType()) {
                return h1.getType().getOrder() - h2.getType().getOrder();
            }
            if (h1.getType() != Highlight.Type.EOBJ) {
                return 0;
            }
            ElectricObject e1 = h1.getElectricObject();
            int type1 = 0;
            if (e1 instanceof NodeInst) {
                type1 = 1;
            } else if (e1 instanceof ArcInst) {
                type1 = 2;
            }
            ElectricObject e2 = h2.getElectricObject();
            int type2 = 0;
            if (e2 instanceof NodeInst) {
                type2 = 1;
            } else if (e2 instanceof ArcInst) {
                type2 = 2;
            }
            if (type1 != type2) {
                return type1 - type2;
            }
            String s1 = e1.toString();
            if (e1 instanceof Geometric) {
                s1 = ((Geometric)e1).describe(false);
            }
            String s2 = e2.toString();
            if (e2 instanceof Geometric) {
                s2 = ((Geometric)e2).describe(false);
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

