/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorHighExport;
import com.sun.electric.tool.user.ErrorHighLine;
import com.sun.electric.tool.user.ErrorHighPoint;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLogger
implements Serializable {
    private int errorLimit;
    private List<MessageLog> allErrors;
    private List<WarningLog> allWarnings;
    private boolean limitExceeded;
    private String errorSystem;
    private boolean terminated;
    private boolean persistent;
    private HashMap<Integer, String> sortKeysToGroupNames;

    private static String correctXmlString(String message) {
        String m = message.replaceAll(">", "&gt;");
        m = m.replaceAll("<", "&lt;");
        return m;
    }

    public HashMap<Integer, String> getSortKeyToGroupNames() {
        return this.sortKeysToGroupNames;
    }

    public String getSystem() {
        return this.errorSystem;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public static ErrorLogger newInstance(String system) {
        return ErrorLogger.newInstance(system, false);
    }

    public static ErrorLogger newInstance(String system, boolean persistent) {
        ErrorLogger logger = new ErrorLogger();
        logger.allErrors = new ArrayList<MessageLog>();
        logger.allWarnings = new ArrayList<WarningLog>();
        logger.limitExceeded = false;
        logger.errorSystem = system;
        logger.errorLimit = User.getErrorLimit();
        logger.terminated = false;
        logger.persistent = persistent;
        logger.sortKeysToGroupNames = null;
        return logger;
    }

    public void addMessages(List<MessageLog> messages) {
        if (messages == null) {
            return;
        }
        for (MessageLog m : messages) {
            if (m instanceof WarningLog) {
                this.allWarnings.add((WarningLog)m);
                continue;
            }
            this.allErrors.add(m);
        }
    }

    public void deleteMessages(List<MessageLog> messages) {
        if (messages == null) {
            return;
        }
        for (MessageLog m : messages) {
            if (m instanceof WarningLog) {
                this.allWarnings.remove(m);
                continue;
            }
            this.allErrors.remove(m);
        }
    }

    private synchronized MessageLog logAnError(String message, Cell cell, int sortKey, List<ErrorHighlight> highlights) {
        CellId cellId = cell != null ? cell.getId() : null;
        return this.logAnError(message, cellId, sortKey, highlights);
    }

    private synchronized MessageLog logAnError(String message, CellId cellId, int sortKey, List<ErrorHighlight> highlights) {
        if (this.terminated && !this.persistent) {
            System.out.println("WARNING: " + this.errorSystem + " already terminated, should not log new error");
        }
        if (this.errorLimit > 0 && this.getNumErrors() >= this.errorLimit) {
            if (!this.limitExceeded) {
                System.out.println("WARNING: more than " + this.errorLimit + " errors found, ignoring the rest");
                this.limitExceeded = true;
            }
            return null;
        }
        MessageLog el = new MessageLog(message, cellId, sortKey, highlights);
        this.allErrors.add(el);
        return el;
    }

    public synchronized void logError(String message, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        this.logAnError(message, (CellId)null, sortKey, h);
    }

    public synchronized void logError(String message, Cell cell, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        this.logAnError(message, cell, sortKey, h);
    }

    public synchronized void logError(String message, CellId cellId, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        this.logAnError(message, cellId, sortKey, h);
    }

    public synchronized void logError(String message, Geometric geom, Cell cell, VarContext context, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        h.add(ErrorHighlight.newInstance(context, geom));
        this.logAnError(message, cell, sortKey, h);
    }

    public synchronized void logError(String message, Export pp, int sortKey) {
        Cell cell = pp.getParent();
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        h.add(new ErrorHighExport(null, pp));
        this.logAnError(message, cell, sortKey, h);
    }

    public synchronized void logError(String message, EPoint pt, Cell cell, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        h.add(new ErrorHighPoint(cell, pt));
        this.logAnError(message, cell, sortKey, h);
    }

    public synchronized void logError(String message, PolyBase poly, Cell cell, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            int prev = i - 1;
            if (i == 0) {
                prev = points.length - 1;
            }
            h.add(ErrorHighlight.newInstance(cell, points[prev], points[i]));
        }
        this.logAnError(message, cell, sortKey, h);
    }

    public synchronized void logError(String message, List<Geometric> geomList, List<Export> exportList, Cell cell, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        if (geomList != null) {
            for (Geometric geom : geomList) {
                h.add(ErrorHighlight.newInstance(null, geom));
            }
        }
        if (exportList != null) {
            for (Export e : exportList) {
                h.add(new ErrorHighExport(null, e));
            }
        }
        this.logAnError(message, cell, sortKey, h);
    }

    public synchronized void logError(String message, List<Geometric> geomList, List<Export> exportList, List<EPoint> lineList, List<EPoint> pointList, List<PolyBase> polyList, Cell cell, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        if (geomList != null) {
            for (Geometric geom : geomList) {
                h.add(ErrorHighlight.newInstance(null, geom));
            }
        }
        if (exportList != null) {
            for (Export e : exportList) {
                h.add(new ErrorHighExport(null, e));
            }
        }
        if (lineList != null) {
            for (int i = 0; i < lineList.size(); i += 2) {
                h.add(new ErrorHighLine(cell, lineList.get(i), lineList.get(i + 1), false));
            }
        }
        if (pointList != null) {
            for (EPoint pt : pointList) {
                h.add(new ErrorHighPoint(cell, pt));
            }
        }
        if (polyList != null) {
            for (PolyBase poly : polyList) {
                Point2D[] points = poly.getPoints();
                for (int i = 0; i < points.length; ++i) {
                    int prev = i - 1;
                    if (i == 0) {
                        prev = points.length - 1;
                    }
                    h.add(new ErrorHighLine(cell, new EPoint(points[prev].getX(), points[prev].getY()), new EPoint(points[i].getX(), points[i].getY()), true));
                }
            }
        }
        this.logAnError(message, cell, sortKey, h);
    }

    private synchronized MessageLog logAWarning(String message, Cell cell, int sortKey, List<ErrorHighlight> highlights) {
        if (this.terminated && !this.persistent) {
            System.out.println("WARNING: " + this.errorSystem + " already terminated, should not log new warning");
        }
        if (this.errorLimit > 0 && this.getNumWarnings() >= this.errorLimit) {
            if (!this.limitExceeded) {
                System.out.println("WARNING: more than " + this.errorLimit + " warnings found, ignoring the rest");
                this.limitExceeded = true;
            }
            return null;
        }
        WarningLog el = new WarningLog(message, cell, sortKey, highlights);
        this.allWarnings.add(el);
        return el;
    }

    public synchronized void logWarning(String message, Cell cell, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        this.logAWarning(message, cell, sortKey, h);
    }

    public synchronized void logWarning(String message, Geometric geom, Cell cell, VarContext context, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        h.add(ErrorHighlight.newInstance(context, geom));
        this.logAWarning(message, cell, sortKey, h);
    }

    public synchronized void logWarning(String message, Export pp, Cell cell, VarContext context, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        h.add(new ErrorHighExport(context, pp));
        this.logAWarning(message, cell, sortKey, h);
    }

    public synchronized void logWarning(String message, List<Geometric> geomList, List<Export> exportList, List<EPoint> lineList, List<EPoint> pointList, List<PolyBase> polyList, Cell cell, int sortKey) {
        ArrayList<ErrorHighlight> h = new ArrayList<ErrorHighlight>();
        if (geomList != null) {
            for (Geometric geom : geomList) {
                h.add(ErrorHighlight.newInstance(null, geom));
            }
        }
        if (exportList != null) {
            for (Export e : exportList) {
                h.add(new ErrorHighExport(null, e));
            }
        }
        if (lineList != null) {
            for (int i = 0; i < lineList.size(); i += 2) {
                h.add(new ErrorHighLine(cell, lineList.get(i), lineList.get(i + 1), false));
            }
        }
        if (pointList != null) {
            for (EPoint pt : pointList) {
                h.add(new ErrorHighPoint(cell, pt));
            }
        }
        if (polyList != null) {
            for (PolyBase poly : polyList) {
                Point2D[] points = poly.getPoints();
                for (int i = 0; i < points.length; ++i) {
                    int prev = i - 1;
                    if (i == 0) {
                        prev = points.length - 1;
                    }
                    h.add(new ErrorHighLine(cell, new EPoint(points[prev].getX(), points[prev].getY()), new EPoint(points[i].getX(), points[i].getY()), false));
                }
            }
        }
        this.logAWarning(message, cell, sortKey, h);
    }

    public synchronized int getNumMessages(Cell cell, boolean searchInError) {
        int numErrors = 0;
        if (searchInError) {
            for (int i = 0; i < this.allErrors.size(); ++i) {
                MessageLog el = this.allErrors.get(i);
                if (el.logCellId != cell.getId()) continue;
                ++numErrors;
            }
        } else {
            for (int i = 0; i < this.allWarnings.size(); ++i) {
                MessageLog el = this.allWarnings.get(i);
                if (el.logCellId != cell.getId()) continue;
                ++numErrors;
            }
        }
        return numErrors;
    }

    public synchronized boolean findMessage(Cell cell, Geometric geom1, Cell cell2, Geometric geom2, boolean searchInError) {
        if (searchInError) {
            for (int i = 0; i < this.allErrors.size(); ++i) {
                MessageLog el = this.allErrors.get(i);
                if (!el.findGeometries(geom1, cell, geom2, cell2)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.allWarnings.size(); ++i) {
                MessageLog el = this.allWarnings.get(i);
                if (!el.findGeometries(geom1, cell, geom2, cell2)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void clearAllLogs() {
        this.allErrors.clear();
        this.allWarnings.clear();
    }

    public synchronized ArrayList<MessageLog> getAllLogs(Cell cell) {
        CellId cellId = cell.getId();
        ArrayList<MessageLog> msgLogs = new ArrayList<MessageLog>();
        for (MessageLog messageLog : this.allErrors) {
            if (messageLog.logCellId != cellId) continue;
            msgLogs.add(messageLog);
        }
        for (WarningLog warningLog : this.allWarnings) {
            if (warningLog.logCellId != cellId) continue;
            msgLogs.add(warningLog);
        }
        return msgLogs;
    }

    public synchronized boolean clearLogs(Cell cell) {
        CellId cellId = cell.getId();
        ArrayList<MessageLog> errLogs = new ArrayList<MessageLog>();
        boolean removed = false;
        for (MessageLog log : this.allErrors) {
            if (log.logCellId != cellId) {
                errLogs.add(log);
                continue;
            }
            removed = true;
        }
        this.allErrors = errLogs;
        ArrayList<WarningLog> warndLogs = new ArrayList<WarningLog>();
        for (WarningLog log : this.allWarnings) {
            if (log.logCellId != cellId) {
                warndLogs.add(log);
                continue;
            }
            removed = true;
        }
        this.allWarnings = warndLogs;
        return removed;
    }

    public void exportErrorLogger(String filePath) {
        PrintStream buffWriter = null;
        try {
            buffWriter = new PrintStream(new FileOutputStream(filePath));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error opening " + filePath);
            return;
        }
        buffWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffWriter.println();
        buffWriter.println("<!DOCTYPE ErrorLogger");
        buffWriter.println(" [");
        buffWriter.println(" <!ELEMENT ErrorLogger (GroupLog|MessageLog|WarningLog)*>");
        buffWriter.println(" <!ELEMENT GroupLog (MessageLog|WarningLog)*>");
        buffWriter.println(" <!ELEMENT MessageLog (ERRORTYPEGEOM|ERRORTYPETHICKLINE|ERRORTYPELINE)* >");
        buffWriter.println(" <!ELEMENT WarningLog ANY >");
        buffWriter.println(" <!ELEMENT ERRORTYPEGEOM ANY>");
        buffWriter.println(" <!ELEMENT ERRORTYPELINE ANY>");
        buffWriter.println(" <!ELEMENT ERRORTYPETHICKLINE ANY>");
        buffWriter.println("<!ATTLIST ErrorLogger");
        buffWriter.println("    errorSystem CDATA #REQUIRED");
        buffWriter.println(" >");
        buffWriter.println(" <!ATTLIST GroupLog");
        buffWriter.println("    message CDATA #REQUIRED");
        buffWriter.println(" >");
        buffWriter.println(" <!ATTLIST MessageLog");
        buffWriter.println("    message CDATA #REQUIRED");
        buffWriter.println("    cellName CDATA #REQUIRED");
        buffWriter.println(" >");
        buffWriter.println(" <!ATTLIST WarningLog");
        buffWriter.println("    message CDATA #REQUIRED");
        buffWriter.println("    cellName CDATA #REQUIRED");
        buffWriter.println(" >");
        buffWriter.println(" <!ATTLIST ERRORTYPEGEOM");
        buffWriter.println("    geomName CDATA #REQUIRED");
        buffWriter.println("    cellName CDATA #REQUIRED");
        buffWriter.println(" >");
        buffWriter.println(" <!ATTLIST ERRORTYPETHICKLINE");
        buffWriter.println("    p1 CDATA #REQUIRED");
        buffWriter.println("    p2 CDATA #REQUIRED");
        buffWriter.println("    cellName CDATA #REQUIRED");
        buffWriter.println(" >");
        buffWriter.println(" <!ATTLIST ERRORTYPELINE");
        buffWriter.println("    p1 CDATA #REQUIRED");
        buffWriter.println("    p2 CDATA #REQUIRED");
        buffWriter.println("    cellName CDATA #REQUIRED");
        buffWriter.println(" >");
        buffWriter.println(" ]>");
        buffWriter.println();
        String className = this.getClass().getSimpleName();
        buffWriter.println("<" + className + " errorSystem=\"" + this.errorSystem + "\">");
        if (this.sortKeysToGroupNames != null) {
            Set<Integer> set = this.sortKeysToGroupNames.keySet();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(set.size());
            arrayList.addAll(set);
            Collections.sort(arrayList);
            for (Integer i : arrayList) {
                String groupName = this.sortKeysToGroupNames.get(i);
                buffWriter.println("    <GroupLog message=\"" + ErrorLogger.correctXmlString(groupName) + "\">");
                for (MessageLog messageLog : this.allErrors) {
                    if (messageLog.getSortKey() != i.intValue()) continue;
                    messageLog.xmlDescription(buffWriter);
                }
                for (WarningLog warningLog : this.allWarnings) {
                    if (warningLog.getSortKey() != i.intValue()) continue;
                    warningLog.xmlDescription(buffWriter);
                }
                buffWriter.println("    </GroupLog>");
            }
        } else {
            for (MessageLog messageLog : this.allErrors) {
                messageLog.xmlDescription(buffWriter);
            }
            for (WarningLog warningLog : this.allWarnings) {
                warningLog.xmlDescription(buffWriter);
            }
        }
        buffWriter.println("</" + className + ">");
        buffWriter.close();
    }

    public void setGroupName(int sortKey, String groupName) {
        if (this.sortKeysToGroupNames == null) {
            this.sortKeysToGroupNames = new HashMap();
        }
        this.sortKeysToGroupNames.put(new Integer(sortKey), groupName);
    }

    public String getGroupName(int sortKey) {
        if (this.sortKeysToGroupNames == null) {
            this.sortKeysToGroupNames = new HashMap();
        }
        return this.sortKeysToGroupNames.get(new Integer(sortKey));
    }

    public synchronized void termLogging(boolean explain) {
        Job.getUserInterface().termLogging(this, explain, true);
    }

    public synchronized void termLogging_(boolean terminate) {
        int errs = 0;
        for (MessageLog messageLog : this.allErrors) {
            messageLog.index = ++errs;
        }
        for (WarningLog warningLog : this.allWarnings) {
            warningLog.index = ++errs;
        }
        if (terminate) {
            this.terminated = true;
        }
    }

    public String getInfo() {
        return this.errorSystem + " found " + this.getNumErrors() + " errors, " + this.getNumWarnings() + " warnings!";
    }

    public synchronized void sortLogs() {
        Collections.sort(this.allErrors, new ErrorLogOrder());
        Collections.sort(this.allWarnings, new ErrorLogOrder());
    }

    public synchronized int getNumErrors() {
        return this.allErrors.size();
    }

    public synchronized int getNumWarnings() {
        return this.allWarnings.size();
    }

    public synchronized int getNumLogs() {
        return this.getNumWarnings() + this.getNumErrors();
    }

    public MessageLog getLog(int i) {
        return i < this.allErrors.size() ? this.allErrors.get(i) : (MessageLog)this.allWarnings.get(i - this.allErrors.size());
    }

    public synchronized Iterator<MessageLog> getLogs() {
        ArrayList<MessageLog> copy = new ArrayList<MessageLog>();
        for (MessageLog ml : this.allErrors) {
            copy.add(ml);
        }
        for (WarningLog wl : this.allWarnings) {
            copy.add(wl);
        }
        return copy.iterator();
    }

    public synchronized void deleteLog(int i) {
        if (i < this.allErrors.size()) {
            this.allErrors.remove(i);
        } else {
            this.allWarnings.remove(i - this.allErrors.size());
        }
    }

    public static class XMLParser {
        public ErrorLogger process(URL fileURL, boolean verbose) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                SAXParser parser = factory.newSAXParser();
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                if (verbose) {
                    System.out.println("Parsing XML file \"" + fileURL + "\"");
                }
                XMLHandler handler = new XMLHandler();
                parser.parse(inputStream, (DefaultHandler)handler);
                if (verbose) {
                    System.out.println("End Parsing XML file ...");
                }
                return handler.logger;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private class XMLHandler
        extends DefaultHandler {
            private ErrorLogger logger = null;
            private Cell curCell;
            private String message = "";
            private List<ErrorHighlight> highlights;
            private Set<String> badCellNames = new HashSet<String>();
            private int theSortLayer = -1;
            private int sortGroups = 1;

            XMLHandler() {
            }

            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                System.out.println("It shouldn't reach this point!");
                return null;
            }

            public void endDocument() throws SAXException {
                this.logger.termLogging(true);
            }

            public void endElement(String uri, String localName, String qName) {
                boolean errorLogBody = qName.equals("MessageLog");
                boolean warnLogBody = qName.equals("WarningLog");
                boolean grpLogBody = qName.equals("GroupLog");
                if (errorLogBody || warnLogBody) {
                    int sortLayer = 0;
                    if (this.theSortLayer != -1) {
                        sortLayer = this.theSortLayer;
                    } else if (this.curCell != null) {
                        sortLayer = this.curCell.hashCode();
                    }
                    if (errorLogBody) {
                        this.logger.logAnError(this.message, this.curCell, sortLayer, (List<ErrorHighlight>)this.highlights);
                    } else {
                        this.logger.logAWarning(this.message, this.curCell, sortLayer, this.highlights);
                    }
                    this.message = "";
                } else if (grpLogBody) {
                    this.theSortLayer = -1;
                }
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                boolean loggerBody = qName.equals("ErrorLogger");
                boolean groupBody = qName.equals("GroupLog");
                boolean errorLogBody = qName.equals("MessageLog");
                boolean warnLogBody = qName.equals("WarningLog");
                boolean geoTypeBody = qName.equals("ERRORTYPEGEOM");
                boolean thickLineTypeBody = qName.equals("ERRORTYPETHICKLINE");
                boolean thinLineTypeBody = qName.equals("ERRORTYPELINE");
                if (!(loggerBody || errorLogBody || warnLogBody || geoTypeBody || groupBody || thinLineTypeBody || thickLineTypeBody)) {
                    return;
                }
                String cellName = null;
                String geomName = null;
                String viewName = null;
                String libraryName = null;
                EPoint p1 = null;
                EPoint p2 = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    double y;
                    String[] points;
                    if (attributes.getQName(i).equals("errorSystem")) {
                        this.logger = ErrorLogger.newInstance(attributes.getValue(i));
                        return;
                    }
                    if (attributes.getQName(i).startsWith("message")) {
                        this.message = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("cell")) {
                        String origName = attributes.getValue(i);
                        String[] names = TextUtils.parseString(attributes.getValue(i), "{}");
                        cellName = origName;
                        viewName = names[1];
                        names = TextUtils.parseString(cellName, ":");
                        if (names.length <= 1) continue;
                        libraryName = names[0];
                        cellName = names[1];
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("geom")) {
                        geomName = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("p1")) {
                        points = TextUtils.parseString(attributes.getValue(i), "(,)");
                        double x = Double.parseDouble(points[0]);
                        y = Double.parseDouble(points[1]);
                        p1 = new EPoint(x, y);
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("p2")) {
                        points = TextUtils.parseString(attributes.getValue(i), "(,)");
                        double x = Double.parseDouble(points[0]);
                        y = Double.parseDouble(points[1]);
                        p2 = new EPoint(x, y);
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("center")) continue;
                    new Error("Invalid attribute in XMLParser");
                }
                if (groupBody) {
                    assert (this.message != null);
                    this.theSortLayer = this.sortGroups;
                    this.logger.setGroupName(this.sortGroups++, this.message);
                } else {
                    View view = View.findView(viewName);
                    this.curCell = Library.findCellInLibraries(cellName, view, libraryName);
                    if (!(this.curCell != null && this.curCell.isLinked() || this.badCellNames.contains(cellName))) {
                        this.badCellNames.add(cellName);
                        System.out.println("Cannot find cell: " + cellName);
                    }
                    if (errorLogBody || warnLogBody) {
                        this.highlights = new ArrayList<ErrorHighlight>();
                    } else if (geoTypeBody) {
                        Geometric geom = this.curCell.findNode(geomName);
                        if (geom == null) {
                            geom = this.curCell.findArc(geomName);
                        }
                        if (geom != null) {
                            this.highlights.add(ErrorHighlight.newInstance(null, geom));
                        } else {
                            System.out.println("Invalid geometry " + geomName + " in " + this.curCell);
                        }
                    } else if (thinLineTypeBody || thickLineTypeBody) {
                        this.highlights.add(new ErrorHighLine(this.curCell, p1, p2, thickLineTypeBody));
                    } else {
                        new Error("Invalid attribute in XMLParser");
                    }
                }
            }

            public void fatalError(SAXParseException e) {
                System.out.println("Parser Fatal Error in " + e.getLineNumber() + " " + e.getPublicId() + " " + e.getSystemId());
                e.printStackTrace();
            }

            public void warning(SAXParseException e) {
                System.out.println("Parser Warning in " + e.getLineNumber() + " " + e.getPublicId() + " " + e.getSystemId());
                e.printStackTrace();
            }

            public void error(SAXParseException e) {
                System.out.println("Parser Error in " + e.getLineNumber() + " " + e.getPublicId() + " " + e.getSystemId());
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WarningLog
    extends MessageLog {
        public WarningLog(String message, Cell cell, int sortKey, List<ErrorHighlight> highlights) {
            super(message, cell, sortKey, highlights);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorLogOrder
    implements Comparator<MessageLog> {
        private ErrorLogOrder() {
        }

        @Override
        public int compare(MessageLog el1, MessageLog el2) {
            int sortedKey = el1.sortKey - el2.sortKey;
            if (sortedKey == 0) {
                sortedKey = el1.compareTo(el2);
            }
            return sortedKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageLog
    implements Comparable<MessageLog>,
    Serializable {
        private final String message;
        final CellId logCellId;
        private final int sortKey;
        private final ErrorHighlight[] highlights;
        protected int index;

        public MessageLog(String message, Cell cell, int sortKey, List<ErrorHighlight> highlights) {
            this(message, cell != null ? cell.getId() : null, sortKey, highlights);
        }

        public MessageLog(String message, CellId logCellId, int sortKey, List<ErrorHighlight> highlights) {
            this.message = message;
            this.logCellId = logCellId;
            this.sortKey = sortKey;
            this.highlights = highlights.toArray(ErrorHighlight.NULL_ARRAY);
            this.index = 0;
        }

        public String getMessageString() {
            return this.message;
        }

        public Iterator<ErrorHighlight> getHighlights() {
            return ArrayIterator.iterator(this.highlights);
        }

        public int getSortKey() {
            return this.sortKey;
        }

        @Override
        public int compareTo(MessageLog log1) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.message, log1.message);
        }

        public boolean findGeometries(Geometric geo1, Cell cell1, Geometric geo2, Cell cell2) {
            boolean eh1found = false;
            boolean eh2found = false;
            for (ErrorHighlight eh : this.highlights) {
                if (eh.containsObject(cell1, geo1)) {
                    eh1found = true;
                }
                if (eh.containsObject(cell2, geo2)) {
                    eh2found = true;
                }
                if (!eh1found || !eh2found) continue;
                return true;
            }
            return false;
        }

        public String getMessage() {
            return "[" + this.index + "] " + this.message;
        }

        protected void xmlDescription(PrintStream msg) {
            String className = this.getClass().getSimpleName();
            if (this.logCellId == null) {
                return;
            }
            Cell logCell = EDatabase.clientDatabase().getCell(this.logCellId);
            if (logCell == null) {
                return;
            }
            String m = ErrorLogger.correctXmlString(this.message);
            msg.append("\t<" + className + " message=\"" + m + "\" " + "cellName=\"" + logCell.describe(false) + "\">\n");
            for (ErrorHighlight eh : this.highlights) {
                eh.xmlDescription(msg, EDatabase.clientDatabase());
            }
            msg.append("\t</" + className + ">\n");
        }

        public boolean isValid(EDatabase database) {
            if (this.logCellId == null) {
                return true;
            }
            if (database.getCell(this.logCellId) == null) {
                return false;
            }
            boolean allValid = true;
            for (ErrorHighlight erh : this.highlights) {
                if (erh.isValid(database)) continue;
                allValid = false;
                break;
            }
            return allValid;
        }
    }
}

