/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralTab
extends PreferencePanel {
    private Map<Object, String> fileTypeMap = new HashMap<Object, String>();
    private JPanel IO;
    private JLabel currentPathLabel;
    private JPanel database;
    private JPanel general;
    private JCheckBox generalBeepAfterLongJobs;
    private JTextField generalErrorLimit;
    private JCheckBox generalLogClientServer;
    private JTextField generalMaxMem;
    private JTextField generalMaxSize;
    private JLabel generalMemoryUsage;
    private JCheckBox generalShowFileDialog;
    private JCheckBox generalSnapshotLogging;
    private JCheckBox generalVerboseMode;
    private JLabel groupLabel;
    private JPanel groupPanel;
    private JLabel jLabel2;
    private JLabel jLabel46;
    private JLabel jLabel53;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JPanel jobs;
    private JTextField maxUndoHistory;
    private JPanel memory;
    private JLabel newPathLabel;
    private JLabel pathLabel;
    private JTextField pathTextField;
    private JButton resetButton;
    private JComboBox workingDirComboBox;

    public GeneralTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.pathTextField);
        EDialog.makeTextFieldSelectAllOnTab(this.generalErrorLimit);
        EDialog.makeTextFieldSelectAllOnTab(this.maxUndoHistory);
        EDialog.makeTextFieldSelectAllOnTab(this.generalMaxMem);
        EDialog.makeTextFieldSelectAllOnTab(this.generalMaxSize);
    }

    public JPanel getUserPreferencesPanel() {
        return this.general;
    }

    public String getName() {
        return "General";
    }

    public void init() {
        this.generalShowFileDialog.setSelected(User.isShowFileSelectionForNetlists());
        for (Object obj : FileType.getFileTypeGroups()) {
            this.workingDirComboBox.addItem(obj);
            this.fileTypeMap.put(obj, null);
        }
        this.workingDirComboBoxActionPerformed(null);
        this.pathTextField.setText(User.getWorkingDirectory());
        this.generalBeepAfterLongJobs.setSelected(User.isBeepAfterLongJobs());
        this.generalVerboseMode.setSelected(User.isJobVerboseMode());
        this.generalErrorLimit.setText(Integer.toString(User.getErrorLimit()));
        this.maxUndoHistory.setText(Integer.toString(User.getMaxUndoHistory()));
        Runtime runtime = Runtime.getRuntime();
        long maxMemLimit = runtime.maxMemory() / 1024L / 1024L;
        this.generalMemoryUsage.setText("Current memory usage: " + Long.toString(maxMemLimit) + " megabytes");
        this.generalMaxMem.setText(Long.toString(User.getMemorySize()));
        this.generalMaxSize.setText(Long.toString(User.getPermSpace()));
        this.generalSnapshotLogging.setSelected(User.isSnapshotLogging());
        this.generalLogClientServer.setSelected(User.isUseClientServer());
    }

    public void term() {
        int currInt;
        boolean currBoolean = this.generalShowFileDialog.isSelected();
        if (currBoolean != User.isShowFileSelectionForNetlists()) {
            User.setShowFileSelectionForNetlists(currBoolean);
        }
        for (Map.Entry<Object, String> entry : this.fileTypeMap.entrySet()) {
            Object obj = entry.getKey();
            FileType.setFileTypeGroupDir(obj, entry.getValue());
        }
        currBoolean = this.generalBeepAfterLongJobs.isSelected();
        if (currBoolean != User.isBeepAfterLongJobs()) {
            User.setBeepAfterLongJobs(currBoolean);
        }
        if ((currBoolean = this.generalVerboseMode.isSelected()) != User.isJobVerboseMode()) {
            User.setJobVerboseMode(currBoolean);
        }
        if ((currInt = TextUtils.atoi(this.generalErrorLimit.getText())) != User.getErrorLimit()) {
            User.setErrorLimit(currInt);
        }
        if ((currInt = TextUtils.atoi(this.maxUndoHistory.getText())) != User.getMaxUndoHistory()) {
            User.setMaxUndoHistory(currInt);
            Undo.setHistoryListSize(currInt);
        }
        if ((currInt = TextUtils.atoi(this.generalMaxMem.getText())) != User.getMemorySize()) {
            User.setMemorySize(currInt);
        }
        if ((currInt = TextUtils.atoi(this.generalMaxSize.getText())) != User.getPermSpace()) {
            User.setPermSpace(currInt);
        }
        if ((currBoolean = this.generalSnapshotLogging.isSelected()) != User.isSnapshotLogging()) {
            User.setSnapshotLogging(currBoolean);
        }
        if ((currBoolean = this.generalLogClientServer.isSelected()) != User.isUseClientServer()) {
            User.setUseClientServer(currBoolean);
        }
    }

    public void reset() {
        if (User.isFactoryShowFileSelectionForNetlists() != User.isShowFileSelectionForNetlists()) {
            User.setShowFileSelectionForNetlists(User.isFactoryShowFileSelectionForNetlists());
        }
        for (Object obj : FileType.getFileTypeGroups()) {
            if (FileType.getFactoryGroupPath(obj).equals(FileType.getGroupPath(obj))) continue;
            FileType.setFileTypeGroupDir(obj, FileType.getFactoryGroupPath(obj));
        }
        if (User.isFactoryBeepAfterLongJobs() != User.isBeepAfterLongJobs()) {
            User.setBeepAfterLongJobs(User.isFactoryBeepAfterLongJobs());
        }
        if (User.isFactoryJobVerboseMode() != User.isJobVerboseMode()) {
            User.setJobVerboseMode(User.isFactoryJobVerboseMode());
        }
        if (User.getFactoryErrorLimit() != User.getErrorLimit()) {
            User.setErrorLimit(User.getFactoryErrorLimit());
        }
        if (User.getFactoryMaxUndoHistory() != User.getMaxUndoHistory()) {
            User.setMaxUndoHistory(User.getFactoryMaxUndoHistory());
        }
        if (User.getFactoryMemorySize() != User.getMemorySize()) {
            User.setMemorySize(User.getFactoryMemorySize());
        }
        if (User.getFactoryPermSpace() != User.getPermSpace()) {
            User.setPermSpace(User.getFactoryPermSpace());
        }
        if (User.isFactoryUseTwoJVMs() != User.isUseTwoJVMs()) {
            User.setUseTwoJVMs(User.isFactoryUseTwoJVMs());
        }
        if (User.isFactoryUseClientServer() != User.isUseClientServer()) {
            User.setUseClientServer(User.isFactoryUseClientServer());
        }
        if (User.isFactorySnapshotLogging() != User.isSnapshotLogging()) {
            User.setSnapshotLogging(User.isFactorySnapshotLogging());
        }
    }

    private void initComponents() {
        this.general = new JPanel();
        this.memory = new JPanel();
        this.jLabel60 = new JLabel();
        this.generalMaxMem = new JTextField();
        this.jLabel61 = new JLabel();
        this.generalMemoryUsage = new JLabel();
        this.jLabel62 = new JLabel();
        this.jLabel63 = new JLabel();
        this.generalMaxSize = new JTextField();
        this.jLabel64 = new JLabel();
        this.IO = new JPanel();
        this.generalShowFileDialog = new JCheckBox();
        this.groupPanel = new JPanel();
        this.newPathLabel = new JLabel();
        this.pathLabel = new JLabel();
        this.pathTextField = new JTextField();
        this.resetButton = new JButton();
        this.workingDirComboBox = new JComboBox();
        this.groupLabel = new JLabel();
        this.currentPathLabel = new JLabel();
        this.jobs = new JPanel();
        this.generalBeepAfterLongJobs = new JCheckBox();
        this.jLabel46 = new JLabel();
        this.jLabel2 = new JLabel();
        this.generalErrorLimit = new JTextField();
        this.maxUndoHistory = new JTextField();
        this.jLabel53 = new JLabel();
        this.generalVerboseMode = new JCheckBox();
        this.database = new JPanel();
        this.generalLogClientServer = new JCheckBox();
        this.generalSnapshotLogging = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GeneralTab.this.closeDialog(evt);
            }
        });
        this.general.setLayout(new GridBagLayout());
        this.memory.setLayout(new GridBagLayout());
        this.memory.setBorder(BorderFactory.createTitledBorder("Memory"));
        this.jLabel60.setText("Maximum memory:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.memory.add((Component)this.jLabel60, gridBagConstraints);
        this.generalMaxMem.setColumns(6);
        this.generalMaxMem.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.memory.add((Component)this.generalMaxMem, gridBagConstraints);
        this.jLabel61.setText("megabytes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.memory.add((Component)this.jLabel61, gridBagConstraints);
        this.generalMemoryUsage.setText("Current memory usage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.memory.add((Component)this.generalMemoryUsage, gridBagConstraints);
        this.jLabel62.setText("Changes to memory take effect when Electric is next run");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.memory.add((Component)this.jLabel62, gridBagConstraints);
        this.jLabel63.setText("Maximum permanent space:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.memory.add((Component)this.jLabel63, gridBagConstraints);
        this.generalMaxSize.setColumns(6);
        this.generalMaxSize.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.memory.add((Component)this.generalMaxSize, gridBagConstraints);
        this.jLabel64.setText("megabytes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.memory.add((Component)this.jLabel64, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.general.add((Component)this.memory, gridBagConstraints);
        this.IO.setLayout(new GridBagLayout());
        this.IO.setBorder(BorderFactory.createTitledBorder("I/O"));
        this.generalShowFileDialog.setText("Show file-selection dialog before writing netlists");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.IO.add((Component)this.generalShowFileDialog, gridBagConstraints);
        this.groupPanel.setLayout(new GridBagLayout());
        this.groupPanel.setBorder(BorderFactory.createTitledBorder("Current Directory (by type)"));
        this.newPathLabel.setText("New:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.groupPanel.add((Component)this.newPathLabel, gridBagConstraints);
        this.pathLabel.setText("Current:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.groupPanel.add((Component)this.pathLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.groupPanel.add((Component)this.pathTextField, gridBagConstraints);
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneralTab.this.resetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.groupPanel.add((Component)this.resetButton, gridBagConstraints);
        this.workingDirComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneralTab.this.workingDirComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.groupPanel.add((Component)this.workingDirComboBox, gridBagConstraints);
        this.groupLabel.setText("Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.groupPanel.add((Component)this.groupLabel, gridBagConstraints);
        this.currentPathLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.groupPanel.add((Component)this.currentPathLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.IO.add((Component)this.groupPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.general.add((Component)this.IO, gridBagConstraints);
        this.jobs.setLayout(new GridBagLayout());
        this.jobs.setBorder(BorderFactory.createTitledBorder("Jobs"));
        this.generalBeepAfterLongJobs.setText("Beep after long jobs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jobs.add((Component)this.generalBeepAfterLongJobs, gridBagConstraints);
        this.jLabel46.setText("Maximum errors to report:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jobs.add((Component)this.jLabel46, gridBagConstraints);
        this.jLabel2.setText("Maximum undo history");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jobs.add((Component)this.jLabel2, gridBagConstraints);
        this.generalErrorLimit.setColumns(6);
        this.generalErrorLimit.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jobs.add((Component)this.generalErrorLimit, gridBagConstraints);
        this.maxUndoHistory.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jobs.add((Component)this.maxUndoHistory, gridBagConstraints);
        this.jLabel53.setText("(0 for infinite)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jobs.add((Component)this.jLabel53, gridBagConstraints);
        this.generalVerboseMode.setText("Verbose mode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jobs.add((Component)this.generalVerboseMode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.general.add((Component)this.jobs, gridBagConstraints);
        this.database.setLayout(new GridBagLayout());
        this.database.setBorder(BorderFactory.createTitledBorder("Database"));
        this.generalLogClientServer.setText("Use Client / Server interactions");
        this.generalLogClientServer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.generalLogClientServer.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.database.add((Component)this.generalLogClientServer, gridBagConstraints);
        this.generalSnapshotLogging.setText("Snapshot Logging");
        this.generalSnapshotLogging.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.generalSnapshotLogging.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.database.add((Component)this.generalSnapshotLogging, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.general.add((Component)this.database, gridBagConstraints);
        this.getContentPane().add((Component)this.general, new GridBagConstraints());
        this.pack();
    }

    private void workingDirComboBoxActionPerformed(ActionEvent evt) {
        this.currentPathLabel.setText(FileType.getGroupPath(this.workingDirComboBox.getSelectedItem()));
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        Object obj = this.workingDirComboBox.getSelectedItem();
        this.fileTypeMap.put(obj, this.pathTextField.getText());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

