/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;

public class EditingPreferences
extends PrefPackage {
    private static final String KEY_EXTEND_X = "DefaultExtendX";
    private static final String KEY_EXTEND_Y = "DefaultExtendY";
    private static final String KEY_EXTEND = "DefaultExtend";
    private static final String KEY_PIN = "Pin";
    private static final String KEY_RIGID = "DefaultRigid";
    private static final String KEY_FIXED_ANGLE = "DefaultFixedAngle";
    private static final String KEY_SLIDABLE = "DefaultSlidable";
    private static final String KEY_EXTENDED = "DefaultExtended";
    private static final String KEY_DIRECTIONAL = "DefaultDirectional";
    private static final String KEY_ANGLE = "DefaultAngle";
    private static final String KEY_ALIGNMENT = "AlignmentToGridVector";
    private static final Dimension2D[] DEFAULT_ALIGNMENTS = new Dimension2D[]{new ImmutableDimension2D(20.0), new ImmutableDimension2D(10.0), new ImmutableDimension2D(5.0), new ImmutableDimension2D(1.0), new ImmutableDimension2D(0.5)};
    private static final int DEFAULT_ALIGNMENT_INDEX = 3;
    private static final String TEXT_DESCRIPTOR_NODE = "database/variable";
    private static final String KEY_TEXT_DESCRIPTOR = "TextDescriptorFor";
    private static final String KEY_TEXT_DESCRIPTOR_COLOR = "TextDescriptorColorFor";
    private static final String KEY_TEXT_DESCRIPTOR_FONT = "TextDescriptorFontFor";
    private static final ThreadLocal<EditingPreferences> threadEditingPreferences = new ThreadLocal();
    private final transient TechPool techPool;
    private final HashMap<PrimitiveNodeId, ImmutableNodeInst> defaultNodes;
    private HashMap<ArcProtoId, ImmutableArcInst> defaultArcs;
    private HashMap<ArcProtoId, Integer> defaultArcAngleIncrements;
    private HashMap<ArcProtoId, PrimitiveNodeId> defaultArcPins;
    private Dimension2D[] alignments;
    private int alignmentIndex;
    private TextDescriptor[] textDescriptors;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartVerticalPlacementExport", factory=0)
    public final int smartVerticalPlacementExport = 0;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartHorizontalPlacementExport", factory=0)
    public final int smartHorizontalPlacementExport = 0;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartVerticalPlacementArc", factory=0)
    public final int smartVerticalPlacementArc = 0;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartHorizontalPlacementArc", factory=0)
    public final int smartHorizontalPlacementArc = 0;
    @PrefPackage.BooleanPref(node="tool/user", key="FatWires", factory=true)
    public boolean fatWires;

    public EditingPreferences(boolean factory, TechPool techPool) {
        super(factory);
        this.techPool = techPool;
        this.defaultNodes = new HashMap();
        this.defaultArcs = new HashMap();
        this.defaultArcAngleIncrements = new HashMap();
        this.defaultArcPins = new HashMap();
        AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
        this.textDescriptors = new TextDescriptor[textTypes.length * 2];
        if (factory) {
            this.alignments = DEFAULT_ALIGNMENTS;
            this.alignmentIndex = 3;
            for (int i = 0; i < textTypes.length; ++i) {
                AbstractTextDescriptor.TextType t = textTypes[i];
                this.textDescriptors[i * 2 + 0] = t.getFactoryTextDescriptor().withDisplay(false);
                this.textDescriptors[i * 2 + 1] = t.getFactoryTextDescriptor();
            }
            return;
        }
        Preferences prefRoot = EditingPreferences.getPrefRoot();
        Preferences techPrefs = prefRoot.node("technology/technologies");
        Preferences userPrefs = prefRoot.node("tool/user");
        Preferences textDescriptorPrefs = prefRoot.node(TEXT_DESCRIPTOR_NODE);
        for (Technology tech : techPool.values()) {
            ImmutableElectricObject factoryInst;
            Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pn = it.next();
                PrimitiveNodeId pnId = pn.getId();
                factoryInst = pn.getFactoryDefaultInst();
                EPoint factorySize = ((ImmutableNodeInst)factoryInst).size;
                String keyExtendX = this.getKey(KEY_EXTEND_X, pnId);
                double factoryExtendX = factorySize.getLambdaX() * 0.5;
                double extendX = techPrefs.getDouble(keyExtendX, factoryExtendX);
                String keyExtendY = this.getKey(KEY_EXTEND_Y, pnId);
                double factoryExtendY = factorySize.getLambdaY() * 0.5;
                double extendY = techPrefs.getDouble(keyExtendY, factoryExtendY);
                if (extendX == factoryExtendX && extendY == factoryExtendY) continue;
                EPoint size = EPoint.fromLambda(extendX * 2.0, extendY * 2.0);
                this.defaultNodes.put(pnId, ((ImmutableNodeInst)factoryInst).withSize(size));
            }
            it = tech.getArcs();
            while (it.hasNext()) {
                PrimitiveNode pin;
                String keyPin;
                String arcPinName;
                int factoryAngleIncrement;
                String keyAngle;
                int angleIncrement;
                ArcProto ap = (ArcProto)it.next();
                ArcProtoId apId = ap.getId();
                factoryInst = ap.getFactoryDefaultInst();
                int flags = ((ImmutableArcInst)factoryInst).flags;
                String keyExtend = this.getKey(KEY_EXTEND, apId);
                double factoryExtend = ((ImmutableArcInst)factoryInst).getLambdaExtendOverMin();
                double extend = techPrefs.getDouble(keyExtend, factoryExtend);
                String keyRigid = this.getKey(KEY_RIGID, apId);
                boolean factoryRigid = ((ImmutableArcInst)factoryInst).isRigid();
                boolean rigid = userPrefs.getBoolean(keyRigid, factoryRigid);
                flags = ImmutableArcInst.RIGID.set(flags, rigid);
                String keyFixedAngle = this.getKey(KEY_FIXED_ANGLE, apId);
                boolean factoryFixedAngle = ((ImmutableArcInst)factoryInst).isFixedAngle();
                boolean fixedAngle = userPrefs.getBoolean(keyFixedAngle, factoryFixedAngle);
                flags = ImmutableArcInst.FIXED_ANGLE.set(flags, fixedAngle);
                String keySlidable = this.getKey(KEY_SLIDABLE, apId);
                boolean factorySlidable = ((ImmutableArcInst)factoryInst).isSlidable();
                boolean slidable = userPrefs.getBoolean(keySlidable, factorySlidable);
                flags = ImmutableArcInst.SLIDABLE.set(flags, slidable);
                String keyExtended = this.getKey(KEY_EXTENDED, apId);
                boolean factoryExtended = ((ImmutableArcInst)factoryInst).isTailExtended();
                assert (factoryExtended == ((ImmutableArcInst)factoryInst).isHeadExtended());
                boolean extended = userPrefs.getBoolean(keyExtended, factoryExtended);
                flags = ImmutableArcInst.TAIL_EXTENDED.set(flags, extended);
                flags = ImmutableArcInst.HEAD_EXTENDED.set(flags, extended);
                String keyDirectional = this.getKey(KEY_DIRECTIONAL, apId);
                boolean factoryDirectional = ((ImmutableArcInst)factoryInst).isHeadArrowed();
                assert (factoryDirectional == ((ImmutableArcInst)factoryInst).isBodyArrowed());
                boolean directional = userPrefs.getBoolean(keyDirectional, factoryDirectional);
                flags = ImmutableArcInst.HEAD_ARROWED.set(flags, directional);
                flags = ImmutableArcInst.BODY_ARROWED.set(flags, directional);
                ImmutableArcInst a = ((ImmutableArcInst)factoryInst).withGridExtendOverMin(DBMath.lambdaToGrid(extend)).withFlags(flags);
                if (a != factoryInst) {
                    this.defaultArcs.put(apId, a);
                }
                if ((angleIncrement = userPrefs.getInt(keyAngle = this.getKey(KEY_ANGLE, apId), factoryAngleIncrement = ap.getFactoryAngleIncrement())) != factoryAngleIncrement) {
                    this.defaultArcAngleIncrements.put(apId, angleIncrement);
                }
                if ((arcPinName = techPrefs.get(keyPin = this.getKey(KEY_PIN, apId), "")).length() <= 0 || (pin = tech.findNodeProto(arcPinName)) == null) continue;
                this.defaultArcPins.put(apId, pin.getId());
            }
        }
        String alignmentStr = userPrefs.get(KEY_ALIGNMENT, null);
        if (alignmentStr != null) {
            this.alignments = EditingPreferences.correctAlignmentGridVector(EditingPreferences.transformStringIntoArray(alignmentStr));
            this.alignmentIndex = Math.max(0, Math.min(this.alignments.length - 1, EditingPreferences.getDefaultAlignmentIndex(alignmentStr)));
        } else {
            this.alignments = DEFAULT_ALIGNMENTS;
            this.alignmentIndex = 3;
        }
        for (int i = 0; i < textTypes.length; ++i) {
            AbstractTextDescriptor.ActiveFont af;
            AbstractTextDescriptor.TextType t = textTypes[i];
            TextDescriptor factoryTd = t.getFactoryTextDescriptor();
            long factoryBits = EditingPreferences.swap(factoryTd.lowLevelGet());
            long bits = textDescriptorPrefs.getLong(t.getKey(KEY_TEXT_DESCRIPTOR), factoryBits);
            int color = textDescriptorPrefs.getInt(t.getKey(KEY_TEXT_DESCRIPTOR_COLOR), 0);
            String fontName = textDescriptorPrefs.get(t.getKey(KEY_TEXT_DESCRIPTOR_FONT), "");
            MutableTextDescriptor mtd = new MutableTextDescriptor(EditingPreferences.swap(bits), color, true);
            int face = 0;
            if (fontName.length() > 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontName)) != null) {
                face = af.getIndex();
            }
            mtd.setFace(face);
            this.textDescriptors[i * 2 + 1] = TextDescriptor.newTextDescriptor(mtd);
            mtd.setDisplay(false);
            this.textDescriptors[i * 2 + 0] = TextDescriptor.newTextDescriptor(mtd);
        }
    }

    public void putPrefs(Preferences prefRoot, boolean removeDefaults) {
        this.putPrefs(prefRoot, removeDefaults, null);
    }

    public void putPrefs(Preferences prefRoot, boolean removeDefaults, EditingPreferences oldEp) {
        super.putPrefs(prefRoot, removeDefaults);
        if (oldEp != null && oldEp.techPool != this.techPool) {
            oldEp = null;
        }
        Preferences techPrefs = prefRoot.node("technology/technologies");
        Preferences userPrefs = prefRoot.node("tool/user");
        Preferences textDescriptorPrefs = prefRoot.node(TEXT_DESCRIPTOR_NODE);
        for (Technology tech : this.techPool.values()) {
            ImmutableElectricObject factoryInst;
            Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pn = it.next();
                PrimitiveNodeId pnId = pn.getId();
                ImmutableNodeInst n = this.defaultNodes.get(pnId);
                if (oldEp != null && n == oldEp.defaultNodes.get(pnId)) continue;
                factoryInst = pn.getFactoryDefaultInst();
                if (n == null) {
                    n = factoryInst;
                }
                String keyX = this.getKey(KEY_EXTEND_X, pnId);
                if (removeDefaults && n.size.getGridX() == ((ImmutableNodeInst)factoryInst).size.getGridX()) {
                    techPrefs.remove(keyX);
                } else {
                    techPrefs.putDouble(keyX, n.size.getLambdaX() * 0.5);
                }
                String keyY = this.getKey(KEY_EXTEND_Y, pnId);
                if (removeDefaults && n.size.getGridY() == ((ImmutableNodeInst)factoryInst).size.getGridY()) {
                    techPrefs.remove(keyY);
                    continue;
                }
                techPrefs.putDouble(keyY, n.size.getLambdaY() * 0.5);
            }
            it = tech.getArcs();
            while (it.hasNext()) {
                String pinName;
                ArcProto ap = (ArcProto)it.next();
                ArcProtoId apId = ap.getId();
                ImmutableElectricObject a = this.defaultArcs.get(apId);
                if (oldEp == null || a != oldEp.defaultArcs.get(apId)) {
                    factoryInst = ap.getFactoryDefaultInst();
                    if (a == null) {
                        a = factoryInst;
                    }
                    String keyExtend = this.getKey(KEY_EXTEND, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).getGridExtendOverMin() == ((ImmutableArcInst)factoryInst).getGridExtendOverMin()) {
                        techPrefs.remove(keyExtend);
                    } else {
                        techPrefs.putDouble(keyExtend, ((ImmutableArcInst)a).getLambdaExtendOverMin());
                    }
                    String keyRigid = this.getKey(KEY_RIGID, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isRigid() == ((ImmutableArcInst)factoryInst).isRigid()) {
                        userPrefs.remove(keyRigid);
                    } else {
                        userPrefs.putBoolean(keyRigid, ((ImmutableArcInst)a).isRigid());
                    }
                    String keyFixedAngle = this.getKey(KEY_FIXED_ANGLE, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isFixedAngle() == ((ImmutableArcInst)factoryInst).isFixedAngle()) {
                        userPrefs.remove(keyFixedAngle);
                    } else {
                        userPrefs.putBoolean(keyFixedAngle, ((ImmutableArcInst)a).isFixedAngle());
                    }
                    String keySlidable = this.getKey(KEY_SLIDABLE, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isSlidable() == ((ImmutableArcInst)factoryInst).isSlidable()) {
                        userPrefs.remove(keySlidable);
                    } else {
                        userPrefs.putBoolean(keySlidable, ((ImmutableArcInst)a).isSlidable());
                    }
                    String keyExtended = this.getKey(KEY_EXTENDED, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isTailExtended() == ((ImmutableArcInst)factoryInst).isTailExtended()) {
                        userPrefs.remove(keyExtended);
                    } else {
                        userPrefs.putBoolean(keyExtended, ((ImmutableArcInst)a).isTailExtended());
                    }
                    String keyDirectional = this.getKey(KEY_DIRECTIONAL, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isHeadArrowed() == ((ImmutableArcInst)factoryInst).isHeadArrowed()) {
                        userPrefs.remove(keyDirectional);
                    } else {
                        userPrefs.putBoolean(keyDirectional, ((ImmutableArcInst)a).isHeadArrowed());
                    }
                }
                Integer angleIncrementObj = this.defaultArcAngleIncrements.get(apId);
                if (oldEp == null || angleIncrementObj != oldEp.defaultArcAngleIncrements.get(apId)) {
                    int factoryAngleIncrement = ap.getFactoryAngleIncrement();
                    int angleIncrement = angleIncrementObj != null ? angleIncrementObj : factoryAngleIncrement;
                    String keyAngle = this.getKey(KEY_ANGLE, apId);
                    if (removeDefaults && angleIncrement == factoryAngleIncrement) {
                        userPrefs.remove(keyAngle);
                    } else {
                        userPrefs.putInt(keyAngle, angleIncrement);
                    }
                }
                PrimitiveNodeId pinId = this.defaultArcPins.get(apId);
                if (oldEp != null && pinId == oldEp.defaultArcPins.get(apId)) continue;
                String keyPin = this.getKey(KEY_PIN, apId);
                String string = pinName = pinId != null ? pinId.name : "";
                if (removeDefaults && pinName.length() == 0) {
                    techPrefs.remove(keyPin);
                    continue;
                }
                techPrefs.put(keyPin, pinName);
            }
        }
        if (oldEp == null || this.alignments != oldEp.alignments || this.alignmentIndex != oldEp.alignmentIndex) {
            if (removeDefaults && Arrays.equals(this.alignments, DEFAULT_ALIGNMENTS) && this.alignmentIndex == 3) {
                userPrefs.remove(KEY_ALIGNMENT);
            } else {
                userPrefs.put(KEY_ALIGNMENT, EditingPreferences.transformArrayIntoString(this.alignments, this.alignmentIndex));
            }
        }
        if (oldEp == null || this.textDescriptors != oldEp.textDescriptors) {
            AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
            for (int i = 0; i < textTypes.length; ++i) {
                String fontName;
                long bits;
                AbstractTextDescriptor.TextType t = textTypes[i];
                TextDescriptor td = this.textDescriptors[i * 2 + 1];
                String keyTextDescriptor = t.getKey(KEY_TEXT_DESCRIPTOR);
                String keyTextDescriptorColor = t.getKey(KEY_TEXT_DESCRIPTOR_COLOR);
                String keyTextDescriptorFont = t.getKey(KEY_TEXT_DESCRIPTOR_FONT);
                long factoryBits = t.getFactoryTextDescriptor().lowLevelGet();
                if (td.getFace() == 0) {
                    bits = td.lowLevelGet();
                    fontName = "";
                } else {
                    fontName = AbstractTextDescriptor.ActiveFont.findActiveFont(td.getFace()).getName();
                    MutableTextDescriptor mtd = new MutableTextDescriptor(td);
                    mtd.setFace(0);
                    bits = mtd.lowLevelGet();
                }
                if (removeDefaults && bits == factoryBits) {
                    textDescriptorPrefs.remove(keyTextDescriptor);
                } else {
                    textDescriptorPrefs.putLong(keyTextDescriptor, EditingPreferences.swap(bits));
                }
                if (removeDefaults && td.getColorIndex() == 0) {
                    textDescriptorPrefs.remove(keyTextDescriptorColor);
                } else {
                    textDescriptorPrefs.putInt(keyTextDescriptorColor, td.getColorIndex());
                }
                if (removeDefaults && fontName.length() == 0) {
                    textDescriptorPrefs.remove(keyTextDescriptorFont);
                    continue;
                }
                textDescriptorPrefs.put(keyTextDescriptorFont, fontName);
            }
        }
    }

    public EditingPreferences withNodeSize(PrimitiveNodeId pnId, EPoint size) {
        PrimitiveNode pn = this.techPool.getPrimitiveNode(pnId);
        if (pn == null) {
            return this;
        }
        ImmutableNodeInst n = pn.getDefaultInst(this);
        assert (n.protoId == pnId);
        if (n.size.equals(size)) {
            return this;
        }
        HashMap<PrimitiveNodeId, ImmutableNodeInst> newDefaultNodes = new HashMap<PrimitiveNodeId, ImmutableNodeInst>(this.defaultNodes);
        if (size.equals(pn.getFactoryDefaultInst().size)) {
            newDefaultNodes.remove(pnId);
        } else {
            newDefaultNodes.put(pnId, n.withSize(size));
        }
        return (EditingPreferences)this.withField("defaultNodes", newDefaultNodes);
    }

    public EditingPreferences withNodesReset() {
        if (this.defaultNodes.isEmpty()) {
            return this;
        }
        return (EditingPreferences)this.withField("defaultNodes", new HashMap());
    }

    public EditingPreferences withArcFlags(ArcProtoId apId, int flags) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        ImmutableArcInst a = ap.getDefaultInst(this);
        if (flags == a.flags) {
            return this;
        }
        HashMap<ArcProtoId, ImmutableArcInst> newDefaultArcs = new HashMap<ArcProtoId, ImmutableArcInst>(this.defaultArcs);
        ImmutableArcInst factoryA = ap.getFactoryDefaultInst();
        if (flags == factoryA.flags) {
            newDefaultArcs.remove(apId);
        } else {
            newDefaultArcs.put(apId, a.withFlags(flags));
        }
        return (EditingPreferences)this.withField("defaultArcs", newDefaultArcs);
    }

    public EditingPreferences withArcGridExtend(ArcProtoId apId, long gridExtend) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        ImmutableArcInst a = ap.getDefaultInst(this);
        if (gridExtend == a.getGridExtendOverMin()) {
            return this;
        }
        HashMap<ArcProtoId, ImmutableArcInst> newDefaultArcs = new HashMap<ArcProtoId, ImmutableArcInst>(this.defaultArcs);
        ImmutableArcInst factoryA = ap.getFactoryDefaultInst();
        if (gridExtend == factoryA.getGridExtendOverMin()) {
            newDefaultArcs.remove(apId);
        } else {
            newDefaultArcs.put(apId, a.withGridExtendOverMin(gridExtend));
        }
        return (EditingPreferences)this.withField("defaultArcs", newDefaultArcs);
    }

    public EditingPreferences withArcAngleIncrement(ArcProtoId apId, int angleIncrement) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        if (angleIncrement == ap.getAngleIncrement(this)) {
            return this;
        }
        HashMap<ArcProtoId, Integer> newDefaultArcAngleIncrements = new HashMap<ArcProtoId, Integer>(this.defaultArcAngleIncrements);
        int factoryAngleIncrement = ap.getFactoryAngleIncrement();
        if (angleIncrement == factoryAngleIncrement) {
            newDefaultArcAngleIncrements.remove(apId);
        } else {
            newDefaultArcAngleIncrements.put(apId, angleIncrement);
        }
        return (EditingPreferences)this.withField("defaultArcAngleIncrements", newDefaultArcAngleIncrements);
    }

    public EditingPreferences withArcPin(ArcProtoId apId, PrimitiveNodeId arcPinId) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        if (arcPinId == ap.findOverridablePinProto(this).getId()) {
            return this;
        }
        HashMap<ArcProtoId, PrimitiveNodeId> newDefaultArcPins = new HashMap<ArcProtoId, PrimitiveNodeId>(this.defaultArcPins);
        PrimitiveNodeId factoryArcPinId = ap.findPinProto().getId();
        if (arcPinId == factoryArcPinId) {
            newDefaultArcPins.remove(apId);
        } else {
            newDefaultArcPins.put(apId, arcPinId);
        }
        return (EditingPreferences)this.withField("defaultArcPins", newDefaultArcPins);
    }

    public EditingPreferences withArcsReset() {
        return this.withDefaultArcsReset().withDefaultAngleIncrementsReset().withDefaultArcPinsReset();
    }

    private EditingPreferences withDefaultArcsReset() {
        if (this.defaultArcs.isEmpty()) {
            return this;
        }
        return (EditingPreferences)this.withField("defaultArcs", new HashMap());
    }

    private EditingPreferences withDefaultAngleIncrementsReset() {
        if (this.defaultArcAngleIncrements.isEmpty()) {
            return this;
        }
        return (EditingPreferences)this.withField("defaultArcAngleIncrements", new HashMap());
    }

    private EditingPreferences withDefaultArcPinsReset() {
        if (this.defaultArcPins.isEmpty()) {
            return this;
        }
        return (EditingPreferences)this.withField("defaultArcPins", new HashMap());
    }

    public ImmutableNodeInst getDefaultNode(PrimitiveNodeId pnId) {
        return this.defaultNodes.get(pnId);
    }

    public ImmutableArcInst getDefaultArc(ArcProtoId apId) {
        return this.defaultArcs.get(apId);
    }

    public Integer getDefaultAngleIncrement(ArcProtoId apId) {
        return this.defaultArcAngleIncrements.get(apId);
    }

    public PrimitiveNodeId getDefaultArcPinId(ArcProtoId apId) {
        return this.defaultArcPins.get(apId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EditingPreferences) {
            EditingPreferences that = (EditingPreferences)o;
            return this.techPool == that.techPool && this.defaultNodes.equals(that.defaultNodes) && this.defaultArcs.equals(that.defaultArcs) && this.defaultArcAngleIncrements.equals(that.defaultArcAngleIncrements) && this.defaultArcPins.equals(that.defaultArcPins) && Arrays.equals(this.alignments, that.alignments) && this.alignmentIndex == that.alignmentIndex && Arrays.equals(this.textDescriptors, that.textDescriptors) && this.fatWires == that.fatWires;
        }
        return false;
    }

    public Dimension2D getAlignmentToGrid() {
        return this.alignments[this.alignmentIndex];
    }

    public int getAlignmentToGridIndex() {
        return this.alignmentIndex;
    }

    public Dimension2D[] getAlignmentToGridVector() {
        return (Dimension2D[])this.alignments.clone();
    }

    public EditingPreferences withAlignment(Dimension2D[] dist, int current) {
        dist = EditingPreferences.correctAlignmentGridVector((Dimension2D[])dist.clone());
        current = Math.max(0, Math.min(dist.length - 1, current));
        return this.withAlignments(dist).withAlignmentIndex(current);
    }

    public EditingPreferences withAlignmentReset() {
        return this.withAlignments(DEFAULT_ALIGNMENTS).withAlignmentIndex(3);
    }

    private EditingPreferences withAlignments(Dimension2D[] alignments) {
        if (Arrays.equals(alignments, this.alignments)) {
            return this;
        }
        return (EditingPreferences)this.withField("alignments", alignments);
    }

    private EditingPreferences withAlignmentIndex(int alignmentIndex) {
        if (alignmentIndex == this.alignmentIndex) {
            return this;
        }
        return (EditingPreferences)this.withField("alignmentIndex", alignmentIndex);
    }

    public TextDescriptor getTextDescriptor(AbstractTextDescriptor.TextType textType, boolean display) {
        return this.textDescriptors[textType.ordinal() * 2 + (display ? 1 : 0)];
    }

    public EditingPreferences withTextDescriptor(AbstractTextDescriptor.TextType textType, TextDescriptor td) {
        if ((td = td.withDisplay(true)) == this.textDescriptors[textType.ordinal() * 2 + 1]) {
            return this;
        }
        TextDescriptor[] newTextDescriptors = (TextDescriptor[])this.textDescriptors.clone();
        newTextDescriptors[textType.ordinal() * 2 + 1] = td;
        newTextDescriptors[textType.ordinal() * 2 + 0] = td.withDisplay(false);
        return (EditingPreferences)this.withField("textDescriptors", newTextDescriptors);
    }

    public EditingPreferences withTextDescriptorsReset() {
        EditingPreferences ep = this;
        AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
        for (int i = 0; i < textTypes.length; ++i) {
            AbstractTextDescriptor.TextType t = textTypes[i];
            ep = ep.withTextDescriptor(t, t.getFactoryTextDescriptor());
        }
        return ep;
    }

    public EditingPreferences withSmartVerticalPlacementExport(int smartVerticalPlacementExport) {
        this.getClass();
        if (smartVerticalPlacementExport == 0) {
            return this;
        }
        return (EditingPreferences)this.withField("smartVerticalPlacementExport", smartVerticalPlacementExport);
    }

    public EditingPreferences withSmartHorizontalPlacementExport(int smartHorizontalPlacementExport) {
        this.getClass();
        if (smartHorizontalPlacementExport == 0) {
            return this;
        }
        return (EditingPreferences)this.withField("smartHorizontalPlacementExport", smartHorizontalPlacementExport);
    }

    public EditingPreferences withSmartVerticalPlacementArc(int smartVerticalPlacementArc) {
        this.getClass();
        if (smartVerticalPlacementArc == 0) {
            return this;
        }
        return (EditingPreferences)this.withField("smartVerticalPlacementArc", smartVerticalPlacementArc);
    }

    public EditingPreferences withSmartHorizontalPlacementArc(int smartHorizontalPlacementArc) {
        this.getClass();
        if (smartHorizontalPlacementArc == 0) {
            return this;
        }
        return (EditingPreferences)this.withField("smartHorizontalPlacementArc", smartHorizontalPlacementArc);
    }

    public EditingPreferences withPlacementReset() {
        return this.withSmartHorizontalPlacementArc(0).withSmartVerticalPlacementArc(0).withSmartHorizontalPlacementExport(0).withSmartVerticalPlacementExport(0);
    }

    public EditingPreferences withFatWiresReset() {
        return (EditingPreferences)this.withField("fatWires", Boolean.TRUE);
    }

    private static Dimension2D[] correctAlignmentGridVector(Dimension2D[] retVal) {
        if (retVal.length < 5) {
            Dimension2D[] newRetVal = new Dimension2D[5];
            int shift = 5 - retVal.length;
            for (int i = retVal.length - 1; i >= 0; --i) {
                newRetVal[i + shift] = retVal[i];
            }
            while (shift > 0) {
                newRetVal[--shift] = new Dimension2D.Double(newRetVal[shift + 1].getWidth() * 2.0, newRetVal[shift + 1].getHeight() * 2.0);
            }
            retVal = newRetVal;
        }
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new ImmutableDimension2D(retVal[i]);
        }
        return retVal;
    }

    private static Dimension2D[] transformStringIntoArray(String vector) {
        StringTokenizer parse = new StringTokenizer(vector, "( )", false);
        ArrayList<Dimension2D.Double> valuesFound = new ArrayList<Dimension2D.Double>();
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            if (value.startsWith("*")) {
                value = value.substring(1);
            }
            int slashPos = value.indexOf(47);
            String xPart = value;
            String yPart = value;
            if (slashPos >= 0) {
                xPart = value.substring(0, slashPos);
                yPart = value.substring(slashPos + 1);
            }
            try {
                Dimension2D.Double dim = new Dimension2D.Double(Math.abs(Double.parseDouble(xPart)), Math.abs(Double.parseDouble(yPart)));
                valuesFound.add(dim);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Dimension2D[] values = new Dimension2D[valuesFound.size()];
        for (int i = 0; i < valuesFound.size(); ++i) {
            values[i] = (Dimension2D)valuesFound.get(i);
        }
        return values;
    }

    private static int getDefaultAlignmentIndex(String vector) {
        int curVal = 0;
        StringTokenizer parse = new StringTokenizer(vector, "( )", false);
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            if (value.startsWith("*")) {
                return curVal;
            }
            if (TextUtils.atof(value) < 0.0) {
                return curVal;
            }
            ++curVal;
        }
        return 0;
    }

    private static String transformArrayIntoString(Dimension2D[] s, int current) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i == 0) {
                sb.append('(');
            } else {
                sb.append(' ');
            }
            if (i == current) {
                sb.append('*');
            }
            sb.append(s[i].getWidth());
            if (s[i].getWidth() == s[i].getHeight()) continue;
            sb.append('/');
            sb.append(s[i].getHeight());
        }
        sb.append(')');
        String dir = sb.toString();
        return dir;
    }

    private static long swap(long value) {
        int v0 = (int)value;
        return value >>> 32 | (long)v0 << 32;
    }

    public int hashCode() {
        return this.defaultNodes.size() + this.defaultArcs.size();
    }

    public static EditingPreferences getThreadEditingPreferences() {
        return threadEditingPreferences.get();
    }

    public static EditingPreferences setThreadEditingPreferences(EditingPreferences ep) {
        EditingPreferences oldEp = threadEditingPreferences.get();
        threadEditingPreferences.set(ep);
        return oldEp;
    }

    private static class ImmutableDimension2D
    extends Dimension2D {
        private final double width;
        private final double height;

        private ImmutableDimension2D(Dimension2D d) {
            this(d.getWidth(), d.getHeight());
        }

        private ImmutableDimension2D(double size) {
            this(size, size);
        }

        private ImmutableDimension2D(double width, double height) {
            this.width = DBMath.round(width * 0.5) * 2.0;
            this.height = DBMath.round(height * 0.5) * 2.0;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public void setSize(java.awt.geom.Dimension2D d) {
            throw new UnsupportedOperationException();
        }

        public void setSize(double width, double height) {
            throw new UnsupportedOperationException();
        }
    }
}

