/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ManipulateExports
extends EDialog {
    private static final String[] columnNames = new String[]{" ", "Name", "Layer", "Characteristic", "Body Only"};
    private ExportsTable exportTable;
    private int sortColumn;
    private boolean sortAscending;
    private JButton deleteExports;
    private JButton deselectAll;
    private JButton done;
    private JScrollPane exportPane;
    private JSeparator jSeparator1;
    private JButton reNumberExports;
    private JButton selectAll;
    private JButton showExports;
    private JLabel title;
    private JButton toggleSelection;

    public static void showDialog() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new ManipulateExports((Frame)TopLevel.getCurrentJFrame(), cell);
    }

    private ManipulateExports(Frame parent, Cell cell) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        this.title.setText("Exports in cell " + cell.describe(false));
        this.sortColumn = 1;
        this.sortAscending = true;
        this.exportTable = new ExportsTable(cell);
        JTableHeader header = this.exportTable.getTableHeader();
        header.addMouseListener(new ColumnListener());
        this.exportPane.setViewportView(this.exportTable);
        this.finishInitialization();
        this.setVisible(true);
    }

    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void initComponents() {
        this.done = new JButton();
        this.title = new JLabel();
        this.exportPane = new JScrollPane();
        this.selectAll = new JButton();
        this.deselectAll = new JButton();
        this.reNumberExports = new JButton();
        this.jSeparator1 = new JSeparator();
        this.deleteExports = new JButton();
        this.showExports = new JButton();
        this.toggleSelection = new JButton();
        this.setTitle("Manipulate Exports");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ManipulateExports.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.doneActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.title.setText("Exports in Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.title, gridBagConstraints);
        this.exportPane.setMinimumSize(new Dimension(200, 200));
        this.exportPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.exportPane, gridBagConstraints);
        this.selectAll.setText("Select All Exports");
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.selectAll, gridBagConstraints);
        this.deselectAll.setText("Deselect All Exports");
        this.deselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.deselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deselectAll, gridBagConstraints);
        this.reNumberExports.setText("Renumber Selected Numeric Export Names");
        this.reNumberExports.setToolTipText("Renames the selected exports so that trailing numbers are in order");
        this.reNumberExports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.reNumberExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.reNumberExports, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.deleteExports.setText("Delete Selected Exports");
        this.deleteExports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.deleteExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deleteExports, gridBagConstraints);
        this.showExports.setText("Show Selected Exports");
        this.showExports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.showExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showExports, gridBagConstraints);
        this.toggleSelection.setText("Toggle Selection");
        this.toggleSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManipulateExports.this.toggleSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.toggleSelection, gridBagConstraints);
        this.pack();
    }

    private void toggleSelectionActionPerformed(ActionEvent evt) {
        this.exportTable.toggleSelection();
    }

    private void showExportsActionPerformed(ActionEvent evt) {
        this.exportTable.showSelected();
    }

    private void deleteExportsActionPerformed(ActionEvent evt) {
        this.exportTable.unExportSelected();
        this.closeDialog(null);
    }

    private void reNumberExportsActionPerformed(ActionEvent evt) {
        this.exportTable.renumberSelectedExports();
        this.closeDialog(null);
    }

    private void deselectAllActionPerformed(ActionEvent evt) {
        this.exportTable.deselectAll();
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.exportTable.selectAll();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class ColumnListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int colNumber;
            TableColumnModel colModel = ManipulateExports.this.exportTable.getColumnModel();
            int modelIndex = colModel.getColumn(colNumber = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (ManipulateExports.this.sortColumn == modelIndex) {
                ManipulateExports.this.sortAscending = !ManipulateExports.this.sortAscending;
            } else {
                ManipulateExports.this.sortColumn = modelIndex;
            }
            ExportTableModel model = ManipulateExports.this.exportTable.getModel();
            model.sortTable(modelIndex, ManipulateExports.this.sortAscending);
            model.fireTableStructureChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportTableModel
    extends AbstractTableModel {
        private Cell cell;
        private List<ExportEntry> exports;

        private ExportTableModel(Cell cell) {
            this.cell = cell;
            this.exports = new ArrayList<ExportEntry>();
        }

        public void newVar(Export e) {
            ExportEntry ve = new ExportEntry(e);
            this.exports.add(ve);
        }

        public void sortTable(int column, boolean ascending) {
            Collections.sort(this.exports, new ExportEntrySort(column, ascending));
            this.fireTableDataChanged();
        }

        public void selectAll() {
            int i = 0;
            for (ExportEntry pe : this.exports) {
                pe.setSelected(true);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void deselectAll() {
            int i = 0;
            for (ExportEntry pe : this.exports) {
                pe.setSelected(false);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void renumberSelectedExports() {
            ArrayList<Export> queuedExports = new ArrayList<Export>();
            for (ExportEntry pe : this.exports) {
                if (!pe.isSelected()) continue;
                queuedExports.add(pe.getExport());
            }
            new ExportChanges.RenumberNumericExports(queuedExports);
        }

        public void unExportSelected() {
            ArrayList<Export> queuedExports = new ArrayList<Export>();
            for (ExportEntry pe : this.exports) {
                if (!pe.isSelected()) continue;
                queuedExports.add(pe.getExport());
            }
            ExportChanges.deleteExports(this.cell, queuedExports);
        }

        public void showSelected() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            wnd.clearHighlighting();
            for (ExportEntry pe : this.exports) {
                if (!pe.isSelected()) continue;
                wnd.addHighlightText(pe.getExport(), this.cell, Export.EXPORT_NAME);
            }
            wnd.finishedHighlighting();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.exports.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ExportEntry pe = this.exports.get(rowIndex);
            if (pe == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return pe.isSelected();
                }
                case 1: {
                    return pe.name;
                }
                case 2: {
                    return this.getLayer(pe.getExport());
                }
                case 3: {
                    return pe.ch;
                }
                case 4: {
                    return pe.getExport().isBodyOnly();
                }
            }
            return null;
        }

        private String getLayer(Export e) {
            ArcProto[] arcs = e.getBasePort().getConnections();
            String layers = "";
            ArcProto firstGeneric = null;
            for (int i = 0; i < arcs.length; ++i) {
                ArcProto ap = arcs[i];
                if (ap.getTechnology() == Generic.tech()) {
                    if (firstGeneric != null) continue;
                    firstGeneric = ap;
                    continue;
                }
                if (layers.length() > 0) {
                    layers = layers + ", ";
                }
                layers = layers + ap.getLayer(0).getName();
            }
            if (layers.length() == 0 && firstGeneric != null) {
                layers = firstGeneric.getLayer(0).getName();
            }
            return layers;
        }

        @Override
        public String getColumnName(int col) {
            String colName = columnNames[col];
            if (col == ManipulateExports.this.sortColumn) {
                colName = ManipulateExports.this.sortAscending ? colName + " \u21d3" : colName + " \u21d1";
            }
            return colName;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0 || col == 1 || col == 3;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            ExportEntry ve = this.exports.get(row);
            if (ve == null) {
                return;
            }
            if (col == 0) {
                Boolean b = (Boolean)aValue;
                if (ve.isSelected() != b) {
                    ve.setSelected(b);
                    this.fireTableCellUpdated(row, col);
                }
            } else if (col == 1) {
                ExportEntry pe = this.exports.get(row);
                if (pe == null) {
                    return;
                }
                pe.name = (String)aValue;
                new ExportChanges.RenameExport(pe.getExport(), pe.name);
            } else if (col == 3) {
                ExportEntry pe = this.exports.get(row);
                if (pe == null) {
                    return;
                }
                pe.ch = (PortCharacteristic)((Object)aValue);
                new ExportChanges.ChangeExportCharacteristic(pe.getExport(), pe.ch);
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ExportEntrySort
        implements Comparator<ExportEntry> {
            private int column;
            private boolean ascending;

            ExportEntrySort(int column, boolean ascending) {
                this.column = column;
                this.ascending = ascending;
            }

            @Override
            public int compare(ExportEntry p1, ExportEntry p2) {
                if (!this.ascending) {
                    ExportEntry swap = p1;
                    p1 = p2;
                    p2 = swap;
                }
                String s1 = null;
                String s2 = null;
                switch (this.column) {
                    case 0: {
                        boolean b1 = p1.isSelected();
                        boolean b2 = p2.isSelected();
                        if (b1 == b2) {
                            return 0;
                        }
                        if (b1) {
                            return 1;
                        }
                        return -1;
                    }
                    case 1: {
                        s1 = p1.name;
                        s2 = p2.name;
                        break;
                    }
                    case 2: {
                        s1 = ExportTableModel.this.getLayer(p1.getExport());
                        s2 = ExportTableModel.this.getLayer(p2.getExport());
                        break;
                    }
                    case 3: {
                        s1 = p1.ch.getName();
                        s2 = p2.ch.getName();
                        return s1.compareTo(s2);
                    }
                    case 4: {
                        boolean b1 = p1.getExport().isBodyOnly();
                        boolean b2 = p2.getExport().isBodyOnly();
                        if (b1 == b2) {
                            return 0;
                        }
                        if (b1) {
                            return 1;
                        }
                        return -1;
                    }
                }
                return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
            }
        }

        private class ExportEntry {
            private boolean selected;
            private String name;
            private PortCharacteristic ch;
            private Export e;

            private ExportEntry(Export e) {
                this.e = e;
                this.name = e.getName();
                this.ch = e.getCharacteristic();
            }

            private Export getExport() {
                return this.e;
            }

            private boolean isSelected() {
                return this.selected;
            }

            private void setSelected(boolean s) {
                this.selected = s;
            }
        }
    }

    public class CellComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public CellComboBoxRenderer(Object[] items) {
            super(items);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    public class CellComboBoxEditor
    extends DefaultCellEditor {
        public CellComboBoxEditor(Object[] items) {
            super(new JComboBox<Object>(items));
        }
    }

    private class ExportsTable
    extends JTable {
        private ExportTableModel model;

        public ExportsTable(Cell cell) {
            this.model = new ExportTableModel(cell);
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                this.model.newVar(e);
            }
            this.model.sortTable(1, true);
            this.setModel(this.model);
            TableColumn tc = this.getColumn(this.getColumnName(0));
            if (tc != null) {
                tc.setPreferredWidth(10);
            }
            if ((tc = this.getColumn(this.getColumnName(1))) != null) {
                tc.setPreferredWidth(120);
            }
            if ((tc = this.getColumn(this.getColumnName(2))) != null) {
                tc.setPreferredWidth(100);
            }
            if ((tc = this.getColumn(this.getColumnName(3))) != null) {
                tc.setPreferredWidth(80);
                List<PortCharacteristic> chars = PortCharacteristic.getOrderedCharacteristics();
                PortCharacteristic[] charNames = new PortCharacteristic[chars.size()];
                for (int i = 0; i < chars.size(); ++i) {
                    charNames[i] = chars.get(i);
                }
                tc.setCellRenderer(new CellComboBoxRenderer((Object[])charNames));
                tc.setCellEditor(new CellComboBoxEditor((Object[])charNames));
            }
            if ((tc = this.getColumn(this.getColumnName(4))) != null) {
                tc.setPreferredWidth(20);
            }
        }

        public void toggleSelection() {
            int[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Boolean b = (Boolean)this.model.getValueAt(rows[i], 0);
                this.model.setValueAt(b == false, rows[i], 0);
            }
        }

        public ExportTableModel getModel() {
            return this.model;
        }

        public void selectAll() {
            this.model.selectAll();
        }

        public void deselectAll() {
            this.model.deselectAll();
        }

        public void renumberSelectedExports() {
            this.model.renumberSelectedExports();
        }

        public void unExportSelected() {
            this.model.unExportSelected();
        }

        public void showSelected() {
            this.model.showSelected();
        }
    }
}

