/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Geometry;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CIF
extends Geometry {
    private int crcChecksum;
    private int[] crcTab = new int[256];
    private boolean crcPrevIsCharSep;
    private int crcNumChars;
    private static final int[] crcRow = new int[]{79764919, 159529838, 319059676, 638119352, 1276238704, -1742489888, 881225847, 1762451694};
    private int cellNumber = 100;
    private Map<Cell, Integer> cellNumbers;
    private double scaleFactor;
    private static final String badNameChars = ":{}/\\";
    private CIFPreferences localPrefs;

    CIF(CIFPreferences cp) {
        this.localPrefs = cp;
        this.cellNumbers = new HashMap<Cell, Integer>();
        this.scaleFactor = Technology.getCurrent().getScale() / 10.0 * (double)this.localPrefs.cifScale;
    }

    protected void start() {
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.writeLine("( Electric VLSI Design System, version " + Version.getVersion() + " );");
            Date now = new Date();
            this.writeLine("( written on " + TextUtils.formatDate(now) + " );");
        } else {
            this.writeLine("( Electric VLSI Design System );");
        }
        this.emitCopyright("( ", " );");
        int i = 0;
        while (i < this.crcTab.length) {
            this.crcTab[i] = 0;
            for (int j = 0; j < 8; ++j) {
                if ((1 << j & i) == 0) continue;
                this.crcTab[i] = this.crcTab[i] ^ crcRow[j];
            }
            int n = i++;
            this.crcTab[n] = this.crcTab[n] & 0xFFFFFFFF;
        }
        this.crcNumChars = 1;
        this.crcPrevIsCharSep = true;
        this.crcChecksum = this.crcTab[32];
    }

    protected void done() {
        if (this.localPrefs.cifOutInstantiatesTopLevel) {
            this.writeLine("C " + this.cellNumber + ";");
        }
        this.writeLine("E");
        if (!this.crcPrevIsCharSep) {
            this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ 0x20) & 0xFF];
            ++this.crcNumChars;
        }
        for (int bytesread = this.crcNumChars; bytesread > 0; bytesread >>= 8) {
            this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ bytesread) & 0xFF];
        }
        this.crcChecksum = ~this.crcChecksum & 0xFFFFFFFF;
        System.out.println("MOSIS CRC: " + GenMath.unsignedIntValue(this.crcChecksum) + " " + this.crcNumChars);
    }

    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
        ++this.cellNumber;
        this.writeLine("DS " + this.cellNumber + " 1 " + this.localPrefs.cifScale + ";");
        String cellName = (cellGeom.nonUniqueName ? cellGeom.cell.getLibrary().getName() + ":" : "") + cellGeom.cell.getName() + ";";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cellName.length(); ++i) {
            char ch = cellName.charAt(i);
            if (badNameChars.indexOf(ch) != -1) {
                ch = '_';
            }
            sb.append(ch);
        }
        this.writeLine("9 " + sb.toString());
        this.cellNumbers.put(cellGeom.cell, new Integer(this.cellNumber));
        Set<Layer> layers = cellGeom.polyMap.keySet();
        for (Layer layer : layers) {
            if (this.writeLayer(layer)) continue;
            List<Object> polyList = cellGeom.polyMap.get(layer);
            for (Object polyObj : polyList) {
                if (this.includeGeometric()) {
                    Geometry.PolyWithGeom pg = (Geometry.PolyWithGeom)polyObj;
                    Poly poly = pg.poly;
                    this.writePoly(poly, cellGeom.cell, pg.geom);
                    continue;
                }
                PolyBase poly = (PolyBase)polyObj;
                this.writePoly(poly, cellGeom.cell, null);
            }
        }
        Iterator<NodeInst> noIt = cellGeom.cell.getNodes();
        while (noIt.hasNext()) {
            NodeInst ni = noIt.next();
            if (!ni.isCellInstance()) continue;
            this.writeNodable(ni);
        }
        this.writeLine("DF;");
    }

    protected boolean mergeGeom(int hierLevelsFromBottom) {
        return this.localPrefs.cifOutMergesBoxes;
    }

    protected boolean includeGeometric() {
        return !this.localPrefs.cifOutMergesBoxes;
    }

    private boolean writeLayer(Layer layer) {
        if (layer.isPseudoLayer()) {
            return true;
        }
        String layName = layer.getCIFLayer();
        if (layName == null || layName.equals("")) {
            return true;
        }
        this.writeLine("L " + layName + ";");
        return false;
    }

    private void writePoly(PolyBase poly, Cell cell, Geometric geom) {
        Point2D[] points = poly.getPoints();
        if (poly.getStyle() == Poly.Type.DISC) {
            this.checkResolution(poly, cell, geom);
            double r = points[0].distance(points[1]);
            if (r <= 0.0) {
                return;
            }
            int radius = this.scale(r);
            int x = this.scale(points[0].getX());
            int y = this.scale(points[0].getY());
            String line = " R " + radius + " " + x + " " + y + ";";
            this.writeLine(line);
        } else {
            Rectangle2D bounds = poly.getBounds2D();
            if (bounds.getHeight() <= 0.0 || bounds.getWidth() <= 0.0) {
                return;
            }
            Rectangle2D box = poly.getBox();
            if (box != null) {
                this.checkPointResolution(box.getWidth(), box.getHeight(), cell, geom, poly.getLayer(), poly);
                this.checkPointResolution(box.getCenterX(), box.getCenterY(), cell, geom, poly.getLayer(), poly);
                int width = this.scale(box.getWidth());
                int height = this.scale(box.getHeight());
                int x = this.scale(box.getCenterX());
                int y = this.scale(box.getCenterY());
                String line = " B " + width + " " + height + " " + x + " " + y + ";";
                this.writeLine(line);
                return;
            }
            this.checkResolution(poly, cell, geom);
            StringBuffer line = new StringBuffer(" P");
            for (int i = 0; i < points.length; ++i) {
                int x = this.scale(points[i].getX());
                int y = this.scale(points[i].getY());
                line.append(" " + x + " " + y);
            }
            line.append(";");
            this.writeLine(line.toString());
        }
    }

    private void writeNodable(NodeInst ni) {
        Cell cell = (Cell)ni.getProto();
        if (!ni.isExpanded() && this.localPrefs.cifOutMimicsDisplay) {
            Rectangle2D bounds = ni.getBounds();
            Poly poly = new Poly(bounds.getCenterX(), bounds.getCenterY(), ni.getXSize(), ni.getYSize());
            AffineTransform localPureTrans = ni.rotateOutAboutTrueCenter();
            poly.transform(localPureTrans);
            Point2D[] points = poly.getPoints();
            String line = "0V";
            for (int i = 0; i < 4; ++i) {
                line = line + " " + this.scale(points[i].getX()) + " " + this.scale(points[i].getY());
            }
            line = line + " " + this.scale(points[0].getX()) + " " + this.scale(points[0].getY());
            this.writeLine(line + ";");
            this.writeLine("2C \"" + cell.describe(false) + "\" T " + this.scale(bounds.getCenterX()) + " " + this.scale(bounds.getCenterY()) + ";");
            return;
        }
        int cellNum = this.cellNumbers.get(cell);
        int rotx = (int)(DBMath.cos(ni.getAngle()) * 100.0);
        int roty = (int)(DBMath.sin(ni.getAngle()) * 100.0);
        String line = "C " + cellNum + " R " + rotx + " " + roty;
        if (ni.isMirroredAboutXAxis()) {
            line = line + " M Y";
        }
        if (ni.isMirroredAboutYAxis()) {
            line = line + " M X";
        }
        line = line + " T " + this.scale(ni.getAnchorCenterX()) + " " + this.scale(ni.getAnchorCenterY());
        this.writeLine(line + ";");
    }

    private void writeLine(String line) {
        line = line + '\n';
        this.printWriter.print(line);
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c > ' ') {
                this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ c) & 0xFF];
                this.crcPrevIsCharSep = false;
            } else if (!this.crcPrevIsCharSep) {
                this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ 0x20) & 0xFF];
                this.crcPrevIsCharSep = true;
            }
            ++this.crcNumChars;
        }
    }

    private int scale(double n) {
        return (int)(this.scaleFactor * n);
    }

    private void checkResolution(PolyBase poly, Cell cell, Geometric geom) {
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            double y;
            double x = points[i].getX();
            if (!this.checkPointResolution(x, y = points[i].getY(), cell, geom, poly.getLayer(), poly)) continue;
            return;
        }
    }

    private boolean checkPointResolution(double x, double y, Cell cell, Geometric geom, Layer layer, PolyBase poly) {
        boolean error;
        boolean badPoints = false;
        if ((double)Math.round(x *= this.scaleFactor) != x || (double)Math.round(y *= this.scaleFactor) != y) {
            badPoints = true;
        }
        boolean badResolution = false;
        boolean bl = error = badPoints || badResolution;
        if (error) {
            String layerName = layer == null ? "**UNKNOWN**" : layer.getName();
            if (geom != null) {
                this.errorLogger.logError("Resolution less than CIF allows on layer " + layerName, geom, cell, null, layer.getIndex());
            } else {
                this.errorLogger.logError("Resolution less than CIF allows on layer " + layerName, poly, cell, layer.getIndex());
            }
        }
        return error;
    }

    private CIFVisitor makeCIFVisitor(int maxDepth) {
        CIFVisitor visitor = new CIFVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private class CIFVisitor
    extends Geometry.Visitor {
        CIFVisitor(Geometry outGeom, int maxHierDepth) {
            super(CIF.this, outGeom, maxHierDepth);
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = (NodeInst)no;
            if (ni.isCellInstance() && !ni.isExpanded() && ((CIF)CIF.this).localPrefs.cifOutMimicsDisplay) {
                return false;
            }
            return super.visitNodeInst(no, info);
        }
    }

    public static class CIFPreferences
    extends Output.OutputPreferences {
        int cifScale = IOTool.getCIFOutScaleFactor();
        boolean cifOutInstantiatesTopLevel = IOTool.isCIFOutInstantiatesTopLevel();
        boolean cifOutMergesBoxes = IOTool.isCIFOutMergesBoxes();
        boolean cifOutMimicsDisplay = IOTool.isCIFOutMimicsDisplay();

        public CIFPreferences(boolean factory) {
            super(factory);
        }

        public Output doOutput(Cell cell, VarContext context, String filePath) {
            CIFVisitor visitor;
            CIF out = new CIF(this);
            if (!(out.openTextOutputStream(filePath) || out.writeCell(cell, context, visitor = out.makeCIFVisitor(Geometry.getMaxHierDepth(cell))) || out.closeTextOutputStream())) {
                System.out.println(filePath + " written");
                if (out.errorLogger.getNumErrors() != 0) {
                    System.out.println(out.errorLogger.getNumErrors() + " CIF RESOLUTION ERRORS FOUND");
                }
            }
            return out.finishWrite();
        }
    }
}

