/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;

public class CantEditException
extends JobException {
    NodeInst lockedNode;
    NodeInst lockedPrim;
    NodeInst lockedComplex;
    Cell lockedInstances;
    Cell lockedAll;
    NodeInst lockedExample;

    public int presentProblem() {
        String[] options = new String[]{"Yes", "No", "Always", "Cancel"};
        UserInterface ui = Job.getUserInterface();
        if (this.lockedNode != null) {
            int ret = ui.askForChoice("Changes to locked " + this.lockedNode + " are disallowed.  Change anyway?", "Allow changes", options, options[1]);
            if (ret == 3 || ret == -1) {
                return -1;
            }
            if (ret == 1) {
                return 1;
            }
            if (ret == 2) {
                this.lockedNode.clearLocked();
            }
            return 0;
        }
        if (this.lockedPrim != null) {
            int ret = ui.askForChoice("Changes to locked primitives (such as " + this.lockedPrim + ") are disallowed.  Change anyway?", "Allow changes", options, options[1]);
            if (ret == 3 || ret == -1) {
                return -1;
            }
            if (ret == 1) {
                return 1;
            }
            if (ret == 2) {
                User.setDisallowModificationLockedPrims(false);
            }
            return 0;
        }
        if (this.lockedInstances != null) {
            int ret = ui.askForChoice("Modification of instances in " + this.lockedInstances + " is disallowed.  You cannot move " + this.lockedExample + ".  Change anyway?", "Allow changes", options, options[1]);
            if (ret == 3 || ret == -1) {
                return -1;
            }
            if (ret == 1) {
                return 1;
            }
            if (ret == 2) {
                this.lockedInstances.clearInstancesLocked();
            }
            return 0;
        }
        if (this.lockedComplex != null) {
            int ret = ui.askForChoice("Changes to complex nodes (such as " + this.lockedComplex + ") are disallowed.  Change anyway?", "Allow changes", options, options[1]);
            if (ret == 3 || ret == -1) {
                return -1;
            }
            if (ret == 1) {
                return 1;
            }
            if (ret == 2) {
                User.setDisallowModificationComplexNodes(false);
            }
            return 0;
        }
        if (this.lockedAll != null) {
            int ret = ui.askForChoice("Modification of " + this.lockedAll + " is disallowed.  Change " + (this.lockedExample == null ? "" : this.lockedExample.toString()) + " anyway?", "Allow changes", options, options[1]);
            if (ret == 3 || ret == -1) {
                return -1;
            }
            if (ret == 1) {
                return 1;
            }
            if (ret == 2) {
                this.lockedAll.clearAllLocked();
            }
            return 0;
        }
        return 0;
    }
}

