/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;

public class VertTrack {
    public static Cell makePart(StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        String nm = stdCell.parameterizedName("vertTrack") + "{lay}";
        Cell vtrack = stdCell.findPart(nm);
        if (vtrack != null) {
            return vtrack;
        }
        vtrack = stdCell.newPart(nm);
        double inX = 3.5;
        double inY = 0.0;
        PortInst inPin = LayoutLib.newNodeInst(tech.m1pin(), ep, inX, inY, 1.0, 1.0, 0.0, vtrack).getOnlyPortInst();
        Export.newInst(vtrack, inPin, "in", ep).setCharacteristic(PortCharacteristic.IN);
        LayoutLib.newArcInst(tech.m1(), ep, 3.0, inPin, inPin);
        double wellMinX = inX - 6.0;
        double wellMaxX = inX + 6.0;
        stdCell.addNmosWell(wellMinX, wellMaxX, vtrack);
        stdCell.addPmosWell(wellMinX, wellMaxX, vtrack);
        double cellMaxX = inX + 2.0 + 1.5;
        stdCell.addEssentialBounds(0.0, cellMaxX, vtrack);
        return vtrack;
    }
}

