/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import java.math.BigInteger;

class Rational
implements Comparable<Rational> {
    final BigInteger n;
    final BigInteger d;

    Rational(BigInteger n, BigInteger d) {
        if (d.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        assert (n.gcd(d).equals(BigInteger.ONE));
        if (d.bitLength() <= 1) {
            d = BigInteger.ONE;
        }
        this.n = n;
        this.d = d;
    }

    static Rational valueOf(BigInteger num, BigInteger den) {
        BigInteger gcd;
        if (den.signum() < 0) {
            num = num.negate();
            den = den.negate();
        }
        if ((gcd = num.gcd(den)).bitLength() > 1) {
            num = num.divide(gcd);
            den = den.divide(gcd);
        }
        return new Rational(num, den);
    }

    int signum() {
        return this.n.signum();
    }

    boolean isInteger() {
        return this.d == BigInteger.ONE;
    }

    Rational negate() {
        return this.n.signum() == 0 ? this : new Rational(this.n.negate(), this.d);
    }

    Rational inverse() {
        int sig = this.signum();
        if (sig > 0) {
            return new Rational(this.d, this.n);
        }
        if (sig < 0) {
            return new Rational(this.d.negate(), this.n.negate());
        }
        return this;
    }

    Rational add(Rational y) {
        BigInteger den;
        if (this.signum() == 0) {
            return y;
        }
        if (y.signum() == 0) {
            return this;
        }
        BigInteger gcd = this.d.gcd(y.d);
        BigInteger xd = gcd.bitLength() <= 1 ? this.d : this.d.divide(gcd);
        BigInteger yd = gcd.bitLength() <= 1 ? y.d : y.d.divide(gcd);
        BigInteger num = this.n.multiply(yd).add(y.n.multiply(xd));
        if ((gcd = num.gcd(den = this.d.multiply(yd))).bitLength() > 1) {
            num = num.divide(gcd);
            den = den.divide(gcd);
        }
        return new Rational(num, den);
    }

    Rational add(BigInteger y) {
        return new Rational(y.multiply(this.d).add(this.n), this.d);
    }

    Rational mul(BigInteger y) {
        if (this.signum() == 0) {
            return this;
        }
        BigInteger gcd = this.d.gcd(y);
        BigInteger num = (gcd.bitLength() <= 1 ? y : y.divide(gcd)).multiply(this.n);
        BigInteger den = gcd.bitLength() <= 1 ? this.d : this.d.divide(gcd);
        return new Rational(num, den);
    }

    Rational mul(Rational y) {
        if (this.signum() == 0) {
            return this;
        }
        if (y.signum() == 0) {
            return y;
        }
        BigInteger gcd1 = this.n.gcd(y.d);
        BigInteger gcd2 = this.d.gcd(y.n);
        BigInteger nom = (gcd1.bitLength() <= 1 ? this.n : this.n.divide(gcd1)).multiply(gcd2.bitLength() <= 1 ? y.n : y.n.divide(gcd2));
        BigInteger den = (gcd2.bitLength() <= 1 ? this.d : this.d.divide(gcd2)).multiply(gcd1.bitLength() <= 1 ? y.d : y.d.divide(gcd1));
        return new Rational(nom, den);
    }

    public boolean equals(Object o) {
        return o instanceof Rational && this.n.equals(((Rational)o).n) && this.d.equals(((Rational)o).d);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.n.hashCode();
        hash = 71 * hash + this.d.hashCode();
        return hash;
    }

    public String toString() {
        return this.n.toString() + "/" + this.d.toString();
    }

    @Override
    public int compareTo(Rational y) {
        if (this.signum() != y.signum()) {
            return this.signum();
        }
        return this.n.multiply(y.d).compareTo(this.d.multiply(y.n));
    }

    @Override
    public int compareTo(BigInteger y) {
        if (this.signum() != y.signum()) {
            return this.signum();
        }
        return this.n.compareTo(this.d.multiply(y));
    }
}

